/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.buffer.BarBuffer;
import com.github.mikephil.charting.buffer.HorizontalBarBuffer;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.formatter.ValueFormatter;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.renderer.BarChartRenderer;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class HorizontalBarChartRenderer
extends BarChartRenderer {
    public HorizontalBarChartRenderer(BarDataProvider barDataProvider, ChartAnimator chartAnimator, ViewPortHandler viewPortHandler) {
        super(barDataProvider, chartAnimator, viewPortHandler);
        this.mValuePaint.setTextAlign(Paint.Align.LEFT);
    }

    @Override
    public void initBuffers() {
        BarData barData = this.mChart.getBarData();
        this.mBarBuffers = new HorizontalBarBuffer[barData.getDataSetCount()];
        int n = 0;
        while (n < this.mBarBuffers.length) {
            IBarDataSet iBarDataSet = (IBarDataSet)barData.getDataSetByIndex(n);
            this.mBarBuffers[n] = new HorizontalBarBuffer(iBarDataSet.getEntryCount() * 4 * (iBarDataSet.isStacked() ? iBarDataSet.getStackSize() : 1), barData.getGroupSpace(), barData.getDataSetCount(), iBarDataSet.isStacked());
            ++n;
        }
    }

    @Override
    protected void drawDataSet(Canvas canvas, IBarDataSet iBarDataSet, int n) {
        Transformer transformer = this.mChart.getTransformer(iBarDataSet.getAxisDependency());
        this.mShadowPaint.setColor(iBarDataSet.getBarShadowColor());
        float f = this.mAnimator.getPhaseX();
        float f2 = this.mAnimator.getPhaseY();
        BarBuffer barBuffer = this.mBarBuffers[n];
        barBuffer.setPhases(f, f2);
        barBuffer.setBarSpace(iBarDataSet.getBarSpace());
        barBuffer.setDataSet(n);
        barBuffer.setInverted(this.mChart.isInverted(iBarDataSet.getAxisDependency()));
        barBuffer.feed(iBarDataSet);
        transformer.pointValuesToPixel(barBuffer.buffer);
        int n2 = 0;
        while (n2 < barBuffer.size()) {
            if (!this.mViewPortHandler.isInBoundsTop(barBuffer.buffer[n2 + 3])) break;
            if (this.mViewPortHandler.isInBoundsBottom(barBuffer.buffer[n2 + 1])) {
                if (this.mChart.isDrawBarShadowEnabled()) {
                    canvas.drawRect(this.mViewPortHandler.contentLeft(), barBuffer.buffer[n2 + 1], this.mViewPortHandler.contentRight(), barBuffer.buffer[n2 + 3], this.mShadowPaint);
                }
                this.mRenderPaint.setColor(iBarDataSet.getColor(n2 / 4));
                canvas.drawRect(barBuffer.buffer[n2], barBuffer.buffer[n2 + 1], barBuffer.buffer[n2 + 2], barBuffer.buffer[n2 + 3], this.mRenderPaint);
            }
            n2 += 4;
        }
    }

    @Override
    public void drawValues(Canvas canvas) {
        if (this.passesCheck()) {
            List list = this.mChart.getBarData().getDataSets();
            float f = Utils.convertDpToPixel(5.0f);
            float f2 = 0.0f;
            float f3 = 0.0f;
            boolean bl = this.mChart.isDrawValueAboveBarEnabled();
            int n = 0;
            while (n < this.mChart.getBarData().getDataSetCount()) {
                IBarDataSet iBarDataSet = (IBarDataSet)list.get(n);
                if (iBarDataSet.isDrawValuesEnabled() && iBarDataSet.getEntryCount() != 0) {
                    BarEntry barEntry;
                    int n2;
                    boolean bl2 = this.mChart.isInverted(iBarDataSet.getAxisDependency());
                    this.applyValueTextStyle(iBarDataSet);
                    float f4 = (float)Utils.calcTextHeight(this.mValuePaint, "10") / 2.0f;
                    ValueFormatter valueFormatter = iBarDataSet.getValueFormatter();
                    Transformer transformer = this.mChart.getTransformer(iBarDataSet.getAxisDependency());
                    float[] fArray = this.getTransformedValues(transformer, iBarDataSet, n);
                    if (!iBarDataSet.isStacked()) {
                        n2 = 0;
                        while ((float)n2 < (float)fArray.length * this.mAnimator.getPhaseX()) {
                            if (this.mViewPortHandler.isInBoundsTop(fArray[n2 + 1])) {
                                if (this.mViewPortHandler.isInBoundsX(fArray[n2]) && this.mViewPortHandler.isInBoundsBottom(fArray[n2 + 1])) {
                                    barEntry = (BarEntry)iBarDataSet.getEntryForIndex(n2 / 2);
                                    float f5 = barEntry.getVal();
                                    String string = valueFormatter.getFormattedValue(f5, barEntry, n, this.mViewPortHandler);
                                    float f6 = Utils.calcTextWidth(this.mValuePaint, string);
                                    f2 = bl ? f : -(f6 + f);
                                    float f7 = f3 = bl ? -(f6 + f) : f;
                                    if (bl2) {
                                        f2 = -f2 - f6;
                                        f3 = -f3 - f6;
                                    }
                                    this.drawValue(canvas, string, fArray[n2] + (f5 >= 0.0f ? f2 : f3), fArray[n2 + 1] + f4, iBarDataSet.getValueTextColor(n2 / 2));
                                }
                                n2 += 2;
                                continue;
                            }
                            break;
                        }
                    } else {
                        n2 = 0;
                        while ((float)n2 < (float)(fArray.length - 1) * this.mAnimator.getPhaseX()) {
                            float f8;
                            barEntry = (BarEntry)iBarDataSet.getEntryForIndex(n2 / 2);
                            float[] fArray2 = barEntry.getVals();
                            if (fArray2 == null) {
                                if (!this.mViewPortHandler.isInBoundsTop(fArray[n2 + 1])) break;
                                if (this.mViewPortHandler.isInBoundsX(fArray[n2]) && this.mViewPortHandler.isInBoundsBottom(fArray[n2 + 1])) {
                                    float f9 = barEntry.getVal();
                                    String string = valueFormatter.getFormattedValue(f9, barEntry, n, this.mViewPortHandler);
                                    f8 = Utils.calcTextWidth(this.mValuePaint, string);
                                    f2 = bl ? f : -(f8 + f);
                                    float f10 = f3 = bl ? -(f8 + f) : f;
                                    if (bl2) {
                                        f2 = -f2 - f8;
                                        f3 = -f3 - f8;
                                    }
                                    this.drawValue(canvas, string, fArray[n2] + (barEntry.getVal() >= 0.0f ? f2 : f3), fArray[n2 + 1] + f4, iBarDataSet.getValueTextColor(n2 / 2));
                                }
                            } else {
                                float f11;
                                float[] fArray3 = new float[fArray2.length * 2];
                                float f12 = 0.0f;
                                f8 = -barEntry.getNegativeSum();
                                int n3 = 0;
                                int n4 = 0;
                                while (n3 < fArray3.length) {
                                    float f13 = fArray2[n4];
                                    if (f13 >= 0.0f) {
                                        f11 = f12 += f13;
                                    } else {
                                        f11 = f8;
                                        f8 -= f13;
                                    }
                                    fArray3[n3] = f11 * this.mAnimator.getPhaseY();
                                    n3 += 2;
                                    ++n4;
                                }
                                transformer.pointValuesToPixel(fArray3);
                                n3 = 0;
                                while (n3 < fArray3.length) {
                                    float f14 = fArray2[n3 / 2];
                                    String string = valueFormatter.getFormattedValue(f14, barEntry, n, this.mViewPortHandler);
                                    f11 = Utils.calcTextWidth(this.mValuePaint, string);
                                    f2 = bl ? f : -(f11 + f);
                                    float f15 = f3 = bl ? -(f11 + f) : f;
                                    if (bl2) {
                                        f2 = -f2 - f11;
                                        f3 = -f3 - f11;
                                    }
                                    float f16 = fArray3[n3] + (f14 >= 0.0f ? f2 : f3);
                                    float f17 = fArray[n2 + 1];
                                    if (!this.mViewPortHandler.isInBoundsTop(f17)) break;
                                    if (this.mViewPortHandler.isInBoundsX(f16) && this.mViewPortHandler.isInBoundsBottom(f17)) {
                                        this.drawValue(canvas, string, f16, f17 + f4, iBarDataSet.getValueTextColor(n2 / 2));
                                    }
                                    n3 += 2;
                                }
                            }
                            n2 += 2;
                        }
                    }
                }
                ++n;
            }
        }
    }

    protected void drawValue(Canvas canvas, String string, float f, float f2, int n) {
        this.mValuePaint.setColor(n);
        canvas.drawText(string, f, f2, this.mValuePaint);
    }

    @Override
    protected void prepareBarHighlight(float f, float f2, float f3, float f4, Transformer transformer) {
        float f5 = f - 0.5f + f4;
        float f6 = f + 0.5f - f4;
        float f7 = f2;
        float f8 = f3;
        this.mBarRect.set(f7, f5, f8, f6);
        transformer.rectValueToPixelHorizontal(this.mBarRect, this.mAnimator.getPhaseY());
    }

    @Override
    public float[] getTransformedValues(Transformer transformer, IBarDataSet iBarDataSet, int n) {
        return transformer.generateTransformedValuesHorizontalBarChart(iBarDataSet, n, this.mChart.getBarData(), this.mAnimator.getPhaseY());
    }

    @Override
    protected boolean passesCheck() {
        return (float)this.mChart.getBarData().getYValCount() < (float)this.mChart.getMaxVisibleCount() * this.mViewPortHandler.getScaleY();
    }
}

