/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.LineDataProvider;
import com.github.mikephil.charting.interfaces.datasets.ILineDataSet;
import com.github.mikephil.charting.renderer.LineRadarRenderer;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.lang.ref.WeakReference;
import java.util.List;

public class LineChartRenderer
extends LineRadarRenderer {
    protected LineDataProvider mChart;
    protected Paint mCirclePaintInner;
    protected WeakReference<Bitmap> mDrawBitmap;
    protected Canvas mBitmapCanvas;
    protected Bitmap.Config mBitmapConfig = Bitmap.Config.ARGB_8888;
    protected Path cubicPath = new Path();
    protected Path cubicFillPath = new Path();
    private float[] a = new float[4];

    public LineChartRenderer(LineDataProvider lineDataProvider, ChartAnimator chartAnimator, ViewPortHandler viewPortHandler) {
        super(chartAnimator, viewPortHandler);
        this.mChart = lineDataProvider;
        this.mCirclePaintInner = new Paint(1);
        this.mCirclePaintInner.setStyle(Paint.Style.FILL);
        this.mCirclePaintInner.setColor(-1);
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(Canvas canvas) {
        int n = (int)this.mViewPortHandler.getChartWidth();
        int n2 = (int)this.mViewPortHandler.getChartHeight();
        if (this.mDrawBitmap == null || ((Bitmap)this.mDrawBitmap.get()).getWidth() != n || ((Bitmap)this.mDrawBitmap.get()).getHeight() != n2) {
            if (n > 0 && n2 > 0) {
                this.mDrawBitmap = new WeakReference<Bitmap>(Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)this.mBitmapConfig));
                this.mBitmapCanvas = new Canvas((Bitmap)this.mDrawBitmap.get());
            } else {
                return;
            }
        }
        ((Bitmap)this.mDrawBitmap.get()).eraseColor(0);
        LineData lineData = this.mChart.getLineData();
        for (ILineDataSet iLineDataSet : lineData.getDataSets()) {
            if (!iLineDataSet.isVisible() || iLineDataSet.getEntryCount() <= 0) continue;
            this.drawDataSet(canvas, iLineDataSet);
        }
        canvas.drawBitmap((Bitmap)this.mDrawBitmap.get(), 0.0f, 0.0f, this.mRenderPaint);
    }

    protected void drawDataSet(Canvas canvas, ILineDataSet iLineDataSet) {
        if (iLineDataSet.getEntryCount() < 1) {
            return;
        }
        this.mRenderPaint.setStrokeWidth(iLineDataSet.getLineWidth());
        this.mRenderPaint.setPathEffect((PathEffect)iLineDataSet.getDashPathEffect());
        if (iLineDataSet.isDrawCubicEnabled()) {
            this.drawCubic(canvas, iLineDataSet);
        } else {
            this.drawLinear(canvas, iLineDataSet);
        }
        this.mRenderPaint.setPathEffect(null);
    }

    protected void drawCubic(Canvas canvas, ILineDataSet iLineDataSet) {
        Transformer transformer = this.mChart.getTransformer(iLineDataSet.getAxisDependency());
        int n = iLineDataSet.getEntryCount();
        Object t = iLineDataSet.getEntryForXIndex(this.mMinX < 0 ? 0 : this.mMinX, DataSet.Rounding.DOWN);
        Object t2 = iLineDataSet.getEntryForXIndex(this.mMaxX, DataSet.Rounding.UP);
        int n2 = t == t2 ? 1 : 0;
        int n3 = Math.max(iLineDataSet.getEntryIndex(t) - n2, 0);
        int n4 = Math.min(Math.max(n3 + 2, iLineDataSet.getEntryIndex(t2) + 1), n);
        float f = this.mAnimator.getPhaseX();
        float f2 = this.mAnimator.getPhaseY();
        float f3 = iLineDataSet.getCubicIntensity();
        this.cubicPath.reset();
        int n5 = (int)Math.ceil((float)(n4 - n3) * f + (float)n3);
        if (n5 - n3 >= 2) {
            Object t3;
            Object t4;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            Object t5 = t4 = (t3 = iLineDataSet.getEntryForIndex(n3));
            Object t6 = iLineDataSet.getEntryForIndex(n3 + 1);
            this.cubicPath.moveTo((float)((Entry)t5).getXIndex(), ((Entry)t5).getVal() * f2);
            f4 = (float)(((Entry)t5).getXIndex() - ((Entry)t4).getXIndex()) * f3;
            f5 = (((Entry)t5).getVal() - ((Entry)t4).getVal()) * f3;
            f6 = (float)(((Entry)t6).getXIndex() - ((Entry)t5).getXIndex()) * f3;
            f7 = (((Entry)t6).getVal() - ((Entry)t5).getVal()) * f3;
            this.cubicPath.cubicTo((float)((Entry)t4).getXIndex() + f4, (((Entry)t4).getVal() + f5) * f2, (float)((Entry)t5).getXIndex() - f6, (((Entry)t5).getVal() - f7) * f2, (float)((Entry)t5).getXIndex(), ((Entry)t5).getVal() * f2);
            int n6 = n3 + 1;
            int n7 = Math.min(n5, n - 1);
            while (n6 < n7) {
                t3 = iLineDataSet.getEntryForIndex(n6 == 1 ? 0 : n6 - 2);
                t4 = iLineDataSet.getEntryForIndex(n6 - 1);
                t5 = iLineDataSet.getEntryForIndex(n6);
                t6 = iLineDataSet.getEntryForIndex(n6 + 1);
                f4 = (float)(((Entry)t5).getXIndex() - ((Entry)t3).getXIndex()) * f3;
                f5 = (((Entry)t5).getVal() - ((Entry)t3).getVal()) * f3;
                f6 = (float)(((Entry)t6).getXIndex() - ((Entry)t4).getXIndex()) * f3;
                f7 = (((Entry)t6).getVal() - ((Entry)t4).getVal()) * f3;
                this.cubicPath.cubicTo((float)((Entry)t4).getXIndex() + f4, (((Entry)t4).getVal() + f5) * f2, (float)((Entry)t5).getXIndex() - f6, (((Entry)t5).getVal() - f7) * f2, (float)((Entry)t5).getXIndex(), ((Entry)t5).getVal() * f2);
                ++n6;
            }
            if (n5 > n - 1) {
                t3 = iLineDataSet.getEntryForIndex(n >= 3 ? n - 3 : n - 2);
                t4 = iLineDataSet.getEntryForIndex(n - 2);
                t6 = t5 = iLineDataSet.getEntryForIndex(n - 1);
                f4 = (float)(((Entry)t5).getXIndex() - ((Entry)t3).getXIndex()) * f3;
                f5 = (((Entry)t5).getVal() - ((Entry)t3).getVal()) * f3;
                f6 = (float)(((Entry)t6).getXIndex() - ((Entry)t4).getXIndex()) * f3;
                f7 = (((Entry)t6).getVal() - ((Entry)t4).getVal()) * f3;
                this.cubicPath.cubicTo((float)((Entry)t4).getXIndex() + f4, (((Entry)t4).getVal() + f5) * f2, (float)((Entry)t5).getXIndex() - f6, (((Entry)t5).getVal() - f7) * f2, (float)((Entry)t5).getXIndex(), ((Entry)t5).getVal() * f2);
            }
        }
        if (iLineDataSet.isDrawFilledEnabled()) {
            this.cubicFillPath.reset();
            this.cubicFillPath.addPath(this.cubicPath);
            this.drawCubicFill(this.mBitmapCanvas, iLineDataSet, this.cubicFillPath, transformer, n3, n5);
        }
        this.mRenderPaint.setColor(iLineDataSet.getColor());
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        transformer.pathValueToPixel(this.cubicPath);
        this.mBitmapCanvas.drawPath(this.cubicPath, this.mRenderPaint);
        this.mRenderPaint.setPathEffect(null);
    }

    protected void drawCubicFill(Canvas canvas, ILineDataSet iLineDataSet, Path path, Transformer transformer, int n, int n2) {
        if (n2 - n <= 1) {
            return;
        }
        float f = iLineDataSet.getFillFormatter().getFillLinePosition(iLineDataSet, this.mChart);
        Object t = iLineDataSet.getEntryForIndex(n2 - 1);
        Object t2 = iLineDataSet.getEntryForIndex(n);
        float f2 = t == null ? 0 : ((Entry)t).getXIndex();
        float f3 = t2 == null ? 0 : ((Entry)t2).getXIndex();
        path.lineTo(f2, f);
        path.lineTo(f3, f);
        path.close();
        transformer.pathValueToPixel(path);
        Drawable drawable = iLineDataSet.getFillDrawable();
        if (drawable != null) {
            this.drawFilledPath(canvas, path, drawable);
        } else {
            this.drawFilledPath(canvas, path, iLineDataSet.getFillColor(), iLineDataSet.getFillAlpha());
        }
    }

    protected void drawLinear(Canvas canvas, ILineDataSet iLineDataSet) {
        int n = iLineDataSet.getEntryCount();
        boolean bl = iLineDataSet.isDrawSteppedEnabled();
        int n2 = bl ? 4 : 2;
        Transformer transformer = this.mChart.getTransformer(iLineDataSet.getAxisDependency());
        float f = this.mAnimator.getPhaseX();
        float f2 = this.mAnimator.getPhaseY();
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        Canvas canvas2 = null;
        canvas2 = iLineDataSet.isDashedLineEnabled() ? this.mBitmapCanvas : canvas;
        Object t = iLineDataSet.getEntryForXIndex(this.mMinX < 0 ? 0 : this.mMinX, DataSet.Rounding.DOWN);
        Object t2 = iLineDataSet.getEntryForXIndex(this.mMaxX, DataSet.Rounding.UP);
        int n3 = t == t2 ? 1 : 0;
        int n4 = Math.max(iLineDataSet.getEntryIndex(t) - n3, 0);
        int n5 = Math.min(Math.max(n4 + 2, iLineDataSet.getEntryIndex(t2) + 1), n);
        int n6 = (int)Math.ceil((float)(n5 - n4) * f + (float)n4);
        if (iLineDataSet.getColors().size() > 1) {
            if (this.a.length != n2 * 2) {
                this.a = new float[n2 * 2];
            }
            int n7 = n4;
            while (n7 < n6) {
                if (n6 > 1 && n7 == n6 - 1) break;
                Object t3 = iLineDataSet.getEntryForIndex(n7);
                if (t3 != null) {
                    this.a[0] = ((Entry)t3).getXIndex();
                    this.a[1] = ((Entry)t3).getVal() * f2;
                    if (n7 + 1 < n6) {
                        t3 = iLineDataSet.getEntryForIndex(n7 + 1);
                        if (t3 == null) break;
                        if (bl) {
                            this.a[2] = ((Entry)t3).getXIndex();
                            this.a[3] = this.a[1];
                            this.a[4] = this.a[2];
                            this.a[5] = this.a[3];
                            this.a[6] = ((Entry)t3).getXIndex();
                            this.a[7] = ((Entry)t3).getVal() * f2;
                        } else {
                            this.a[2] = ((Entry)t3).getXIndex();
                            this.a[3] = ((Entry)t3).getVal() * f2;
                        }
                    } else {
                        this.a[2] = this.a[0];
                        this.a[3] = this.a[1];
                    }
                    transformer.pointValuesToPixel(this.a);
                    if (!this.mViewPortHandler.isInBoundsRight(this.a[0])) break;
                    if (this.mViewPortHandler.isInBoundsLeft(this.a[2]) && (this.mViewPortHandler.isInBoundsTop(this.a[1]) || this.mViewPortHandler.isInBoundsBottom(this.a[3])) && (this.mViewPortHandler.isInBoundsTop(this.a[1]) || this.mViewPortHandler.isInBoundsBottom(this.a[3]))) {
                        this.mRenderPaint.setColor(iLineDataSet.getColor(n7));
                        canvas2.drawLines(this.a, 0, n2 * 2, this.mRenderPaint);
                    }
                }
                ++n7;
            }
        } else {
            Object t4;
            if (this.a.length != Math.max((n - 1) * n2, n2) * 2) {
                this.a = new float[Math.max((n - 1) * n2, n2) * 2];
            }
            if ((t4 = iLineDataSet.getEntryForIndex(n4)) != null) {
                int n8 = n6 > 1 ? n4 + 1 : n4;
                int n9 = 0;
                while (n8 < n6) {
                    t4 = iLineDataSet.getEntryForIndex(n8 == 0 ? 0 : n8 - 1);
                    Object t5 = iLineDataSet.getEntryForIndex(n8);
                    if (t4 != null && t5 != null) {
                        this.a[n9++] = ((Entry)t4).getXIndex();
                        this.a[n9++] = ((Entry)t4).getVal() * f2;
                        if (bl) {
                            this.a[n9++] = ((Entry)t5).getXIndex();
                            this.a[n9++] = ((Entry)t4).getVal() * f2;
                            this.a[n9++] = ((Entry)t5).getXIndex();
                            this.a[n9++] = ((Entry)t4).getVal() * f2;
                        }
                        this.a[n9++] = ((Entry)t5).getXIndex();
                        this.a[n9++] = ((Entry)t5).getVal() * f2;
                    }
                    ++n8;
                }
                transformer.pointValuesToPixel(this.a);
                n8 = Math.max((n6 - n4 - 1) * n2, n2) * 2;
                this.mRenderPaint.setColor(iLineDataSet.getColor());
                canvas2.drawLines(this.a, 0, n8, this.mRenderPaint);
                if (iLineDataSet.isNeedHighLight()) {
                    this.mRenderPaint.setAlpha(iLineDataSet.getHighLightAlph());
                    this.mRenderPaint.setColor(-16777216);
                    this.mRenderPaint.setAlpha(iLineDataSet.getHighLightAlph());
                    canvas2.drawLines(this.a, 0, n8, this.mRenderPaint);
                }
            }
        }
        this.mRenderPaint.setPathEffect(null);
        if (iLineDataSet.isDrawFilledEnabled() && n > 0) {
            this.drawLinearFill(canvas, iLineDataSet, n4, n5, transformer);
        }
    }

    protected void drawLinearFill(Canvas canvas, ILineDataSet iLineDataSet, int n, int n2, Transformer transformer) {
        Path path = this.a(iLineDataSet, n, n2);
        transformer.pathValueToPixel(path);
        Drawable drawable = iLineDataSet.getFillDrawable();
        if (drawable != null) {
            this.drawFilledPath(canvas, path, drawable);
        } else {
            this.drawFilledPath(canvas, path, iLineDataSet.getFillColor(), iLineDataSet.getFillAlpha());
        }
    }

    private Path a(ILineDataSet iLineDataSet, int n, int n2) {
        float f = iLineDataSet.getFillFormatter().getFillLinePosition(iLineDataSet, this.mChart);
        float f2 = this.mAnimator.getPhaseX();
        float f3 = this.mAnimator.getPhaseY();
        boolean bl = iLineDataSet.isDrawSteppedEnabled();
        Path path = new Path();
        Object t = iLineDataSet.getEntryForIndex(n);
        path.moveTo((float)((Entry)t).getXIndex(), f);
        path.lineTo((float)((Entry)t).getXIndex(), ((Entry)t).getVal() * f3);
        int n3 = n + 1;
        int n4 = (int)Math.ceil((float)(n2 - n) * f2 + (float)n);
        while (n3 < n4) {
            block4: {
                Object t2;
                block3: {
                    t2 = iLineDataSet.getEntryForIndex(n3);
                    if (!bl) break block3;
                    Object t3 = iLineDataSet.getEntryForIndex(n3 - 1);
                    if (t3 == null) break block4;
                    path.lineTo((float)((Entry)t2).getXIndex(), ((Entry)t3).getVal() * f3);
                }
                path.lineTo((float)((Entry)t2).getXIndex(), ((Entry)t2).getVal() * f3);
            }
            ++n3;
        }
        path.lineTo((float)((Entry)iLineDataSet.getEntryForIndex(Math.max(Math.min((int)Math.ceil((float)(n2 - n) * f2 + (float)n) - 1, iLineDataSet.getEntryCount() - 1), 0))).getXIndex(), f);
        path.close();
        return path;
    }

    @Override
    public void drawValues(Canvas canvas) {
        if ((float)this.mChart.getLineData().getYValCount() < (float)this.mChart.getMaxVisibleCount() * this.mViewPortHandler.getScaleX() && this.mChart.isDrawValueEnable()) {
            List list = this.mChart.getLineData().getDataSets();
            int n = 0;
            while (n < list.size()) {
                ILineDataSet iLineDataSet = (ILineDataSet)list.get(n);
                if (iLineDataSet.isDrawValuesEnabled() && iLineDataSet.getEntryCount() != 0) {
                    this.applyValueTextStyle(iLineDataSet);
                    Transformer transformer = this.mChart.getTransformer(iLineDataSet.getAxisDependency());
                    int n2 = (int)(iLineDataSet.getCircleRadius() * 1.75f);
                    if (!iLineDataSet.isDrawCirclesEnabled()) {
                        n2 /= 2;
                    }
                    int n3 = iLineDataSet.getEntryCount();
                    Object t = iLineDataSet.getEntryForXIndex(this.mMinX < 0 ? 0 : this.mMinX, DataSet.Rounding.DOWN);
                    Object t2 = iLineDataSet.getEntryForXIndex(this.mMaxX, DataSet.Rounding.UP);
                    int n4 = t == t2 ? 1 : 0;
                    int n5 = Math.max(iLineDataSet.getEntryIndex(t) - n4, 0);
                    int n6 = Math.min(Math.max(n5 + 2, iLineDataSet.getEntryIndex(t2) + 1), n3);
                    float[] fArray = transformer.generateTransformedValuesLine(iLineDataSet, this.mAnimator.getPhaseX(), this.mAnimator.getPhaseY(), n5, n6);
                    int n7 = 0;
                    while (n7 < fArray.length) {
                        float f = fArray[n7];
                        float f2 = fArray[n7 + 1];
                        if (!this.mViewPortHandler.isInBoundsRight(f)) break;
                        if (this.mViewPortHandler.isInBoundsLeft(f) && this.mViewPortHandler.isInBoundsY(f2)) {
                            Object t3 = iLineDataSet.getEntryForIndex(n7 / 2 + n5);
                            this.drawValue(canvas, iLineDataSet.getValueFormatter(), ((Entry)t3).getVal(), (Entry)t3, n, f, f2 - (float)n2, iLineDataSet.getValueTextColor(n7 / 2));
                        }
                        n7 += 2;
                    }
                }
                ++n;
            }
        }
    }

    @Override
    public void drawExtras(Canvas canvas) {
        this.drawCircles(canvas);
    }

    protected void drawCircles(Canvas canvas) {
        this.mRenderPaint.setStyle(Paint.Style.FILL);
        float f = this.mAnimator.getPhaseX();
        float f2 = this.mAnimator.getPhaseY();
        float[] fArray = new float[2];
        List list = this.mChart.getLineData().getDataSets();
        int n = 0;
        while (n < list.size()) {
            ILineDataSet iLineDataSet = (ILineDataSet)list.get(n);
            if (iLineDataSet.isVisible() && iLineDataSet.isDrawCirclesEnabled() && iLineDataSet.getEntryCount() != 0) {
                this.mCirclePaintInner.setColor(iLineDataSet.getCircleHoleColor());
                Transformer transformer = this.mChart.getTransformer(iLineDataSet.getAxisDependency());
                int n2 = iLineDataSet.getEntryCount();
                Object t = iLineDataSet.getEntryForXIndex(this.mMinX < 0 ? 0 : this.mMinX, DataSet.Rounding.DOWN);
                Object t2 = iLineDataSet.getEntryForXIndex(this.mMaxX, DataSet.Rounding.UP);
                int n3 = t == t2 ? 1 : 0;
                int n4 = Math.max(iLineDataSet.getEntryIndex(t) - n3, 0);
                int n5 = Math.min(Math.max(n4 + 2, iLineDataSet.getEntryIndex(t2) + 1), n2);
                float f3 = iLineDataSet.getCircleRadius() / 2.0f;
                int n6 = n4;
                int n7 = (int)Math.ceil((float)(n5 - n4) * f + (float)n4);
                while (n6 < n7) {
                    Object t3 = iLineDataSet.getEntryForIndex(n6);
                    if (t3 == null) break;
                    fArray[0] = ((Entry)t3).getXIndex();
                    fArray[1] = ((Entry)t3).getVal() * f2;
                    transformer.pointValuesToPixel(fArray);
                    if (!this.mViewPortHandler.isInBoundsRight(fArray[0])) break;
                    if (this.mViewPortHandler.isInBoundsLeft(fArray[0]) && this.mViewPortHandler.isInBoundsY(fArray[1])) {
                        int n8 = iLineDataSet.getCircleColor(n6);
                        this.mRenderPaint.setColor(n8);
                        canvas.drawCircle(fArray[0], fArray[1], iLineDataSet.getCircleRadius(), this.mRenderPaint);
                        if (iLineDataSet.isDrawCircleHoleEnabled() && n8 != this.mCirclePaintInner.getColor()) {
                            canvas.drawCircle(fArray[0], fArray[1], f3, this.mCirclePaintInner);
                        }
                    }
                    ++n6;
                }
            }
            ++n;
        }
    }

    @Override
    public void drawHighlighted(Canvas canvas, Highlight[] highlightArray) {
        int n = 0;
        while (n < highlightArray.length) {
            float f;
            int n2;
            ILineDataSet iLineDataSet = (ILineDataSet)this.mChart.getLineData().getDataSetByIndex(highlightArray[n].getDataSetIndex());
            if (iLineDataSet != null && iLineDataSet.isHighlightEnabled() && !((float)(n2 = highlightArray[n].getXIndex()) > this.mChart.getXChartMax() * this.mAnimator.getPhaseX()) && (f = iLineDataSet.getYValForXIndex(n2)) != Float.NaN) {
                float f2 = f * this.mAnimator.getPhaseY();
                float[] fArray = new float[]{n2, f2};
                this.mChart.getTransformer(iLineDataSet.getAxisDependency()).pointValuesToPixel(fArray);
                this.drawHighlightLines(canvas, fArray, iLineDataSet);
            }
            ++n;
        }
    }

    public void setBitmapConfig(Bitmap.Config config) {
        this.mBitmapConfig = config;
        this.releaseBitmap();
    }

    public Bitmap.Config getBitmapConfig() {
        return this.mBitmapConfig;
    }

    public void releaseBitmap() {
        if (this.mDrawBitmap != null) {
            ((Bitmap)this.mDrawBitmap.get()).recycle();
            this.mDrawBitmap.clear();
            this.mDrawBitmap = null;
        }
    }
}

