/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.charts.RadarChart;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.RadarData;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.datasets.IRadarDataSet;
import com.github.mikephil.charting.renderer.LineRadarRenderer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;

public class RadarChartRenderer
extends LineRadarRenderer {
    protected RadarChart mChart;
    protected Paint mWebPaint;

    public RadarChartRenderer(RadarChart radarChart, ChartAnimator chartAnimator, ViewPortHandler viewPortHandler) {
        super(chartAnimator, viewPortHandler);
        this.mChart = radarChart;
        this.mHighlightPaint = new Paint(1);
        this.mHighlightPaint.setStyle(Paint.Style.STROKE);
        this.mHighlightPaint.setStrokeWidth(2.0f);
        this.mHighlightPaint.setColor(Color.rgb((int)255, (int)187, (int)115));
        this.mWebPaint = new Paint(1);
        this.mWebPaint.setStyle(Paint.Style.STROKE);
    }

    public Paint getWebPaint() {
        return this.mWebPaint;
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(Canvas canvas) {
        RadarData radarData = (RadarData)this.mChart.getData();
        int n = 0;
        for (IRadarDataSet iRadarDataSet : radarData.getDataSets()) {
            if (iRadarDataSet.getEntryCount() <= n) continue;
            n = iRadarDataSet.getEntryCount();
        }
        for (IRadarDataSet iRadarDataSet : radarData.getDataSets()) {
            if (!iRadarDataSet.isVisible() || iRadarDataSet.getEntryCount() <= 0) continue;
            this.drawDataSet(canvas, iRadarDataSet, n);
        }
    }

    protected void drawDataSet(Canvas canvas, IRadarDataSet iRadarDataSet, int n) {
        float f = this.mAnimator.getPhaseX();
        float f2 = this.mAnimator.getPhaseY();
        float f3 = this.mChart.getSliceAngle();
        float f4 = this.mChart.getFactor();
        PointF pointF = this.mChart.getCenterOffsets();
        Path path = new Path();
        boolean bl = false;
        int n2 = 0;
        while (n2 < iRadarDataSet.getEntryCount()) {
            this.mRenderPaint.setColor(iRadarDataSet.getColor(n2));
            Object t = iRadarDataSet.getEntryForIndex(n2);
            PointF pointF2 = Utils.getPosition(pointF, (((Entry)t).getVal() - this.mChart.getYChartMin()) * f4 * f2, f3 * (float)n2 * f + this.mChart.getRotationAngle());
            if (!Float.isNaN(pointF2.x)) {
                if (!bl) {
                    path.moveTo(pointF2.x, pointF2.y);
                    bl = true;
                } else {
                    path.lineTo(pointF2.x, pointF2.y);
                }
            }
            ++n2;
        }
        if (iRadarDataSet.getEntryCount() > n) {
            path.lineTo(pointF.x, pointF.y);
        }
        path.close();
        if (iRadarDataSet.isDrawFilledEnabled()) {
            Drawable drawable = iRadarDataSet.getFillDrawable();
            if (drawable != null) {
                this.drawFilledPath(canvas, path, drawable);
            } else {
                this.drawFilledPath(canvas, path, iRadarDataSet.getFillColor(), iRadarDataSet.getFillAlpha());
            }
        }
        this.mRenderPaint.setStrokeWidth(iRadarDataSet.getLineWidth());
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        if (!iRadarDataSet.isDrawFilledEnabled() || iRadarDataSet.getFillAlpha() < 255) {
            canvas.drawPath(path, this.mRenderPaint);
        }
    }

    @Override
    public void drawValues(Canvas canvas) {
        float f = this.mAnimator.getPhaseX();
        float f2 = this.mAnimator.getPhaseY();
        float f3 = this.mChart.getSliceAngle();
        float f4 = this.mChart.getFactor();
        PointF pointF = this.mChart.getCenterOffsets();
        float f5 = Utils.convertDpToPixel(5.0f);
        int n = 0;
        while (n < ((RadarData)this.mChart.getData()).getDataSetCount()) {
            IRadarDataSet iRadarDataSet = (IRadarDataSet)((RadarData)this.mChart.getData()).getDataSetByIndex(n);
            if (iRadarDataSet.isDrawValuesEnabled() && iRadarDataSet.getEntryCount() != 0) {
                this.applyValueTextStyle(iRadarDataSet);
                int n2 = 0;
                while (n2 < iRadarDataSet.getEntryCount()) {
                    Object t = iRadarDataSet.getEntryForIndex(n2);
                    PointF pointF2 = Utils.getPosition(pointF, (((Entry)t).getVal() - this.mChart.getYChartMin()) * f4 * f2, f3 * (float)n2 * f + this.mChart.getRotationAngle());
                    this.drawValue(canvas, iRadarDataSet.getValueFormatter(), ((Entry)t).getVal(), (Entry)t, n, pointF2.x, pointF2.y - f5, iRadarDataSet.getValueTextColor(n2));
                    ++n2;
                }
            }
            ++n;
        }
    }

    @Override
    public void drawExtras(Canvas canvas) {
        this.drawWeb(canvas);
    }

    protected void drawWeb(Canvas canvas) {
        float f = this.mChart.getSliceAngle();
        float f2 = this.mChart.getFactor();
        float f3 = this.mChart.getRotationAngle();
        PointF pointF = this.mChart.getCenterOffsets();
        this.mWebPaint.setStrokeWidth(this.mChart.getWebLineWidth());
        this.mWebPaint.setColor(this.mChart.getWebColor());
        this.mWebPaint.setAlpha(this.mChart.getWebAlpha());
        int n = 1 + this.mChart.getSkipWebLineCount();
        int n2 = 0;
        while (n2 < ((RadarData)this.mChart.getData()).getXValCount()) {
            PointF pointF2 = Utils.getPosition(pointF, this.mChart.getYRange() * f2, f * (float)n2 + f3);
            canvas.drawLine(pointF.x, pointF.y, pointF2.x, pointF2.y, this.mWebPaint);
            n2 += n;
        }
        this.mWebPaint.setStrokeWidth(this.mChart.getWebLineWidthInner());
        this.mWebPaint.setColor(this.mChart.getWebColorInner());
        this.mWebPaint.setAlpha(this.mChart.getWebAlpha());
        n2 = this.mChart.getYAxis().mEntryCount;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < ((RadarData)this.mChart.getData()).getXValCount()) {
                float f4 = (this.mChart.getYAxis().mEntries[n3] - this.mChart.getYChartMin()) * f2;
                PointF pointF3 = Utils.getPosition(pointF, f4, f * (float)n4 + f3);
                PointF pointF4 = Utils.getPosition(pointF, f4, f * (float)(n4 + 1) + f3);
                canvas.drawLine(pointF3.x, pointF3.y, pointF4.x, pointF4.y, this.mWebPaint);
                ++n4;
            }
            ++n3;
        }
    }

    @Override
    public void drawHighlighted(Canvas canvas, Highlight[] highlightArray) {
        float f = this.mAnimator.getPhaseX();
        float f2 = this.mAnimator.getPhaseY();
        float f3 = this.mChart.getSliceAngle();
        float f4 = this.mChart.getFactor();
        PointF pointF = this.mChart.getCenterOffsets();
        int n = 0;
        while (n < highlightArray.length) {
            int n2;
            Object t;
            IRadarDataSet iRadarDataSet = (IRadarDataSet)((RadarData)this.mChart.getData()).getDataSetByIndex(highlightArray[n].getDataSetIndex());
            if (iRadarDataSet != null && iRadarDataSet.isHighlightEnabled() && (t = iRadarDataSet.getEntryForXIndex(n2 = highlightArray[n].getXIndex())) != null && ((Entry)t).getXIndex() == n2) {
                int n3 = iRadarDataSet.getEntryIndex(t);
                float f5 = ((Entry)t).getVal() - this.mChart.getYChartMin();
                if (!Float.isNaN(f5)) {
                    PointF pointF2 = Utils.getPosition(pointF, f5 * f4 * f2, f3 * (float)n3 * f + this.mChart.getRotationAngle());
                    float[] fArray = new float[]{pointF2.x, pointF2.y};
                    this.drawHighlightLines(canvas, fArray, iRadarDataSet);
                }
            }
            ++n;
        }
    }
}

