/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.PointF;
import com.github.mikephil.charting.charts.BarChart;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.renderer.XAxisRenderer;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;

public class XAxisRendererBarChart
extends XAxisRenderer {
    protected BarChart mChart;

    public XAxisRendererBarChart(ViewPortHandler viewPortHandler, XAxis xAxis, Transformer transformer, BarChart barChart) {
        super(viewPortHandler, xAxis, transformer);
        this.mChart = barChart;
    }

    @Override
    protected void drawLabels(Canvas canvas, float f, PointF pointF) {
        float f2 = this.mXAxis.getLabelRotationAngle();
        float[] fArray = new float[]{0.0f, 0.0f};
        BarData barData = (BarData)this.mChart.getData();
        int n = barData.getDataSetCount();
        int n2 = this.mMinX;
        while (n2 <= this.mMaxX) {
            fArray[0] = (float)(n2 * n) + (float)n2 * barData.getGroupSpace() + barData.getGroupSpace() / 2.0f;
            if (n > 1) {
                fArray[0] = fArray[0] + ((float)n - 1.0f) / 2.0f;
            }
            this.mTrans.pointValuesToPixel(fArray);
            if (this.mViewPortHandler.isInBoundsX(fArray[0]) && n2 >= 0 && n2 < this.mXAxis.getValues().size()) {
                String string = this.mXAxis.getValues().get(n2);
                if (this.mXAxis.isAvoidFirstLastClippingEnabled()) {
                    float f3;
                    if (n2 == this.mXAxis.getValues().size() - 1) {
                        f3 = Utils.calcTextWidth(this.mAxisLabelPaint, string);
                        if (fArray[0] + f3 / 2.0f > this.mViewPortHandler.contentRight()) {
                            fArray[0] = this.mViewPortHandler.contentRight() - f3 / 2.0f;
                        }
                    } else if (n2 == 0 && fArray[0] - (f3 = (float)Utils.calcTextWidth(this.mAxisLabelPaint, string)) / 2.0f < this.mViewPortHandler.contentLeft()) {
                        fArray[0] = this.mViewPortHandler.contentLeft() + f3 / 2.0f;
                    }
                }
                this.drawLabel(canvas, string, n2, fArray[0], f, pointF, f2);
            }
            n2 += this.mXAxis.mAxisLabelModulus;
        }
    }

    @Override
    public void renderGridLines(Canvas canvas) {
        if (!this.mXAxis.isDrawGridLinesEnabled() || !this.mXAxis.isEnabled()) {
            return;
        }
        float[] fArray = new float[]{0.0f, 0.0f};
        this.mGridPaint.setColor(this.mXAxis.getGridColor());
        this.mGridPaint.setStrokeWidth(this.mXAxis.getGridLineWidth());
        BarData barData = (BarData)this.mChart.getData();
        int n = barData.getDataSetCount();
        int n2 = this.mMinX;
        while (n2 < this.mMaxX) {
            fArray[0] = (float)(n2 * n) + (float)n2 * barData.getGroupSpace() - 0.5f;
            this.mTrans.pointValuesToPixel(fArray);
            if (this.mViewPortHandler.isInBoundsX(fArray[0])) {
                canvas.drawLine(fArray[0], this.mViewPortHandler.offsetTop(), fArray[0], this.mViewPortHandler.contentBottom(), this.mGridPaint);
            }
            n2 += this.mXAxis.mAxisLabelModulus;
        }
    }

    @Override
    public void renderIndexMarkLines(Canvas canvas) {
        float[] fArray = new float[]{0.0f, 0.0f};
        this.mGridPaint.setColor(this.mXAxis.getGridColor());
        this.mGridPaint.setStrokeWidth(this.mXAxis.getGridLineWidth());
        BarData barData = (BarData)this.mChart.getData();
        int n = barData.getDataSetCount();
        int n2 = -6;
        int n3 = this.mMinX;
        while (n3 < this.mMaxX) {
            fArray[0] = (float)(n3 * n) + (float)n3 * barData.getGroupSpace() - 0.5f;
            this.mTrans.pointValuesToPixel(fArray);
            if (this.mViewPortHandler.isInBoundsX(fArray[0])) {
                canvas.drawLine(fArray[0], this.mViewPortHandler.contentBottom() + (float)n2, fArray[0], this.mViewPortHandler.contentBottom(), this.mGridPaint);
            }
            n3 += this.mXAxis.mAxisLabelModulus;
        }
    }
}

