/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import com.github.mikephil.charting.components.LimitLine;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.renderer.YAxisRenderer;
import com.github.mikephil.charting.utils.PointD;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class YAxisRendererHorizontalBarChart
extends YAxisRenderer {
    public YAxisRendererHorizontalBarChart(ViewPortHandler viewPortHandler, YAxis yAxis, Transformer transformer) {
        super(viewPortHandler, yAxis, transformer);
        this.mLimitLinePaint.setTextAlign(Paint.Align.LEFT);
    }

    @Override
    public void computeAxis(float f, float f2) {
        if (this.mViewPortHandler.contentHeight() > 10.0f && !this.mViewPortHandler.isFullyZoomedOutX()) {
            PointD pointD = this.mTrans.getValuesByTouchPoint(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop());
            PointD pointD2 = this.mTrans.getValuesByTouchPoint(this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentTop());
            if (!this.mYAxis.isInverted()) {
                f = (float)pointD.x;
                f2 = (float)pointD2.x;
            } else {
                f = (float)pointD2.x;
                f2 = (float)pointD.x;
            }
        }
        this.computeAxisValues(f, f2);
    }

    @Override
    public void renderAxisLabels(Canvas canvas) {
        if (!this.mYAxis.isEnabled() || !this.mYAxis.isDrawLabelsEnabled()) {
            return;
        }
        float[] fArray = new float[this.mYAxis.mEntryCount * 2];
        int n = 0;
        while (n < fArray.length) {
            fArray[n] = this.mYAxis.mEntries[n / 2];
            n += 2;
        }
        this.mTrans.pointValuesToPixel(fArray);
        this.mAxisLabelPaint.setTypeface(this.mYAxis.getTypeface());
        this.mAxisLabelPaint.setTextSize(this.mYAxis.getTextSize());
        this.mAxisLabelPaint.setColor(this.mYAxis.getTextColor());
        this.mAxisLabelPaint.setTextAlign(Paint.Align.CENTER);
        float f = Utils.convertDpToPixel(2.5f);
        float f2 = Utils.calcTextHeight(this.mAxisLabelPaint, "Q");
        YAxis.AxisDependency axisDependency = this.mYAxis.getAxisDependency();
        YAxis.YAxisLabelPosition yAxisLabelPosition = this.mYAxis.getLabelPosition();
        float f3 = 0.0f;
        f3 = axisDependency == YAxis.AxisDependency.LEFT ? (yAxisLabelPosition == YAxis.YAxisLabelPosition.OUTSIDE_CHART ? this.mViewPortHandler.contentTop() - f : this.mViewPortHandler.contentTop() - f) : (yAxisLabelPosition == YAxis.YAxisLabelPosition.OUTSIDE_CHART ? this.mViewPortHandler.contentBottom() + f2 + f : this.mViewPortHandler.contentBottom() + f2 + f);
        this.drawYLabels(canvas, f3, fArray, this.mYAxis.getYOffset());
    }

    @Override
    public void renderAxisLine(Canvas canvas) {
        if (!this.mYAxis.isEnabled() || !this.mYAxis.isDrawAxisLineEnabled()) {
            return;
        }
        this.mAxisLinePaint.setColor(this.mYAxis.getAxisLineColor());
        this.mAxisLinePaint.setStrokeWidth(this.mYAxis.getAxisLineWidth());
        if (this.mYAxis.getAxisDependency() == YAxis.AxisDependency.LEFT) {
            canvas.drawLine(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop(), this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentTop(), this.mAxisLinePaint);
        } else {
            canvas.drawLine(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom(), this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentBottom(), this.mAxisLinePaint);
        }
    }

    @Override
    protected void drawYLabels(Canvas canvas, float f, float[] fArray, float f2) {
        this.mAxisLabelPaint.setTypeface(this.mYAxis.getTypeface());
        this.mAxisLabelPaint.setTextSize(this.mYAxis.getTextSize());
        this.mAxisLabelPaint.setColor(this.mYAxis.getTextColor());
        int n = 0;
        while (n < this.mYAxis.mEntryCount) {
            String string = this.mYAxis.getFormattedLabel(n);
            if (!this.mYAxis.isDrawTopYLabelEntryEnabled() && n >= this.mYAxis.mEntryCount - 1) {
                return;
            }
            canvas.drawText(string, fArray[n * 2], f - f2, this.mAxisLabelPaint);
            ++n;
        }
    }

    @Override
    public void renderGridLines(Canvas canvas) {
        if (!this.mYAxis.isEnabled()) {
            return;
        }
        float[] fArray = new float[2];
        if (this.mYAxis.isDrawGridLinesEnabled()) {
            this.mGridPaint.setColor(this.mYAxis.getGridColor());
            this.mGridPaint.setStrokeWidth(this.mYAxis.getGridLineWidth());
            int n = 0;
            while (n < this.mYAxis.mEntryCount) {
                fArray[0] = this.mYAxis.mEntries[n];
                this.mTrans.pointValuesToPixel(fArray);
                canvas.drawLine(fArray[0], this.mViewPortHandler.contentTop(), fArray[0], this.mViewPortHandler.contentBottom(), this.mGridPaint);
                ++n;
            }
        }
        if (this.mYAxis.isDrawZeroLineEnabled()) {
            fArray[0] = 0.0f;
            this.mTrans.pointValuesToPixel(fArray);
            this.drawZeroLine(canvas, fArray[0] + 1.0f, fArray[0] + 1.0f, this.mViewPortHandler.contentTop(), this.mViewPortHandler.contentBottom());
        }
    }

    @Override
    public void renderLimitLines(Canvas canvas) {
        List<LimitLine> list = this.mYAxis.getLimitLines();
        if (list == null || list.size() <= 0) {
            return;
        }
        float[] fArray = new float[4];
        Path path = new Path();
        int n = 0;
        while (n < list.size()) {
            LimitLine limitLine = list.get(n);
            if (limitLine.isEnabled()) {
                fArray[0] = limitLine.getLimit();
                fArray[2] = limitLine.getLimit();
                this.mTrans.pointValuesToPixel(fArray);
                fArray[1] = this.mViewPortHandler.contentTop();
                fArray[3] = this.mViewPortHandler.contentBottom();
                path.moveTo(fArray[0], fArray[1]);
                path.lineTo(fArray[2], fArray[3]);
                this.mLimitLinePaint.setStyle(Paint.Style.STROKE);
                this.mLimitLinePaint.setColor(limitLine.getLineColor());
                this.mLimitLinePaint.setPathEffect((PathEffect)limitLine.getDashPathEffect());
                this.mLimitLinePaint.setStrokeWidth(limitLine.getLineWidth());
                canvas.drawPath(path, this.mLimitLinePaint);
                path.reset();
                String string = limitLine.getLabel();
                if (string != null && !string.equals("")) {
                    float f;
                    this.mLimitLinePaint.setStyle(limitLine.getTextStyle());
                    this.mLimitLinePaint.setPathEffect(null);
                    this.mLimitLinePaint.setColor(limitLine.getTextColor());
                    this.mLimitLinePaint.setTypeface(limitLine.getTypeface());
                    this.mLimitLinePaint.setStrokeWidth(0.5f);
                    this.mLimitLinePaint.setTextSize(limitLine.getTextSize());
                    float f2 = limitLine.getLineWidth() + limitLine.getXOffset();
                    float f3 = Utils.convertDpToPixel(2.0f) + limitLine.getYOffset();
                    LimitLine.LimitLabelPosition limitLabelPosition = limitLine.getLabelPosition();
                    if (limitLabelPosition == LimitLine.LimitLabelPosition.RIGHT_TOP) {
                        f = Utils.calcTextHeight(this.mLimitLinePaint, string);
                        this.mLimitLinePaint.setTextAlign(Paint.Align.LEFT);
                        canvas.drawText(string, fArray[0] + f2, this.mViewPortHandler.contentTop() + f3 + f, this.mLimitLinePaint);
                    } else if (limitLabelPosition == LimitLine.LimitLabelPosition.RIGHT_BOTTOM) {
                        this.mLimitLinePaint.setTextAlign(Paint.Align.LEFT);
                        canvas.drawText(string, fArray[0] + f2, this.mViewPortHandler.contentBottom() - f3, this.mLimitLinePaint);
                    } else if (limitLabelPosition == LimitLine.LimitLabelPosition.LEFT_TOP) {
                        this.mLimitLinePaint.setTextAlign(Paint.Align.RIGHT);
                        f = Utils.calcTextHeight(this.mLimitLinePaint, string);
                        canvas.drawText(string, fArray[0] - f2, this.mViewPortHandler.contentTop() + f3 + f, this.mLimitLinePaint);
                    } else {
                        this.mLimitLinePaint.setTextAlign(Paint.Align.RIGHT);
                        canvas.drawText(string, fArray[0] - f2, this.mViewPortHandler.contentBottom() - f3, this.mLimitLinePaint);
                    }
                }
            }
            ++n;
        }
    }
}

