/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.utils;

import android.content.res.AssetManager;
import android.os.Environment;
import android.util.Log;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.Entry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    public static List<Entry> loadEntriesFromFile(String string) {
        File file = Environment.getExternalStorageDirectory();
        File file2 = new File(file, string);
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = string2.split("#");
                if (stringArray.length <= 2) {
                    arrayList.add(new Entry(Float.parseFloat(stringArray[0]), Integer.parseInt(stringArray[1])));
                    continue;
                }
                float[] fArray = new float[stringArray.length - 1];
                int n = 0;
                while (n < fArray.length) {
                    fArray[n] = Float.parseFloat(stringArray[n]);
                    ++n;
                }
                arrayList.add(new BarEntry(fArray, Integer.parseInt(stringArray[stringArray.length - 1])));
            }
        }
        catch (IOException iOException) {
            Log.e((String)"MPChart-FileUtils", (String)iOException.toString());
        }
        return arrayList;
    }

    public static List<Entry> loadEntriesFromAssets(AssetManager assetManager, String string) {
        ArrayList<Entry> arrayList;
        block16: {
            arrayList = new ArrayList<Entry>();
            BufferedReader bufferedReader = null;
            try {
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(assetManager.open(string), "UTF-8"));
                    String string2 = bufferedReader.readLine();
                    while (string2 != null) {
                        String[] stringArray = string2.split("#");
                        if (stringArray.length <= 2) {
                            arrayList.add(new Entry(Float.parseFloat(stringArray[0]), Integer.parseInt(stringArray[1])));
                        } else {
                            float[] fArray = new float[stringArray.length - 1];
                            int n = 0;
                            while (n < fArray.length) {
                                fArray[n] = Float.parseFloat(stringArray[n]);
                                ++n;
                            }
                            arrayList.add(new BarEntry(fArray, Integer.parseInt(stringArray[stringArray.length - 1])));
                        }
                        string2 = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    Log.e((String)"MPChart-FileUtils", (String)iOException.toString());
                    if (bufferedReader == null) break block16;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2) {
                        Log.e((String)"MPChart-FileUtils", (String)iOException2.toString());
                    }
                }
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        Log.e((String)"MPChart-FileUtils", (String)iOException.toString());
                    }
                }
            }
        }
        return arrayList;
    }

    public static void saveToSdCard(List<Entry> list, String string) {
        File file = Environment.getExternalStorageDirectory();
        File file2 = new File(file, string);
        if (!file2.exists()) {
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                Log.e((String)"MPChart-FileUtils", (String)iOException.toString());
            }
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2, true));
            for (Entry entry : list) {
                bufferedWriter.append(String.valueOf(entry.getVal()) + "#" + entry.getXIndex());
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            Log.e((String)"MPChart-FileUtils", (String)iOException.toString());
        }
    }

    public static List<BarEntry> loadBarEntriesFromAssets(AssetManager assetManager, String string) {
        ArrayList<BarEntry> arrayList;
        block13: {
            arrayList = new ArrayList<BarEntry>();
            BufferedReader bufferedReader = null;
            try {
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(assetManager.open(string), "UTF-8"));
                    String string2 = bufferedReader.readLine();
                    while (string2 != null) {
                        String[] stringArray = string2.split("#");
                        arrayList.add(new BarEntry(Float.parseFloat(stringArray[0]), Integer.parseInt(stringArray[1])));
                        string2 = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    Log.e((String)"MPChart-FileUtils", (String)iOException.toString());
                    if (bufferedReader == null) break block13;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2) {
                        Log.e((String)"MPChart-FileUtils", (String)iOException2.toString());
                    }
                }
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        Log.e((String)"MPChart-FileUtils", (String)iOException.toString());
                    }
                }
            }
        }
        return arrayList;
    }
}

