/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.utils;

import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.view.View;
import com.github.mikephil.charting.utils.Utils;

public class ViewPortHandler {
    protected final Matrix mMatrixTouch = new Matrix();
    protected RectF mContentRect = new RectF();
    protected float mChartWidth = 0.0f;
    protected float mChartHeight = 0.0f;
    private float a = 1.0f;
    private float b = Float.MAX_VALUE;
    private float c = 1.0f;
    private float d = Float.MAX_VALUE;
    private float e = 1.0f;
    private float f = 1.0f;
    private float g = 0.0f;
    private float h = 0.0f;
    private float i = 0.0f;
    private float j = 0.0f;
    protected final float[] matrixBuffer = new float[9];

    public void setChartDimens(float f, float f2) {
        float f3 = this.offsetLeft();
        float f4 = this.offsetTop();
        float f5 = this.offsetRight();
        float f6 = this.offsetBottom();
        this.mChartHeight = f2;
        this.mChartWidth = f;
        this.restrainViewPort(f3, f4, f5, f6);
    }

    public boolean hasChartDimens() {
        return this.mChartHeight > 0.0f && this.mChartWidth > 0.0f;
    }

    public void restrainViewPort(float f, float f2, float f3, float f4) {
        this.mContentRect.set(f, f2, this.mChartWidth - f3, this.mChartHeight - f4);
    }

    public float offsetLeft() {
        return this.mContentRect.left;
    }

    public float offsetRight() {
        return this.mChartWidth - this.mContentRect.right;
    }

    public float offsetTop() {
        return this.mContentRect.top;
    }

    public float offsetBottom() {
        return this.mChartHeight - this.mContentRect.bottom;
    }

    public float contentTop() {
        return this.mContentRect.top;
    }

    public float contentLeft() {
        return this.mContentRect.left;
    }

    public float contentRight() {
        return this.mContentRect.right;
    }

    public float contentBottom() {
        return this.mContentRect.bottom;
    }

    public float contentWidth() {
        return this.mContentRect.width();
    }

    public float contentHeight() {
        return this.mContentRect.height();
    }

    public RectF getContentRect() {
        return this.mContentRect;
    }

    public PointF getContentCenter() {
        return new PointF(this.mContentRect.centerX(), this.mContentRect.centerY());
    }

    public float getChartHeight() {
        return this.mChartHeight;
    }

    public float getChartWidth() {
        return this.mChartWidth;
    }

    public Matrix zoomIn(float f, float f2) {
        Matrix matrix = new Matrix();
        matrix.set(this.mMatrixTouch);
        matrix.postScale(1.4f, 1.4f, f, f2);
        return matrix;
    }

    public Matrix zoomOut(float f, float f2) {
        Matrix matrix = new Matrix();
        matrix.set(this.mMatrixTouch);
        matrix.postScale(0.7f, 0.7f, f, f2);
        return matrix;
    }

    public Matrix zoom(float f, float f2) {
        Matrix matrix = new Matrix();
        matrix.set(this.mMatrixTouch);
        matrix.postScale(f, f2);
        return matrix;
    }

    public Matrix zoom(float f, float f2, float f3, float f4) {
        Matrix matrix = new Matrix();
        matrix.set(this.mMatrixTouch);
        matrix.postScale(f, f2, f3, f4);
        return matrix;
    }

    public Matrix setZoom(float f, float f2) {
        Matrix matrix = new Matrix();
        matrix.set(this.mMatrixTouch);
        matrix.setScale(f, f2);
        return matrix;
    }

    public Matrix setZoom(float f, float f2, float f3, float f4) {
        Matrix matrix = new Matrix();
        matrix.set(this.mMatrixTouch);
        matrix.setScale(f, f2, f3, f4);
        return matrix;
    }

    public Matrix fitScreen() {
        this.c = 1.0f;
        this.a = 1.0f;
        Matrix matrix = new Matrix();
        matrix.set(this.mMatrixTouch);
        float[] fArray = new float[9];
        matrix.getValues(fArray);
        fArray[2] = 0.0f;
        fArray[5] = 0.0f;
        fArray[0] = 1.0f;
        fArray[4] = 1.0f;
        matrix.setValues(fArray);
        return matrix;
    }

    public Matrix translate(float[] fArray) {
        Matrix matrix = new Matrix();
        matrix.set(this.mMatrixTouch);
        float f = fArray[0] - this.offsetLeft();
        float f2 = fArray[1] - this.offsetTop();
        matrix.postTranslate(-f, -f2);
        return matrix;
    }

    public void centerViewPort(float[] fArray, View view) {
        Matrix matrix = new Matrix();
        matrix.set(this.mMatrixTouch);
        float f = fArray[0] - this.offsetLeft();
        float f2 = fArray[1] - this.offsetTop();
        matrix.postTranslate(-f, -f2);
        this.refresh(matrix, view, true);
    }

    public Matrix refresh(Matrix matrix, View view, boolean bl) {
        this.mMatrixTouch.set(matrix);
        this.limitTransAndScale(this.mMatrixTouch, this.mContentRect);
        if (bl) {
            view.invalidate();
        }
        matrix.set(this.mMatrixTouch);
        return matrix;
    }

    public void limitTransAndScale(Matrix matrix, RectF rectF) {
        matrix.getValues(this.matrixBuffer);
        float f = this.matrixBuffer[2];
        float f2 = this.matrixBuffer[0];
        float f3 = this.matrixBuffer[5];
        float f4 = this.matrixBuffer[4];
        this.e = Math.min(Math.max(this.c, f2), this.d);
        this.f = Math.min(Math.max(this.a, f4), this.b);
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (rectF != null) {
            f5 = rectF.width();
            f6 = rectF.height();
        }
        float f7 = -f5 * (this.e - 1.0f);
        this.g = Math.min(Math.max(f, f7 - this.i), this.i);
        float f8 = f6 * (this.f - 1.0f);
        this.h = Math.max(Math.min(f3, f8 + this.j), -this.j);
        this.matrixBuffer[2] = this.g;
        this.matrixBuffer[0] = this.e;
        this.matrixBuffer[5] = this.h;
        this.matrixBuffer[4] = this.f;
        matrix.setValues(this.matrixBuffer);
    }

    public void setMinimumScaleX(float f) {
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.c = f;
        this.limitTransAndScale(this.mMatrixTouch, this.mContentRect);
    }

    public void setMaximumScaleX(float f) {
        this.d = f;
        this.limitTransAndScale(this.mMatrixTouch, this.mContentRect);
    }

    public void setMinMaxScaleX(float f, float f2) {
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.c = f;
        this.d = f2;
        this.limitTransAndScale(this.mMatrixTouch, this.mContentRect);
    }

    public void setMinimumScaleY(float f) {
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.a = f;
        this.limitTransAndScale(this.mMatrixTouch, this.mContentRect);
    }

    public void setMaximumScaleY(float f) {
        this.b = f;
        this.limitTransAndScale(this.mMatrixTouch, this.mContentRect);
    }

    public Matrix getMatrixTouch() {
        return this.mMatrixTouch;
    }

    public boolean isInBoundsX(float f) {
        return this.isInBoundsLeft(f) && this.isInBoundsRight(f);
    }

    public boolean isInBoundsY(float f) {
        return this.isInBoundsTop(f) && this.isInBoundsBottom(f);
    }

    public boolean isInBounds(float f, float f2) {
        return this.isInBoundsX(f) && this.isInBoundsY(f2);
    }

    public boolean isInBoundsLeft(float f) {
        return this.mContentRect.left <= f;
    }

    public boolean isInBoundsRight(float f) {
        return this.mContentRect.right >= (f = (float)((int)(f * 100.0f)) / 100.0f);
    }

    public boolean isInBoundsTop(float f) {
        return this.mContentRect.top <= f;
    }

    public boolean isInBoundsBottom(float f) {
        return this.mContentRect.bottom >= (f = (float)((int)(f * 100.0f)) / 100.0f);
    }

    public float getScaleX() {
        return this.e;
    }

    public float getScaleY() {
        return this.f;
    }

    public float getMinScaleX() {
        return this.c;
    }

    public float getMaxScaleX() {
        return this.d;
    }

    public float getMinScaleY() {
        return this.a;
    }

    public float getMaxScaleY() {
        return this.b;
    }

    public float getTransX() {
        return this.g;
    }

    public float getTransY() {
        return this.h;
    }

    public boolean isFullyZoomedOut() {
        return this.isFullyZoomedOutX() && this.isFullyZoomedOutY();
    }

    public boolean isFullyZoomedOutY() {
        return !(this.f > this.a) && !(this.a > 1.0f);
    }

    public boolean isFullyZoomedOutX() {
        return !(this.e > this.c) && !(this.c > 1.0f);
    }

    public void setDragOffsetX(float f) {
        this.i = Utils.convertDpToPixel(f);
    }

    public void setDragOffsetY(float f) {
        this.j = Utils.convertDpToPixel(f);
    }

    public boolean hasNoDragOffset() {
        return this.i <= 0.0f && this.j <= 0.0f;
    }

    public boolean canZoomOutMoreX() {
        return this.e > this.c;
    }

    public boolean canZoomInMoreX() {
        return this.e < this.d;
    }

    public boolean canZoomOutMoreY() {
        return this.f > this.a;
    }

    public boolean canZoomInMoreY() {
        return this.f < this.b;
    }
}

