/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst;

import com.supermap.analyst.BufferAnalystGeometryNative;
import com.supermap.analyst.BufferAnalystParameter;
import com.supermap.analyst.BufferEndType;
import com.supermap.analyst.BufferRadiusUnit;
import com.supermap.analyst.a;
import com.supermap.analyst.b;
import com.supermap.analyst.c;
import com.supermap.analyst.d;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Toolkit;

public class BufferAnalystGeometry {
    private BufferAnalystGeometry() {
    }

    public static GeoRegion createBuffer(Geometry geometry, BufferAnalystParameter bufferAnalystParameter, PrjCoordSys prjCoordSys) {
        double d2;
        BufferEndType bufferEndType = bufferAnalystParameter.getEndType();
        int n = bufferAnalystParameter.getSemicircleLineSegment();
        Object object = bufferAnalystParameter.getLeftDistance();
        Object object2 = bufferAnalystParameter.getRightDistance();
        BufferRadiusUnit bufferRadiusUnit = bufferAnalystParameter.getRadiusUnit();
        long l = b.a(prjCoordSys);
        if (geometry == null) {
            String string = c.a("geometry", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = b.a(geometry);
        if (l2 == 0L) {
            String string = c.a("geometry", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        int n2 = -1;
        GeoRegion geoRegion = null;
        GeometryType geometryType = geometry.getType();
        if (bufferEndType.equals(BufferEndType.FLAT)) {
            if (object == null && object2 == null) {
                String string = c.a("objLeftDistance and objRightDistance", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (geometryType != GeometryType.GEOLINE) {
                String string = c.a("geometry", "BufferAnalyst_BufferGeometryTypeShouldBeLine", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (object instanceof String || object2 instanceof String) {
                String string = c.a("LeftDistance and RightDistance", "BufferAnalyst_DistenceOfStringTypeIsInvalidForGeometryBuffer", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            d2 = d.a(object);
            double d3 = d.a(object2);
            if (object != null && d2 <= 0.0) {
                String string = c.a("leftDistance", "BufferAnalyst_BufferDistanceShouldBePositive", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (object2 != null && d3 <= 0.0) {
                String string = c.a("rightDistance", "BufferAnalyst_BufferDistanceShouldBePositive", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (object == null) {
                n2 = d.a.d.value();
            } else if (object2 == null) {
                n2 = d.a.c.value();
            } else if (d2 == d3) {
                n2 = d.a.b.value();
            } else if (d2 != d3) {
                n2 = d.a.e.value();
            }
            if (geometry.isEmpty()) {
                return new GeoRegion();
            }
            int n3 = BufferEndType.FLAT.value();
            long l3 = BufferAnalystGeometryNative.jni_CreateLineBuffer(l2, l, d2, d3, bufferRadiusUnit.value(), n, n2, n3);
            geoRegion = l3 != 0L ? (GeoRegion)a.a(l3) : new GeoRegion();
        }
        if (bufferEndType.equals(BufferEndType.ROUND)) {
            if (geometryType != GeometryType.GEOPOINT && geometryType != GeometryType.GEOLINE && geometryType != GeometryType.GEOREGION) {
                String string = c.a("geometry", "BufferAnalyst_BufferGeometryTypeInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (object instanceof String) {
                String string = c.a("LeftDistance", "BufferAnalyst_DistenceOfStringTypeIsInvalidForGeometryBuffer", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            d2 = d.a(object);
            if (object == null) {
                String string = c.a("objLeftDistance", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (!geometryType.equals(GeometryType.GEOREGION) && d2 <= 0.0) {
                String string = c.a("", "BufferAnalyst_BufferDistanceShouldBePositive", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometryType.equals(GeometryType.GEOREGION) && Toolkit.isZero(d2)) {
                String string = c.a("", "BufferAnalyst_BufferDistanceShouldNotBeZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometryType.equals(GeometryType.GEOLINE)) {
                n2 = d.a.b.value();
            }
            if (geometry.isEmpty()) {
                return new GeoRegion();
            }
            int n4 = BufferEndType.ROUND.value();
            long l4 = BufferAnalystGeometryNative.jni_CreateGeometryBuffer(l2, l, d2, bufferRadiusUnit.value(), n, n2, n4);
            geoRegion = l4 != 0L ? (GeoRegion)a.a(l4) : new GeoRegion();
        }
        return geoRegion;
    }
}

