/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Color;
import com.supermap.data.ColorGradientType;
import com.supermap.data.ColorsNative;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;

public class Colors
extends InternalHandleDisposable {
    private boolean a = false;

    public Colors() {
        this.setHandle(ColorsNative.jni_New(), true);
    }

    public Colors(Color[] colorArray) {
        if (colorArray == null) {
            String string = InternalResource.loadString("colors", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        this.setHandle(ColorsNative.jni_New(), true);
        this.addRange(colorArray);
    }

    public Colors(Colors colors) {
        if (colors == null) {
            throw new NullPointerException("colors");
        }
        if (colors.getHandle() == 0L) {
            String string = InternalResource.loadString("colors", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(ColorsNative.jni_New(), true);
        this.addRange(colors.toArray());
    }

    Colors(long l, boolean bl) {
        this.a = bl;
        this.setHandle(l, false);
    }

    Colors(long l, boolean bl, boolean bl2) {
        this.a = bl2;
        this.setHandle(l, bl);
    }

    public Color get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = ColorsNative.jni_GetItem(this.getHandle(), n);
        Color color = new Color(n2);
        if (this.a) {
            color = this.a(color);
        }
        return color;
    }

    public void set(int n, Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("set(int index, Color value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (color == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        Color color2 = color;
        if (this.a) {
            color2 = this.a(color);
        }
        ColorsNative.jni_Set(this.getHandle(), n, color2.getRGB());
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ColorsNative.jni_GetCount(this.getHandle());
    }

    public int add(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(Color color)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (color == null) {
            String string = InternalResource.loadString("color", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        Color color2 = color;
        if (this.a) {
            color2 = this.a(color);
        }
        return ColorsNative.jni_Add(this.getHandle(), color2.getRGB());
    }

    public int addRange(Color[] colorArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addRange(Color[] colors)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (colorArray == null) {
            throw new NullPointerException("colors");
        }
        int n = colorArray.length;
        int[] nArray = new int[n];
        if (this.a) {
            for (int i = 0; i < n; ++i) {
                Color color = this.a(colorArray[i]);
                nArray[i] = color.getRGB();
            }
        } else {
            for (int i = 0; i < n; ++i) {
                nArray[i] = colorArray[i].getRGB();
            }
        }
        return ColorsNative.jni_AddRange(this.getHandle(), nArray);
    }

    public boolean insert(int n, Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insert(int index, Color color)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_InvalidInsertPosition", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (color == null) {
            String string = InternalResource.loadString("color", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (n == this.getCount()) {
            return this.add(color) != -1;
        }
        Color color2 = color;
        if (this.a) {
            color2 = this.a(color);
        }
        boolean bl = ColorsNative.jni_Insert(this.getHandle(), n, color2.getRGB());
        return bl;
    }

    public boolean remove(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return ColorsNative.jni_Remove(this.getHandle(), n);
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        ColorsNative.jni_Clear(this.getHandle());
    }

    public static Colors makeRandom(int n) {
        if (n <= 0) {
            String string = InternalResource.loadString("count", "Colors_CountShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ColorsNative.jni_MakeRandom(n);
        if (l == 0L) {
            return null;
        }
        return new Colors(l, true, false);
    }

    public static Colors makeGradient(int n, Color[] colorArray) {
        if (n <= 0) {
            String string = InternalResource.loadString("count", "Colors_CountShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (colorArray == null) {
            String string = InternalResource.loadString("intervalColors", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (colorArray.length < 2) {
            String string = InternalResource.loadString("intervalColors", "Colors_IntervalColorsLengthInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = colorArray.length;
        int[] nArray = new int[n2];
        for (int i = 0; i < colorArray.length; ++i) {
            nArray[i] = colorArray[i].getRGB();
        }
        long l = ColorsNative.jni_MakeGradient1(n, nArray);
        if (l == 0L) {
            return null;
        }
        return new Colors(l, true, false);
    }

    public static Colors makeGradient(int n, ColorGradientType colorGradientType, boolean bl) {
        if (n <= 0) {
            String string = InternalResource.loadString("count", "Colors_CountShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (colorGradientType == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = ColorsNative.jni_MakeGradient2(n, colorGradientType.getUGCValue(), bl);
        if (l == 0L) {
            return null;
        }
        return new Colors(l, true, false);
    }

    public Color[] toArray() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toArray()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        Color[] colorArray = new Color[n];
        for (int i = 0; i < n; ++i) {
            colorArray[i] = this.get(i);
        }
        return colorArray;
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Count=");
        stringBuffer.append(this.getCount());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            ColorsNative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    @Override
    protected void clearHandle() {
        this.setHandle(0L);
    }

    protected static Colors createInstance(long l, boolean bl) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new Colors(l, bl);
    }

    protected static void clearHandle(Colors colors) {
        colors.clearHandle();
    }

    protected static void changeHandle(Colors colors, long l) {
        colors.a(l);
    }

    private void a(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() != 0L) {
            ColorsNative.jni_Delete(this.getHandle());
        }
        this.setHandle(l, false);
    }

    private Color a(Color color) {
        Color color2 = new Color(color.getB(), color.getG(), color.getR());
        return color2;
    }

    public Colors makeRandom(int n, Color[] colorArray) {
        if (n < 2) {
            String string = InternalResource.loadString("count", "Colors_CountShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (colorArray == null) {
            String string = InternalResource.loadString("color", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (colorArray.length < 2) {
            String string = InternalResource.loadString("color", "Colors_IntervalColorsLengthInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (colorArray.length > n) {
            String string = InternalResource.loadString("count", "Colors_IntervalColorsLengthInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = colorArray.length;
        int[] nArray = new int[n2];
        for (int i = 0; i < colorArray.length; ++i) {
            nArray[i] = colorArray[i].getRGB();
        }
        long l = ColorsNative.jni_MakeRandom1(n, nArray);
        if (l == 0L) {
            return null;
        }
        return new Colors(l, true, false);
    }
}

