/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CoordSysTransMethod;
import com.supermap.data.CoordSysTransParameter;
import com.supermap.data.CoordSysTranslatorNative;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;
import com.supermap.data.PrjCoordSys;

public final class CoordSysTranslator {
    public static boolean forward(Point2Ds point2Ds, PrjCoordSys prjCoordSys) {
        int n;
        if (point2Ds == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Point2Ds.a a2 = point2Ds.a();
        point2Ds.a(Point2Ds.a.a);
        int n2 = point2Ds.getCount();
        if (n2 < 1) {
            String string = InternalResource.loadString("points", "Point2DsIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = point2Ds.getItem(n).getX();
            dArray2[n] = point2Ds.getItem(n).getY();
            if (!(dArray[n] > 180.0 || dArray[n] < -180.0 || dArray2[n] > 90.0) && !(dArray2[n] < -90.0)) continue;
            String string = InternalResource.loadString("points", "InvalidLongitudeLatitudeCoord", "data_resources");
            throw new IllegalArgumentException(string);
        }
        n = CoordSysTranslatorNative.jni_Forward(dArray, dArray2, prjCoordSys.getHandle()) ? 1 : 0;
        for (int i = 0; i < n2; ++i) {
            point2Ds.setItem(i, new Point2D(dArray[i], dArray2[i]));
        }
        point2Ds.a(a2);
        return n != 0;
    }

    public static boolean inverse(Point2Ds point2Ds, PrjCoordSys prjCoordSys) {
        int n;
        if (point2Ds == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Point2Ds.a a2 = point2Ds.a();
        point2Ds.a(Point2Ds.a.a);
        int n2 = point2Ds.getCount();
        if (n2 < 1) {
            String string = InternalResource.loadString("points", "Point2DsIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = point2Ds.getItem(n).getX();
            dArray2[n] = point2Ds.getItem(n).getY();
        }
        n = CoordSysTranslatorNative.jni_Inverse(dArray, dArray2, prjCoordSys.getHandle()) ? 1 : 0;
        for (int i = 0; i < n2; ++i) {
            point2Ds.setItem(i, new Point2D(dArray[i], dArray2[i]));
        }
        point2Ds.a(a2);
        return n != 0;
    }

    public static boolean convert(Point2Ds point2Ds, PrjCoordSys prjCoordSys, PrjCoordSys prjCoordSys2, CoordSysTransParameter coordSysTransParameter, CoordSysTransMethod coordSysTransMethod) {
        int n;
        if (point2Ds == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Point2Ds.a a2 = point2Ds.a();
        point2Ds.a(Point2Ds.a.a);
        int n2 = point2Ds.getCount();
        if (n2 < 1) {
            String string = InternalResource.loadString("points", "Point2DsIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("srcPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys2 == null || prjCoordSys2.getHandle() == 0L) {
            String string = InternalResource.loadString("targetPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (coordSysTransParameter == null || coordSysTransParameter.getHandle() == 0L) {
            coordSysTransParameter = new CoordSysTransParameter();
        }
        if (coordSysTransMethod == null) {
            String string = InternalResource.loadString("coordSysTransMethod", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = point2Ds.getItem(n).getX();
            dArray2[n] = point2Ds.getItem(n).getY();
        }
        n = CoordSysTranslatorNative.jni_ConvertPoints(dArray, dArray2, prjCoordSys.getHandle(), prjCoordSys2.getHandle(), coordSysTransParameter.getHandle(), coordSysTransMethod.getUGCValue()) ? 1 : 0;
        for (int i = 0; i < n2; ++i) {
            point2Ds.setItem(i, new Point2D(dArray[i], dArray2[i]));
        }
        point2Ds.a(a2);
        return n != 0;
    }

    public static boolean convert(Point3Ds point3Ds, PrjCoordSys prjCoordSys, PrjCoordSys prjCoordSys2, CoordSysTransParameter coordSysTransParameter, CoordSysTransMethod coordSysTransMethod) {
        int n;
        if (point3Ds == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = point3Ds.getCount();
        if (n2 < 1) {
            String string = InternalResource.loadString("points", "Point2DsIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("srcPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys2 == null || prjCoordSys2.getHandle() == 0L) {
            String string = InternalResource.loadString("targetPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (coordSysTransParameter == null || coordSysTransParameter.getHandle() == 0L) {
            coordSysTransParameter = new CoordSysTransParameter();
        }
        if (coordSysTransMethod == null) {
            String string = InternalResource.loadString("coordSysTransMethod", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = point3Ds.getItem(n).getX();
            dArray2[n] = point3Ds.getItem(n).getY();
            dArray3[n] = point3Ds.getItem(n).getZ();
        }
        n = CoordSysTranslatorNative.jni_ConvertPoint3Ds(dArray, dArray2, dArray3, prjCoordSys.getHandle(), prjCoordSys2.getHandle(), coordSysTransParameter.getHandle(), coordSysTransMethod.getUGCValue()) ? 1 : 0;
        for (int i = 0; i < n2; ++i) {
            point3Ds.setItem(i, new Point3D(dArray[i], dArray2[i], dArray3[i]));
        }
        return n != 0;
    }

    public static boolean convert(Geometry geometry, PrjCoordSys prjCoordSys, PrjCoordSys prjCoordSys2, CoordSysTransParameter coordSysTransParameter, CoordSysTransMethod coordSysTransMethod) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("srcPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys2 == null || prjCoordSys2.getHandle() == 0L) {
            String string = InternalResource.loadString("desPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (coordSysTransParameter == null || coordSysTransParameter.getHandle() == 0L) {
            coordSysTransParameter = new CoordSysTransParameter();
        }
        if (coordSysTransMethod == null) {
            String string = InternalResource.loadString("coordSysTransMethod", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = CoordSysTranslatorNative.jni_ConvertGeometry(geometry.getHandle(), prjCoordSys.getHandle(), prjCoordSys2.getHandle(), coordSysTransParameter.getHandle(), coordSysTransMethod.getUGCValue());
        if (geometry.getType() == GeometryType.GEOREGION) {
            ((GeoRegion)geometry).refrashPartsList();
        }
        return bl;
    }
}

