/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import android.util.Log;
import com.supermap.data.Charset;
import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.Datasets;
import com.supermap.data.Datasource;
import com.supermap.data.EncodeType;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldType;
import com.supermap.data.GPXAnalyticClass;
import com.supermap.data.GPXBean;
import com.supermap.data.GPXExportClass;
import com.supermap.data.GeoCoordSysType;
import com.supermap.data.GeoPoint;
import com.supermap.data.InternalResource;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.Recordset;
import com.supermap.data.conversion.DataExport;
import com.supermap.data.conversion.DataImport;
import com.supermap.data.conversion.ExportResult;
import com.supermap.data.conversion.ExportSetting;
import com.supermap.data.conversion.ExportSettings;
import com.supermap.data.conversion.FileType;
import com.supermap.data.conversion.ImportResult;
import com.supermap.data.conversion.ImportSettingDWG;
import com.supermap.data.conversion.ImportSettingDXF;
import com.supermap.data.conversion.ImportSettingKML;
import com.supermap.data.conversion.ImportSettingKMZ;
import com.supermap.data.conversion.ImportSettingMIF;
import com.supermap.data.conversion.ImportSettingSHP;
import com.supermap.data.conversion.ImportSettingTIF;
import com.supermap.data.conversion.ImportSettings;
import com.supermap.data.conversion.MultiBandImportMode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DataConversion {
    static Charset a = Charset.GB18030;
    private static GeoPoint a = null;
    private static Recordset a = null;
    private static Datasets a = null;
    private static DatasetVector a = null;
    private static DatasetVectorInfo a = null;
    private static Map a = null;
    private static FieldInfo a = null;
    private static FieldInfos a = null;
    private static List<GPXBean> a;
    private static GPXBean a;
    private static boolean a;
    private static boolean b;
    private static GPXAnalyticClass a;
    private static Recordset.BatchEditor a;

    public static void setConvertCharset(Charset charset) {
        if (charset == null) {
            String string = InternalResource.loadString("charset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        a = charset;
    }

    public static boolean importSHP(String string, Datasource datasource) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            String string2 = InternalResource.loadString(file.getAbsolutePath(), "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (datasource == null) {
            String string3 = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 2) {
            String string4 = InternalResource.loadString(file.getAbsolutePath(), "GlobalPathSplitNumNotValid", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (stringArray[1].compareTo("shp") != 0) {
            String string5 = InternalResource.loadString(file.getAbsolutePath(), "GlobalPathSplitTypeNotValid", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        ImportSettingSHP importSettingSHP = new ImportSettingSHP();
        importSettingSHP.setTargetDatasource(datasource);
        importSettingSHP.setSourceFilePath(string);
        importSettingSHP.setSourceFileCharset(a);
        DataImport dataImport = new DataImport();
        ImportSettings importSettings = dataImport.getImportSettings();
        importSettings.add(importSettingSHP);
        ImportResult importResult = dataImport.run();
        int n = importResult.getSucceedSettings().length;
        return importResult.getSucceedSettings().length > 0;
    }

    public static boolean importMIF(String string, Datasource datasource) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            String string2 = InternalResource.loadString(file.getAbsolutePath(), "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (datasource == null) {
            String string3 = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 2) {
            String string4 = InternalResource.loadString(file.getAbsolutePath(), "GlobalPathSplitNumNotValid", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (stringArray[1].compareTo("mif") != 0) {
            String string5 = InternalResource.loadString(file.getAbsolutePath(), "GlobalPathSplitTypeNotValid", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        ImportSettingMIF importSettingMIF = new ImportSettingMIF();
        importSettingMIF.setTargetDatasource(datasource);
        importSettingMIF.setSourceFilePath(string);
        importSettingMIF.setSourceFileCharset(a);
        DataImport dataImport = new DataImport();
        ImportSettings importSettings = dataImport.getImportSettings();
        importSettings.add(importSettingMIF);
        ImportResult importResult = dataImport.run();
        int n = importResult.getSucceedSettings().length;
        return n > 0;
    }

    public static boolean exportSHP(String string, Dataset dataset) throws Exception {
        Object object;
        if (!DataConversion.isDirectoryExisted(string)) {
            String string2 = InternalResource.loadString("filePath:" + string, "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (dataset == null) {
            String string3 = InternalResource.loadString("dataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 2) {
            object = dataset.getName() + ".shp";
            stringArray[0] = stringArray[0] + (String)object;
            string = stringArray[0];
        } else if (stringArray[1].compareTo("shp") != 0) {
            String string4 = InternalResource.loadString(string, "GlobalPathSplitTypeNotValid", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (dataset.getType() != DatasetType.POINT && dataset.getType() != DatasetType.LINE && dataset.getType() != DatasetType.REGION && dataset.getType() != DatasetType.CAD && dataset.getType() != DatasetType.TEXT) {
            object = InternalResource.loadString("DatasetType Error", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException((String)object);
        }
        object = new ExportSetting();
        ((ExportSetting)object).setSourceData(dataset);
        ((ExportSetting)object).setTargetFilePath(string);
        ((ExportSetting)object).setTargetFileType(FileType.SHP);
        ((ExportSetting)object).setOverwrite(true);
        ((ExportSetting)object).setTargetFileCharset(a);
        DataExport dataExport = new DataExport();
        ExportSettings exportSettings = dataExport.getExportSettings();
        exportSettings.add((ExportSetting)object);
        ExportResult exportResult = dataExport.run();
        int n = exportResult.getSucceedSettings().length;
        return n > 0;
    }

    public static boolean exportMIF(String string, Dataset dataset) throws Exception {
        Object object;
        if (!DataConversion.isDirectoryExisted(string)) {
            String string2 = InternalResource.loadString("filePath:" + string, "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (dataset == null) {
            String string3 = InternalResource.loadString("dataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 2) {
            object = dataset.getName() + ".mif";
            stringArray[0] = stringArray[0] + (String)object;
            string = stringArray[0];
        } else if (stringArray[1].compareTo("mif") != 0) {
            String string4 = InternalResource.loadString(string, "GlobalPathSplitTypeNotValid", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (dataset.getType() != DatasetType.POINT && dataset.getType() != DatasetType.LINE && dataset.getType() != DatasetType.REGION && dataset.getType() != DatasetType.CAD && dataset.getType() != DatasetType.TEXT) {
            object = InternalResource.loadString("DatasetType Error", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException((String)object);
        }
        object = new ExportSetting();
        ((ExportSetting)object).setSourceData(dataset);
        ((ExportSetting)object).setTargetFilePath(string);
        ((ExportSetting)object).setTargetFileType(FileType.MIF);
        ((ExportSetting)object).setOverwrite(true);
        ((ExportSetting)object).setTargetFileCharset(a);
        DataExport dataExport = new DataExport();
        ExportSettings exportSettings = dataExport.getExportSettings();
        exportSettings.add((ExportSetting)object);
        ExportResult exportResult = dataExport.run();
        int n = exportResult.getSucceedSettings().length;
        return n > 0;
    }

    private static boolean isDirectoryExisted(String string) {
        File file = new File(string);
        boolean bl = false;
        if (file.getParent() == null) {
            bl = true;
        } else {
            File file2 = new File(file.getParent());
            if (file2.exists()) {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean importDWG(String string, Datasource datasource, boolean bl) throws Exception {
        return DataConversion.importDWG(string, datasource, bl, true);
    }

    public static boolean importDWG(String string, Datasource datasource, boolean bl, boolean bl2) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            String string2 = InternalResource.loadString(file.getAbsolutePath(), "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (datasource == null) {
            String string3 = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 2) {
            String string4 = InternalResource.loadString(file.getAbsolutePath(), "GlobalPathSplitNumNotValid", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (stringArray[1].compareToIgnoreCase("dwg") != 0) {
            String string5 = InternalResource.loadString(file.getAbsolutePath(), "GlobalPathSplitTypeNotValid", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        ImportSettingDWG importSettingDWG = new ImportSettingDWG();
        importSettingDWG.setTargetDatasource(datasource);
        importSettingDWG.setSourceFilePath(string);
        importSettingDWG.setSourceFileCharset(a);
        importSettingDWG.setIsBlackWhiteInverse(bl);
        importSettingDWG.setImportingAsCAD(bl2);
        return DataConversion.importDWG(importSettingDWG);
    }

    public static boolean importDWG(ImportSettingDWG importSettingDWG) throws Exception {
        if (importSettingDWG == null) {
            String string = InternalResource.loadString("setting", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DataImport dataImport = new DataImport();
        ImportSettings importSettings = dataImport.getImportSettings();
        importSettings.add(importSettingDWG);
        ImportResult importResult = dataImport.run();
        int n = importResult.getSucceedSettings().length;
        return n > 0;
    }

    public static boolean importDXF(String string, Datasource datasource, boolean bl, boolean bl2) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            String string2 = InternalResource.loadString(file.getAbsolutePath(), "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (datasource == null) {
            String string3 = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 2) {
            String string4 = InternalResource.loadString(file.getAbsolutePath(), "GlobalPathSplitNumNotValid", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (stringArray[1].compareToIgnoreCase("dxf") != 0) {
            String string5 = InternalResource.loadString(file.getAbsolutePath(), "GlobalPathSplitTypeNotValid", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        ImportSettingDXF importSettingDXF = new ImportSettingDXF();
        importSettingDXF.setTargetDatasource(datasource);
        importSettingDXF.setSourceFilePath(string);
        importSettingDXF.setSourceFileCharset(a);
        importSettingDXF.setIsBlackWhiteInverse(bl);
        importSettingDXF.setImportingAsCAD(bl2);
        return DataConversion.importDXF(importSettingDXF);
    }

    public static boolean importDXF(String string, Datasource datasource, boolean bl) throws Exception {
        return DataConversion.importDXF(string, datasource, bl, true);
    }

    public static boolean importDXF(ImportSettingDXF importSettingDXF) throws Exception {
        if (importSettingDXF == null) {
            String string = InternalResource.loadString("setting", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DataImport dataImport = new DataImport();
        ImportSettings importSettings = dataImport.getImportSettings();
        importSettings.add(importSettingDXF);
        ImportResult importResult = dataImport.run();
        int n = importResult.getSucceedSettings().length;
        return n > 0;
    }

    public static boolean exportDXF(String string, Dataset dataset) throws Exception {
        Object object;
        if (!DataConversion.isDirectoryExisted(string)) {
            String string2 = InternalResource.loadString("filePath:" + string, "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (dataset == null) {
            String string3 = InternalResource.loadString("dataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 2) {
            object = dataset.getName() + ".dxf";
            stringArray[0] = stringArray[0] + (String)object;
            string = stringArray[0];
        } else if (stringArray[1].compareToIgnoreCase("dxf") != 0) {
            String string4 = InternalResource.loadString(string, "GlobalPathSplitTypeNotValid", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (dataset.getType() != DatasetType.POINT && dataset.getType() != DatasetType.LINE && dataset.getType() != DatasetType.REGION && dataset.getType() != DatasetType.CAD && dataset.getType() != DatasetType.TEXT) {
            object = InternalResource.loadString("DatasetType Error", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException((String)object);
        }
        object = new ExportSetting();
        ((ExportSetting)object).setSourceData(dataset);
        ((ExportSetting)object).setTargetFilePath(string);
        ((ExportSetting)object).setTargetFileType(FileType.DXF);
        ((ExportSetting)object).setOverwrite(true);
        ((ExportSetting)object).setTargetFileCharset(a);
        DataExport dataExport = new DataExport();
        ExportSettings exportSettings = dataExport.getExportSettings();
        exportSettings.add((ExportSetting)object);
        ExportResult exportResult = dataExport.run();
        int n = exportResult.getSucceedSettings().length;
        return n > 0;
    }

    public static boolean exportDWG(String string, Dataset dataset) throws Exception {
        Object object;
        if (!DataConversion.isDirectoryExisted(string)) {
            String string2 = InternalResource.loadString("filePath:" + string, "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (dataset == null) {
            String string3 = InternalResource.loadString("dataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 2) {
            object = dataset.getName() + ".dwg";
            stringArray[0] = stringArray[0] + (String)object;
            string = stringArray[0];
        } else if (stringArray[1].compareToIgnoreCase("dwg") != 0) {
            String string4 = InternalResource.loadString(string, "GlobalPathSplitTypeNotValid", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (dataset.getType() != DatasetType.POINT && dataset.getType() != DatasetType.LINE && dataset.getType() != DatasetType.REGION && dataset.getType() != DatasetType.CAD && dataset.getType() != DatasetType.TEXT) {
            object = InternalResource.loadString("DatasetType Error", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException((String)object);
        }
        object = new ExportSetting();
        ((ExportSetting)object).setSourceData(dataset);
        ((ExportSetting)object).setTargetFilePath(string);
        ((ExportSetting)object).setTargetFileType(FileType.DWG);
        ((ExportSetting)object).setOverwrite(true);
        ((ExportSetting)object).setTargetFileCharset(a);
        DataExport dataExport = new DataExport();
        ExportSettings exportSettings = dataExport.getExportSettings();
        exportSettings.add((ExportSetting)object);
        ExportResult exportResult = dataExport.run();
        int n = exportResult.getSucceedSettings().length;
        return n > 0;
    }

    public static boolean importTIF(String string, Datasource datasource) throws Exception {
        return DataConversion.importTIF(string, datasource, "", false);
    }

    public static boolean importTIF(ImportSettingTIF importSettingTIF) throws Exception {
        if (importSettingTIF == null) {
            String string = InternalResource.loadString("setting", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DataImport dataImport = new DataImport();
        ImportSettings importSettings = dataImport.getImportSettings();
        importSettings.add(importSettingTIF);
        ImportResult importResult = dataImport.run();
        int n = importResult.getSucceedSettings().length;
        return n > 0;
    }

    public static boolean importTIF(String string, Datasource datasource, String string2, boolean bl) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            String string3 = InternalResource.loadString(file.getAbsolutePath(), "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (datasource == null) {
            String string4 = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 2) {
            String string5 = InternalResource.loadString(file.getAbsolutePath(), "GlobalPathSplitNumNotValid", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (stringArray[1].compareToIgnoreCase("tif") != 0 && stringArray[1].compareToIgnoreCase("tiff") != 0) {
            String string6 = InternalResource.loadString(file.getAbsolutePath(), "GlobalPathSplitTypeNotValid", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        ImportSettingTIF importSettingTIF = new ImportSettingTIF();
        importSettingTIF.setTargetDatasource(datasource);
        importSettingTIF.setSourceFilePath(string);
        importSettingTIF.setSourceFileCharset(Charset.ANSI);
        if (!string2.isEmpty()) {
            importSettingTIF.setTargetDatasetName(string2);
        }
        importSettingTIF.setMultiBandImportMode(MultiBandImportMode.MULTIBAND);
        importSettingTIF.setTargetEncodeType(EncodeType.DCT);
        if (bl) {
            importSettingTIF.setImportingAsGrid(true);
            importSettingTIF.setMultiBandImportMode(MultiBandImportMode.SINGLEBAND);
        }
        DataImport dataImport = new DataImport();
        ImportSettings importSettings = dataImport.getImportSettings();
        importSettings.add(importSettingTIF);
        ImportResult importResult = dataImport.run();
        int n = importResult.getSucceedSettings().length;
        return n > 0;
    }

    public static boolean exportTIF(String string, Dataset dataset) throws Exception {
        Object object;
        if (!DataConversion.isDirectoryExisted(string)) {
            String string2 = InternalResource.loadString("filePath:" + string, "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (dataset == null) {
            String string3 = InternalResource.loadString("dataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 2) {
            object = dataset.getName() + ".tif";
            stringArray[0] = stringArray[0] + (String)object;
            string = stringArray[0];
        } else if (stringArray[1].compareToIgnoreCase("tif") != 0 && stringArray[1].compareToIgnoreCase("tiff") != 0) {
            String string4 = InternalResource.loadString(string, "GlobalPathSplitTypeNotValid", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (dataset.getType() != DatasetType.GRID && dataset.getType() != DatasetType.IMAGE) {
            object = InternalResource.loadString("DatasetType Error", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException((String)object);
        }
        object = new ExportSetting();
        ((ExportSetting)object).setSourceData(dataset);
        ((ExportSetting)object).setTargetFilePath(string);
        ((ExportSetting)object).setTargetFileType(FileType.TIF);
        ((ExportSetting)object).setOverwrite(true);
        ((ExportSetting)object).setTargetFileCharset(a);
        DataExport dataExport = new DataExport();
        ExportSettings exportSettings = dataExport.getExportSettings();
        exportSettings.add((ExportSetting)object);
        ExportResult exportResult = dataExport.run();
        int n = exportResult.getSucceedSettings().length;
        return n > 0;
    }

    public static boolean importKML(String string, Datasource datasource, String string2, boolean bl) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            String string3 = InternalResource.loadString(file.getAbsolutePath(), "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (datasource == null) {
            String string4 = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 2) {
            String string5 = InternalResource.loadString(file.getAbsolutePath(), "GlobalPathSplitNumNotValid", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (stringArray[1].compareToIgnoreCase("kml") != 0) {
            String string6 = InternalResource.loadString(file.getAbsolutePath(), "GlobalPathSplitTypeNotValid", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (string2 == null) {
            String string7 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        ImportSettingKML importSettingKML = new ImportSettingKML();
        importSettingKML.setTargetDatasource(datasource);
        importSettingKML.setSourceFilePath(string);
        importSettingKML.setSourceFileCharset(Charset.ANSI);
        importSettingKML.setImportingAsCAD(bl);
        if (!string2.isEmpty()) {
            importSettingKML.setTargetDatasetName(string2);
        }
        DataImport dataImport = new DataImport();
        ImportSettings importSettings = dataImport.getImportSettings();
        importSettings.add(importSettingKML);
        ImportResult importResult = dataImport.run();
        int n = importResult.getSucceedSettings().length;
        return n > 0;
    }

    public static boolean exportKML(String string, Dataset dataset) throws Exception {
        Object object;
        if (!DataConversion.isDirectoryExisted(string)) {
            String string2 = InternalResource.loadString("filePath:" + string, "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (dataset == null) {
            String string3 = InternalResource.loadString("dataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 2) {
            object = dataset.getName() + ".kml";
            stringArray[0] = stringArray[0] + (String)object;
            string = stringArray[0];
        } else if (stringArray[1].compareToIgnoreCase("kml") != 0) {
            String string4 = InternalResource.loadString(string, "GlobalPathSplitTypeNotValid", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!Dataset.isVector(dataset)) {
            object = InternalResource.loadString("DatasetType Error", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException((String)object);
        }
        if (dataset.getPrjCoordSys().getType() != PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE || dataset.getPrjCoordSys().getGeoCoordSys().getType() != GeoCoordSysType.GCS_WGS_1984) {
            object = InternalResource.loadString("dataset prcoordsys must be wgs1984!", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException((String)object);
        }
        object = new ExportSetting();
        ((ExportSetting)object).setSourceData(dataset);
        ((ExportSetting)object).setTargetFilePath(string);
        ((ExportSetting)object).setTargetFileType(FileType.KML);
        ((ExportSetting)object).setOverwrite(true);
        ((ExportSetting)object).setTargetFileCharset(a);
        DataExport dataExport = new DataExport();
        ExportSettings exportSettings = dataExport.getExportSettings();
        exportSettings.add((ExportSetting)object);
        ExportResult exportResult = dataExport.run();
        int n = exportResult.getSucceedSettings().length;
        return n > 0;
    }

    public static boolean importGPX(String string, Datasource datasource, String string2) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            String string3 = InternalResource.loadString(file.getAbsolutePath(), "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (datasource == null) {
            String string4 = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 2) {
            String string5 = InternalResource.loadString(file.getAbsolutePath(), "GlobalPathSplitNumNotValid", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (stringArray[1].compareToIgnoreCase("gpx") != 0) {
            String string6 = InternalResource.loadString(file.getAbsolutePath(), "GlobalPathSplitTypeNotValid", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (string2 == null) {
            String string7 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        a = new GPXAnalyticClass();
        a = a.pullParseXml(string);
        a = new DatasetVectorInfo();
        a.setName(string2);
        a.setType(DatasetType.POINT);
        a = datasource.getDatasets();
        a = a.create(a);
        a.open();
        a = new FieldInfo();
        a.setName("ele");
        a.setType(FieldType.SINGLE);
        a = a.getFieldInfos();
        a.add(a);
        a.dispose();
        a = new FieldInfo();
        a.setName("time");
        a.setType(FieldType.CHAR);
        a.add(a);
        a.dispose();
        a = a.getRecordset(false, CursorType.DYNAMIC);
        a = a.getBatch();
        a.begin();
        Iterator iterator = a.iterator();
        while (iterator.hasNext()) {
            GPXBean gPXBean = (GPXBean)iterator.next();
            a = new GeoPoint();
            a = new HashMap();
            a.setX(gPXBean.getLon());
            a.setY(gPXBean.getLat());
            a.put("ele", Float.valueOf(gPXBean.getEle()));
            a.put("time", gPXBean.getTime());
            a.addNew(a, a);
        }
        a.update();
        if (a.getRecordCount() == a.size()) {
            a.dispose();
            a.dispose();
            a.dispose();
            return true;
        }
        a.dispose();
        a.dispose();
        a.dispose();
        return false;
    }

    public static boolean exportGPX(String string, DatasetVector datasetVector) throws Exception {
        String string2;
        if (!DataConversion.isDirectoryExisted(string)) {
            String string3 = InternalResource.loadString("filePath:" + string, "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (datasetVector == null) {
            String string4 = InternalResource.loadString("dataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (datasetVector.getType() != DatasetType.POINT) {
            Log.e((String)"error", (String)"\u6570\u636e\u96c6\u683c\u5f0f\u4e0d\u6b63\u786e,\u53ea\u652f\u6301\u70b9\u6570\u636e\u96c6");
            return false;
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 2) {
            string2 = datasetVector.getName() + ".gpx";
            stringArray[0] = stringArray[0] + string2;
            string = stringArray[0];
        } else if (stringArray[1].compareToIgnoreCase("gpx") != 0) {
            String string5 = InternalResource.loadString(string, "GlobalPathSplitTypeNotValid", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (!Dataset.isVector(datasetVector)) {
            string2 = InternalResource.loadString("DatasetType Error", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (datasetVector.getPrjCoordSys().getType() != PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE || datasetVector.getPrjCoordSys().getGeoCoordSys().getType() != GeoCoordSysType.GCS_WGS_1984) {
            string2 = InternalResource.loadString("dataset prcoordsys must be wgs1984!", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        a = datasetVector.getRecordset(false, CursorType.DYNAMIC);
        a = new ArrayList();
        while (!a.isEOF()) {
            a = new GPXBean();
            try {
                a.setEle(a.getSingle("ele"));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                a.setEle(0.0f);
            }
            try {
                a.setTime(a.getString("time"));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                a.setTime("0");
            }
            try {
                a.setLat(a.getDouble("SmY"));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                a.setLat(0.0);
            }
            try {
                a.setLon(a.getDouble("SmX"));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                a.setLat(0.0);
            }
            a.moveNext();
            a.add(a);
        }
        a.close();
        a.dispose();
        a = GPXExportClass.printGPX(string, (List<GPXBean>)((Object)a));
        return a;
    }

    public static boolean importKMZ(String string, Datasource datasource, String string2, boolean bl) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            String string3 = InternalResource.loadString(file.getAbsolutePath(), "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (datasource == null) {
            String string4 = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 2) {
            String string5 = InternalResource.loadString(file.getAbsolutePath(), "GlobalPathSplitNumNotValid", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (stringArray[1].compareToIgnoreCase("kmz") != 0) {
            String string6 = InternalResource.loadString(file.getAbsolutePath(), "GlobalPathSplitTypeNotValid", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (string2 == null) {
            String string7 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        ImportSettingKMZ importSettingKMZ = new ImportSettingKMZ();
        importSettingKMZ.setTargetDatasource(datasource);
        importSettingKMZ.setSourceFilePath(string);
        importSettingKMZ.setSourceFileCharset(Charset.ANSI);
        importSettingKMZ.setImportingAsCAD(bl);
        if (!string2.isEmpty()) {
            importSettingKMZ.setTargetDatasetName(string2);
        }
        DataImport dataImport = new DataImport();
        ImportSettings importSettings = dataImport.getImportSettings();
        importSettings.add(importSettingKMZ);
        ImportResult importResult = dataImport.run();
        int n = importResult.getSucceedSettings().length;
        return n > 0;
    }

    public static boolean exportKMZ(String string, Dataset dataset) throws Exception {
        Object object;
        if (!DataConversion.isDirectoryExisted(string)) {
            String string2 = InternalResource.loadString("filePath:" + string, "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (dataset == null) {
            String string3 = InternalResource.loadString("dataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 2) {
            object = dataset.getName() + ".kmz";
            stringArray[0] = stringArray[0] + (String)object;
            string = stringArray[0];
        } else if (stringArray[1].compareToIgnoreCase("kmz") != 0) {
            String string4 = InternalResource.loadString(string, "GlobalPathSplitTypeNotValid", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!Dataset.isVector(dataset)) {
            object = InternalResource.loadString("DatasetType Error", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException((String)object);
        }
        if (dataset.getPrjCoordSys().getType() != PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE || dataset.getPrjCoordSys().getGeoCoordSys().getType() != GeoCoordSysType.GCS_WGS_1984) {
            object = InternalResource.loadString("dataset prcoordsys must be wgs1984!", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException((String)object);
        }
        object = new ExportSetting();
        ((ExportSetting)object).setSourceData(dataset);
        ((ExportSetting)object).setTargetFilePath(string);
        ((ExportSetting)object).setTargetFileType(FileType.KMZ);
        ((ExportSetting)object).setOverwrite(true);
        ((ExportSetting)object).setTargetFileCharset(a);
        DataExport dataExport = new DataExport();
        ExportSettings exportSettings = dataExport.getExportSettings();
        exportSettings.add((ExportSetting)object);
        ExportResult exportResult = dataExport.run();
        int n = exportResult.getSucceedSettings().length;
        return n > 0;
    }

    static {
        a = null;
        a = null;
        a = false;
        b = false;
        a = null;
        a = null;
    }
}

