/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetNative;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.EncodeType;
import com.supermap.data.Enum;
import com.supermap.data.FieldInfoNative;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalResource;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Rectangle2D;
import com.supermap.data.c;

public abstract class Dataset
extends InternalHandle {
    protected Datasource m_datasource = null;
    protected long m_selfEventHandle;
    protected static String m_senderMethodName;
    private PrjCoordSys a;

    protected Dataset() {
        m_senderMethodName = "PJConvert";
    }

    static c isValidDatasetName(String string) {
        int n = FieldInfoNative.jni_IsValidTableName(string);
        if (n == -1) {
            return null;
        }
        return (c)Enum.parseUGCValue(c.class, n);
    }

    public void setPrjCoordSys(PrjCoordSys prjCoordSys) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        if (prjCoordSys == null) {
            DatasetNative.jni_UnSetPrjCoordSys(this.getHandle());
            if (this.a != null) {
                this.a.clearHandle();
                this.a = null;
            }
        } else {
            long l = InternalHandle.getHandle(prjCoordSys);
            if (l == 0L) {
                String string = InternalResource.loadString("value", "Global_InvalidConstructorArgument", "data_resources");
                throw new IllegalArgumentException(string);
            }
            this.a = prjCoordSys.clone();
            DatasetNative.jni_setPrjCoordSys(this.getHandle(), l);
        }
    }

    public PrjCoordSys getPrjCoordSys() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetPrjCoordSys()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isOpen()) {
            this.open();
        }
        if (this.a == null && (l = DatasetNative.jni_getPrjCoordSys(this.getHandle())) != 0L) {
            this.a = PrjCoordSys.createInstance(l, false);
        }
        return this.a;
    }

    private boolean hasVersion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hasVersion()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_hasVersion(this.getHandle());
    }

    public String getExtInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetExtInfo(this.getHandle());
    }

    public void setExtInfo(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null) {
            string = "";
        }
        if (string.length() > 2047) {
            throw new IllegalStateException("The length is outof range");
        }
        DatasetNative.jni_SetExtInfo(this.getHandle(), string);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        DatasetNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public boolean isReadOnly() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = this.m_datasource.isReadOnly();
        boolean bl2 = DatasetNative.jni_GetIsReadOnly(this.getHandle());
        return bl || bl2;
    }

    public boolean isOpen() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetIsOpen(this.getHandle());
    }

    public Datasource getDatasource() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_datasource;
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetDescription(this.getHandle());
    }

    public void setDescription(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null) {
            string = "";
        }
        DatasetNative.jni_SetDescription(this.getHandle(), string);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetName(this.getHandle());
    }

    public DatasetType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetNative.jni_GetType(this.getHandle());
        DatasetType datasetType = null;
        datasetType = (DatasetType)Enum.parseUGCValue(DatasetType.class, n);
        return datasetType;
    }

    public EncodeType getEncodeType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetNative.jni_GetEncodeType(this.getHandle());
        return (EncodeType)Enum.parseUGCValue(EncodeType.class, n);
    }

    public void close() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetNative.jni_Close(this.getHandle());
    }

    public boolean open() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_Open(this.getHandle());
    }

    @Override
    protected void clearHandle() {
        this.m_datasource = null;
        this.a = null;
        this.setHandle(0L);
    }

    protected static boolean isVector(Dataset dataset) {
        boolean bl = true;
        bl = dataset == null || dataset.getHandle() == 0L ? false : dataset.isVector();
        return bl;
    }

    protected static Dataset createInstance(long l, DatasetType datasetType, Datasource datasource) {
        if (l == 0L) {
            String string = InternalResource.loadString("", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalStateException(string);
        }
        Dataset dataset = null;
        dataset = datasetType.equals(DatasetType.IMAGE) || datasetType.equals(DatasetType.WMS) || datasetType.equals(DatasetType.WCS) ? new DatasetImage(l, datasource) : (datasetType.equals(DatasetType.LINE) || datasetType.equals(DatasetType.POINT) || datasetType.equals(DatasetType.REGION) || datasetType.equals(DatasetType.TABULAR) || datasetType.equals(DatasetType.POINT3D) || datasetType.equals(DatasetType.LINE3D) || datasetType.equals(DatasetType.REGION3D) || datasetType.equals(DatasetType.CAD) || datasetType.equals(DatasetType.NETWORK) || datasetType.equals(DatasetType.NETWORK3D) || datasetType.equals(DatasetType.TEXT) || datasetType.equals(DatasetType.NdfVector) || datasetType.equals(DatasetType.WFS) ? new DatasetVector(l, datasource) : (datasetType.equals(DatasetType.GRID) || datasetType.equals(DatasetType.DEM) ? new DatasetGrid(l, datasource) : null));
        return dataset;
    }

    private boolean isVector() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetIsVector(this.getHandle());
    }

    public void setReadOnly(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetNative.jni_SetReadOnly(this.getHandle(), bl);
    }
}

