/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Color;
import com.supermap.data.ColorSpaceType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetImageNative;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.GeoRegion;
import com.supermap.data.InternalResource;
import com.supermap.data.MapCacheListener;
import com.supermap.data.PixelFormat;
import com.supermap.data.Rectangle2D;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DatasetImage
extends Dataset {
    private GeoRegion a;
    private boolean a;
    private static Integer a = new Integer(0);
    private MapCacheService a = new MapCacheService();

    DatasetImage(long l, Datasource datasource) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("datasource", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l);
        this.m_datasource = datasource;
    }

    public int getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_GetWidth(this.getHandle());
    }

    public int getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_GetHeight(this.getHandle());
    }

    public PixelFormat getPixelFormat() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetImageNative.jni_GetPixelFormat(this.getHandle());
        return (PixelFormat)Enum.parseUGCValue(PixelFormat.class, n);
    }

    public Color getPixel(int n, int n2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getWidth()) {
            String string = InternalResource.loadString("column", "DataseImage_ColumnIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0 || n2 >= this.getHeight()) {
            String string = InternalResource.loadString("row", "DatasetImage_RowIsOutOfRange", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n3 = DatasetImageNative.jni_GetPixel(this.getHandle(), n, n2);
        return new Color(n3);
    }

    private boolean a() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isMultiBand()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_IsMultiBand(this.getHandle());
    }

    public ColorSpaceType getColorSpace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorSpace()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.a()) {
            String string = InternalResource.loadString("getColorSpace()", "DatasetImage_ThisOperationIsAvailableForMultibandsDataOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        int n = DatasetImageNative.jni_GetColorSpaceType(this.getHandle());
        return (ColorSpaceType)Enum.parseUGCValue(ColorSpaceType.class, n);
    }

    public int getBandCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetBandCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.a()) {
            String string = InternalResource.loadString("getBandCount()", "DatasetImage_ThisOperationIsAvailableForMultibandsDataOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        return DatasetImageNative.jni_GetBandCount(this.getHandle());
    }

    public boolean getHasPyramid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_GetHasPyramid(this.getHandle());
    }

    public boolean buildPyramid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isOpen()) {
            String string = InternalResource.loadString("", "DatasetImage_ShouldBeClosedBeforeBuildPyramid", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        bl = this.getHasPyramid() ? true : DatasetImageNative.jni_BuildPyramid(this.getHandle());
        return bl;
    }

    public boolean updatePyramid(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        bl = DatasetImageNative.jni_UpdatePyramid(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        return bl;
    }

    public boolean removePyramid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetImageNative.jni_RemovePyramid(this.getHandle());
    }

    @Override
    protected void clearHandle() {
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        this.setHandle(0L);
    }

    public MapCacheService getMapCacheService() {
        return this.a;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class MapCacheService {
        Vector<MapCacheListener> a;
        private ExecutorService a = new Vector();

        @Deprecated
        public boolean startDownload(Rectangle2D rectangle2D) {
            if (DatasetImage.this.getHandle() == 0L) {
                String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (rectangle2D == null || rectangle2D.isEmpty()) {
                String string = InternalResource.loadString("rcBounds", "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetImageNative.jni_RegisterAllEvent(DatasetImage.this.getHandle(), this);
            return DatasetImageNative.jni_StartDownload(DatasetImage.this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        }

        public void stopDownload() {
            if (DatasetImage.this.getHandle() == 0L) {
                String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            DatasetImageNative.jni_StopDownload(DatasetImage.this.getHandle());
        }

        public void setListener(MapCacheListener mapCacheListener) {
            if (mapCacheListener != null && !this.a.contains(mapCacheListener)) {
                this.a.add(mapCacheListener);
            }
        }

        public void removeListener(MapCacheListener mapCacheListener) {
            if (this.a != null && this.a.contains(mapCacheListener)) {
                this.a.remove(mapCacheListener);
            }
        }

        protected void onCheckedCallBack() {
            if (this.a != null) {
                Vector<MapCacheListener> vector = this.a;
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    vector.elementAt(i).onChecked();
                }
            }
        }

        protected void onCompleteCallBack(int n) {
            if (this.a != null) {
                Vector<MapCacheListener> vector = this.a;
                int n2 = vector.size();
                for (int i = 0; i < n2; ++i) {
                    vector.elementAt(i).onComplete(n);
                }
            }
        }

        protected void onProgressCallBack(int n) {
            if (this.a != null) {
                Vector<MapCacheListener> vector = this.a;
                int n2 = vector.size();
                for (int i = 0; i < n2; ++i) {
                    vector.elementAt(i).onProgress(n);
                }
            }
        }

        protected void onCacheStatusCallBack(int n, long l) {
            if (this.a != null) {
                Vector<MapCacheListener> vector = this.a;
                int n2 = vector.size();
                for (int i = 0; i < n2; ++i) {
                    vector.elementAt(i).onCacheStatus(n, l);
                }
            }
        }

        private void a() {
            if (DatasetImage.this.getHandle() == 0L) {
                String string = InternalResource.loadString("removeCache(Rectangle2D rcBounds)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            DatasetImageNative.jni_RenameCache(DatasetImage.this.getHandle());
        }

        private void b() {
            if (DatasetImage.this.getHandle() == 0L) {
                String string = InternalResource.loadString("removeCache(Rectangle2D rcBounds)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            DatasetImageNative.jni_RemoveCache(DatasetImage.this.getHandle());
        }

        public void removeCache() {
            this.a();
            if (this.a == null) {
                this.a = Executors.newSingleThreadExecutor();
            }
            this.a.execute(new Runnable(){

                @Override
                public void run() {
                    MapCacheService.this.b();
                }
            });
        }

        public void removeCache(double d2, Rectangle2D rectangle2D) {
            if (DatasetImage.this.getHandle() == 0L) {
                String string = InternalResource.loadString("removeCache(double scale, Rectangle2D bounds)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (rectangle2D == null) {
                String string = InternalResource.loadString("bounds", "Global_OwnerHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (d2 == 0.0) {
                String string = InternalResource.loadString("scale", "Global_ArgumentShouldMoreThanZero", "data_resources");
                throw new IllegalStateException(string);
            }
            DatasetImageNative.jni_RemoveCacheWithScaleBounds(DatasetImage.this.getHandle(), d2, rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        }

        public boolean startDownload(double d2, double d3, Rectangle2D rectangle2D) {
            if (DatasetImage.this.getHandle() == 0L) {
                String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (rectangle2D == null || rectangle2D.isEmpty()) {
                String string = InternalResource.loadString("rcBounds", "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (d2 <= 0.0 || d3 <= 0.0) {
                String string = InternalResource.loadString("maxScale, minScale", "Global_ArgumentShouldNotBeNegative", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (d2 < d3) {
                String string = "maxScale must be not less than minScale!";
                throw new IllegalArgumentException(string);
            }
            DatasetImageNative.jni_RegisterAllEvent(DatasetImage.this.getHandle(), this);
            return DatasetImageNative.jni_StartDownloadWithScale(DatasetImage.this.getHandle(), d2, d3, rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        }
    }
}

