/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.DatasetsNative;
import com.supermap.data.Datasource;
import com.supermap.data.DatasourceNative;
import com.supermap.data.EncodeType;
import com.supermap.data.Enum;
import com.supermap.data.InternalResource;
import java.util.ArrayList;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Datasets {
    private ArrayList a;
    private Datasource a = null;

    protected Datasets() {
    }

    Datasets(Datasource datasource) {
        this.a();
        this.a = new ArrayList();
        this.a = datasource;
        this.reset();
    }

    public DatasetVector create(DatasetVectorInfo datasetVectorInfo) {
        if (!this.a()) {
            String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a.isReadOnly()) {
            String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (datasetVectorInfo == null) {
            String string = InternalResource.loadString("datasetInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasetVectorInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("datasetInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Datasets.isCreatableVectorType(datasetVectorInfo.getType())) {
            String string = InternalResource.loadString("type", "Datasets_FailToCreateBecauseOfType", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Datasets.isCreatableEnCodeType(datasetVectorInfo.getType(), datasetVectorInfo.getEncodeType())) {
            String string = InternalResource.loadString("encodeType", "Datasets_FailToCreateBecauseOfEncodeType", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetVector datasetVector = null;
        if (datasetVectorInfo.getName().trim().equals("") || !this.isAvailableDatasetName(datasetVectorInfo.getName())) {
            String string = InternalResource.loadString("name", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = DatasetsNative.jni_CreateDatasetVector(this.a.getHandle(), datasetVectorInfo.getHandle());
        if (l != 0L) {
            datasetVector = new DatasetVector(l, this.a);
            this.a(datasetVector);
        }
        return datasetVector;
    }

    public boolean delete(int n) {
        if (!this.a()) {
            String string = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a.isReadOnly()) {
            String string = InternalResource.loadString("delete(int index)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Dataset dataset = this.get(n);
        String string = dataset.getName();
        boolean bl = DatasetsNative.jni_DeleteDataset2(this.a.getHandle(), string);
        if (bl) {
            dataset.clearHandle();
            this.a.remove(n);
        }
        return bl;
    }

    public boolean delete(String string) {
        if (!this.a()) {
            String string2 = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.a.isReadOnly()) {
            String string3 = InternalResource.loadString("delete(String name)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string3);
        }
        int n = this.indexOf(string);
        if (-1 == n) {
            return false;
        }
        boolean bl = DatasetsNative.jni_DeleteDataset2(this.a.getHandle(), string);
        if (bl) {
            Dataset dataset = this.get(n);
            dataset.clearHandle();
            this.a.remove(n);
        }
        return bl;
    }

    public int getCount() {
        if (!this.a()) {
            String string = InternalResource.loadString("getCount()", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a.size();
    }

    public Dataset get(String string) {
        if (!this.a()) {
            String string2 = InternalResource.loadString("get(String name)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string2);
        }
        Dataset dataset = null;
        int n = this.indexOf(string);
        if (n != -1) {
            dataset = this.get(n);
        }
        return dataset;
    }

    public Dataset get(int n) {
        if (!this.a()) {
            String string = InternalResource.loadString("get(int index)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return (Dataset)this.a.get(n);
    }

    public String getAvailableDatasetName(String string) {
        if (!this.a()) {
            String string2 = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        return DatasetsNative.jni_GetUnoccupiedDatasetName(this.a.getHandle(), string);
    }

    public boolean isAvailableDatasetName(String string) {
        if (!this.a()) {
            String string2 = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        if (string != null && string.trim().length() != 0) {
            bl = DatasetsNative.jni_IsAvailableDatasetName(this.a.getHandle(), string);
        }
        return bl;
    }

    public boolean contains(String string) {
        boolean bl = false;
        if (this.indexOf(string) != -1) {
            bl = true;
        }
        return bl;
    }

    public int indexOf(String string) {
        if (!this.a()) {
            String string2 = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string2);
        }
        int n = -1;
        if (string != null && string.trim().length() != 0) {
            int n2 = this.getCount();
            for (int i = 0; i < n2; ++i) {
                if (!string.equalsIgnoreCase(this.get(i).getName())) continue;
                return i;
            }
        }
        return n;
    }

    void a() {
        if (this.a != null) {
            int n = this.a.size();
            for (int i = 0; i < n; ++i) {
                if (this.a.get(i) == null) continue;
                ((Dataset)this.a.get(i)).clearHandle();
            }
            this.a.clear();
            this.a = null;
        }
        this.a = null;
    }

    public void reset() {
        this.a.clear();
        int n = DatasourceNative.jni_GetDatasetsCount(this.a.getHandle());
        if (n < 0) {
            return;
        }
        long[] lArray = new long[n];
        int[] nArray = new int[n];
        DatasourceNative.jni_GetDatasets(this.a.getHandle(), lArray, nArray);
        for (int i = 0; i < n; ++i) {
            DatasetType datasetType;
            try {
                datasetType = (DatasetType)Enum.parseUGCValue(DatasetType.class, nArray[i]);
            }
            catch (RuntimeException runtimeException) {
                if (nArray[i] != 88) continue;
                datasetType = DatasetType.IMAGE;
            }
            try {
                Dataset dataset = Dataset.createInstance(lArray[i], datasetType, this.a);
                if (dataset == null) continue;
                this.a.add(dataset);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    void a(Dataset dataset) {
        String string = dataset.getName();
        if (!this.contains(string)) {
            this.a.add(dataset);
        }
    }

    protected static void add(Datasets datasets, Dataset dataset) {
        if (datasets != null) {
            datasets.a(dataset);
        }
    }

    private boolean a() {
        boolean bl = true;
        if (this.a == null || this.a.getHandle() == 0L || this.a.getWorkspace() == null || this.a.getWorkspace().getHandle() == 0L) {
            bl = false;
        }
        return bl;
    }

    static boolean isCreatableVectorType(DatasetType datasetType) {
        boolean bl = true;
        if (datasetType.equals(DatasetType.IMAGE)) {
            bl = false;
        }
        return bl;
    }

    static boolean isCreatableEnCodeType(DatasetType datasetType, EncodeType encodeType) {
        boolean bl = true;
        if (datasetType.equals(DatasetType.TABULAR) || datasetType.equals(DatasetType.POINT)) {
            bl = bl && encodeType.equals(EncodeType.NONE);
        } else if (Datasets.isCreatableVectorType(datasetType)) {
            bl = bl && !encodeType.equals(EncodeType.DCT);
            bl = bl && !encodeType.equals(EncodeType.SGL);
            bl = bl && !encodeType.equals(EncodeType.LZW);
        } else if (datasetType.equals(DatasetType.IMAGE)) {
            bl = encodeType.equals(EncodeType.NONE) || encodeType.equals(EncodeType.DCT) || encodeType.equals(EncodeType.SGL) || encodeType.equals(EncodeType.LZW);
        }
        return bl;
    }
}

