/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.FieldInfoNative;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldInfosNative;
import com.supermap.data.FieldType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;

public class FieldInfo
extends InternalHandleDisposable {
    private FieldInfos a = null;

    public FieldInfo() {
        this.setHandle(FieldInfoNative.jni_New(), true);
        this.reset();
    }

    public FieldInfo(FieldInfo fieldInfo) {
        if (fieldInfo == null || fieldInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("fieldInfo", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(FieldInfoNative.jni_New(), true);
        this.setZeroLengthAllowed(fieldInfo.isZeroLengthAllowed());
        this.setCaption(fieldInfo.getCaption());
        this.setDefaultValue(fieldInfo.getDefaultValue());
        if (fieldInfo.getName().compareTo("") != 0) {
            this.setName(fieldInfo.getName());
        }
        this.setRequired(fieldInfo.isRequired());
        if (fieldInfo.getMaxLength() > 0) {
            this.setMaxLength(fieldInfo.getMaxLength());
        }
        this.setType(fieldInfo.getType());
    }

    public FieldInfo(String string, FieldType fieldType) {
        this();
        this.setName(string);
        this.setType(fieldType);
    }

    FieldInfo(long l, FieldInfos fieldInfos) {
        this.setHandle(l, false);
        this.a = fieldInfos;
    }

    FieldInfo(long l) {
        this.setHandle(l, false);
    }

    public boolean isZeroLengthAllowed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        if (this.a != null && this.a.getHandle() == 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        return FieldInfoNative.jni_GetIsZeroLengthAllowed(this.getHandle());
    }

    public void setZeroLengthAllowed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        if (this.a != null && this.a.getDataset().getHandle() != 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        FieldInfoNative.jni_SetIsZeroLengthAllowed(this.getHandle(), bl);
    }

    public String getCaption() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        if (this.a != null && this.a.getHandle() == 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        return FieldInfoNative.jni_GetCaption(this.getHandle(), 0L);
    }

    public void setCaption(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        this.resetUGCHandle();
        if (this.a != null && this.a.getDataset() != null && this.a.getDataset().getHandle() != 0L) {
            FieldInfoNative.jni_SetCaption(this.getHandle(), string, this.a.getDataset().getHandle());
        } else {
            FieldInfoNative.jni_SetCaption(this.getHandle(), string, 0L);
        }
    }

    public String getDefaultValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        if (this.a != null && this.a.getHandle() == 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        return FieldInfoNative.jni_GetDefaultValue(this.getHandle());
    }

    public void setDefaultValue(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        this.resetUGCHandle();
        if (this.a != null && this.a.getDataset().getHandle() != 0L) {
            String string3 = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null) {
            string = "";
        }
        FieldInfoNative.jni_SetDefaultValue(this.getHandle(), string);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        if (this.a != null && this.a.getHandle() == 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        return FieldInfoNative.jni_GetName(this.getHandle());
    }

    public void setName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        this.resetUGCHandle();
        if (this.a != null) {
            if (this.a.getHandle() == 0L) {
                String string4 = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
                throw new IllegalStateException(string4);
            }
            if (this.a.getDataset() == null) {
                if (this.a.indexOf(string) != -1) {
                    String string5 = InternalResource.loadString("value", "FieldInfo_NameIsNotAvaliable", "data_resources");
                    throw new IllegalArgumentException(string5);
                }
            } else {
                String string6 = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
                throw new IllegalStateException(string6);
            }
        }
        FieldInfoNative.jni_SetName(this.getHandle(), string);
    }

    public boolean isRequired() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        if (this.a != null && this.a.getHandle() == 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        return FieldInfoNative.jni_GetIsRequired(this.getHandle());
    }

    public void setRequired(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        if (this.a != null && this.a.getDataset().getHandle() != 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        FieldInfoNative.jni_SetIsRequired(this.getHandle(), bl);
    }

    public int getMaxLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a != null && this.a.getHandle() == 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        return FieldInfoNative.jni_GetMaxLength(this.getHandle());
    }

    public void setMaxLength(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("value:" + String.valueOf(n), "FieldInfo_MaxLengthShouldntBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.resetUGCHandle();
        if (this.a != null && this.a.getDataset().getHandle() != 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        FieldInfoNative.jni_SetMaxLength(this.getHandle(), n);
    }

    public FieldType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        if (this.a != null && this.a.getHandle() == 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = FieldInfoNative.jni_GetType(this.getHandle());
        if (n == 12) {
            n = 10;
        }
        return (FieldType)Enum.parseUGCValue(FieldType.class, n);
    }

    public void setType(FieldType fieldType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        if (this.a != null && this.a.getDataset().getHandle() != 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        FieldInfoNative.jni_SetType(this.getHandle(), fieldType.getUGCValue());
    }

    public boolean isSystemField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        if (this.a != null && this.a.getHandle() == 0L) {
            String string = InternalResource.loadString("", "FieldInfo_FieldInfosIsInvalid", "data_resources");
            throw new IllegalStateException(string);
        }
        return FieldInfoNative.jni_GetIsSystemField(this.getHandle());
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            this.resetUGCHandle();
            FieldInfoNative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    @Override
    protected void clearHandle() {
        this.a = null;
        this.setHandle(0L);
    }

    void reset() {
        if (this.getHandle() != 0L) {
            FieldInfoNative.jni_Reset(this.getHandle());
            this.setMaxLength(255);
        }
    }

    private void resetUGCHandle() {
        if (this.a != null && this.a.getDataset() != null && this.a.getDataset().getHandle() != 0L) {
            int n = this.a.indexOf(this);
            long l = this.a.getHandle();
            long l2 = FieldInfosNative.jni_GetFieldInfoByIndex(l, n);
            if (l2 != 0L) {
                this.setHandle(l2, false);
            }
        }
    }

    public FieldInfo clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.resetUGCHandle();
        return new FieldInfo(this);
    }

    protected static FieldInfo createInstance(long l) {
        return new FieldInfo(l);
    }
}

