/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoChordNative;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;

public class GeoChord
extends Geometry {
    public GeoChord() {
        long l = GeoChordNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoChord(GeoChord geoChord) {
        if (geoChord == null) {
            String string = InternalResource.loadString("geoChord", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(geoChord);
        if (l == 0L) {
            String string = InternalResource.loadString("geoChord", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoChordNative.jni_Clone(l);
        this.setHandle(l2, true);
    }

    public GeoChord(Point2D point2D, double d2, double d3, double d4, double d5, double d6) {
        double d7 = point2D.getX();
        double d8 = point2D.getY();
        if (d2 <= 0.0) {
            String string = InternalResource.loadString("semimajorAxis", "GeoChord_SemimajorAxisShouldBePositive", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d3 <= 0.0) {
            String string = InternalResource.loadString("semiminorAxis", "GeoChord_SemiMinorAxisShouldBePositive", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d5 <= -360.0 || d5 >= 360.0) {
            String string = InternalResource.loadString("sweepAngle", "GeoChord_SweepAngleRange:(-360,0)||(0,360)", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d5 == 0.0) {
            String string = InternalResource.loadString("sweepAngle", "GeoChord_SweepAngleShouldNotBeZero", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoChordNative.jni_New2(d7, d8, d2, d3, d4, d5, d6);
        this.setHandle(l, true);
    }

    GeoChord(long l) {
        this.setHandle(l, false);
    }

    public Point2D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoChordNative.jni_GetCenter(this.getHandle(), dArray);
        Point2D point2D = new Point2D();
        point2D.setX(dArray[0]);
        point2D.setY(dArray[1]);
        return point2D;
    }

    public void setCenter(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCenter(Point2D center)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        GeoChordNative.jni_SetCenter(this.getHandle(), d2, d3);
    }

    public double getSemimajorAxis() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSemimajorAxis()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoChordNative.jni_GetSemimajorAxis(this.getHandle());
    }

    public void setSemimajorAxis(double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSemimajorAxis(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 <= 0.0) {
            String string = InternalResource.loadString("value", "GeoChord_SemimajorAxisShouldBePositive", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoChordNative.jni_SetSemimajorAxis(this.getHandle(), d2);
    }

    public double getSemiminorAxis() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSemiminorAxis()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoChordNative.jni_GetSemiminorAxis(this.getHandle());
    }

    public void setSemiminorAxis(double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSemiminorAxis(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 <= 0.0) {
            String string = InternalResource.loadString("value", "GeoChord_SemiMinorAxisShouldBePositive", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoChordNative.jni_SetSemiminorAxis(this.getHandle(), d2);
    }

    public double getStartAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStartAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoChordNative.jni_GetStartAngle(this.getHandle());
    }

    public void setStartAngle(double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStartAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoChordNative.jni_SetStartAngle(this.getHandle(), d2);
    }

    public double getSweepAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSweepAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoChordNative.jni_GetSweepAngle(this.getHandle());
    }

    public void setSweepAngle(double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSweepAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 <= -360.0 || d2 >= 360.0) {
            String string = InternalResource.loadString("sweepAngle", "GeoChord_SweepAngleRange:(-360,0)||(0,360)", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 == 0.0) {
            String string = InternalResource.loadString("sweepAngle", "GeoChord_SweepAngleShouldNotBeZero", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoChordNative.jni_SetSweepAngle(this.getHandle(), d2);
    }

    public double getRotation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoChordNative.jni_GetRotation(this.getHandle());
    }

    public void setRotation(double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoChordNative.jni_SetRotation(this.getHandle(), d2);
    }

    public double getPerimeter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPerimeter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoChordNative.jni_GetPerimeter(this.getHandle());
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoChordNative.jni_GetArea(this.getHandle());
    }

    public GeoLine convertToLine(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 2) {
            String string = InternalResource.loadString("segmentCount", "Global_ArgumentShouldNotSmallerThanOne", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoChordNative.jni_ConvertToLine(this.getHandle(), n);
        GeoLine geoLine = null;
        if (l != 0L) {
            geoLine = new GeoLine(l);
            geoLine.setIsDisposable(true);
        }
        return geoLine;
    }

    public GeoRegion convertToRegion(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToRegion(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 2) {
            String string = InternalResource.loadString("segmentCount", "Global_ArgumentShouldNotSmallerThanTwo", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoChordNative.jni_ConvertToRegion(this.getHandle(), n);
        GeoRegion geoRegion = null;
        if (l != 0L) {
            geoRegion = new GeoRegion(l);
            geoRegion.setIsDisposable(true);
        }
        return geoRegion;
    }

    @Override
    public GeoChord clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoChord(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoChordNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }

    @Override
    public boolean fromJson(String string) {
        return false;
    }

    @Override
    public String toJson() {
        return null;
    }
}

