/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoCircleNative;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;

public class GeoCircle
extends Geometry {
    public GeoCircle() {
        this.setHandle(GeoCircleNative.jni_New(), true);
        this.setRadius(1.0);
    }

    public GeoCircle(GeoCircle geoCircle) {
        if (geoCircle == null) {
            String string = InternalResource.loadString("GeoCircle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(geoCircle);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoCircle", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoCircleNative.jni_Clone(l);
        super.setHandle(l2, true);
    }

    public GeoCircle(Point2D point2D, double d2) {
        this();
        this.setCenter(point2D);
        this.setRadius(d2);
    }

    public GeoCircle(Point2D point2D, Point2D point2D2) {
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        double d4 = point2D2.getX();
        double d5 = point2D2.getY();
        if (d2 == d4 && d3 == d5) {
            String string = InternalResource.loadString("geoCircle", "PointsAreSame", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(GeoCircleNative.jni_New2(d2, d3, d4, d5), true);
    }

    public GeoCircle(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        double d4 = point2D2.getX();
        double d5 = point2D2.getY();
        double d6 = point2D3.getX();
        double d7 = point2D3.getY();
        if (Math.abs(d4 - d2) < 1.0E-10 && Math.abs(d6 - d2) < 1.0E-10) {
            String string = InternalResource.loadString("geoCircle", "ThreePointsAreInOneLine", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (Math.abs(d7 - d3 - (d5 - d3) / (d4 - d2) * (d6 - d2)) < 1.0E-10) {
            String string = InternalResource.loadString("geoCircle", "ThreePointsAreInOneLine", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(GeoCircleNative.jni_New3(d2, d3, d4, d5, d6, d7), true);
    }

    GeoCircle(long l) {
        this.setHandle(l, false);
    }

    public Point2D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoCircleNative.jni_GetCenter(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public void setCenter(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCenter(Point2D value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoCircleNative.jni_SetCenter(this.getHandle(), point2D.getX(), point2D.getY());
    }

    public double getRadius() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRadius()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoCircleNative.jni_GetRadius(this.getHandle());
    }

    public void setRadius(double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRadius(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 <= 0.0) {
            String string = InternalResource.loadString("setRadius()", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoCircleNative.jni_SetRadius(this.getHandle(), d2);
    }

    public double getPerimeter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPerimeter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoCircleNative.jni_GetPerimeter(this.getHandle());
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoCircleNative.jni_GetArea(this.getHandle());
    }

    public GeoLine convertToLine(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 2) {
            String string = InternalResource.loadString("segmentCount", "Global_ArgumentShouldNotSmallerThanTwo", "data_resources");
            throw new NullPointerException(string);
        }
        long l = GeoCircleNative.jni_ConvertToLine(this.getHandle(), n);
        GeoLine geoLine = null;
        if (l != 0L) {
            geoLine = new GeoLine(l);
            geoLine.setIsDisposable(true);
        }
        return geoLine;
    }

    public GeoRegion convertToRegion(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToRegion(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 2) {
            String string = InternalResource.loadString("segmentCount", "Global_ArgumentShouldNotSmallerThanTwo", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoCircleNative.jni_ConvertToRegion(this.getHandle(), n);
        GeoRegion geoRegion = null;
        if (l != 0L) {
            geoRegion = new GeoRegion(l);
            geoRegion.setIsDisposable(true);
        }
        return geoRegion;
    }

    @Override
    public GeoCircle clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoCircle(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoCircleNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    public boolean fromJson(String string) {
        return false;
    }

    @Override
    public String toJson() {
        return null;
    }
}

