/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoCompoundNative;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import java.util.ArrayList;

public class GeoCompound
extends Geometry {
    private ArrayList<Geometry> a;

    public GeoCompound() {
        long l = GeoCompoundNative.jni_New();
        this.setHandle(l, true);
        this.a = new ArrayList();
    }

    GeoCompound(long l) {
        this.setHandle(l, false);
        this.a = new ArrayList();
        GeoCompound.refreshFromUGC1(this);
    }

    public GeoCompound(GeoCompound geoCompound) {
        if (geoCompound == null) {
            String string = InternalResource.loadString("geoCompound", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoCompound);
        if (l == 0L) {
            String string = InternalResource.loadString("geoCompound", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoCompoundNative.jni_Clone(l);
        this.a = new ArrayList();
        this.setHandle(l2, true);
        GeoCompound.refreshFromUGC1(this);
    }

    public int addPart(Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("AddPart(Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = GeoCompoundNative.jni_addPart(this.getHandle(), geometry2.getHandle());
        int n = -1;
        if (bl) {
            this.a.add(geometry2);
            InternalHandleDisposable.setIsDisposable(geometry2, false);
            n = this.a.size() - 1;
        }
        return n;
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoCompoundNative.jni_getPartCount(this.getHandle());
    }

    public boolean removePart(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("RemovePart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.a.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        bl = GeoCompoundNative.jni_removePart(this.getHandle(), n);
        if (bl) {
            this.a.get(n).clearHandle();
            InternalHandleDisposable.setIsDisposable(this.a.get(n), true);
            this.a.remove(n);
        }
        return bl;
    }

    public Geometry getPart(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetPart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.a.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.a.get(n);
    }

    public boolean insertPart(int n, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("InsertPart(int index, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n > this.a.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = false;
        bl = GeoCompoundNative.jni_insertPart(this.getHandle(), n, geometry2.getHandle());
        if (bl) {
            this.a.add(n, geometry2);
            InternalHandleDisposable.setIsDisposable(geometry2, false);
        }
        return bl;
    }

    public boolean setPart(int n, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetPart(int index, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n >= this.a.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = false;
        bl = GeoCompoundNative.jni_setPart(this.getHandle(), n, geometry2.getHandle());
        if (bl) {
            Geometry geometry3 = this.a.get(n);
            geometry3.clearHandle();
            this.a.remove(n);
            this.a.add(n, geometry2);
            geometry2.setIsDisposable(false);
        }
        return bl;
    }

    public void adjust(boolean bl) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Adjust(boolean isMinGeometryMovedUp)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoCompoundNative.jni_adjust(this.getHandle(), bl);
        int n2 = this.getPartCount();
        long[] lArray = new long[n2];
        GeoCompoundNative.jni_AllSubGeometrys(this.getHandle(), lArray);
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (n = 0; n < this.a.size(); ++n) {
            arrayList.add(this.a.get(n));
        }
        this.a.clear();
        block1: for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                if (((Geometry)arrayList.get(i)).getHandle() != lArray[n]) continue;
                this.a.add((Geometry)arrayList.get(i));
                arrayList.remove(i);
                continue block1;
            }
        }
    }

    public Geometry[] divide(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Divide(boolean isTopOnly)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = GeoCompoundNative.jni_divide(this.getHandle(), bl);
        int n = lArray.length;
        Geometry[] geometryArray = new Geometry[n];
        for (int i = 0; i < n; ++i) {
            geometryArray[i] = Geometry.createInstance(lArray[i]);
        }
        return geometryArray;
    }

    @Override
    public GeoCompound clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoCompound(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoCompoundNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPartCount() == 0;
    }

    @Override
    public void rotate(Point2D point2D, double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Rotate(Point2D basePoint, double angle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.rotate(point2D, d2);
        this.a();
    }

    @Override
    public void offset(double d2, double d3) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("offset(double dx, double dy)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.offset(d2, d3);
        this.a();
    }

    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoCompoundNative.jni_Clear(this.getHandle());
        this.clearHandle();
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        for (int i = 0; i < this.a.size(); ++i) {
            this.a.get(i).setIsDisposable(true);
            this.a.get(i).setHandle(0L);
            this.a.get(i).clearHandle();
        }
        this.a.clear();
    }

    static void refreshFromUGC1(GeoCompound geoCompound) {
        int n = geoCompound.getPartCount();
        long[] lArray = new long[n];
        GeoCompoundNative.jni_AllSubGeometrys(geoCompound.getHandle(), lArray);
        for (int i = 0; i < lArray.length; ++i) {
            Geometry geometry = Geometry.createInstance(lArray[i]);
            geometry.setIsDisposable(false);
            geoCompound.a.add(geometry);
        }
    }

    void a() {
        for (int i = 0; i < this.a.size(); ++i) {
            Geometry geometry;
            if (this.a.get(i) instanceof GeoRegion) {
                geometry = (GeoRegion)this.a.get(i);
                ((GeoRegion)geometry).refrashPartsList();
            }
            if (!(this.a.get(i) instanceof GeoLine)) continue;
            geometry = (GeoLine)this.a.get(i);
            ((GeoLine)geometry).a();
        }
    }

    protected static GeoCompound creatInstance(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new GeoCompound(l);
    }
}

