/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import android.util.Log;
import com.supermap.data.GeoLineNative;
import com.supermap.data.Geometry;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.imb.jsonlib.SiJsonArray;
import com.supermap.imb.jsonlib.SiJsonObject;
import java.util.ArrayList;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GeoLine
extends Geometry {
    private ArrayList a;

    public GeoLine() {
        long l = GeoLineNative.jni_New();
        this.setHandle(l, true);
        this.a = new ArrayList();
    }

    public GeoLine(GeoLine geoLine) {
        if (geoLine == null) {
            String string = InternalResource.loadString("geoLine", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoLine.getHandle() == 0L) {
            String string = InternalResource.loadString("geoLine", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoLineNative.jni_Clone(geoLine.getHandle());
        this.setHandle(l, true);
        this.a = new ArrayList();
        for (int i = 0; i < geoLine.a().size(); ++i) {
            Point2Ds point2Ds = (Point2Ds)geoLine.a().get(i);
            this.a.add(point2Ds.clone());
        }
    }

    public GeoLine(Point2Ds point2Ds) {
        this();
        this.addPart(point2Ds);
    }

    GeoLine(long l) {
        this.setHandle(l, false);
        this.a = new ArrayList();
        this.a();
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPartCount() == 0;
    }

    @Override
    public GeoLine clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoLine(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoLineNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineNative.jni_GetLength(this.getHandle());
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineNative.jni_GetPartCount(this.getHandle());
    }

    public int addPart(Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addPart()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = point2Ds.getCount();
        if (n < 2) {
            String string = InternalResource.loadString("points", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        Point2Ds point2Ds2 = new Point2Ds(point2Ds, this);
        this.a.add(point2Ds2);
        return GeoLineNative.jni_AddPart(this.getHandle(), dArray, dArray2);
    }

    public boolean removePart(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removePart()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = GeoLineNative.jni_RemovePart(this.getHandle(), n);
        if (bl) {
            this.a.remove(n);
        }
        return bl;
    }

    public Point2D findPointOnLineByDistance(double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findPointOnLineByDistance(double distance)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 < 0.0) {
            String string = InternalResource.loadString("distance", "GeoLine_ArgumentShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Point2D point2D = new Point2D();
        if (this.getPartCount() > 0) {
            double[] dArray = new double[2];
            GeoLineNative.jni_FindPointOnLineByDistance(this.getHandle(), d2, dArray);
            point2D.setX(dArray[0]);
            point2D.setY(dArray[1]);
        }
        return point2D;
    }

    public Point2Ds getPart(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPart()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (this.a.isEmpty()) {
            this.a();
        }
        return (Point2Ds)this.a.get(n);
    }

    @Override
    public boolean fromXML(String string) {
        boolean bl = super.fromXML(string);
        this.a();
        return bl;
    }

    public boolean insertPart(int n, Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertPart(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = point2Ds.getCount();
        if (n2 < 2) {
            String string = InternalResource.loadString("Point2Ds", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        int n3 = this.getPartCount();
        if (n3 == n) {
            int n4 = this.addPart(point2Ds);
            boolean bl2 = bl = n4 == n;
            if (bl) {
                Point2Ds point2Ds2 = new Point2Ds(point2Ds, this);
                this.a.add(n, point2Ds2);
            }
            return bl;
        }
        if (n < 0 || n > this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        bl = GeoLineNative.jni_InsertPart(this.getHandle(), n, dArray, dArray2);
        if (bl) {
            Point2Ds point2Ds3 = new Point2Ds(point2Ds, this);
            this.a.add(n, point2Ds3);
        }
        return bl;
    }

    public boolean setPart(int n, Point2Ds point2Ds) {
        int n2;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = point2Ds.getCount();
        if (n3 < 2) {
            String string = InternalResource.loadString("Point2Ds", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = point2Ds.getItem(n2).getX();
            dArray2[n2] = point2Ds.getItem(n2).getY();
        }
        n2 = GeoLineNative.jni_SetPart(this.getHandle(), n, dArray, dArray2) ? 1 : 0;
        if (n2 == 1) {
            Point2Ds point2Ds2 = new Point2Ds(point2Ds, this);
            this.a.set(n, point2Ds2);
        }
        return n2 != 0;
    }

    @Override
    public void rotate(Point2D point2D, double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("rotate(Point2D basePoint, double angle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.rotate(point2D, d2);
        this.b();
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        if (this.a != null) {
            this.a.clear();
            this.a = null;
        }
    }

    ArrayList a() {
        return this.a;
    }

    private Point2D[] a(int n) {
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = GeoLineNative.jni_GetPartPointCount(this.getHandle(), n);
        if (n2 > 1) {
            Point2D[] point2DArray = new Point2D[n2];
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            GeoLineNative.jni_GetPart(this.getHandle(), n, dArray, dArray2);
            for (int i = 0; i < n2; ++i) {
                point2DArray[i] = new Point2D(dArray[i], dArray2[i]);
            }
            return point2DArray;
        }
        return null;
    }

    private void b() {
        int n = this.getPartCount();
        for (int i = 0; i < n; ++i) {
            Point2Ds point2Ds = (Point2Ds)this.a.get(i);
            point2Ds.a(Point2Ds.a.a);
            point2Ds.clear();
            point2Ds.addRange(this.a(i));
            point2Ds.a(Point2Ds.a.b);
        }
    }

    void a() {
        int n = this.getPartCount();
        this.a.clear();
        for (int i = 0; i < n; ++i) {
            Point2Ds point2Ds = new Point2Ds(this.a(i));
            Point2Ds point2Ds2 = new Point2Ds(point2Ds, this);
            this.a.add(point2Ds2);
        }
    }

    @Override
    public boolean fromJson(SiJsonObject siJsonObject) {
        if (super.fromJson(siJsonObject)) {
            SiJsonArray siJsonArray = siJsonObject.getJsonArray("parts");
            SiJsonArray siJsonArray2 = siJsonObject.getJsonArray("points");
            int n = siJsonArray.getArraySize();
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                n2 = siJsonArray.getInt(i);
                Point2Ds point2Ds = new Point2Ds();
                for (int j = 0; j < n2; ++j) {
                    SiJsonObject siJsonObject2;
                    Point2D point2D = new Point2D();
                    if (!point2D.fromJson(siJsonObject2 = siJsonArray2.getJsonObject(n3++))) {
                        siJsonObject2.dispose();
                        continue;
                    }
                    siJsonObject2.dispose();
                    point2Ds.add(point2D);
                }
                this.addPart(point2Ds);
            }
            siJsonArray.dispose();
            siJsonArray2.dispose();
            return true;
        }
        return false;
    }

    @Override
    public boolean fromJson(String string) {
        SiJsonObject siJsonObject = new SiJsonObject(string);
        boolean bl = this.fromJson(siJsonObject);
        siJsonObject.dispose();
        return bl;
    }

    @Override
    public String toJson() {
        StringBuilder stringBuilder = new StringBuilder(super.toJson());
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(",");
        String string = "";
        int n = this.getPartCount();
        for (int i = 0; i < n; ++i) {
            string = string + this.getPart(i).getCount();
            if (i == n - 1) continue;
            string = string + ",";
        }
        stringBuilder.append(" \"parts\": [" + string + "]" + ",");
        stringBuilder.append(" \"type\": LINE,");
        String string2 = "";
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Point2Ds point2Ds = this.getPart(i);
            n2 = point2Ds.getCount();
            for (int j = 0; j < n2; ++j) {
                string2 = string2 + point2Ds.getItem(j).toJson();
                if (i == n - 1 && j == n2 - 1) continue;
                string2 = string2 + ",";
            }
        }
        stringBuilder.append(" \"points\" :[" + string2 + "]");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public String toGeoJSON() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.getPartCount();
        if (n > 1) {
            stringBuilder.append("{\"type\": \"MultiLineString\",");
        } else {
            stringBuilder.append("{\"type\": \"LineString\",");
        }
        stringBuilder.append("\"coordinates\":[");
        this.a(stringBuilder, n);
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }

    @Override
    public boolean fromGeoJSON(String string) {
        if (string.contains("LineString") || string.contains("MultiLineString")) {
            ArrayList<Point2Ds> arrayList = this.getPointsFromGeoJSON(string);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                this.addPart(arrayList.get(i));
            }
        } else {
            Log.e((String)"GeoLine", (String)"Not match the type of LineString or MultiLineString");
            return false;
        }
        return true;
    }

    private void a(StringBuilder stringBuilder, int n) {
        StringBuilder stringBuilder2 = new StringBuilder();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (n > 1) {
                stringBuilder2.append("[");
            }
            Point2Ds point2Ds = this.getPart(i);
            n2 = point2Ds.getCount();
            for (int j = 0; j < n2; ++j) {
                stringBuilder2.append("[");
                stringBuilder2.append(point2Ds.getItem(j).getX());
                stringBuilder2.append(",");
                stringBuilder2.append(point2Ds.getItem(j).getY());
                stringBuilder2.append("],");
                if (j <= 0 || j % 1000 != 0 || j == n2 - 1) continue;
                stringBuilder.append(stringBuilder2.toString());
                stringBuilder2.delete(0, stringBuilder2.length());
            }
            if (n2 > 0) {
                stringBuilder2.deleteCharAt(stringBuilder2.length() - 1);
            }
            if (n > 1) {
                stringBuilder2.append("]");
            }
            stringBuilder2.append(",");
            stringBuilder.append(stringBuilder2.toString());
            stringBuilder2.delete(0, stringBuilder2.length());
        }
        if (n > 0) {
            stringBuilder = stringBuilder.deleteCharAt(stringBuilder.lastIndexOf(","));
        }
    }
}

