/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CalibrateMode;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoLineMNative;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.PointM;
import com.supermap.data.PointMs;
import com.supermap.data.Rectangle2D;
import com.supermap.data.WhereToCalibrate;
import java.util.ArrayList;

public class GeoLineM
extends Geometry {
    private ArrayList<PointMs> a;

    ArrayList<PointMs> a() {
        return this.a;
    }

    public GeoLineM() {
        long l = GeoLineMNative.jni_New();
        this.setHandle(l, true);
        this.a = new ArrayList();
    }

    public GeoLineM(GeoLineM geoLineM) {
        if (geoLineM.getHandle() == 0L) {
            String string = InternalResource.loadString("geoLineM", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoLineMNative.jni_Clone(geoLineM.getHandle());
        this.setHandle(l, true);
        this.a = new ArrayList();
        for (int i = 0; i < geoLineM.a().size(); ++i) {
            PointMs pointMs = geoLineM.a().get(i);
            this.a.add(pointMs.clone());
        }
    }

    public GeoLineM(PointMs pointMs) {
        this();
        this.addPart(pointMs);
    }

    GeoLineM(long l) {
        this.setHandle(l, false);
        this.a = new ArrayList();
        this.b();
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPartCount() == 0;
    }

    @Override
    public GeoLineM clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoLineM(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoLineMNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineMNative.jni_GetLength(this.getHandle());
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineMNative.jni_GetPartCount(this.getHandle());
    }

    public int addPart(PointMs pointMs) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addPart(PointMs pointMs)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = pointMs.getCount();
        if (n < 2) {
            String string = InternalResource.loadString("pointMs", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = pointMs.getItem(i).getX();
            dArray2[i] = pointMs.getItem(i).getY();
            dArray3[i] = pointMs.getItem(i).getM();
        }
        PointMs pointMs2 = new PointMs(pointMs, this);
        this.a.add(pointMs2);
        return GeoLineMNative.jni_AddPart(this.getHandle(), dArray, dArray2, dArray3);
    }

    public boolean removePart(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removePart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = GeoLineMNative.jni_RemovePart(this.getHandle(), n);
        if (bl) {
            this.a.remove(n);
        }
        return bl;
    }

    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLineMNative.jni_Clear(this.getHandle());
        this.a.clear();
    }

    public GeoRegion convertToRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToRegion()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoLineMNative.jni_ConvertToRegion(this.getHandle());
        GeoRegion geoRegion = new GeoRegion(l);
        geoRegion.setIsDisposable(true);
        if (this.getPartCount() != geoRegion.getPartCount()) {
            String string = InternalResource.loadString("convertToRegion", "GeoLine_UnsupportOperation", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        return geoRegion;
    }

    public Point2D findPointOnLineByDistance(double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findPointOnLineByDistance(double distance)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 < 0.0) {
            String string = InternalResource.loadString("distance", "GeoLine_ArgumentShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Point2D point2D = new Point2D();
        if (this.getPartCount() > 0) {
            double[] dArray = new double[2];
            GeoLineMNative.jni_FindPointOnLineByDistance(this.getHandle(), d2, dArray);
            point2D.setX(dArray[0]);
            point2D.setY(dArray[1]);
        }
        return point2D;
    }

    public PointMs getPart(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.a.get(n);
    }

    public boolean insertPart(int n, PointMs pointMs) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertPart(int index, PointMs pointMs)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        int n2 = this.getPartCount();
        if (n2 == n) {
            int n3 = this.addPart(pointMs);
            boolean bl2 = bl = n3 == n;
            if (bl) {
                PointMs pointMs2 = new PointMs(pointMs, this);
                this.a.add(n, pointMs2);
            }
            return bl;
        }
        if (n < 0 || n > this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n4 = pointMs.getCount();
        if (n4 < 2) {
            String string = InternalResource.loadString("PointMs", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        double[] dArray3 = new double[n4];
        for (int i = 0; i < n4; ++i) {
            dArray[i] = pointMs.getItem(i).getX();
            dArray2[i] = pointMs.getItem(i).getY();
            dArray3[i] = pointMs.getItem(i).getM();
        }
        bl = GeoLineMNative.jni_InsertPart(this.getHandle(), n, dArray, dArray2, dArray3);
        if (bl) {
            PointMs pointMs3 = new PointMs(pointMs, this);
            this.a.add(n, pointMs3);
        }
        return bl;
    }

    public int indexOf(PointMs pointMs) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(PointMs part)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a.indexOf(pointMs);
    }

    public boolean reverse() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reverse()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = GeoLineMNative.jni_Reverse(this.getHandle());
        this.a();
        return bl;
    }

    public boolean reverseMOrder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reverseMOrder()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = GeoLineMNative.jni_ReverseMOrder(this.getHandle());
        if (bl) {
            this.a();
            return true;
        }
        return false;
    }

    public boolean setPart(int n, PointMs pointMs) {
        int n2;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(int index, PointMs pointMs)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = pointMs.getCount();
        if (n3 < 2) {
            String string = InternalResource.loadString("PointMs", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = pointMs.getItem(n2).getX();
            dArray2[n2] = pointMs.getItem(n2).getY();
            dArray3[n2] = pointMs.getItem(n2).getM();
        }
        n2 = GeoLineMNative.jni_SetPart(this.getHandle(), n, dArray, dArray2, dArray3) ? 1 : 0;
        if (n2 == 1) {
            PointMs pointMs2 = this.a.get(n);
            PointMs pointMs3 = new PointMs(pointMs, this);
            this.a.set(n, pointMs3);
            pointMs2.a(null);
        }
        return n2 != 0;
    }

    boolean a(int n, PointMs pointMs) {
        int n2;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(int index, PointMs pointMs)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = pointMs.getCount();
        if (n3 < 2) {
            String string = InternalResource.loadString("PointMs", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = pointMs.getItem(n2).getX();
            dArray2[n2] = pointMs.getItem(n2).getY();
            dArray3[n2] = pointMs.getItem(n2).getM();
        }
        n2 = GeoLineMNative.jni_SetPart(this.getHandle(), n, dArray, dArray2, dArray3) ? 1 : 0;
        return n2 != 0;
    }

    @Override
    public boolean fromXML(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = super.fromXML(string);
        if (bl) {
            this.b();
        }
        return bl;
    }

    @Override
    public void offset(double d2, double d3) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("offset(double dx, double dy)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.offset(d2, d3);
        this.a();
    }

    public void offsetMeasure(double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("offset(double dx, double dy)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLineMNative.jni_OffsetMeasure(this.getHandle(), d2);
        this.a();
    }

    @Override
    public void resize(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("resize(Rectangle2D bounds)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.resize(rectangle2D);
        this.a();
    }

    @Override
    public void rotate(Point2D point2D, double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("rotate(Point2D basePoint, double angle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.rotate(point2D, d2);
        this.a();
    }

    public double getMaxM() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxM()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineMNative.jni_GetMaxM(this.getHandle());
    }

    public double getMinM() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinM()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineMNative.jni_GetMinM(this.getHandle());
    }

    public GeoLine convertToLine() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoLineMNative.jni_ConvertToLine(this.getHandle());
        GeoLine geoLine = null;
        if (l != 0L) {
            geoLine = new GeoLine(l);
            geoLine.setIsDisposable(true);
        }
        return geoLine;
    }

    public void setMAsDistance(double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMAsDistance(double originM)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLineMNative.jni_SetMAsDistance(this.getHandle(), d2, 1.0, true);
        this.a();
    }

    public void setMAsDistance(double d2, double d3) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMAsDistance(double originM,double scale)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLineMNative.jni_SetMAsDistance(this.getHandle(), d2, d3, true);
        this.a();
    }

    public void setMAsDistance(double d2, double d3, boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMAsDistance(double originM,double scale,boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLineMNative.jni_SetMAsDistance(this.getHandle(), d2, d3, bl);
        this.a();
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        if (this.a != null) {
            this.a.clear();
            this.a = null;
        }
    }

    protected static void clearHandle(GeoLineM geoLineM) {
        geoLineM.clearHandle();
    }

    private void a() {
        int n = this.getPartCount();
        for (int i = 0; i < n; ++i) {
            PointMs pointMs = this.a.get(i);
            pointMs.a(null);
            pointMs.clear();
            pointMs.addRange(this.a(i));
        }
    }

    private PointM[] a(int n) {
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = GeoLineMNative.jni_GetPartPointCount(this.getHandle(), n);
        if (n2 > 1) {
            PointM[] pointMArray = new PointM[n2];
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            double[] dArray3 = new double[n2];
            GeoLineMNative.jni_GetPart(this.getHandle(), n, dArray, dArray2, dArray3);
            for (int i = 0; i < n2; ++i) {
                pointMArray[i] = new PointM(dArray[i], dArray2[i], dArray3[i]);
            }
            return pointMArray;
        }
        return null;
    }

    private void b() {
        int n = this.getPartCount();
        this.a.clear();
        for (int i = 0; i < n; ++i) {
            PointMs pointMs = new PointMs(this.a(i));
            PointMs pointMs2 = new PointMs(pointMs, this);
            this.a.add(pointMs2);
        }
    }

    public Point2D getPointAtM(double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPointAtM(double measure)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPointAtM(d2, 0.0, true);
    }

    public Point2D getPointAtM(double d2, double d3, boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPointAtM(double measure,double offset, boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Point2D point2D = new Point2D();
        double[] dArray = new double[2];
        GeoLineMNative.jni_GetPointAtM(this.getHandle(), dArray, d2, d3, bl);
        point2D.setX(dArray[0]);
        point2D.setY(dArray[1]);
        return point2D;
    }

    public Point2D getPointAtDistance(double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPointAtDistance(double distance, boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Point2D point2D = new Point2D();
        double[] dArray = new double[2];
        GeoLineMNative.jni_GetPointAtDistance(this.getHandle(), dArray, d2, false);
        point2D.setX(dArray[0]);
        point2D.setY(dArray[1]);
        return point2D;
    }

    public Point2D getPointAtDistance(double d2, boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPointAtDistance(double distance, boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Point2D point2D = new Point2D();
        double[] dArray = new double[2];
        GeoLineMNative.jni_GetPointAtDistance(this.getHandle(), dArray, d2, bl);
        point2D.setX(dArray[0]);
        point2D.setY(dArray[1]);
        return point2D;
    }

    public double getMAtDistance(double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMAtDistance(double distance)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineMNative.jni_GetMAtDistance(this.getHandle(), d2, true);
    }

    public double getMAtDistance(double d2, boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMAtDistance(double distance, boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineMNative.jni_GetMAtDistance(this.getHandle(), d2, bl);
    }

    public double getMAtDistance(double d2, int n, boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMAtDistance(double distance, boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineMNative.jni_GetMAtDistanceSub(this.getHandle(), d2, n - 1, bl);
    }

    public double getDistanceAtM(double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDistanceAtM(double measure)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineMNative.jni_GetDistanceAtM(this.getHandle(), d2, false);
    }

    public double getDistanceAtM(double d2, boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDistanceAtM(double measure,boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineMNative.jni_GetDistanceAtM(this.getHandle(), d2, bl);
    }

    public double getDistanceAtM(double d2, int n, boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMAtDistance(double distance, boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineMNative.jni_GetDistanceAtMSub(this.getHandle(), d2, n - 1, bl);
    }

    public boolean setMAtPoint(Point2D point2D, double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Point2D point2D, double measure,double tolorence,WhereToCalibrate wheretocalibrate)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        int n = GeoLineMNative.jni_SetMAtPoint(this.getHandle(), dArray, d2, 1.0E-6, 0);
        if (n != -1) {
            this.b();
            return true;
        }
        return false;
    }

    public boolean setMAtPoint(Point2D point2D, double d2, double d3, WhereToCalibrate whereToCalibrate) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Point2D point2D, double measure,double tolorence,WhereToCalibrate wheretocalibrate)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        int n = whereToCalibrate.value();
        int n2 = GeoLineMNative.jni_SetMAtPoint(this.getHandle(), dArray, d2, d3, n);
        return n2 != -1;
    }

    public double getMAtPoint(Point2D point2D, double d2, boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMAtPoint(Point2D point2D, double tolerance,boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double d3 = -9999.0;
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        d3 = GeoLineMNative.jni_GetMAtPoint(this.getHandle(), dArray, d2, bl);
        return d3;
    }

    public GeoLine getSubCurveAtM(double d2, double d3) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSubCurveAtM(double fromMeasure,double toMeasure)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoLineMNative.jni_GetSubCurveAtM(this.getHandle(), d2, d3);
        if (l != 0L) {
            GeoLine geoLine = (GeoLine)Geometry.createInstance(l);
            return geoLine;
        }
        return null;
    }

    public GeoLineM getSubLineMAtM(double d2, double d3) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLineMAtM(double startMeasure, double endMeasure)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double d4 = 0.0;
        boolean bl = true;
        long l = GeoLineMNative.jni_GetLineMAtM(this.getHandle(), d2, d3, d4, bl);
        if (l != 0L) {
            GeoLineM geoLineM = (GeoLineM)Geometry.createInstance(l);
            return geoLineM;
        }
        return null;
    }

    public static GeoLineM union(GeoLineM geoLineM, GeoLineM geoLineM2) {
        if (geoLineM.getHandle() == 0L) {
            String string = InternalResource.loadString("geolinem", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoLineM2.getHandle() == 0L) {
            String string = InternalResource.loadString("otherLineM", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoLineM geoLineM3 = new GeoLineM(geoLineM);
        int n = geoLineM2.a().size();
        for (int i = 0; i < n; ++i) {
            geoLineM3.addPart(geoLineM2.getPart(i));
        }
        return geoLineM3;
    }

    public boolean joint(GeoLineM geoLineM) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Joint(GeoLineM otherLineM)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoLineM.getHandle() == 0L) {
            String string = InternalResource.loadString("otherLineM", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = geoLineM.a().size();
        int n2 = this.getPartCount();
        PointMs pointMs = this.a().get(n2 - 1);
        PointMs pointMs2 = geoLineM.a().get(0);
        pointMs.addRange(pointMs2.toArray());
        for (int i = 1; i < n; ++i) {
            PointMs pointMs3 = geoLineM.a().get(i);
            this.a.add(pointMs3.clone());
        }
        return true;
    }

    public boolean split(Point2D point2D, GeoLineM geoLineM, GeoLineM geoLineM2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Split(Point2D splitPoint,GeoLineM geolinem1,GeoLineM geolinem2)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        if (GeoLineMNative.jni_Split(this.getHandle(), dArray, geoLineM.getHandle(), geoLineM2.getHandle())) {
            geoLineM.b();
            geoLineM2.b();
            return true;
        }
        return false;
    }

    public boolean calibrateLineM(PointMs pointMs, CalibrateMode calibrateMode, boolean bl) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CalibrateLineM(PointMs pointMs)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = pointMs.getCount();
        if (n2 < 2) {
            String string = InternalResource.loadString("PointMs", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = pointMs.getItem(n).getX();
            dArray2[n] = pointMs.getItem(n).getY();
            dArray3[n] = pointMs.getItem(n).getM();
        }
        n = GeoLineMNative.jni_CalibrateLineM(this.getHandle(), dArray, dArray2, dArray3, calibrateMode.value(), bl) ? 1 : 0;
        if (n == 1) {
            this.a.clear();
            this.b();
        }
        return n != 0;
    }

    public boolean calibrateLineM(GeoLineM geoLineM, CalibrateMode calibrateMode, boolean bl) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("(GeoLineM geoLineM, CalibrateMeasureMethod method, boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoLineM.getHandle() == 0L) {
            String string = InternalResource.loadString("(GeoLineM geoLineM, CalibrateMeasureMethod method, boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        PointMs pointMs = geoLineM.getPart(0);
        int n2 = pointMs.getCount();
        if (n2 < 2) {
            String string = InternalResource.loadString("PointMs", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = pointMs.getItem(n).getX();
            dArray2[n] = pointMs.getItem(n).getY();
            dArray3[n] = pointMs.getItem(n).getM();
        }
        n = GeoLineMNative.jni_CalibrateLineM(this.getHandle(), dArray, dArray2, dArray3, calibrateMode.getUGCValue(), bl) ? 1 : 0;
        if (n == 1) {
            this.a.clear();
            this.b();
        }
        return n != 0;
    }

    public static GeoLineM clip(GeoLineM geoLineM, GeoRegion geoRegion) {
        if (geoLineM == null || geoLineM.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoRegion == null || geoRegion.getHandle() == 0L) {
            String string = InternalResource.loadString("clipGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoLineM.getType() != GeometryType.GEOLINEM) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoRegion.getType() != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("clipGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoLineMNative.jni_Clip(geoLineM.getHandle(), geoRegion.getHandle());
        GeoLineM geoLineM2 = null;
        if (l != 0L) {
            geoLineM2 = new GeoLineM(l);
        }
        double d2 = geoLineM2.getMaxM();
        System.out.println(d2);
        return geoLineM2;
    }

    public boolean updateM(Point2D point2D, Point2D point2D2, double d2, double d3, double d4, WhereToCalibrate whereToCalibrate, CalibrateMode calibrateMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("UpdateM(Point2D fromPoint,Point2D toPoint, double fromMeasure,double toMeasure,double tolerance, WhereToCalibrate wheretoCalibrate, CalibrateMeasureMethod method)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        double[] dArray2 = new double[]{point2D2.getX(), point2D2.getY()};
        boolean bl = GeoLineMNative.jni_UpdateM(this.getHandle(), dArray, dArray2, d2, d3, d4, whereToCalibrate.value(), calibrateMode.value());
        if (bl) {
            this.b();
            return true;
        }
        return false;
    }

    public boolean updateM(int n, int n2, double d2, double d3, WhereToCalibrate whereToCalibrate, CalibrateMode calibrateMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("UpdateM(int fromIndex, int toIndex, double fromMeasure, double toMeasure,WhereToCalibrate wheretoCalibrate,CalibrateMode method)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = GeoLineMNative.jni_UpdateMIndex(this.getHandle(), n, n2, d2, d3, whereToCalibrate.value(), calibrateMode.value());
        if (bl) {
            this.b();
            return true;
        }
        return false;
    }

    public boolean interpolateM(Point2D point2D, Point2D point2D2, double d2, double d3, double d4, CalibrateMode calibrateMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("InterpolateM(Point2D fromPoint,Point2D toPoint, double fromMeasure, double toMeasure,double tolerance, CalibrateMeasureMethod method)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        double[] dArray2 = new double[]{point2D2.getX(), point2D2.getY()};
        boolean bl = GeoLineMNative.jni_InterpolateM(this.getHandle(), dArray, dArray2, d2, d3, d4, calibrateMode.value());
        if (bl) {
            this.b();
            return true;
        }
        return false;
    }

    public boolean extrapolateM(Point2D point2D, Point2D point2D2, double d2, double d3, double d4, CalibrateMode calibrateMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ExtrapolateM(Point2D fromPoint,Point2D toPoint, double fromMeasure,double toMeasure,double tolerance, CalibrateMeasureMethod method)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        double[] dArray2 = new double[]{point2D2.getX(), point2D2.getY()};
        boolean bl = GeoLineMNative.jni_ExtrapolateM(this.getHandle(), dArray, dArray2, d2, d3, d4, calibrateMode.value());
        if (bl) {
            this.b();
            return true;
        }
        return false;
    }

    public void calculateNoM(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CalculateNoM(boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLineMNative.jni_CalculateNoM(this.getHandle(), bl);
        this.b();
    }

    public static GeoLineM makeLineM(GeoLine geoLine, PointMs pointMs) {
        if (geoLine == null || geoLine.getHandle() == 0L) {
            String string = InternalResource.loadString("geoline", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = pointMs.getCount();
        if (n < 2) {
            String string = InternalResource.loadString("pointMs", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoLine.getType() != GeometryType.GEOLINE) {
            String string = InternalResource.loadString("geoline", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = pointMs.getItem(i).getX();
            dArray2[i] = pointMs.getItem(i).getY();
            dArray3[i] = pointMs.getItem(i).getM();
        }
        long l = GeoLineMNative.jni_MakeLineM(geoLine.getHandle(), dArray, dArray2, dArray3);
        if (l != 0L) {
            GeoLineM geoLineM = (GeoLineM)Geometry.createInstance(l);
            return geoLineM;
        }
        return null;
    }
}

