/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import android.util.Log;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegionNative;
import com.supermap.data.Geometry;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.imb.jsonlib.SiJsonArray;
import com.supermap.imb.jsonlib.SiJsonObject;
import java.util.ArrayList;

public class GeoRegion
extends Geometry {
    private ArrayList a;

    public GeoRegion() {
        super.setHandle(GeoRegionNative.jni_New(), true);
        this.a = new ArrayList();
    }

    public GeoRegion(GeoRegion geoRegion) {
        if (geoRegion == null) {
            String string = InternalResource.loadString("region", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoRegion.getHandle() == 0L) {
            String string = InternalResource.loadString("region", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoRegionNative.jni_Clone(geoRegion.getHandle());
        super.setHandle(l, true);
        this.a = new ArrayList(geoRegion.getPartsList().size());
        for (int i = 0; i < geoRegion.getPartsList().size(); ++i) {
            Point2Ds point2Ds = (Point2Ds)geoRegion.getPartsList().get(i);
            this.a.add(point2Ds.clone());
        }
    }

    public GeoRegion(Point2Ds point2Ds) {
        this();
        if (point2Ds.getCount() < 3) {
            String string = InternalResource.loadString("convertToRegion", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.addPart(point2Ds);
    }

    public int addPart(Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addPart(Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = point2Ds.getCount();
        if (n < 3) {
            String string = InternalResource.loadString("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        int n2 = GeoRegionNative.jni_AddPart(this.getHandle(), dArray, dArray2);
        Point2Ds point2Ds2 = new Point2Ds(this.getPartFromUGC(n2));
        Point2Ds point2Ds3 = new Point2Ds(point2Ds2, this);
        this.a.add(point2Ds3);
        return n2;
    }

    public GeoLine convertToLine() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoRegionNative.jni_ConvertToLine(this.getHandle());
        if (l != 0L) {
            GeoLine geoLine = new GeoLine(l);
            geoLine.setIsDisposable(true);
            return geoLine;
        }
        return null;
    }

    public Point2Ds getPart(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return (Point2Ds)this.a.get(n);
    }

    public boolean insertPart(int n, Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertPart(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = point2Ds.getCount();
        if (n2 < 3) {
            String string = InternalResource.loadString("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n > this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        if (n == this.getPartCount()) {
            int n3 = GeoRegionNative.jni_AddPart(this.getHandle(), dArray, dArray2);
            Point2Ds point2Ds2 = new Point2Ds(this.getPartFromUGC(n3));
            Point2Ds point2Ds3 = new Point2Ds(point2Ds2, this);
            this.a.add(n, point2Ds3);
            return n3 != -1;
        }
        boolean bl = GeoRegionNative.jni_InsertPart(this.getHandle(), n, dArray, dArray2);
        Point2Ds point2Ds4 = new Point2Ds(this.getPartFromUGC(n));
        Point2Ds point2Ds5 = new Point2Ds(point2Ds4, this);
        this.a.add(n, point2Ds5);
        return bl;
    }

    public boolean removePart(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removePart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = GeoRegionNative.jni_RemovePart(this.getHandle(), n);
        if (bl) {
            this.a.remove(n);
        }
        return bl;
    }

    public boolean setPart(int n, Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (point2Ds.getCount() < 3) {
            String string = InternalResource.loadString("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = point2Ds.getCount();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        boolean bl = GeoRegionNative.jni_SetPart(this.getHandle(), n, dArray, dArray2);
        if (bl) {
            Point2Ds point2Ds2 = new Point2Ds(this.getPartFromUGC(n));
            Point2Ds point2Ds3 = new Point2Ds(point2Ds2, this);
            this.a.set(n, point2Ds3);
        }
        return bl;
    }

    boolean setPartJustToUGC(int n, Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (point2Ds.getCount() < 3) {
            String string = InternalResource.loadString("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = point2Ds.getCount();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        boolean bl = GeoRegionNative.jni_SetPart(this.getHandle(), n, dArray, dArray2);
        return bl;
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegionNative.jni_GetArea(this.getHandle());
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegionNative.jni_GetPartCount(this.getHandle());
    }

    public double getPerimeter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPerimeter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegionNative.jni_GetPerimeter(this.getHandle());
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        if (this.a != null) {
            this.a.clear();
            this.a = null;
        }
        this.setHandle(0L);
    }

    protected static void clearHandle(GeoRegion geoRegion) {
        geoRegion.clearHandle();
    }

    protected void changeHandle(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("regionHandle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setIsDisposable(true);
        this.dispose();
        this.setHandle(l, false);
    }

    protected static void changeHandle(GeoRegion geoRegion, long l) {
        geoRegion.changeHandle(l);
    }

    ArrayList getPartsList() {
        return this.a;
    }

    private Point2D[] getPartFromUGC(int n) {
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = GeoRegionNative.jni_GetPartPointCount(this.getHandle(), n);
        if (n2 > 2) {
            Point2D[] point2DArray = new Point2D[n2];
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            GeoRegionNative.jni_GetPart(this.getHandle(), n, dArray, dArray2);
            for (int i = 0; i < n2; ++i) {
                point2DArray[i] = new Point2D(dArray[i], dArray2[i]);
            }
            return point2DArray;
        }
        return null;
    }

    private void refreshFromUGC() {
        int n = this.getPartCount();
        for (int i = 0; i < n; ++i) {
            Point2Ds point2Ds = (Point2Ds)this.a.get(i);
            point2Ds.a(Point2Ds.a.a);
            point2Ds.clear();
            point2Ds.addRange(this.getPartFromUGC(i));
            point2Ds.a(Point2Ds.a.c);
        }
    }

    void refrashPartsList() {
        int n = this.getPartCount();
        this.a.clear();
        for (int i = 0; i < n; ++i) {
            Point2Ds point2Ds = new Point2Ds(this.getPartFromUGC(i));
            Point2Ds point2Ds2 = new Point2Ds(point2Ds, this);
            this.a.add(point2Ds2);
        }
    }

    @Override
    public GeoRegion clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoRegion(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoRegionNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPartCount() == 0;
    }

    GeoRegion(long l) {
        this.setHandle(l, false);
        this.a = new ArrayList();
        this.refrashPartsList();
    }

    protected void refreshHandle(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l, false);
    }

    protected static void refreshHandle(GeoRegion geoRegion, long l) {
        geoRegion.refreshHandle(l);
    }

    @Override
    public boolean fromJson(String string) {
        SiJsonObject siJsonObject = new SiJsonObject(string);
        boolean bl = this.fromJson(siJsonObject);
        siJsonObject.dispose();
        return bl;
    }

    @Override
    public boolean fromJson(SiJsonObject siJsonObject) {
        if (super.fromJson(siJsonObject)) {
            SiJsonArray siJsonArray = siJsonObject.getJsonArray("parts");
            SiJsonArray siJsonArray2 = siJsonObject.getJsonArray("points");
            int n = siJsonArray.getArraySize();
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                n2 = siJsonArray.getInt(i);
                Point2Ds point2Ds = new Point2Ds();
                for (int j = 0; j < n2; ++j) {
                    SiJsonObject siJsonObject2;
                    Point2D point2D = new Point2D();
                    if (!point2D.fromJson(siJsonObject2 = siJsonArray2.getJsonObject(n3++))) {
                        siJsonObject2.dispose();
                        continue;
                    }
                    siJsonObject2.dispose();
                    point2Ds.add(point2D);
                }
                this.addPart(point2Ds);
            }
            siJsonArray.dispose();
            siJsonArray2.dispose();
            return true;
        }
        return false;
    }

    @Override
    public String toJson() {
        StringBuilder stringBuilder = new StringBuilder(super.toJson());
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(",");
        String string = "";
        int n = this.getPartCount();
        for (int i = 0; i < n; ++i) {
            string = string + this.getPart(i).getCount();
            if (i == n - 1) continue;
            string = string + ",";
        }
        stringBuilder.append(" \"parts\": [" + string + "]" + ",");
        stringBuilder.append(" \"type\": \"REGION\",");
        String string2 = "";
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Point2Ds point2Ds = this.getPart(i);
            n2 = point2Ds.getCount();
            for (int j = 0; j < n2; ++j) {
                string2 = string2 + point2Ds.getItem(j).toJson();
                if (i == n - 1 && j == n2 - 1) continue;
                string2 = string2 + ",";
            }
        }
        stringBuilder.append(" \"points\" :[" + string2 + "]");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public String toGeoJSON() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.getPartCount();
        stringBuilder.append("{\"type\": \"Polygon\",");
        stringBuilder.append("\"coordinates\":[");
        this.getCoordinatesString(stringBuilder, n);
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }

    @Override
    public boolean fromGeoJSON(String string) {
        if (!string.contains("Polygon")) {
            Log.e((String)"GeoRegion", (String)"Not match the type of Polygon");
            return false;
        }
        ArrayList<Point2Ds> arrayList = this.getPointsFromGeoJSON(string);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            this.addPart(arrayList.get(i));
        }
        return true;
    }

    private void getCoordinatesString(StringBuilder stringBuilder, int n) {
        StringBuilder stringBuilder2 = new StringBuilder();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (n > 1) {
                stringBuilder2.append("[");
            }
            Point2Ds point2Ds = this.getPart(i);
            n2 = point2Ds.getCount();
            for (int j = 0; j < n2; ++j) {
                stringBuilder2.append("[");
                stringBuilder2.append(point2Ds.getItem(j).getX());
                stringBuilder2.append(",");
                stringBuilder2.append(point2Ds.getItem(j).getY());
                stringBuilder2.append("],");
                if (j <= 0 || j % 1000 != 0 || j == n2 - 1) continue;
                stringBuilder.append(stringBuilder2.toString());
                stringBuilder2.delete(0, stringBuilder2.length());
            }
            if (n2 > 0) {
                stringBuilder2.deleteCharAt(stringBuilder2.length() - 1);
            }
            if (n > 1) {
                stringBuilder2.append("]");
            }
            stringBuilder2.append(",");
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder2.delete(0, stringBuilder2.length());
        }
        if (n > 0) {
            stringBuilder = stringBuilder.deleteCharAt(stringBuilder.lastIndexOf(","));
        }
    }
}

