/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoRegion3DNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;
import com.supermap.imb.jsonlib.SiJsonArray;
import com.supermap.imb.jsonlib.SiJsonObject;
import java.util.ArrayList;

public class GeoRegion3D
extends Geometry3D {
    private ArrayList<Point3Ds> a;

    public GeoRegion3D() {
        super.setHandle(GeoRegion3DNative.jni_New(), true);
        this.a = new ArrayList();
    }

    public GeoRegion3D(Point3Ds point3Ds) {
        this();
        this.addPart(point3Ds);
    }

    public GeoRegion3D(GeoRegion3D geoRegion3D) {
        if (geoRegion3D == null) {
            String string = InternalResource.loadString("region3D", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoRegion3D.getHandle() == 0L) {
            String string = InternalResource.loadString("region3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoRegion3DNative.jni_Clone(geoRegion3D.getHandle());
        super.setHandle(l, true);
        this.a = new ArrayList();
        for (int i = 0; i < geoRegion3D.a().size(); ++i) {
            Point3Ds point3Ds = geoRegion3D.a().get(i);
            this.a.add(point3Ds.clone());
        }
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoRegion3DNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegion3DNative.jni_GetArea(this.getHandle());
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegion3DNative.jni_GetPartCount(this.getHandle());
    }

    public int addPart(Point3Ds point3Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addPart(points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = point3Ds.getCount();
        if (n < 3) {
            String string = InternalResource.loadString("points", "GeoRegion3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point3Ds.getItem(i).getX();
            dArray2[i] = point3Ds.getItem(i).getY();
            dArray3[i] = point3Ds.getItem(i).getZ();
        }
        int n2 = GeoRegion3DNative.jni_AddPart(this.getHandle(), dArray, dArray2, dArray3);
        Point3Ds point3Ds2 = new Point3Ds(this.a(n2));
        Point3Ds point3Ds3 = new Point3Ds(point3Ds2, this);
        this.a.add(point3Ds3);
        return n2;
    }

    public GeoLine3D convertToLine() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLine3D geoLine3D = new GeoLine3D();
        for (int i = 0; i < this.getPartCount(); ++i) {
            geoLine3D.addPart(this.getPart(i));
        }
        geoLine3D.setIsDisposable(true);
        return geoLine3D;
    }

    public Point3Ds getPart(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPart(index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.a.get(n);
    }

    boolean a(int n, Point3Ds point3Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(index, points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (point3Ds.getCount() < 3) {
            String string = InternalResource.loadString("points", "GeoRegion3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = point3Ds.getCount();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = point3Ds.getItem(i).getX();
            dArray2[i] = point3Ds.getItem(i).getY();
            dArray3[i] = point3Ds.getItem(i).getZ();
        }
        boolean bl = GeoRegion3DNative.jni_SetPart(this.getHandle(), n, dArray, dArray2, dArray3);
        if (bl) {
            Point3Ds point3Ds2 = new Point3Ds(this.a(n));
            Point3Ds point3Ds3 = new Point3Ds(point3Ds2, this);
            this.a.set(n, point3Ds3);
        }
        return bl;
    }

    boolean b(int n, Point3Ds point3Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(index, points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (point3Ds.getCount() < 3) {
            String string = InternalResource.loadString("points", "GeoRegion3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = point3Ds.getCount();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = point3Ds.getItem(i).getX();
            dArray2[i] = point3Ds.getItem(i).getY();
            dArray3[i] = point3Ds.getItem(i).getZ();
        }
        boolean bl = GeoRegion3DNative.jni_SetPart(this.getHandle(), n, dArray, dArray2, dArray3);
        return bl;
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        if (this.a != null) {
            this.a.clear();
            this.a = null;
        }
        this.setHandle(0L);
    }

    ArrayList<Point3Ds> a() {
        return this.a;
    }

    private Point3D[] a(int n) {
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = GeoRegion3DNative.jni_GetPartPointCount(this.getHandle(), n);
        if (n2 > 2) {
            Point3D[] point3DArray = new Point3D[n2];
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            double[] dArray3 = new double[n2];
            GeoRegion3DNative.jni_GetPart(this.getHandle(), n, dArray, dArray2, dArray3);
            for (int i = 0; i < n2; ++i) {
                point3DArray[i] = new Point3D(dArray[i], dArray2[i], dArray3[i]);
            }
            return point3DArray;
        }
        return null;
    }

    @Override
    public GeoRegion3D clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoRegion3D(this);
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPartCount() == 0;
    }

    GeoRegion3D(long l) {
        this.setHandle(l, false);
        this.a = new ArrayList();
        this.a();
    }

    private void a() {
        int n = this.getPartCount();
        this.a.clear();
        for (int i = 0; i < n; ++i) {
            Point3Ds point3Ds = new Point3Ds(this.a(i));
            Point3Ds point3Ds2 = new Point3Ds(point3Ds, this);
            this.a.add(point3Ds2);
        }
    }

    @Override
    public boolean fromJson(String string) {
        SiJsonObject siJsonObject = new SiJsonObject(string);
        boolean bl = this.fromJson(siJsonObject);
        siJsonObject.dispose();
        return bl;
    }

    @Override
    public boolean fromJson(SiJsonObject siJsonObject) {
        if (super.fromJson(siJsonObject)) {
            SiJsonArray siJsonArray = siJsonObject.getJsonArray("parts");
            SiJsonArray siJsonArray2 = siJsonObject.getJsonArray("points");
            int n = siJsonArray.getArraySize();
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                n2 = siJsonArray.getInt(i);
                Point3Ds point3Ds = new Point3Ds();
                for (int j = 0; j < n2; ++j) {
                    SiJsonObject siJsonObject2;
                    Point3D point3D = new Point3D();
                    if (!point3D.fromJson(siJsonObject2 = siJsonArray2.getJsonObject(n3++))) {
                        siJsonObject2.dispose();
                        continue;
                    }
                    siJsonObject2.dispose();
                    point3Ds.add(point3D);
                }
                this.addPart(point3Ds);
            }
            siJsonArray.dispose();
            siJsonArray2.dispose();
            return true;
        }
        return false;
    }

    @Override
    public String toJson() {
        StringBuilder stringBuilder = new StringBuilder(super.toJson());
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(",");
        String string = "";
        int n = this.getPartCount();
        for (int i = 0; i < n; ++i) {
            string = string + this.getPart(i).getCount();
            if (i == n - 1) continue;
            string = string + ",";
        }
        stringBuilder.append(" \"parts\": [" + string + "]" + ",");
        stringBuilder.append(" \"type\": \"REGION3D\",");
        String string2 = "";
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Point3Ds point3Ds = this.getPart(i);
            n2 = point3Ds.getCount();
            for (int j = 0; j < n2; ++j) {
                string2 = string2 + point3Ds.getItem(j).toJson();
                if (i == n - 1 && j == n2 - 1) continue;
                string2 = string2 + ",";
            }
        }
        stringBuilder.append(" \"points\" :[" + string2 + "]");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

