/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Environment;
import com.supermap.data.GeoArc;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeometristNative;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Rectangle2D;
import com.supermap.data.ResampleType;

public class Geometrist {
    private Geometrist() {
    }

    public static boolean isIdentical(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsIdentical(geometry.getHandle(), geometry2.getHandle());
    }

    public static boolean isDisjointed(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsDisjointed(geometry.getHandle(), geometry2.getHandle());
    }

    public static boolean hasIntersection(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION, GeometryType.GEOTEXT)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION, GeometryType.GEOTEXT)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType() != GeometryType.GEOREGION && geometry2.getType() != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("geometrySearch&geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_HasIntersection(geometry.getHandle(), geometry2.getHandle());
    }

    public static boolean hasTouch(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_HasTouch(geometry.getHandle(), geometry2.getHandle());
    }

    public static boolean hasOverlap(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2.getType() != geometry2.getType()) {
            String string = InternalResource.loadString("geometrySearch&geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_HasOverlap(geometry.getHandle(), geometry2.getHandle());
    }

    public static boolean hasCross(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOLINE)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_HasCross(geometry.getHandle(), geometry2.getHandle());
    }

    public static boolean isWithin(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsWithin(geometry.getHandle(), geometry2.getHandle());
    }

    public static boolean canContain(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_CanContain(geometry.getHandle(), geometry2.getHandle());
    }

    public static boolean hasCommonPoint(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_HasCommonPoint(geometry.getHandle(), geometry2.getHandle());
    }

    public static boolean hasCommonLine(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_HasCommonLine(geometry.getHandle(), geometry2.getHandle());
    }

    public static Geometry clip(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("clipGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("clipGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_Clip(geometry.getHandle(), geometry2.getHandle());
        Geometry geometry3 = null;
        if (l != 0L) {
            geometry3 = Geometry.createInstance(l);
        }
        return geometry3;
    }

    public static Geometry clip(Geometry geometry, Rectangle2D rectangle2D) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D == null) {
            String string = InternalResource.loadString("clipRectangle", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D.isEmpty()) {
            String string = InternalResource.loadString("clipRectangle", "GeometryShouldNotBeEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_ClipRect(geometry.getHandle(), rectangle2D.getLeft(), rectangle2D.getTop(), rectangle2D.getRight(), rectangle2D.getBottom());
        Geometry geometry2 = null;
        if (l != 0L) {
            geometry2 = Geometry.createInstance(l);
        }
        return geometry2;
    }

    public static boolean hasHollow(Geometry geometry) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_HasHollow(geometry.getHandle());
    }

    @Deprecated
    public static boolean HasHollow(Geometry geometry) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_HasHollow(geometry.getHandle());
    }

    public static Geometry intersect(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!geometry.getType().equals(geometry2.getType())) {
            String string = InternalResource.loadString("", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_Intersect(geometry.getHandle(), geometry2.getHandle());
        Geometry geometry3 = null;
        if (l != 0L) {
            geometry3 = Geometry.createInstance(l);
        }
        return geometry3;
    }

    public static Geometry erase(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("eraseGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("eraseGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_Erase(geometry.getHandle(), geometry2.getHandle());
        Geometry geometry3 = null;
        if (l != 0L) {
            geometry3 = Geometry.createInstance(l);
        }
        return geometry3;
    }

    public static Geometry union(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_Union(geometry.getHandle(), geometry2.getHandle());
        Geometry geometry3 = null;
        if (l != 0L) {
            geometry3 = Geometry.createInstance(l);
        }
        return geometry3;
    }

    public static Geometry xOR(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType() != geometry2.getType()) {
            String string = InternalResource.loadString("geometry1&geometry2", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_XOR(geometry.getHandle(), geometry2.getHandle());
        Geometry geometry3 = null;
        if (l != 0L) {
            geometry3 = Geometry.createInstance(l);
        }
        return geometry3;
    }

    public static Geometry update(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("updateGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("updateGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_Update(geometry.getHandle(), geometry2.getHandle());
        Geometry geometry3 = null;
        if (l != 0L) {
            geometry3 = Geometry.createInstance(l);
        }
        return geometry3;
    }

    public static Geometry identity(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("identityGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("identityGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_Identity(geometry.getHandle(), geometry2.getHandle());
        Geometry geometry3 = null;
        if (l != 0L) {
            geometry3 = Geometry.createInstance(l);
        }
        return geometry3;
    }

    @Deprecated
    public static Geometry resample(Geometry geometry, double d2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 <= 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ToleranceShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_Resample(geometry.getHandle(), d2);
        Geometry geometry2 = null;
        if (l != 0L) {
            geometry2 = Geometry.createInstance(l);
        }
        return geometry2;
    }

    public static Geometry resample(Geometry geometry, ResampleType resampleType, double d2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 <= 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ToleranceShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = resampleType.getUGCValue();
        long l = GeometristNative.jni_Resample1(geometry.getHandle(), n, d2);
        Geometry geometry2 = null;
        if (l != 0L) {
            geometry2 = Geometry.createInstance(l);
        }
        return geometry2;
    }

    public static double distance(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d2 = GeometristNative.jni_Distance(geometry.getHandle(), geometry2.getHandle());
        return d2;
    }

    public static GeoRegion computeConvexHull(Point2Ds point2Ds) {
        int n = point2Ds.getCount();
        if (n < 3) {
            String string = InternalResource.loadString("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        long l = GeometristNative.jni_ComputeConvexHullPoints(dArray, dArray2, n);
        Geometry geometry = null;
        if (l != 0L) {
            geometry = Geometry.createInstance(l);
        }
        return (GeoRegion)geometry;
    }

    public static GeoRegion computeConvexHull(Geometry geometry) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_ComputeConvexHull(geometry.getHandle());
        Geometry geometry2 = null;
        geometry2 = l != 0L ? Geometry.createInstance(l) : Geometry.createInstance(geometry.getType());
        return (GeoRegion)geometry2;
    }

    public static boolean splitRegion(GeoRegion geoRegion, Geometry geometry, GeoRegion geoRegion2, GeoRegion geoRegion3) {
        if (geoRegion == null || geoRegion.getHandle() == 0L) {
            String string = InternalResource.loadString("soureRegion", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("splitGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoRegion2 == null || geoRegion2.getHandle() == 0L) {
            String string = InternalResource.loadString("targetGeoRegion1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoRegion3 == null || geoRegion3.getHandle() == 0L) {
            String string = InternalResource.loadString("targetGeoRegion2", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geoRegion, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("soureRegion", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("splitGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geoRegion2, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("targetGeoRegion1", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geoRegion3, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("targetGeoRegion2", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType().equals(GeometryType.GEOPOINT)) {
            String string = InternalResource.loadString("splitGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_SplitRegion(geoRegion.getHandle(), geometry.getHandle(), geoRegion2.getHandle(), geoRegion3.getHandle());
        if (bl) {
            geoRegion2.refrashPartsList();
            geoRegion3.refrashPartsList();
        }
        return bl;
    }

    public static GeoArc computeFillet(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4, double d2) {
        if (d2 <= 0.0) {
            String string = InternalResource.loadString("radius", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2D.equals(point2D2)) {
            String string = InternalResource.loadString("startPoint1,endPoint1", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2D3.equals(point2D4)) {
            String string = InternalResource.loadString("startPoint2,endPoint2", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_ComputeFillet(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), point2D4.getX(), point2D4.getY(), d2);
        Geometry geometry = null;
        if (l != 0L) {
            geometry = Geometry.createInstance(l);
        }
        return (GeoArc)geometry;
    }

    public static boolean isParallel(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        if (point2D.equals(point2D2)) {
            String string = InternalResource.loadString("startPoint1,endPoint1", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2D3.equals(point2D4)) {
            String string = InternalResource.loadString("startPoint2,endPoint2", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsParallel(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), point2D4.getX(), point2D4.getY());
    }

    public static GeoLine computeParallel(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        if (point2D2.equals(point2D3)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Point2Ds point2Ds = new Point2Ds();
        point2Ds.add(point2D2);
        point2Ds.add(point2D3);
        GeoLine geoLine = new GeoLine(point2Ds);
        if (!Geometrist.isPointOnLine(point2D, point2D2, point2D3, true)) {
            geoLine = Geometrist.computePerpendicular(point2D, point2D2, point2D3);
            geoLine.rotate(point2D, -90.0);
        }
        return geoLine;
    }

    public static GeoLine computeParallel(GeoLine geoLine, double d2) {
        if (geoLine == null || geoLine.getHandle() == 0L) {
            String string = InternalResource.loadString("geoLine", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_ComputeParallel(geoLine.getHandle(), d2);
        Geometry geometry = null;
        if (l != 0L) {
            geometry = Geometry.createInstance(l);
        }
        return (GeoLine)geometry;
    }

    public static boolean isPerpendicular(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        if (point2D.equals(point2D2)) {
            String string = InternalResource.loadString("startPoint1,endPoint1", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2D3.equals(point2D4)) {
            String string = InternalResource.loadString("startPoint2,endPoint2", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsPerpendicular(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), point2D4.getX(), point2D4.getY());
    }

    public static GeoLine computePerpendicular(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        if (point2D2.equals(point2D3)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Point2Ds point2Ds = new Point2Ds();
        point2Ds.add(point2D2);
        point2Ds.add(point2D3);
        GeoLine geoLine = new GeoLine(point2Ds);
        Point2D point2D4 = Geometrist.computePerpendicularPosition(point2D, point2D2, point2D3);
        geoLine.rotate(point2D4, 90.0);
        return geoLine;
    }

    public static Point2D computePerpendicularPosition(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        if (point2D2.equals(point2D3)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        GeometristNative.jni_ComputePerpendicularPosition(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public static boolean isPointOnLine(Point2D point2D, Point2D point2D2, Point2D point2D3, boolean bl) {
        if (point2D2.equals(point2D3)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsPointOnLine(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), bl);
    }

    public static Point2D intersectLine(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4, boolean bl) {
        if (point2D.equals(point2D2)) {
            String string = InternalResource.loadString("startPoint1,endPoint1", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2D3.equals(point2D4)) {
            String string = InternalResource.loadString("startPoint2,endPoint2", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        boolean bl2 = GeometristNative.jni_IntersectLine(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), point2D4.getX(), point2D4.getY(), bl, dArray);
        if (bl2) {
            return new Point2D(dArray[0], dArray[1]);
        }
        return null;
    }

    public static double computeGeodesicDistance(Point2Ds point2Ds, double d2, double d3) {
        if (point2Ds.getCount() < 2) {
            String string = InternalResource.loadString("points", "Point2Ds_PointCountShouldMoreThanTwo", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 <= 0.0) {
            String string = InternalResource.loadString("majorAxis", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d3 <= 0.0) {
            String string = InternalResource.loadString("flatten", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d3 >= 1.0) {
            String string = InternalResource.loadString("flatten", "Global_ArgumentOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[point2Ds.getCount()];
        double[] dArray2 = new double[point2Ds.getCount()];
        for (int i = 0; i < point2Ds.getCount(); ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        return GeometristNative.jni_ComputeGeodesicDistance(dArray, dArray2, d2, d3);
    }

    public static double computeGeodesicLength(Geometry geometry, PrjCoordSys prjCoordSys) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_ComputeGeodesicDistance(geometry.getHandle(), prjCoordSys.getHandle());
    }

    public static double computeGeodesicArea(Geometry geometry, PrjCoordSys prjCoordSys) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType() != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_ComputeGeodesicArea(geometry.getHandle(), prjCoordSys.getHandle());
    }

    public static Point2D[] intersectPolyLine(Point2Ds point2Ds, Point2Ds point2Ds2) {
        int n = point2Ds.getCount();
        if (n < 2) {
            String string = InternalResource.loadString("points1", "Point2Ds_PointCountShouldMoreThanTwo", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = point2Ds2.getCount();
        if (n2 < 2) {
            String string = InternalResource.loadString("points2", "Point2Ds_PointCountShouldMoreThanTwo", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray3[i] = point2Ds2.getItem(i).getX();
            dArray4[i] = point2Ds2.getItem(i).getY();
        }
        double[][] dArray5 = GeometristNative.jni_IntersectPolyLine(dArray, dArray2, n, dArray3, dArray4, n2);
        double[] dArray6 = dArray5[0];
        double[] dArray7 = dArray5[1];
        Point2D[] point2DArray = new Point2D[dArray6.length];
        for (int i = 0; i < point2DArray.length; ++i) {
            Point2D point2D = new Point2D();
            point2D.setX(dArray6[i]);
            point2D.setY(dArray7[i]);
            point2DArray[i] = point2D;
        }
        return point2DArray;
    }

    public static Point2Ds smooth(Point2Ds point2Ds, int n) {
        if (point2Ds == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2Ds.getCount() < 4) {
            String string = InternalResource.loadString("points", "Geometrist_SmoothPointsCountShouldNotSmallThanFour", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 2) {
            String string = InternalResource.loadString("smoothness", "Global_ArgumentShouldNotSmallerThanTwo", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoLine geoLine = new GeoLine(point2Ds);
        InternalHandleDisposable.setIsDisposable(geoLine, false);
        long l = geoLine.getHandle();
        long l2 = GeometristNative.jni_Smooth(l, n);
        Point2Ds point2Ds2 = null;
        if (l2 != 0L) {
            GeoLine geoLine2 = new GeoLine(l2);
            int n2 = geoLine2.getPart(0).getCount();
            Point2D[] point2DArray = new Point2D[n2];
            for (int i = 0; i < n2; ++i) {
                Point2D point2D;
                point2DArray[i] = point2D = geoLine2.getPart(0).getItem(i);
            }
            point2Ds2 = new Point2Ds(point2DArray);
            InternalHandleDisposable.setIsDisposable(geoLine2, true);
            geoLine2.dispose();
        }
        return point2Ds2;
    }

    public static GeoLine[] splitLine(GeoLine geoLine, Geometry geometry, double d2) {
        if (geoLine == null || geoLine.getHandle() == 0L) {
            String string = InternalResource.loadString("sourceLine", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("splitGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geoLine, GeometryType.GEOLINE)) {
            String string = InternalResource.loadString("sourceLine", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("splitGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType().equals(GeometryType.GEOPOINT) && d2 <= 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = GeometristNative.jni_SplitLine(geoLine.getHandle(), geometry.getHandle(), d2);
        if (lArray == null) {
            return null;
        }
        int n = lArray.length;
        GeoLine[] geoLineArray = new GeoLine[n];
        for (int i = 0; i < n; ++i) {
            geoLineArray[i] = (GeoLine)Geometry.createInstance(lArray[i]);
        }
        return geoLineArray;
    }

    private static boolean hasAssignedGeometryTypes(Geometry geometry, GeometryType ... geometryTypeArray) {
        boolean bl = false;
        for (GeometryType geometryType : geometryTypeArray) {
            bl = bl || geometry.getType() == geometryType;
        }
        return bl;
    }

    private static boolean nearestPointToVertex(Point2D point2D, GeoLine geoLine, double[] dArray) {
        if (geoLine == null || geoLine.getHandle() == 0L) {
            String string = InternalResource.loadString("geoLine", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geoLine, GeometryType.GEOLINE)) {
            String string = InternalResource.loadString("sourceLine", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        bl = GeometristNative.jni_NearestPointToVertex(point2D.getX(), point2D.getY(), geoLine.getHandle(), dArray);
        return bl;
    }

    private static double GetSpheroidDistance(Point2D point2D, Point2D point2D2) {
        double d2 = 0.0;
        d2 = GeometristNative.jni_GetSpheroidDistance(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
        return d2;
    }

    public static boolean isSelfIntersect(Geometry geometry) {
        if (geometry != null && geometry.getHandle() != 0L) {
            return GeometristNative.jni_IsSelfIntersect(geometry.getHandle());
        }
        return false;
    }

    static {
        Environment.LoadWrapJ();
    }
}

