/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.GeoArc;
import com.supermap.data.GeoBSpline;
import com.supermap.data.GeoCardinal;
import com.supermap.data.GeoChord;
import com.supermap.data.GeoCircle;
import com.supermap.data.GeoCompound;
import com.supermap.data.GeoCurve;
import com.supermap.data.GeoEllipse;
import com.supermap.data.GeoEllipticArc;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoLineM;
import com.supermap.data.GeoModel;
import com.supermap.data.GeoPie;
import com.supermap.data.GeoPlacemark;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoPoint3D;
import com.supermap.data.GeoRectangle;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoRegion3D;
import com.supermap.data.GeoStyle;
import com.supermap.data.GeoText;
import com.supermap.data.GeometryNative;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Workspace;
import com.supermap.imb.jsonlib.SiJsonObject;
import com.supermap.plot.GeoGraphicObject;
import java.util.ArrayList;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class Geometry
extends InternalHandleDisposable {
    private GeoStyle a;
    private boolean a = false;

    protected Geometry() {
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        GeometryNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public Point2D getInnerPoint() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInnerPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeometryNative.jni_GetInnerPoint(this.getHandle(), dArray);
        Point2D point2D = new Point2D(dArray[0], dArray[1]);
        return point2D;
    }

    public Point2D getHandles(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInnerPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeometryNative.jni_GetHandles(this.getHandle(), n, dArray);
        Point2D point2D = new Point2D(dArray[0], dArray[1]);
        return point2D;
    }

    public int getHandleCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInnerPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeometryNative.jni_GetHandleCount(this.getHandle());
        return n;
    }

    public int getID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getID()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeometryNative.jni_GetID(this.getHandle());
    }

    public boolean isEmpty() {
        return false;
    }

    public GeoStyle getStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == null && (l = GeometryNative.jni_GetStyle(this.getHandle())) != 0L) {
            this.a = GeoStyle.createInstance(l);
        }
        return this.a;
    }

    public void setStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStyle(GeoStyle value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeometryType geometryType = this.getType();
        if (geometryType == GeometryType.GEOTEXT) {
            String string = InternalResource.loadString("value", "GeoText_UnsupprotStyle", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geoStyle == null) {
            if (this.a != null) {
                this.a.clearHandle();
                this.a = null;
            }
            GeometryNative.jni_SetStyle(this.getHandle(), 0L);
        } else {
            if (geoStyle.getHandle() == 0L) {
                String string = InternalResource.loadString("value", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            GeoStyle geoStyle2 = geoStyle.clone();
            GeometryNative.jni_SetStyle(this.getHandle(), geoStyle2.getHandle());
            geoStyle2.dispose();
        }
        this.a = true;
    }

    public GeometryType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeometryNative.jni_GetType(this.getHandle());
        try {
            return (GeometryType)Enum.parseUGCValue(GeometryType.class, n);
        }
        catch (Exception exception) {
            return new GeometryType(n, n);
        }
    }

    public abstract Geometry clone();

    public boolean hitTest(Point2D point2D, double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hitTest(Point2D point, double tolerance)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 < 0.0) {
            String string = InternalResource.loadString("tolerance", "Geometry_InvalidTolerance", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometryNative.jni_HitTest(this.getHandle(), point2D.getX(), point2D.getY(), d2);
    }

    public void offset(double d2, double d3) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("offset(double dx, double dy)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeometryNative.jni_Offset(this.getHandle(), d2, d3);
    }

    public void resize(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("resize(Rectangle2D bounds)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() == GeometryType.GEOREGION) {
            if (rectangle2D.getWidth() == 0.0) {
                String string = InternalResource.loadString("bounds", "Geometry_ResizeBoundsWidthIsZero", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (rectangle2D.getHeight() == 0.0) {
                String string = InternalResource.loadString("bounds", "Geometry_ResizeBoundsHeightIsZero", "data_resources");
                throw new IllegalArgumentException(string);
            }
        }
        GeometryNative.jni_Resize(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getTop(), rectangle2D.getRight(), rectangle2D.getBottom());
        if (this.getType() == GeometryType.GEOTEXT) {
            GeoText geoText = (GeoText)this;
            double d2 = geoText.getTextStyle().getFontWidth();
            double d3 = geoText.getTextStyle().getFontHeight();
            if (d2 < 0.0) {
                geoText.getTextStyle().setFontWidth(Math.abs(d2));
            }
            if (d3 < 0.0) {
                geoText.getTextStyle().setFontHeight(Math.abs(d3));
            }
        } else if (this.getType() == GeometryType.GEOREGION) {
            GeoRegion geoRegion = (GeoRegion)this;
            geoRegion.refrashPartsList();
        }
    }

    public void rotate(Point2D point2D, double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("rotate(Point2D basePoint, double angle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeometryNative.jni_Rotate(this.getHandle(), point2D.getX(), point2D.getY(), d2);
    }

    private void setEmpty() {
    }

    protected static final Geometry internalCreateInstance2(long l, Workspace workspace) {
        return Geometry.createInstance2(l, workspace);
    }

    static final Geometry createInstance(long l) {
        if (l == 0L) {
            return null;
        }
        InternalHandleDisposable internalHandleDisposable = null;
        int n = GeometryNative.jni_GetType(l);
        int[] nArray = Enum.getValues(GeometryType.class);
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            bl = false;
            break;
        }
        if (!bl) {
            GeometryType geometryType = (GeometryType)Enum.parseUGCValue(GeometryType.class, n);
            if (geometryType.equals(GeometryType.GEOPOINT)) {
                internalHandleDisposable = new GeoPoint(l);
            } else if (geometryType.equals(GeometryType.GEOLINE)) {
                internalHandleDisposable = new GeoLine(l);
            } else if (geometryType.equals(GeometryType.GEOREGION)) {
                internalHandleDisposable = new GeoRegion(l);
            } else if (geometryType.equals(GeometryType.GEOTEXT)) {
                internalHandleDisposable = new GeoText(l);
            } else if (geometryType.equals(GeometryType.GEOLINEM)) {
                internalHandleDisposable = new GeoLineM(l);
            } else if (geometryType.equals(GeometryType.GEOPOINT3D)) {
                internalHandleDisposable = new GeoPoint3D(l);
            } else if (geometryType.equals(GeometryType.GEOLINE3D)) {
                internalHandleDisposable = new GeoLine3D(l);
            } else if (geometryType.equals(GeometryType.GEOREGION3D)) {
                internalHandleDisposable = new GeoRegion3D(l);
            } else if (geometryType.equals(GeometryType.GEOPLACEMARK)) {
                internalHandleDisposable = new GeoPlacemark(l);
            } else if (geometryType.equals(GeometryType.GEOMODEL)) {
                internalHandleDisposable = new GeoModel(l);
            }
        }
        if (internalHandleDisposable != null) {
            internalHandleDisposable.setIsDisposable(true);
        }
        return internalHandleDisposable;
    }

    @Override
    public abstract void dispose();

    @Override
    protected void clearHandle() {
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        this.setHandle(0L);
    }

    protected static void clearHandle(Geometry geometry) {
        geometry.clearHandle();
    }

    static final Geometry createInstance(GeometryType geometryType) {
        Geometry geometry = null;
        if (geometryType.equals(GeometryType.GEOPOINT)) {
            geometry = new GeoPoint();
        } else if (geometryType.equals(GeometryType.GEOLINE)) {
            geometry = new GeoLine();
        } else if (geometryType.equals(GeometryType.GEOREGION)) {
            geometry = new GeoRegion();
        } else if (geometryType.equals(GeometryType.GEOTEXT)) {
            geometry = new GeoText();
        } else {
            throw new RuntimeException("$$$\u76f8\u5173\u7c7b\u578b\u8fd8\u672a\u5b9e\u73b0");
        }
        geometry.setIsDisposable(true);
        return geometry;
    }

    static final Geometry createInstance2(long l, Workspace workspace) {
        if (l == 0L) {
            return null;
        }
        InternalHandleDisposable internalHandleDisposable = null;
        int n = GeometryNative.jni_GetType(l);
        int[] nArray = Enum.getValues(GeometryType.class);
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            bl = false;
            break;
        }
        if (!bl) {
            switch (n) {
                case 1: {
                    internalHandleDisposable = new GeoPoint(l);
                    break;
                }
                case 3: {
                    internalHandleDisposable = new GeoLine(l);
                    break;
                }
                case 5: {
                    internalHandleDisposable = new GeoRegion(l);
                    break;
                }
                case 7: {
                    internalHandleDisposable = new GeoText(l);
                    break;
                }
                case 12: {
                    internalHandleDisposable = new GeoRectangle(l);
                    break;
                }
                case 15: {
                    internalHandleDisposable = new GeoCircle(l);
                    break;
                }
                case 20: {
                    internalHandleDisposable = new GeoEllipse(l);
                    break;
                }
                case 21: {
                    internalHandleDisposable = new GeoPie(l);
                    break;
                }
                case 24: {
                    internalHandleDisposable = new GeoArc(l);
                    break;
                }
                case 25: {
                    internalHandleDisposable = new GeoEllipticArc(l);
                    break;
                }
                case 27: {
                    internalHandleDisposable = new GeoCardinal(l);
                    break;
                }
                case 28: {
                    internalHandleDisposable = new GeoCurve(l);
                    break;
                }
                case 29: {
                    internalHandleDisposable = new GeoBSpline(l);
                    break;
                }
                case 101: {
                    internalHandleDisposable = new GeoPoint3D(l);
                    break;
                }
                case 103: {
                    internalHandleDisposable = new GeoLine3D(l);
                    break;
                }
                case 105: {
                    internalHandleDisposable = new GeoRegion3D(l);
                    break;
                }
                case 23: {
                    internalHandleDisposable = new GeoChord(l);
                    break;
                }
                case 35: {
                    internalHandleDisposable = new GeoLineM(l);
                    break;
                }
                case 108: {
                    internalHandleDisposable = new GeoPlacemark(l);
                    break;
                }
                case 1000: {
                    internalHandleDisposable = new GeoCompound(l);
                    break;
                }
                case 3000: {
                    internalHandleDisposable = new GeoGraphicObject(l);
                    break;
                }
            }
        }
        if (internalHandleDisposable != null) {
            internalHandleDisposable.setIsDisposable(true);
        }
        return internalHandleDisposable;
    }

    public boolean fromXML(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        if (string != null && string.trim().length() != 0) {
            bl = GeometryNative.jni_FromXML(this.getHandle(), string);
        }
        return bl;
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toXML()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeometryNative.jni_ToXML(this.getHandle());
    }

    public static final Geometry internalCreateInstance(long l) {
        return Geometry.createInstance(l);
    }

    public String toJson() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        stringBuilder.append(" \"id\" : " + this.getID() + ",");
        stringBuilder.append(" \"center\" :{ \"x\" :" + this.getInnerPoint().getX() + ", \"y\" : " + this.getInnerPoint().getY() + "}" + ",");
        GeoStyle geoStyle = this.getStyle();
        String string = "null";
        if (geoStyle != null) {
            string = geoStyle.toJson();
        }
        stringBuilder.append(" \"style\" :" + string);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean fromJson(String string) {
        SiJsonObject siJsonObject = new SiJsonObject(string);
        boolean bl = this.fromJson(siJsonObject);
        siJsonObject.dispose();
        return bl;
    }

    public boolean fromJson(SiJsonObject siJsonObject) {
        return true;
    }

    public String toGeoJSON() {
        return null;
    }

    public boolean fromGeoJSON(String string) {
        return false;
    }

    protected ArrayList<Point2Ds> getPointsFromGeoJSON(String string) {
        String string2 = string.substring(string.indexOf("["), string.lastIndexOf("]") + 1).replace(" ", "");
        char c2 = '\u0000';
        ArrayList<Point2Ds> arrayList = new ArrayList<Point2Ds>();
        Point2Ds point2Ds = new Point2Ds();
        Point2D point2D = new Point2D(0.0, 0.0);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = null;
        int n = string2.length();
        block6: for (int i = 0; i < n; ++i) {
            c2 = string2.charAt(i);
            switch (c2) {
                case ' ': {
                    continue block6;
                }
                case ',': {
                    if (stringBuilder.length() > 0) {
                        point2D.setX(Double.parseDouble(stringBuilder.toString()));
                        stringBuilder.delete(0, stringBuilder.length());
                    }
                    if (this.checkLineEnd(string3 = string3 + ",")) {
                        arrayList.add(point2Ds);
                        point2Ds = new Point2Ds();
                    }
                    string3 = "";
                    continue block6;
                }
                case '[': {
                    continue block6;
                }
                case ']': {
                    if (stringBuilder.length() > 0) {
                        point2D.setY(Double.parseDouble(stringBuilder.toString()));
                        stringBuilder.delete(0, stringBuilder.length());
                        point2Ds.add(point2D);
                        point2D.setX(0.0);
                        point2D.setY(0.0);
                    }
                    string3 = string3 + "]";
                    continue block6;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        arrayList.add(point2Ds);
        return arrayList;
    }

    private boolean checkLineEnd(String string) {
        if (string != null) {
            return string.equals("]],");
        }
        return false;
    }
}

