/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.JoinItem;
import com.supermap.data.JoinItemsNative;
import java.util.ArrayList;

public class JoinItems
extends InternalHandleDisposable {
    private ArrayList a = null;

    public JoinItems() {
        this.a = new ArrayList();
        this.setHandle(JoinItemsNative.jni_New(), true);
    }

    public JoinItems(JoinItem[] joinItemArray) {
        if (joinItemArray == null) {
            String string = InternalResource.loadString("joinItems", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        this.a = new ArrayList();
        this.setHandle(JoinItemsNative.jni_New(), true);
        for (int i = 0; i < joinItemArray.length; ++i) {
            this.add(joinItemArray[i]);
        }
    }

    public JoinItems(JoinItems joinItems) {
        if (joinItems == null) {
            String string = InternalResource.loadString("joinItems", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (joinItems.getHandle() == 0L) {
            String string = InternalResource.loadString("joinItems", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = JoinItemsNative.jni_Clone(joinItems.getHandle());
        this.a = new ArrayList();
        this.setHandle(l, true);
        int n = joinItems.getCount();
        for (int i = 0; i < n; ++i) {
            this.add(joinItems.get(i));
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a.size();
    }

    public JoinItem get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return (JoinItem)this.a.get(n);
    }

    public void set(int n, JoinItem joinItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (joinItem.getHandle() == 0L) {
            String string = InternalResource.loadString("value", "JoinItems_SetJoinItemDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        JoinItemsNative.jni_Set(this.get(n).getHandle(), joinItem.getHandle());
    }

    public JoinItems clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new JoinItems(this);
    }

    public int add(JoinItem joinItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (joinItem.getHandle() == 0L) {
            String string = InternalResource.loadString("joinItem", "JoinItems_SetJoinItemDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = JoinItemsNative.jni_Add(this.getHandle(), joinItem.getHandle());
        if (l != 0L) {
            JoinItem joinItem2 = new JoinItem(l);
            this.a.add(joinItem2);
            return this.getCount() - 1;
        }
        return -1;
    }

    public int addRange(JoinItem[] joinItemArray) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = 0;
        int n3 = joinItemArray.length;
        for (n = 0; n < n3; ++n) {
            JoinItem joinItem = joinItemArray[n];
            if (joinItem == null) {
                String string = InternalResource.loadString("joinItems[" + n + "]", "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (joinItem.getHandle() != 0L) continue;
            String string = InternalResource.loadString("joinItems[" + n + "]", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        for (n = 0; n < n3; ++n) {
            this.add(joinItemArray[n]);
            ++n2;
        }
        return n2;
    }

    public boolean insert(int n, JoinItem joinItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (joinItem.getHandle() == 0L) {
            String string = InternalResource.loadString("insert(int index, JoinItem joinItem)", "JoinItems_SetJoinItemDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n == this.getCount()) {
            return this.add(joinItem) != -1;
        }
        long l = JoinItemsNative.jni_Insert(this.getHandle(), n, joinItem.getHandle());
        if (l == 0L) {
            return false;
        }
        JoinItem joinItem2 = new JoinItem(l);
        this.a.add(n, joinItem2);
        return true;
    }

    public int insertRange(int n, JoinItem[] joinItemArray) {
        int n2;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = joinItemArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            JoinItem joinItem = joinItemArray[n2];
            if (joinItem == null) {
                String string = InternalResource.loadString("joinItems[" + n2 + "]", "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (joinItem.getHandle() != 0L) continue;
            String string = InternalResource.loadString("joinItems[" + n2 + "]", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        n2 = 0;
        boolean bl = false;
        for (int i = 0; i < n3; ++i) {
            bl = this.insert(n + n2, joinItemArray[i]);
            if (!bl) continue;
            ++n2;
        }
        return n2;
    }

    public boolean remove(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        JoinItemsNative.jni_Remove(this.getHandle(), n);
        JoinItem joinItem = this.get(n);
        joinItem.clearHandle();
        this.a.remove(n);
        return true;
    }

    public int removeRange(int n, int n2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (n2 < 0 || n2 > this.getCount() - n) {
            String string = InternalResource.loadString("count", "JoinItems_RemoveRangeCountInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n3 = 0;
        boolean bl = false;
        for (int i = n + n2 - 1; i >= n; --i) {
            try {
                bl = this.remove(i);
                if (!bl) continue;
                ++n3;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n3;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        for (int i = n - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public JoinItem[] toArray() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this.a.size();
        JoinItem[] joinItemArray = new JoinItem[n];
        for (int i = 0; i < n; ++i) {
            joinItemArray[i] = new JoinItem(this.get(i));
        }
        return joinItemArray;
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            JoinItemsNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        if (this.a != null) {
            int n = this.a.size();
            for (int i = 0; i < n; ++i) {
                JoinItem joinItem = this.get(i);
                joinItem.clearHandle();
            }
            this.a.clear();
            this.a = null;
        }
        this.setHandle(0L);
    }
}

