/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.GeoLine3D;
import com.supermap.data.Geometry;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.NodeAnimationNative;
import com.supermap.data.NodeAnimationPlayMode;
import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;
import com.supermap.data.TimePositionChangedEvent;
import com.supermap.data.TimePositionChangedListener;
import java.util.Vector;

public class NodeAnimation
extends InternalHandle {
    transient Vector<TimePositionChangedListener> a;

    NodeAnimation(long l) {
        this.setHandle(l);
        NodeAnimationNative.jni_NewSelfEventHandle(this.getHandle(), this);
    }

    static void timePositionChangedCallBack(NodeAnimation nodeAnimation) {
        if (nodeAnimation.getHandle() == 0L) {
            String string = InternalResource.loadString("NodeAnimation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double d2 = nodeAnimation.getTimePosition();
        TimePositionChangedEvent timePositionChangedEvent = new TimePositionChangedEvent(nodeAnimation, d2);
        nodeAnimation.a(timePositionChangedEvent);
    }

    private void a(TimePositionChangedEvent timePositionChangedEvent) {
        if (this.a != null) {
            Vector<TimePositionChangedListener> vector = this.a;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).timePositionChanged(timePositionChangedEvent);
            }
        }
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return NodeAnimationNative.jni_GetLength(this.getHandle());
    }

    public void setLength(double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        NodeAnimationNative.jni_SetLength(this.getHandle(), d2);
    }

    public boolean isEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isEnabled()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return NodeAnimationNative.jni_GetEnabled(this.getHandle());
    }

    public void setEnabled(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEnabled()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        NodeAnimationNative.jni_SetEnabled(this.getHandle(), bl);
    }

    public NodeAnimationPlayMode getPlayMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPlayMode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = NodeAnimationNative.jni_GetPlayMode(this.getHandle());
        return (NodeAnimationPlayMode)Enum.parseUGCValue(NodeAnimationPlayMode.class, n);
    }

    public void setPlayMode(NodeAnimationPlayMode nodeAnimationPlayMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPlayMode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = nodeAnimationPlayMode.getUGCValue();
        NodeAnimationNative.jni_SetPlayMode(this.getHandle(), n);
    }

    public double getTimePosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTimePostition()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return NodeAnimationNative.jni_GetTimePosition(this.getHandle());
    }

    public void setTimePosition(double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTimePostition()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        NodeAnimationNative.jni_SetTimePosition(this.getHandle(), d2);
    }

    public Point3D getPostition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPostition()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        NodeAnimationNative.jni_GetPosition(this.getHandle(), dArray);
        Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
        return point3D;
    }

    public double getDirection() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDirection()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return NodeAnimationNative.jni_GetDirection(this.getHandle());
    }

    public double getPitch() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPitch()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return NodeAnimationNative.jni_GetPitch(this.getHandle());
    }

    public boolean setTrack(Geometry3D geometry3D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTrack()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry3D == null) {
            return false;
        }
        long l = InternalHandle.getHandle(geometry3D);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry geometry = geometry3D.clone();
        InternalHandleDisposable.setIsDisposable(geometry, false);
        long l2 = InternalHandle.getHandle(geometry);
        if (l2 == 0L) {
            return false;
        }
        boolean bl = NodeAnimationNative.jni_SetTrack(this.getHandle(), l2);
        return bl;
    }

    public Geometry3D getTrack() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTrack()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = NodeAnimationNative.jni_GetTrack(this.getHandle());
        Point3Ds point3Ds = new Point3Ds();
        Point3D point3D = new Point3D();
        for (int i = 0; i < dArray.length / 3; ++i) {
            point3D.setX(dArray[i * 3]);
            point3D.setY(dArray[i * 3 + 1]);
            point3D.setZ(dArray[i * 3 + 2]);
            point3Ds.add(point3D);
        }
        GeoLine3D geoLine3D = new GeoLine3D(point3Ds);
        return geoLine3D;
    }

    public synchronized void addTimePositionChangedListener(TimePositionChangedListener timePositionChangedListener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addRatioChangedListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == null) {
            this.a = new Vector();
        }
        if (!this.a.contains(timePositionChangedListener)) {
            this.a.add(timePositionChangedListener);
        }
    }

    public synchronized void removeTimePositionChangedListener(TimePositionChangedListener timePositionChangedListener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeRatioChangedListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a != null && this.a.contains(timePositionChangedListener)) {
            this.a.remove(timePositionChangedListener);
        }
    }
}

