/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import android.util.Log;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.EngineType;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldType;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.QueryParameter;
import com.supermap.data.RecordsetNative;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SpatialQueryMode;
import com.supermap.data.StatisticMode;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.Toolkit;
import com.supermap.data.e;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Recordset
extends InternalHandleDisposable {
    private DatasetVector a;
    private Object a;
    private SpatialQueryMode a;
    private BatchEditor a;
    private boolean a;
    private int a;
    private boolean b;
    private FieldInfos a;
    private boolean[] a;
    transient Vector a = new boolean[]{false};
    protected long m_selfEventHandle;

    protected Recordset() {
    }

    Recordset(long l, DatasetVector datasetVector) {
        this.setHandle(l, true);
        this.a = datasetVector;
        this.b = RecordsetNative.jni_IsCursorTypeStatic(this.getHandle());
        this.a = new FieldInfos(RecordsetNative.jni_GetFieldInfos(this.getHandle()));
        this.a = this.a.getCount();
    }

    public Rectangle2D getBounds() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        RecordsetNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public DatasetVector getDataset() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a;
    }

    public QueryParameter getQueryParameter() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = RecordsetNative.jni_GetQueryParameter(this.getHandle());
        QueryParameter queryParameter = new QueryParameter(l, this.a, this.a);
        queryParameter.setIsDisposable(true);
        return queryParameter;
    }

    public FieldInfos getFieldInfos() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new FieldInfos(this.a);
    }

    public int getFieldCount() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.a = RecordsetNative.jni_GetFieldCount(this.getHandle());
        return this.a;
    }

    public boolean isClosed() {
        boolean bl = false;
        bl = this.a != null ? this.getHandle() == 0L || this.a.getHandle() == 0L || !this.a.isOpen() : true;
        if (bl) {
            this.setHandle(0L);
        }
        return bl;
    }

    public boolean isBOF() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_GetIsBOF(this.getHandle());
    }

    public boolean isEOF() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_GetIsEOF(this.getHandle());
    }

    public boolean isEmpty() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_GetIsEmpty(this.getHandle());
    }

    public boolean isReadOnly() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.b || this.a.isReadOnly();
    }

    public int getRecordCount() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_GetRecordCount(this.getHandle());
    }

    public boolean addNew(Geometry geometry) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            this.enableEditBulk(true);
        }
        Geometry geometry2 = geometry;
        boolean bl = false;
        if (!this.a) {
            if (geometry2 == null) {
                if (this.a.getType() == DatasetType.TABULAR) {
                    bl = RecordsetNative.jni_AddNew(this.getHandle(), 0L);
                }
            } else {
                long l = geometry2.getHandle();
                if (l == 0L) {
                    String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                if (geometry2.isEmpty()) {
                    String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                if (this.a.getType() != DatasetType.TABULAR) {
                    bl = RecordsetNative.jni_AddNew(this.getHandle(), l);
                }
            }
        } else if (geometry2 == null) {
            if (this.a.getType() == DatasetType.TABULAR) {
                bl = RecordsetNative.jni_AddNew1(this.getHandle(), 0L);
            }
        } else {
            long l = geometry2.getHandle();
            if (l == 0L) {
                String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometry2.isEmpty()) {
                String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (this.a.getType() != DatasetType.TABULAR) {
                bl = RecordsetNative.jni_AddNew1(this.getHandle(), l);
            }
        }
        this.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public boolean addNew(Geometry geometry, Map<String, Object> map) {
        long l;
        int n;
        if (map == null) {
            return this.addNew(geometry);
        }
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        Geometry geometry2 = geometry;
        Object[] objectArray = map.keySet().toArray();
        int n2 = objectArray.length;
        String[] stringArray = new String[n2];
        long[] lArray = new long[n2];
        e[] eArray = new e[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = (String)objectArray[n];
            if (stringArray[n].equalsIgnoreCase("smid")) {
                String string = InternalResource.loadString("map", "MAPCannotContainSMID", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (map.get(stringArray[n]) != null) {
                if (!e.a(map.get(stringArray[n]))) {
                    String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                eArray[n] = new e(map.get(stringArray[n]));
            } else {
                eArray[n] = new e();
            }
            eArray[n].setIsDisposable(false);
            lArray[n] = eArray[n].getHandle();
        }
        n = 0;
        if (!this.a) {
            if (geometry2 == null) {
                if (this.a.getType() == DatasetType.TABULAR) {
                    n = RecordsetNative.jni_AddNew2(this.getHandle(), 0L, stringArray, lArray) ? 1 : 0;
                }
            } else {
                l = geometry2.getHandle();
                if (l == 0L) {
                    String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                if (geometry2.isEmpty()) {
                    String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                if (this.a.getType() != DatasetType.TABULAR) {
                    n = RecordsetNative.jni_AddNew2(this.getHandle(), l, stringArray, lArray) ? 1 : 0;
                }
            }
        } else if (geometry2 == null) {
            if (this.a.getType() == DatasetType.TABULAR) {
                n = RecordsetNative.jni_AddNew3(this.getHandle(), 0L, stringArray, lArray) ? 1 : 0;
            }
        } else {
            l = geometry2.getHandle();
            if (l == 0L) {
                String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometry2.isEmpty()) {
                String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (this.a.getType() != DatasetType.TABULAR) {
                n = RecordsetNative.jni_AddNew3(this.getHandle(), l, stringArray, lArray) ? 1 : 0;
            }
        }
        for (int i = 0; i < eArray.length; ++i) {
            eArray[i].setIsDisposable(true);
            eArray[i].dispose();
            eArray[i] = null;
        }
        this.makeSureNativeObjectLive(geometry2);
        return n != 0;
    }

    public boolean edit() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_Edit(this.getHandle());
    }

    public boolean update() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a) {
            String string = InternalResource.loadString("", "Recordset_BatchEditorIsBeginning", "data_resources");
            throw new IllegalStateException(string);
        }
        this.enableEditBulk(false);
        boolean bl = RecordsetNative.jni_Update(this.getHandle());
        return bl;
    }

    public boolean cancelUpdate() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_CancelUpdate(this.getHandle());
    }

    public void close() {
        if (!this.isClosed()) {
            RecordsetNative.jni_Close(this.getHandle());
            this.clearHandle();
            if (this.a != null) {
                this.a.setIsDisposable(true);
                this.a.dispose();
                this.a = null;
            }
        }
    }

    public boolean delete() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_Delete(this.getHandle());
    }

    public boolean deleteAll() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_DeleteAll(this.getHandle());
    }

    private void checkExceptionForGetFieldValueByIndex(int n) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.a) {
            String string = InternalResource.loadString("" + n, "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
    }

    public Object getFieldValue(int n) {
        this.checkExceptionForGetFieldValueByIndex(n);
        FieldType fieldType = this.a.get(n).getType();
        if (fieldType.equals(FieldType.INT32)) {
            Integer n2 = this.getInt32(n);
            if (this.a[0]) {
                return null;
            }
            return n2;
        }
        if (fieldType.equals(FieldType.INT64)) {
            Long l = this.getInt64(n);
            if (this.a[0]) {
                return null;
            }
            return l;
        }
        if (fieldType.equals(FieldType.INT16)) {
            Short s = this.getInt16(n);
            if (this.a[0]) {
                return null;
            }
            return s;
        }
        if (fieldType.equals(FieldType.BOOLEAN)) {
            Boolean bl = this.getBoolean(n);
            if (this.a[0]) {
                return null;
            }
            return bl;
        }
        if (fieldType.equals(FieldType.BYTE)) {
            Byte by = this.getByte(n);
            if (this.a[0]) {
                return null;
            }
            return by;
        }
        if (fieldType.equals(FieldType.CHAR)) {
            String string = this.getString(n);
            if (this.a[0]) {
                return null;
            }
            return string;
        }
        if (fieldType.equals(FieldType.DATETIME)) {
            Date date = this.getDateTime(n);
            if (this.a[0]) {
                return null;
            }
            return date;
        }
        if (fieldType.equals(FieldType.DOUBLE)) {
            Double d2 = this.getDouble(n);
            if (this.a[0]) {
                return null;
            }
            return d2;
        }
        if (fieldType.equals(FieldType.LONGBINARY)) {
            byte[] byArray = this.getLongBinary(n);
            if (this.a[0]) {
                return null;
            }
            return byArray;
        }
        if (fieldType.equals(FieldType.SINGLE)) {
            Float f2 = Float.valueOf(this.getSingle(n));
            if (this.a[0]) {
                return null;
            }
            return f2;
        }
        if (fieldType.equals(FieldType.TEXT)) {
            String string = this.getString(n);
            if (this.a[0]) {
                return null;
            }
            return string;
        }
        return null;
    }

    public int getInt32(int n) {
        this.checkExceptionForGetFieldValueByIndex(n);
        int n2 = RecordsetNative.jni_GetFieldValueIntByIndex(this.getHandle(), n, this.a);
        return n2;
    }

    public int getInt32(String string) {
        return this.getInt32(this.a.indexOf(string));
    }

    public short getInt16(int n) {
        this.checkExceptionForGetFieldValueByIndex(n);
        short s = RecordsetNative.jni_GetFieldValueShortByIndex(this.getHandle(), n, this.a);
        return s;
    }

    public short getInt16(String string) {
        return this.getInt16(this.a.indexOf(string));
    }

    public long getInt64(int n) {
        this.checkExceptionForGetFieldValueByIndex(n);
        long l = RecordsetNative.jni_GetFieldValueLongByIndex(this.getHandle(), n, this.a);
        return l;
    }

    public long getInt64(String string) {
        return this.getInt64(this.a.indexOf(string));
    }

    public boolean getBoolean(int n) {
        this.checkExceptionForGetFieldValueByIndex(n);
        boolean bl = RecordsetNative.jni_GetFieldValueBooleanByIndex(this.getHandle(), n, this.a);
        return bl;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(this.a.indexOf(string));
    }

    public String getString(int n) {
        this.checkExceptionForGetFieldValueByIndex(n);
        String string = RecordsetNative.jni_GetFieldValueTextByIndex(this.getHandle(), n, this.a);
        return string;
    }

    public String getString(String string) {
        return this.getString(this.a.indexOf(string));
    }

    public Date getDateTime(int n) {
        this.checkExceptionForGetFieldValueByIndex(n);
        Date date = this.getFieldValueDateTimeByIndex(n, this.a);
        return date;
    }

    public Date getDateTime(String string) {
        int n = this.a.indexOf(string);
        return this.getDateTime(n);
    }

    Date getFieldValueDateTimeByIndex(int n, boolean[] blArray) {
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        String string = RecordsetNative.jni_GetFieldValueDateByIndex(this.getHandle(), n, blArray);
        if (string == null) {
            return null;
        }
        Date date = null;
        String string2 = System.getProperty("os.name").toLowerCase();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            try {
                SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
                date = simpleDateFormat2.parse(string);
            }
            catch (ParseException parseException2) {
                // empty catch block
            }
        }
        return date;
    }

    public double getDouble(int n) {
        this.checkExceptionForGetFieldValueByIndex(n);
        double d2 = RecordsetNative.jni_GetFieldValueDoubleByIndex(this.getHandle(), n, this.a);
        return d2;
    }

    public double getDouble(String string) {
        int n = this.a.indexOf(string);
        return this.getDouble(n);
    }

    public float getSingle(int n) {
        this.checkExceptionForGetFieldValueByIndex(n);
        float f2 = RecordsetNative.jni_GetFieldValueFloatByIndex(this.getHandle(), n, this.a);
        return f2;
    }

    public float getSingle(String string) {
        int n = this.a.indexOf(string);
        return this.getSingle(n);
    }

    public byte getByte(int n) {
        this.checkExceptionForGetFieldValueByIndex(n);
        byte by = RecordsetNative.jni_GetFieldValueByteByIndex(this.getHandle(), n, this.a);
        return by;
    }

    public byte getByte(String string) {
        int n = this.a.indexOf(string);
        return this.getByte(n);
    }

    public byte[] getLongBinary(int n) {
        this.checkExceptionForGetFieldValueByIndex(n);
        byte[] byArray = RecordsetNative.jni_GetFieldValueLongBinaryByIndex(this.getHandle(), n, this.a);
        return byArray;
    }

    public byte[] getLongBinary(String string) {
        int n = this.a.indexOf(string);
        return this.getLongBinary(n);
    }

    private void checkExceptionForGetFieldValueByName(String string) {
        if (this.isClosed()) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
    }

    public Object getFieldValue(String string) {
        this.checkExceptionForGetFieldValueByName(string);
        int n = this.a.indexOf(string);
        if (n < 0) {
            String string2 = InternalResource.loadString(string, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        return this.getFieldValue(n);
    }

    public Geometry getGeometry() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = RecordsetNative.jni_GetGeometry(this.getHandle());
        if (l == 0L) {
            return null;
        }
        Geometry geometry = Geometry.createInstance2(l, this.getDataset().getDatasource().getWorkspace());
        if (geometry != null) {
            geometry.setIsDisposable(true);
        }
        return geometry;
    }

    public int getID() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_GetID(this.getHandle());
    }

    public boolean move(int n) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_Move(this.getHandle(), n);
    }

    public boolean moveFirst() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_MoveFirst(this.getHandle());
    }

    public boolean moveLast() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_MoveLast(this.getHandle());
    }

    public boolean moveNext() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_MoveNext(this.getHandle());
    }

    public boolean movePrev() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_MovePrev(this.getHandle());
    }

    public boolean moveTo(int n) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_MoveTo(this.getHandle(), n);
    }

    public boolean refresh() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_Refresh(this.getHandle());
    }

    public boolean seekID(int n) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        bl = n < 0 ? false : RecordsetNative.jni_SeekID(this.getHandle(), n);
        return bl;
    }

    private void enableEditBulk(boolean bl) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetVector datasetVector = this.getDataset();
        Datasource datasource = datasetVector.getDatasource();
        if (datasource.getDatasets().contains(datasetVector.getName() + "_Table")) {
            RecordsetNative.jni_SetEditBulk(this.getHandle(), bl);
        }
    }

    private void checkExcepitonForSetFieldValueByIndex(int n) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.a) {
            String string = InternalResource.loadString("" + n, "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
    }

    public boolean setFieldValue(int n, Object object) {
        this.checkExcepitonForSetFieldValueByIndex(n);
        if (this.a.get(n).isSystemField()) {
            String string = InternalResource.loadString("index", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        bl = object == null ? this.setFieldValueNull(n) : this.setFieldValue(this.a.get(n).getName(), object);
        return bl;
    }

    private void checkExceptionForSetFieldValueByName(String string) {
        if (this.isClosed()) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.isReadOnly()) {
            String string3 = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
    }

    public boolean setFieldValue(String string, Object object) {
        FieldInfo fieldInfo = this.a.get(string);
        if (fieldInfo == null) {
            String string2 = InternalResource.loadString(string, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (fieldInfo.isSystemField()) {
            String string3 = InternalResource.loadString("name", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        boolean bl = false;
        FieldType fieldType = fieldInfo.getType();
        if (object == null) {
            bl = this.setFieldValueNull(string);
        } else {
            String string4 = object.toString();
            if (fieldType.equals(FieldType.BOOLEAN)) {
                bl = this.setBoolean(string, (boolean)((Boolean)object));
            } else if (fieldType.equals(FieldType.BYTE)) {
                bl = this.setByte(string, (byte)((Byte)object));
            } else if (fieldType.equals(FieldType.CHAR)) {
                bl = this.setFieldValueChar(string, (String)object);
            } else if (fieldType.equals(FieldType.DATETIME)) {
                Date date = null;
                if (object instanceof String) {
                    String string5;
                    Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
                    if (pattern.matcher(string5 = (String)object).matches()) {
                        String string6 = System.getProperty("os.name").toLowerCase();
                        if (string6.equals("aix")) {
                            try {
                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                date = simpleDateFormat.parse(string5);
                            }
                            catch (ParseException parseException) {
                                try {
                                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                                    date = simpleDateFormat.parse(string5);
                                }
                                catch (ParseException parseException2) {}
                            }
                        } else {
                            try {
                                date = DateFormat.getDateInstance().parse(string5);
                            }
                            catch (ParseException parseException) {}
                        }
                    }
                } else {
                    date = (Date)object;
                }
                bl = this.setDateTime(string, date);
            } else {
                bl = fieldType.equals(FieldType.DOUBLE) ? (string4.length() == 0 ? this.setDouble(string, 0.0) : this.setDouble(string, (double)Double.valueOf(string4))) : (fieldType.equals(FieldType.INT16) ? (string4.length() == 0 ? this.setDouble(string, 0.0) : this.setInt16(string, (short)Short.valueOf(string4))) : (fieldType.equals(FieldType.INT32) ? (string4.length() == 0 ? this.setDouble(string, 0.0) : this.setInt32(string, (int)Integer.valueOf(string4))) : (fieldType.equals(FieldType.INT64) ? (string4.length() == 0 ? this.setDouble(string, 0.0) : this.setInt64(string, (long)Long.valueOf(string4))) : (fieldType.equals(FieldType.LONGBINARY) ? (string4.length() == 0 ? this.setDouble(string, 0.0) : this.setLongBinary(string, (byte[])object)) : (fieldType.equals(FieldType.SINGLE) ? (string4.length() == 0 ? this.setDouble(string, 0.0) : this.setSingle(string, Float.valueOf(string4).floatValue())) : (fieldType.equals(FieldType.TEXT) ? (string4.length() == 0 && !fieldInfo.isZeroLengthAllowed() ? false : this.setString(string, String.valueOf(string4))) : false))))));
            }
        }
        return bl;
    }

    public boolean setByte(int n, byte by) {
        this.checkExcepitonForSetFieldValueByIndex(n);
        String string = this.a.get(n).getName();
        return this.setByte(string, by);
    }

    public boolean setByte(String string, byte by) {
        this.checkExceptionForSetFieldValueByName(string);
        return RecordsetNative.jni_setFieldValueByteByName(this.getHandle(), string, by);
    }

    public boolean setInt32(String string, int n) {
        this.checkExceptionForSetFieldValueByName(string);
        return RecordsetNative.jni_setFieldValueIntByName(this.getHandle(), string, n);
    }

    public boolean setInt32(int n, int n2) {
        this.checkExcepitonForSetFieldValueByIndex(n);
        String string = this.a.get(n).getName();
        return RecordsetNative.jni_setFieldValueIntByName(this.getHandle(), string, n2);
    }

    public boolean setInt16(String string, short s) {
        this.checkExceptionForSetFieldValueByName(string);
        return RecordsetNative.jni_setFieldValueShortByName2(this.getHandle(), string, s);
    }

    public boolean setInt16(int n, short s) {
        this.checkExcepitonForSetFieldValueByIndex(n);
        String string = this.a.get(n).getName();
        return RecordsetNative.jni_setFieldValueShortByName2(this.getHandle(), string, s);
    }

    public boolean setInt64(String string, long l) {
        this.checkExceptionForSetFieldValueByName(string);
        return RecordsetNative.jni_setFieldValueLongByName(this.getHandle(), string, l);
    }

    public boolean setInt64(int n, long l) {
        this.checkExcepitonForSetFieldValueByIndex(n);
        String string = this.a.get(n).getName();
        return RecordsetNative.jni_setFieldValueLongByName(this.getHandle(), string, l);
    }

    public boolean setDouble(String string, double d2) {
        this.checkExceptionForSetFieldValueByName(string);
        return RecordsetNative.jni_setFieldValueDoubleByName(this.getHandle(), string, d2);
    }

    public boolean setDouble(int n, double d2) {
        this.checkExcepitonForSetFieldValueByIndex(n);
        String string = this.a.get(n).getName();
        return RecordsetNative.jni_setFieldValueDoubleByName(this.getHandle(), string, d2);
    }

    public boolean setSingle(String string, float f2) {
        this.checkExceptionForSetFieldValueByName(string);
        return RecordsetNative.jni_setFieldValueFloatByname(this.getHandle(), string, f2);
    }

    public boolean setSingle(int n, float f2) {
        this.checkExcepitonForSetFieldValueByIndex(n);
        String string = this.a.get(n).getName();
        return RecordsetNative.jni_setFieldValueFloatByname(this.getHandle(), string, f2);
    }

    public boolean setBoolean(String string, boolean bl) {
        this.checkExceptionForGetFieldValueByName(string);
        return RecordsetNative.jni_setFieldValueBooleanByName(this.getHandle(), string, bl);
    }

    public boolean setBoolean(int n, boolean bl) {
        this.checkExcepitonForSetFieldValueByIndex(n);
        String string = this.a.get(n).getName();
        return RecordsetNative.jni_setFieldValueBooleanByName(this.getHandle(), string, bl);
    }

    private boolean setFieldValueChar(String string, String string2) {
        return RecordsetNative.jni_setFieldValueCharByName(this.getHandle(), string, string2);
    }

    public boolean setString(String string, String string2) {
        this.checkExceptionForSetFieldValueByName(string);
        return RecordsetNative.jni_setFieldValueTextByName(this.getHandle(), string, string2);
    }

    public boolean setString(int n, String string) {
        this.checkExcepitonForSetFieldValueByIndex(n);
        String string2 = this.a.get(n).getName();
        return RecordsetNative.jni_setFieldValueTextByName(this.getHandle(), string2, string);
    }

    public boolean setLongBinary(String string, byte[] byArray) {
        this.checkExceptionForSetFieldValueByName(string);
        return RecordsetNative.jni_setFieldValueLongBinaryByName(this.getHandle(), string, byArray);
    }

    public boolean setLongBinary(int n, byte[] byArray) {
        this.checkExcepitonForSetFieldValueByIndex(n);
        String string = this.a.get(n).getName();
        return RecordsetNative.jni_setFieldValueLongBinaryByName(this.getHandle(), string, byArray);
    }

    public boolean setDateTime(String string, Date date) {
        this.checkExceptionForSetFieldValueByName(string);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.getDefault());
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        return RecordsetNative.jni_setFieldValueDateTimeByName(this.getHandle(), string, n, n2, n3, n4, n5, n6);
    }

    public boolean setDateTime(int n, Date date) {
        this.checkExcepitonForSetFieldValueByIndex(n);
        String string = this.a.get(n).getName();
        return this.setDateTime(string, date);
    }

    public boolean setFieldValueNull(int n) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.a) {
            String string = InternalResource.loadString("" + n, "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (this.a.get(n).isSystemField()) {
            String string = InternalResource.loadString("index", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.a.get(n).isRequired()) {
            String string = InternalResource.loadString("", "Recordset_RequiredFieldShouldNotBeNull", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_SetFieldValueNullByIndex(this.getHandle(), n);
    }

    public boolean setFieldValueNull(String string) {
        if (this.isClosed()) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.isReadOnly()) {
            String string3 = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        int n = RecordsetNative.jni_GetFieldIndex(this.getHandle(), string);
        if (n < 0) {
            String string5 = InternalResource.loadString(string, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this.a.get(n).isSystemField()) {
            String string6 = InternalResource.loadString("name", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (this.a.get(n).isRequired()) {
            String string7 = InternalResource.loadString("", "Recordset_RequiredFieldShouldNotBeNull", "data_resources");
            throw new IllegalStateException(string7);
        }
        return RecordsetNative.jni_SetFieldValueNullByName(this.getHandle(), string);
    }

    public boolean setGeometry(Geometry geometry) {
        GeometryType geometryType;
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetType datasetType = this.getDataset().getType();
        if (!Recordset.checkDatasetAndGeometryType(datasetType, geometryType = geometry.getType())) {
            String string = InternalResource.loadString("geometry", "Recordset_DatasetTypeAndGeometryTypeIsDifferent", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.isEmpty()) {
            String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return RecordsetNative.jni_SetGeometry(this.getHandle(), geometry.getHandle());
    }

    public double statistic(int n, StatisticMode statisticMode) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.a) {
            String string = InternalResource.loadString("fieldIndex", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (statisticMode == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        FieldType fieldType = this.a.get(n).getType();
        if (fieldType != FieldType.BOOLEAN && fieldType != FieldType.BYTE && fieldType != FieldType.DOUBLE && fieldType != FieldType.SINGLE && fieldType != FieldType.INT16 && fieldType != FieldType.INT32) {
            String string = InternalResource.loadString("FieldType", "Recordset_StatisticUnsupprotFieldType", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return RecordsetNative.jni_StatisticByIndex(this.getHandle(), n, statisticMode.getUGCValue());
    }

    public double statistic(String string, StatisticMode statisticMode) {
        if (this.isClosed()) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (statisticMode == null) {
            String string4 = InternalResource.loadString("mode", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string4);
        }
        int n = RecordsetNative.jni_GetFieldIndex(this.getHandle(), string);
        if (n < 0) {
            String string5 = InternalResource.loadString(string, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        FieldType fieldType = this.a.get(n).getType();
        if (fieldType != FieldType.BOOLEAN && fieldType != FieldType.BYTE && fieldType != FieldType.DOUBLE && fieldType != FieldType.SINGLE && fieldType != FieldType.INT16 && fieldType != FieldType.INT32) {
            String string6 = InternalResource.loadString("FieldType", "Recordset_StatisticUnsupprotFieldType", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        return RecordsetNative.jni_StatisticByName(this.getHandle(), string, statisticMode.getUGCValue());
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            this.close();
        }
    }

    public BatchEditor getBatch() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetBatchEdit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == null) {
            this.a = new BatchEditor(this.getHandle());
        }
        return this.a;
    }

    void setQueryParameter(QueryParameter queryParameter) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (queryParameter.getHandle() == 0L) {
            String string = InternalResource.loadString("queryParameter", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (queryParameter.getSpatialQueryObject() != null) {
            this.a = queryParameter.getSpatialQueryObject();
            this.a = queryParameter.getSpatialQueryMode();
        }
        RecordsetNative.jni_SetQueryParameter(this.getHandle(), queryParameter.getHandle());
    }

    @Override
    protected void clearHandle() {
        this.setHandle(0L);
        this.a = null;
        this.a = null;
        this.a = null;
    }

    protected static Recordset createInstance(long l, DatasetVector datasetVector) {
        return new Recordset(l, datasetVector);
    }

    static boolean checkDatasetAndGeometryType(DatasetType datasetType, GeometryType geometryType) {
        boolean bl = false;
        if (datasetType != null && geometryType != null) {
            if (datasetType == DatasetType.CAD) {
                bl = true;
            }
            if (datasetType == DatasetType.POINT && geometryType == GeometryType.GEOPOINT || datasetType == DatasetType.LINE && geometryType == GeometryType.GEOLINE || datasetType == DatasetType.REGION && geometryType == GeometryType.GEOREGION || datasetType == DatasetType.TEXT && geometryType == GeometryType.GEOTEXT) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean wasNull() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a[0];
    }

    public boolean setValues(Map<String, Object> map) {
        int n;
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.a) {
            int n2 = 0;
            Set<Map.Entry<String, Object>> set = map.entrySet();
            for (Map.Entry<String, Object> entry : set) {
                String string = entry.getKey();
                int n3 = this.a.indexOf(string);
                if (n3 == -1) continue;
                Object object = entry.getValue();
                this.setFieldValue(n3, object);
                ++n2;
            }
            return n2 > 0;
        }
        Object[] objectArray = map.keySet().toArray();
        int n4 = objectArray.length;
        String[] stringArray = new String[n4];
        long[] lArray = new long[n4];
        e[] eArray = new e[n4];
        for (n = 0; n < n4; ++n) {
            stringArray[n] = (String)objectArray[n];
            if (stringArray[n].equalsIgnoreCase("smid")) {
                String string = InternalResource.loadString("map", "MAPCannotContainSMID", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (map.get(stringArray[n]) != null) {
                if (!e.a(map.get(stringArray[n]))) {
                    String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                eArray[n] = new e(map.get(stringArray[n]));
            } else {
                eArray[n] = new e();
            }
            eArray[n].setIsDisposable(false);
            lArray[n] = eArray[n].getHandle();
        }
        n = 0;
        n = RecordsetNative.jni_SetGeometry1(this.getHandle(), 0L, false, stringArray, lArray) ? 1 : 0;
        for (int i = 0; i < eArray.length; ++i) {
            eArray[i].setIsDisposable(true);
            eArray[i].dispose();
            eArray[i] = null;
        }
        return n != 0;
    }

    public boolean setValues(Map<String, Object> map, Geometry geometry) {
        int n;
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (!this.a) {
            this.setGeometry(geometry);
            int n2 = 0;
            Set<Map.Entry<String, Object>> set = map.entrySet();
            for (Map.Entry<String, Object> entry : set) {
                String string = entry.getKey();
                int n3 = this.a.indexOf(string);
                if (n3 == -1) continue;
                Object object = entry.getValue();
                this.setFieldValue(n3, object);
                ++n2;
            }
            return n2 > 0;
        }
        if (!this.a.getDatasource().getConnectionInfo().getEngineType().equals(EngineType.UDB)) {
            return false;
        }
        Geometry geometry2 = geometry;
        long l = 0L;
        if (geometry2 != null) {
            l = geometry2.getHandle();
        }
        Object[] objectArray = map.keySet().toArray();
        int n4 = objectArray.length;
        String[] stringArray = new String[n4];
        long[] lArray = new long[n4];
        e[] eArray = new e[n4];
        for (n = 0; n < n4; ++n) {
            stringArray[n] = (String)objectArray[n];
            if (stringArray[n].equalsIgnoreCase("smid")) {
                String string = InternalResource.loadString("map", "MAPCannotContainSMID", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (map.get(stringArray[n]) != null) {
                if (!e.a(map.get(stringArray[n]))) {
                    String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                eArray[n] = new e(map.get(stringArray[n]));
            } else {
                eArray[n] = new e();
            }
            eArray[n].setIsDisposable(false);
            lArray[n] = eArray[n].getHandle();
        }
        n = 0;
        n = RecordsetNative.jni_SetGeometry1(this.getHandle(), l, true, stringArray, lArray) ? 1 : 0;
        for (int i = 0; i < eArray.length; ++i) {
            eArray[i].setIsDisposable(true);
            eArray[i].dispose();
            eArray[i] = null;
        }
        this.makeSureNativeObjectLive(geometry2);
        return n != 0;
    }

    public boolean setValues(Object[] objectArray) {
        int n;
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (objectArray.length != this.a) {
            String string = InternalResource.loadString("", "Recordset_ValuesLengthShouldEqualsFieldCount", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.a) {
            for (int i = 0; i < objectArray.length; ++i) {
                boolean bl;
                if (this.a.get(i).isSystemField() || (bl = this.setFieldValue(i, objectArray[i]))) continue;
                return false;
            }
            return true;
        }
        if (!this.a.getDatasource().getConnectionInfo().getEngineType().equals(EngineType.UDB)) {
            return false;
        }
        String[] stringArray = new String[objectArray.length];
        long[] lArray = new long[objectArray.length];
        e[] eArray = new e[objectArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            if (this.a.get(n).isSystemField()) continue;
            stringArray[n] = this.a.get(n).getName();
            if (stringArray[n].equalsIgnoreCase("smid")) {
                String string = InternalResource.loadString("map", "MAPCannotContainSMID", "data_resources");
                throw new IllegalArgumentException(string);
            }
            eArray[n] = new e(objectArray[n]);
            eArray[n].setIsDisposable(false);
            lArray[n] = eArray[n].getHandle();
        }
        n = RecordsetNative.jni_SetGeometry1(this.getHandle(), 0L, false, stringArray, lArray) ? 1 : 0;
        for (int i = 0; i < eArray.length; ++i) {
            eArray[i].setIsDisposable(true);
            eArray[i].dispose();
            eArray[i] = null;
        }
        return n != 0;
    }

    public boolean setValues(Object[] objectArray, Geometry geometry) {
        int n;
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (objectArray.length != this.a) {
            String string = InternalResource.loadString("", "Recordset_ValuesLengthShouldEqualsFieldCount", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (!this.a) {
            this.setGeometry(geometry);
            for (int i = 0; i < objectArray.length; ++i) {
                boolean bl;
                if (this.a.get(i).isSystemField() || (bl = this.setFieldValue(i, objectArray[i]))) continue;
                return false;
            }
            return true;
        }
        if (!this.a.getDatasource().getConnectionInfo().getEngineType().equals(EngineType.UDB)) {
            return false;
        }
        Geometry geometry2 = geometry;
        long l = geometry2.getHandle();
        String[] stringArray = new String[objectArray.length];
        long[] lArray = new long[objectArray.length];
        e[] eArray = new e[objectArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            if (this.a.get(n).isSystemField()) continue;
            stringArray[n] = this.a.get(n).getName();
            if (stringArray[n].equalsIgnoreCase("smid")) {
                String string = InternalResource.loadString("map", "MAPCannotContainSMID", "data_resources");
                throw new IllegalArgumentException(string);
            }
            eArray[n] = new e(objectArray[n]);
            eArray[n].setIsDisposable(false);
            lArray[n] = eArray[n].getHandle();
        }
        n = RecordsetNative.jni_SetGeometry1(this.getHandle(), l, true, stringArray, lArray) ? 1 : 0;
        for (int i = 0; i < eArray.length; ++i) {
            eArray[i].setIsDisposable(true);
            eArray[i].dispose();
            eArray[i] = null;
        }
        this.makeSureNativeObjectLive(geometry2);
        return n != 0;
    }

    public Object[] getValues() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Object[] objectArray = new Object[this.a];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.getFieldValue(i);
        }
        return objectArray;
    }

    public boolean setObject(int n, Object object) {
        return this.setFieldValue(n, object);
    }

    public boolean setObject(String string, Object object) {
        return this.setFieldValue(string, object);
    }

    public Object getObject(int n) {
        return this.getFieldValue(n);
    }

    public Object getObject(String string) {
        return this.getFieldValue(string);
    }

    private void makeSureNativeObjectLive(InternalHandleDisposable internalHandleDisposable) {
        if (internalHandleDisposable != null) {
            internalHandleDisposable.getHandle();
        }
    }

    public synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (this.a == null) {
            this.a = new Vector();
        }
        if (!this.a.contains(steppedListener)) {
            this.a.add(steppedListener);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (this.a != null && this.a.contains(steppedListener)) {
            this.a.remove(steppedListener);
        }
    }

    protected void fireStepped(SteppedEvent steppedEvent) {
        if (this.a != null) {
            Vector vector = this.a;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(Recordset recordset, int n, long l, String string, String string2, long l2) {
        if (recordset != null) {
            boolean bl = Toolkit.getHandleBooleanValue(l2);
            SteppedEvent steppedEvent = new SteppedEvent(recordset, n, l, string, string2, null, bl);
            recordset.fireStepped(steppedEvent);
            Toolkit.setHandleBooleanValue(l2, steppedEvent.getCancel());
        }
    }

    protected void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            RecordsetNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    public boolean fromGeoJSON(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            Object object = jSONObject.get("type");
            if (object.equals("FeatureCollection")) {
                bl = this.fromFeatureCollectionGeoJSON(string);
            } else if (object.equals("Feature")) {
                bl = this.fromFeatureGeoJSON(string);
            } else if (object.equals("GeometryCollection")) {
                bl = this.fromGeometryCollectionGeoJSON(string);
            } else if (object.equals("Point") || object.equals("LineString") || object.equals("Polygon")) {
                bl = this.fromGeometryGeoJSON(string);
            } else {
                Log.e((String)"Recordset", (String)("Unsupported GeoJSON Object type: " + object));
                bl = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public String toGeoJSON(boolean bl, int n) {
        String string = null;
        if (bl) {
            if (n == 1) {
                string = this.toFeatureGeoJSON();
            }
            if (n > 1) {
                string = this.toFeatureCollectionGeoJSON(n, -1);
            }
        } else {
            if (n == 1) {
                string = this.toGeometryGeoJSON();
            }
            if (n > 1) {
                string = this.toGeometryCollectionGeoJSON(n, -1);
            }
        }
        return string;
    }

    String toGeoJSON(boolean bl, int n, int n2) {
        String string = null;
        if (bl) {
            if (n == 1) {
                string = this.toFeatureGeoJSON();
            }
            if (n > 1) {
                string = this.toFeatureCollectionGeoJSON(n, n2);
            }
        } else {
            if (n == 1) {
                string = this.toGeometryGeoJSON();
            }
            if (n > 1) {
                string = this.toGeometryCollectionGeoJSON(n, n2);
            }
        }
        return string;
    }

    private boolean fromGeometryGeoJSON(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            Geometry geometry = null;
            geometry = this.getGeometryFromJSON(jSONObject);
            bl = this.addNew(geometry);
            geometry.dispose();
            geometry = null;
        }
        catch (Exception exception) {
            Log.e((String)"Recordset", (String)("The geometry is " + exception.toString()));
            return false;
        }
        bl = this.update();
        return bl;
    }

    private String toGeometryGeoJSON() {
        String string = null;
        Geometry geometry = null;
        geometry = this.getGeometry();
        if (geometry != null) {
            string = geometry.toGeoJSON();
            if (string.isEmpty()) {
                Log.e((String)"Recordset", (String)("SmID=" + this.getFieldValue("SmID").toString() + ", Unsupported geometry type: " + geometry.getType()));
            }
            geometry.dispose();
            geometry = null;
        }
        return string;
    }

    private String toGeometryCollectionGeoJSON(int n, int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"type\":\"GeometryCollection\",");
        stringBuilder.append("\"geometries\":[");
        Geometry geometry = null;
        int n4 = 0;
        int n5 = n3 = n > 10 ? 10 : n;
        if (n3 < 0) {
            n3 = 0;
        }
        while (!this.isEOF() && n4 < n3) {
            geometry = this.getGeometry();
            if (geometry != null) {
                String string = geometry.toGeoJSON();
                if (!string.isEmpty()) {
                    stringBuilder.append(string);
                    stringBuilder.append(",");
                } else {
                    Log.e((String)"Recordset", (String)("SmID=" + this.getFieldValue("SmID").toString() + ", Unsupported geometry type: " + geometry.getType()));
                }
                geometry.dispose();
                geometry = null;
            }
            this.moveNext();
            ++n4;
            if (n2 <= 0 || this.getID() <= n2) continue;
        }
        if (stringBuilder.lastIndexOf(",") == stringBuilder.length() - 1) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }

    private boolean fromGeometryCollectionGeoJSON(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        this.getBatch().begin();
        try {
            JSONObject jSONObject = new JSONObject(string);
            Object object = jSONObject.get("type");
            if (!object.equals("GeometryCollection")) {
                Log.e((String)"Recordset", (String)"Not match the type of GeometryCollection");
                return false;
            }
            JSONArray jSONArray = jSONObject.getJSONArray("geometries");
            Geometry geometry = null;
            boolean bl2 = false;
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    geometry = this.getGeometryFromJSON((JSONObject)jSONArray.get(i));
                }
                catch (Exception exception) {
                    Log.e((String)"Recordset", (String)("The " + i + "th geometry, " + exception.toString()));
                    bl = false;
                }
                if (geometry != null) {
                    bl2 = this.addNew(geometry);
                    geometry.dispose();
                    geometry = null;
                }
                bl = i == 0 ? bl2 : bl && bl2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.getBatch().update();
            return false;
        }
        this.getBatch().update();
        return bl;
    }

    private String toFeatureGeoJSON() {
        StringBuilder stringBuilder = new StringBuilder();
        Geometry geometry = this.getGeometry();
        if (geometry == null) {
            return null;
        }
        String string = geometry.toGeoJSON();
        geometry.dispose();
        if (string != null) {
            stringBuilder.append("{\"type\":\"Feature\",");
            stringBuilder.append("\"geometry\":");
            stringBuilder.append(string);
            stringBuilder.append(",");
            stringBuilder.append("\"properties\":{");
            int n = this.getFieldCount();
            for (int i = 0; i < n; ++i) {
                String string2 = this.a.get(i).getName();
                if (i == 0) {
                    string2 = "SmID";
                }
                stringBuilder.append("\"" + string2 + "\":");
                if (this.a.get(i).getType() == FieldType.TEXT) {
                    stringBuilder.append("\"" + this.getFieldValue(string2) + "\"");
                } else {
                    stringBuilder.append(this.getFieldValue(string2));
                }
                stringBuilder.append(",");
            }
            if (stringBuilder.lastIndexOf(",") == stringBuilder.length() - 1) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            stringBuilder.append("}}");
            string = null;
        } else {
            Log.e((String)"Recordset", (String)("SmID=" + this.getFieldValue("SmID").toString() + ", can not get geometry."));
        }
        return stringBuilder.toString();
    }

    public String toFeatureCollectionGeoJSON(int n, int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"type\":\"FeatureCollection\",");
        stringBuilder.append("\"features\":[");
        int n4 = 0;
        int n5 = n3 = n > 10 ? 10 : n;
        if (n3 < 0) {
            n3 = 0;
        }
        String string = null;
        while (!this.isEOF() && n4 < n3) {
            string = this.toFeatureGeoJSON();
            if (string != null) {
                stringBuilder.append(string);
                stringBuilder.append(",");
            }
            string = null;
            this.moveNext();
            ++n4;
            if (n2 <= 0 || this.getID() <= n2) continue;
        }
        if (stringBuilder.lastIndexOf(",") == stringBuilder.length() - 1) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append("]}");
        if (stringBuilder.toString().isEmpty()) {
            return null;
        }
        return stringBuilder.toString();
    }

    private boolean fromFeatureGeoJSON(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        int n = -1;
        try {
            JSONObject jSONObject = new JSONObject(string);
            Object object = jSONObject.get("type");
            if (!object.equals("Feature")) {
                Log.e((String)"Recordset", (String)"Not match the type of Feature");
                return false;
            }
            JSONObject jSONObject2 = (JSONObject)jSONObject.get("geometry");
            JSONObject jSONObject3 = (JSONObject)jSONObject.get("properties");
            try {
                n = (Integer)jSONObject3.get("SmID");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                n = -1;
            }
            Geometry geometry = null;
            try {
                geometry = this.getGeometryFromJSON(jSONObject2);
            }
            catch (Exception exception) {
                Log.e((String)"Recordset", (String)("SMID=" + n + ", the geometry is " + exception.toString()));
                bl = false;
            }
            if (n > 0) {
                bl = this.seekID(n);
                if (!bl) {
                    bl = this.addNew(geometry);
                } else {
                    this.edit();
                    bl = this.setGeometry(geometry);
                }
            } else {
                bl = this.addNew(geometry);
            }
            if (bl) {
                JSONArray jSONArray = jSONObject3.names();
                String string2 = null;
                int n2 = jSONArray.length();
                for (int i = 0; i < n2; ++i) {
                    string2 = jSONArray.get(i).toString();
                    if (this.a.indexOf(string2) <= -1 || this.a.get(string2).isSystemField()) continue;
                    this.setFieldValue(string2, jSONObject3.get(string2));
                }
                bl = this.update();
                geometry.dispose();
                geometry = null;
            } else {
                Log.e((String)"Recordset", (String)("\u6dfb\u52a0\u6216\u8bbe\u7f6egeometry\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5SmID\u548cgeometry\u7684\u503c\uff0cinput GeoJSON:" + string));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return bl;
    }

    private boolean fromFeatureCollectionGeoJSON(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            Object object = jSONObject.get("type");
            if (!object.equals("FeatureCollection")) {
                Log.e((String)"Recordset", (String)"Not match the type of FeatureCollection");
                return false;
            }
            JSONArray jSONArray = jSONObject.getJSONArray("features");
            boolean bl2 = false;
            for (int i = 0; i < jSONArray.length(); ++i) {
                bl2 = this.fromFeatureGeoJSON(jSONArray.get(i).toString());
                bl = i == 0 ? bl2 : bl && bl2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return bl;
    }

    private Geometry getGeometryFromJSON(JSONObject jSONObject) throws Exception {
        Geometry geometry = null;
        if (jSONObject != null) {
            Object object = jSONObject.get("type");
            if (object.equals("Point")) {
                geometry = new GeoPoint();
            }
            if (object.equals("LineString") || object.equals("MultiLineString")) {
                geometry = new GeoLine();
            }
            if (object.equals("Polygon")) {
                geometry = new GeoRegion();
            }
            if (geometry != null) {
                ((Geometry)geometry).fromGeoJSON(jSONObject.toString());
            } else {
                throw new Exception("Unsupported GeoJSON Object type: " + object);
            }
        }
        return geometry;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class BatchEditor {
        private int a;
        long a = 0L;

        private BatchEditor(long l) {
            this.a = l;
        }

        public void begin() {
            if (this.a == 0L) {
                String string = InternalResource.loadString("Begin()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            boolean bl = RecordsetNative.jni_setMaxRecordCount(this.a, this.a);
            boolean bl2 = RecordsetNative.jni_begin(this.a, true);
            Recordset.this.a = true;
        }

        public void update() {
            if (this.a == 0L) {
                String string = InternalResource.loadString("Update()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            boolean bl = RecordsetNative.jni_Update1(this.a);
            if (bl) {
                Recordset.this.a = false;
                RecordsetNative.jni_begin(this.a, false);
            }
        }

        public void setMaxRecordCount(int n) {
            if (this.a == 0L) {
                String string = InternalResource.loadString("SetMaxRecordCount(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (n < 0) {
                String string = InternalResource.loadString("value", "Global_ArgumentShouldNotBeNegative", "data_resources");
                throw new IllegalStateException(string);
            }
            if (Recordset.this.a) {
                String string = InternalResource.loadString("SetMaxRecordCount(int value)", "SetMaxRecordCount_Must_BeforeBegin", "data_resources");
                throw new IllegalStateException(string);
            }
            this.a = n;
        }

        public int getMaxRecordCount() {
            return this.a;
        }
    }
}

