/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import android.graphics.Bitmap;
import com.supermap.data.GeoStyle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.SymbolFill;
import com.supermap.data.SymbolGroup;
import com.supermap.data.SymbolLibrary;
import com.supermap.data.SymbolLine;
import com.supermap.data.SymbolMarker;
import com.supermap.data.SymbolNative;
import com.supermap.data.SymbolType;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class Symbol
extends InternalHandleDisposable {
    private SymbolLibrary a;
    private SymbolGroup a;
    protected GeoStyle m_geoStyle;

    protected Symbol() {
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolNative.jni_getName(this.getHandle());
    }

    public int getID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getID()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolNative.jni_getID(this.getHandle());
    }

    public SymbolLibrary getLibrary() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLibrary()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a;
    }

    public abstract SymbolType getType();

    public abstract boolean draw(Bitmap var1);

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Name=");
        stringBuffer.append(this.getName());
        stringBuffer.append(",ID=");
        stringBuffer.append(this.getID());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    static final Symbol createInstance(Symbol symbol) {
        long l = SymbolNative.createInstance(symbol.getHandle());
        return Symbol.createInstance(l);
    }

    static final Symbol createInstance(long l) {
        if (l == 0L) {
            return null;
        }
        int n = SymbolNative.jni_GetType(l);
        Symbol symbol = null;
        if (n == 0) {
            symbol = new SymbolMarker(l);
        } else if (n == 1 || n == 4) {
            symbol = new SymbolLine(l);
        } else if (n == 2) {
            symbol = new SymbolFill(l);
        }
        if (symbol != null) {
            symbol.setIsDisposable(true);
        }
        return symbol;
    }

    void a(SymbolLibrary symbolLibrary) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLibrary()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.a = symbolLibrary;
    }

    protected void setGroup(SymbolGroup symbolGroup) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLibrary()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.a = symbolGroup;
    }

    protected SymbolGroup getGroup() {
        return this.a;
    }

    public void setSymbolStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSymbolStyle(GeoStyle style)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null && this.m_geoStyle != null) {
            this.m_geoStyle.clearHandle();
            this.m_geoStyle = null;
        }
        this.m_geoStyle = geoStyle;
    }

    @Override
    protected void clearHandle() {
        if (this.m_geoStyle != null) {
            this.m_geoStyle.clearHandle();
            this.m_geoStyle = null;
        }
    }

    @Override
    public void dispose() {
        this.clearHandle();
    }
}

