/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import android.graphics.Bitmap;
import com.supermap.data.Color;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoStyle;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolFillNative;
import com.supermap.data.SymbolLibrary;
import com.supermap.data.SymbolType;

public class SymbolFill
extends Symbol {
    SymbolFill(long l) {
        this.setHandle(l, false);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SymbolFillNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    public boolean draw(Bitmap bitmap) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(Graphics graphics, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (bitmap == null) {
            String string = InternalResource.loadString("draw", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = bitmap.getWidth();
        int n2 = bitmap.getHeight();
        GeoRegion geoRegion = new GeoRegion();
        Point2Ds point2Ds = new Point2Ds();
        point2Ds.add(new Point2D((double)n * 0.05, (double)n2 * 0.05));
        point2Ds.add(new Point2D((double)n * 0.05, (double)n2 * 0.95));
        point2Ds.add(new Point2D((double)n * 0.95, (double)n2 * 0.95));
        point2Ds.add(new Point2D((double)n * 0.95, (double)n2 * 0.05));
        geoRegion.addPart(point2Ds);
        GeoStyle geoStyle = new GeoStyle();
        if (this.m_geoStyle == null) {
            geoStyle.setFillBackColor(new Color(255, 255, 255));
            geoStyle.setFillForeColor(new Color(13, 80, 143));
            geoStyle.setFillSymbolID(this.getID());
            geoRegion.setStyle(geoStyle);
        } else {
            this.m_geoStyle.setFillSymbolID(this.getID());
            geoRegion.setStyle(this.m_geoStyle);
        }
        SymbolLibrary symbolLibrary = this.getLibrary();
        long l = 0L;
        if (symbolLibrary != null) {
            l = symbolLibrary.getHandle();
        }
        boolean bl = SymbolFillNative.jni_Draw(this.getHandle(), bitmap, geoRegion.getHandle(), l);
        geoStyle.dispose();
        geoRegion.dispose();
        return bl;
    }

    @Override
    public SymbolType getType() {
        return SymbolType.FILL;
    }
}

