/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolFill;
import com.supermap.data.SymbolFillLibrary;
import com.supermap.data.SymbolGroup;
import com.supermap.data.SymbolLibraryNative;
import com.supermap.data.SymbolLine;
import com.supermap.data.SymbolLineLibrary;

public abstract class SymbolLibrary
extends InternalHandleDisposable {
    private SymbolGroup a;

    protected SymbolLibrary() {
    }

    public SymbolGroup findGroup(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findGroup(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolGroup symbolGroup = null;
        if (this.getRootGroup() != null) {
            symbolGroup = this.a.a(n);
        }
        return symbolGroup;
    }

    public boolean contains(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("contains(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLibraryNative.jni_Contains(this.getHandle(), n);
    }

    public Symbol findSymbol(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findSymbol(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Symbol symbol = null;
        if (this.getRootGroup() != null) {
            symbol = this.a.a(n);
        }
        return symbol;
    }

    public Symbol findSymbol(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("findSymbol(String name)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        Symbol symbol = null;
        if (this.getRootGroup() != null) {
            symbol = this.a.a(string);
        }
        return symbol;
    }

    public boolean fromFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("fromFile(String filename, boolean overWrite)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        if (string != null && string.trim().length() != 0) {
            bl = SymbolLibraryNative.jni_fromFile(this.getHandle(), string, false);
        }
        if (bl && this.getRootGroup() != null) {
            this.a.a();
        }
        return bl;
    }

    public boolean remove(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (this.getRootGroup() != null) {
            bl = this.a.a(n);
        }
        return bl;
    }

    public int add(Symbol symbol, SymbolGroup symbolGroup) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(Symbol symbol, SymbolGroup desGroup)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (symbol == null) {
            String string = InternalResource.loadString("symbol", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(symbol);
        if (l == 0L) {
            String string = InternalResource.loadString("symbol", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (symbolGroup == null) {
            String string = InternalResource.loadString("desGroup", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(symbolGroup);
        if (l2 == 0L) {
            String string = InternalResource.loadString("desGroup", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.a.getChildGroups().contains(symbolGroup.getName())) {
            String string = InternalResource.loadString("desGroup", "SymbolGroups_NotContainTheSymbolGroup", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.add(symbol);
        if (n != -1) {
            this.moveTo(n, symbolGroup);
        }
        return n;
    }

    public int add(Symbol symbol) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Add(Symbol symbol)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (symbol == null) {
            String string = InternalResource.loadString("symbol", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(symbol);
        if (l == 0L) {
            String string = InternalResource.loadString("symbol", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this instanceof SymbolFillLibrary && !(symbol instanceof SymbolFill)) {
            String string = InternalResource.loadString("symbol", "SymbolLibrary_Unsupported_Add", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this instanceof SymbolLineLibrary && !(symbol instanceof SymbolLine)) {
            String string = InternalResource.loadString("symbol", "SymbolLibrary_Unsupported_Add", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = SymbolLibraryNative.jni_add(this.getHandle(), l);
        int n = -1;
        if (l2 != 0L) {
            Symbol symbol2 = Symbol.createInstance(l2);
            n = symbol2.getID();
            symbol2.setIsDisposable(false);
            if (this.a != null) {
                this.a.a().add(symbol2);
            }
            symbol2.a(this);
            symbol2.setGroup(this.a);
        }
        return n;
    }

    public boolean moveTo(int n, SymbolGroup symbolGroup) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveTo(int index, SymbolGroup group)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (symbolGroup == null) {
            String string = InternalResource.loadString("group", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(symbolGroup);
        if (l == 0L) {
            String string = InternalResource.loadString("group", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        Symbol symbol = this.findSymbol(n);
        SymbolGroup symbolGroup2 = symbol.getGroup();
        int n2 = symbolGroup2.indexOf(n);
        bl = symbolGroup2.moveTo(n2, symbolGroup);
        return bl;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolLibraryNative.jni_clear(this.getHandle());
        if (this.a != null) {
            this.a.a();
        }
    }

    public SymbolGroup getRootGroup() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRootGroup()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == null && (l = SymbolLibraryNative.jni_GetRootGroup(this.getHandle())) != 0L) {
            this.a = new SymbolGroup(this, l);
        }
        return this.a;
    }

    String a() {
        return SymbolLibraryNative.jni_GetLibPath(this.getHandle());
    }

    @Override
    protected void clearHandle() {
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        this.setHandle(0L);
    }
}

