/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import android.graphics.Bitmap;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalResource;
import com.supermap.data.Point;
import com.supermap.data.Size2D;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolMarkerNative;
import com.supermap.data.SymbolMarkerStroke;
import com.supermap.data.SymbolType;
import java.util.ArrayList;

public class SymbolMarker
extends Symbol {
    private ArrayList<SymbolMarkerStroke> a;

    SymbolMarker(long l) {
        this.setHandle(l, false);
        this.a(l);
    }

    @Override
    public boolean draw(Bitmap bitmap) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(Graphics graphics, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (bitmap == null) {
            String string = InternalResource.loadString("draw", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = bitmap.getWidth();
        int n2 = bitmap.getHeight();
        GeoPoint geoPoint = new GeoPoint(n / 2, n2 / 2);
        GeoStyle geoStyle = new GeoStyle();
        if (this.m_geoStyle == null) {
            geoStyle.setMarkerSymbolID(this.getID());
            geoStyle.setMarkerSize(new Size2D((double)n * 0.9, (double)n2 * 0.9));
            geoPoint.setStyle(geoStyle);
        } else {
            this.m_geoStyle.setMarkerSymbolID(this.getID());
            geoPoint.setStyle(this.m_geoStyle);
        }
        boolean bl = SymbolMarkerNative.jni_Draw(this.getHandle(), bitmap, geoPoint.getHandle());
        geoStyle.dispose();
        ((Geometry)geoPoint).dispose();
        return bl;
    }

    private void a(long l) {
        Object object;
        int n;
        if (this.a != null) {
            for (n = 0; n < this.a.size(); ++n) {
                object = this.a.get(n);
                ((InternalHandle)object).clearHandle();
            }
            this.a.clear();
        } else {
            this.a = new ArrayList();
        }
        n = SymbolMarkerNative.jni_GetStrokesCount(l);
        if (n > 0) {
            object = new long[n];
            SymbolMarkerNative.jni_GetStrokeHandle(l, (long[])object);
            for (int i = 0; i < n; ++i) {
                if (object[i] == 0L) continue;
                SymbolMarkerStroke symbolMarkerStroke = new SymbolMarkerStroke((long)object[i]);
                this.a.add(symbolMarkerStroke);
            }
        }
    }

    SymbolMarker() {
        long l = SymbolMarkerNative.jni_New();
        this.setHandle(l, true);
        this.a(null);
        this.a(l);
    }

    public int computeDisplaySize(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeDisplaySize(int symbolSize)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n <= 0) {
            String string = InternalResource.loadString("computeDisplaySize(int symbolSize)", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return SymbolMarkerNative.jni_ComputeDisplaySize(this.getHandle(), n);
    }

    public int computeSymbolSize(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeSymbolSize(int displaySize)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n <= 0) {
            String string = InternalResource.loadString("computeSymbolSize(int displaySize)", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return SymbolMarkerNative.jni_ComputeSymbolSize(this.getHandle(), n);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SymbolMarkerNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    public SymbolType getType() {
        return SymbolType.MARKER;
    }

    public Point getOrigin() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOrigin()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[2];
        SymbolMarkerNative.jni_GetOrigin(this.getHandle(), nArray);
        return new Point(nArray[0], nArray[1]);
    }

    public void setOrigin(Point point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOrigin(Point value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (point == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SymbolMarkerNative.jni_SetOrigin(this.getHandle(), point.getX(), point.getY());
    }

    public SymbolMarkerStroke get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.a.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        this.a(n);
        return this.a.get(n);
    }

    private void a(int n) {
        SymbolMarkerNative.jni_GetMatrialStream(this.getHandle(), this.getLibrary().a(), n);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a.size();
    }

    @Override
    protected void clearHandle() {
        if (this.a != null) {
            for (int i = 0; i < this.a.size(); ++i) {
                SymbolMarkerStroke symbolMarkerStroke = this.a.get(i);
                symbolMarkerStroke.clearHandle();
            }
            this.a.clear();
        }
        this.setHandle(0L);
    }
}

