/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import android.graphics.Bitmap;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetNative;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVectorNative;
import com.supermap.data.Datasource;
import com.supermap.data.DatasourceNative;
import com.supermap.data.EncodeType;
import com.supermap.data.Environment;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Resources;
import com.supermap.data.ToolkitNative;
import com.supermap.data.Workspace;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class Toolkit {
    protected static final double DBL_MAX_VALUE = Double.MAX_VALUE;
    protected static final double DBL_MIN_VALUE = -1.7976931348623157E308;
    protected static final float FLT_MAX_VALUE = Float.MAX_VALUE;
    protected static final float FLT_MIN_VALUE = -3.4028235E38f;

    protected Toolkit() {
    }

    public static boolean drawToPNG(Geometry geometry, Resources resources, String string, int n, int n2) {
        if (geometry == null) {
            String string2 = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string3 = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (resources == null) {
            String string4 = InternalResource.loadString("resources", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        long l2 = InternalHandle.getHandle(resources);
        if (l2 == 0L) {
            String string5 = InternalResource.loadString("resources", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = false;
        bl = ToolkitNative.jni_DrawGeometryToPNG(geometry2.getHandle(), l2, string, n, n2);
        return bl;
    }

    private static boolean draw(Geometry geometry, Resources resources, Bitmap bitmap) {
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (resources == null) {
            String string = InternalResource.loadString("resources", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(resources);
        if (l2 == 0L) {
            String string = InternalResource.loadString("resources", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (bitmap == null) {
            String string = InternalResource.loadString("bmp", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry geometry2 = geometry.clone();
        Rectangle2D rectangle2D = geometry2.getBounds();
        return ToolkitNative.jni_DrawGeometry(geometry2.getHandle(), l2, bitmap);
    }

    public static boolean isZero(double d2) {
        boolean bl = d2 >= Environment.getMinEqualZeroPrecision() && d2 <= Environment.getMaxEqualZeroPrecision();
        return bl;
    }

    public static boolean isZero(double d2, double d3) {
        boolean bl = d2 >= -Math.abs(d3) && d2 <= Math.abs(d3);
        return bl;
    }

    public static boolean isZero(double d2, double d3, double d4) {
        boolean bl = d2 >= d3 && d2 <= d4;
        return bl;
    }

    public static boolean compactDatasource(Datasource datasource) {
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(datasource);
        if (l == 0L) {
            String string = InternalResource.loadString("datasource", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ToolkitNative.jni_CompactDatasource(l);
        if (datasource.getDatasets().getCount() > 0) {
            datasource.getDatasets().reset();
        }
        return bl;
    }

    public static EncodeType[] getEncodeType(DatasetType datasetType) {
        if (datasetType == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        ArrayList<EncodeType> arrayList = new ArrayList<EncodeType>();
        switch (datasetType.value()) {
            case 3: 
            case 4: 
            case 5: {
                arrayList.add(EncodeType.BYTE);
                arrayList.add(EncodeType.INT16);
                arrayList.add(EncodeType.INT24);
                arrayList.add(EncodeType.INT32);
                arrayList.add(EncodeType.NONE);
                break;
            }
            case 0: 
            case 1: 
            case 7: 
            case 35: 
            case 149: 
            case 153: {
                arrayList.add(EncodeType.NONE);
                break;
            }
            case 81: {
                arrayList.add(EncodeType.LZW);
                arrayList.add(EncodeType.DCT);
                break;
            }
            case 83: {
                arrayList.add(EncodeType.LZW);
                arrayList.add(EncodeType.SGL);
                break;
            }
        }
        EncodeType[] encodeTypeArray = new EncodeType[arrayList.size()];
        return arrayList.toArray(encodeTypeArray);
    }

    public static void clearErrors() {
        ToolkitNative.jni_ClearErrors();
    }

    public static boolean extractCacheFile(String string, String string2) {
        return Toolkit.extractCacheFile(string, string2, "");
    }

    public static boolean extractCacheFile(String string, String string2, String string3) {
        if (string3 == null) {
            string3 = "";
        }
        boolean bl = false;
        bl = ToolkitNative.jni_ExtractCacheFile(string, string2, string3);
        return bl;
    }

    public static boolean unCompress(String string, String string2, String string3) {
        boolean bl = false;
        if (string != null && string2 != null) {
            if (string3 == null) {
                string3 = "";
            }
            bl = ToolkitNative.jni_UnCompress7Zip(string, string2, string3);
        }
        return bl;
    }

    protected static void setHandleBooleanValue(long l, boolean bl) {
        ToolkitNative.jni_SetBooleanHandle(l, bl);
    }

    protected static boolean getHandleBooleanValue(long l) {
        return ToolkitNative.jni_GetBooleanHandle(l);
    }

    protected static double getHandleDoubleValue(long l) {
        return ToolkitNative.jni_GetHandleDoubleValue(l);
    }

    protected static void setHandleDoubleValue(long l, double d2) {
        ToolkitNative.jni_SetHandleDoubleValue(l, d2);
    }

    protected static String joinString(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0 || string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuffer.append(stringArray[i] + string);
        }
        stringBuffer.append(stringArray[stringArray.length - 1]);
        return stringBuffer.toString();
    }

    protected static String[] splitString(String string, String string2) {
        if (string == null || string.trim().equals("") || string2 == null) {
            return new String[0];
        }
        return string.split(string2);
    }

    static Date parseUGCTime(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    static String toUGCTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return simpleDateFormat.format(date);
    }

    static boolean isValidEncodeType(boolean bl, EncodeType encodeType) {
        boolean bl2 = true;
        if (bl) {
            if (encodeType.equals(EncodeType.DCT) || encodeType.equals(EncodeType.LZW) || encodeType.equals(EncodeType.SGL)) {
                bl2 = false;
            }
        } else if (encodeType.equals(EncodeType.BYTE) || encodeType.equals(EncodeType.INT16) || encodeType.equals(EncodeType.INT24) || encodeType.equals(EncodeType.INT32)) {
            bl2 = false;
        }
        return bl2;
    }

    protected static boolean isDirectoryExisted(String string) {
        File file = new File(string);
        boolean bl = false;
        if (file.getParent() == null) {
            bl = true;
        } else {
            File file2 = new File(file.getParent());
            if (file2.exists()) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copyFileToTempFile(String string, String string2, String ... stringArray) {
        for (String string3 : stringArray) {
            String string4 = string + string3;
            URL uRL = Class.class.getResource(string4);
            String string5 = string2 + string3;
            File file = new File(string5);
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = null;
            if (string5 == null) continue;
            try {
                inputStream = uRL.openStream();
                fileOutputStream = new FileOutputStream(file);
            }
            catch (IOException iOException) {
                System.out.println("File Not Found!");
                iOException.printStackTrace();
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
            try {
                String string6 = null;
                while ((string6 = lineNumberReader.readLine()) != null) {
                    fileOutputStream.write(string6.getBytes());
                }
            }
            catch (Exception exception) {
                System.out.println("IO write Error");
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    if (lineNumberReader != null) {
                        lineNumberReader.close();
                    }
                }
                catch (IOException iOException) {
                    System.out.println("IO close Error");
                }
            }
        }
    }

    protected static Dataset toManageDataset(Workspace workspace, long l) {
        if (workspace == null || InternalHandle.getHandle(workspace) == 0L || l == 0L) {
            return null;
        }
        long l2 = DatasetNative.jni_GetDatasource(l);
        String string = null;
        if (l2 != 0L) {
            string = DatasourceNative.jni_GetAlias(l2);
        }
        Datasource datasource = workspace.getDatasources().get(string);
        Dataset dataset = null;
        if (datasource != null) {
            dataset = Toolkit.toManageDataset(datasource, l);
        }
        return dataset;
    }

    private static Dataset toManageDataset(Datasource datasource, long l) {
        if (datasource == null || InternalHandle.getHandle(datasource) == 0L || l == 0L) {
            return null;
        }
        String string = DatasetNative.jni_GetName(l);
        boolean bl = false;
        long l2 = 0L;
        boolean bl2 = DatasetNative.jni_GetIsVector(l);
        if (bl2) {
            l2 = DatasetVectorNative.jni_GetParentDataset(l);
        }
        if (l2 != 0L) {
            string = DatasetNative.jni_GetName(l2);
        }
        Dataset dataset = datasource.getDatasets().get(string);
        return dataset;
    }

    public static float calcAngleWithLines(Point point, Point point2, Point point3, Point point4) {
        Point point5 = new Point(point2.getX() - point.getX(), point2.getY() - point.getY());
        Point point6 = new Point(point4.getX() - point3.getX(), point4.getY() - point3.getY());
        double d2 = point5.getX() * point6.getX() + point5.getY() * point6.getY();
        double d3 = Math.sqrt(point5.getX() * point5.getX() + point5.getY() * point5.getY()) * Math.sqrt(point6.getX() * point6.getX() + point6.getY() * point6.getY());
        double d4 = d2 / d3;
        float f2 = (float)(Math.acos(d4) * 57.29577951308232);
        return f2;
    }

    public static double calcLength(Point2Ds point2Ds, PrjCoordSys prjCoordSys) {
        if (point2Ds.getCount() < 2) {
            return 0.0;
        }
        int n = point2Ds.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        return ToolkitNative.jni_CalcLength(dArray, dArray2, prjCoordSys.getHandle());
    }

    public static double calcArea(Point2Ds point2Ds, PrjCoordSys prjCoordSys) {
        if (point2Ds.getCount() < 3) {
            return 0.0;
        }
        int n = point2Ds.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        return ToolkitNative.jni_CalcArea(dArray, dArray2, prjCoordSys.getHandle());
    }

    public static String getLastError() {
        return ToolkitNative.jni_GetLastError();
    }

    public static double calcAngle(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        double d2 = 0.0;
        if (point2D != null && point2D2 != null && point2D3 != null) {
            double d3 = Math.PI / 180;
            double d4 = point2D2.getX() - point2D.getX();
            double d5 = point2D2.getY() - point2D.getY();
            double d6 = point2D3.getX() - point2D2.getX();
            double d7 = point2D3.getY() - point2D2.getY();
            double d8 = (d4 * d6 + d5 * d7) / (Math.sqrt(d4 * d4 + d5 * d5) * Math.sqrt(d6 * d6 + d7 * d7));
            d2 = Math.acos(d8) * 1.0 / d3;
            double d9 = (point2D3.getX() - point2D.getX()) * (point2D2.getY() - point2D.getY()) - (point2D3.getY() - point2D.getY()) * (point2D2.getX() - point2D.getX());
            d2 = d9 > 0.0 ? 180.0 + d2 : (d9 < 0.0 ? 180.0 - d2 : (point2D2.getX() != point2D3.getX() || point2D.getX() != point2D3.getX() ? (point2D.getX() > point2D2.getX() ? (point2D3.getX() < point2D2.getX() ? 180.0 : 0.0) : (point2D3.getX() > point2D2.getX() ? 180.0 : 0.0)) : (point2D.getY() > point2D2.getY() ? (point2D3.getY() < point2D2.getY() ? 180.0 : 0.0) : (point2D3.getY() > point2D2.getY() ? 180.0 : 0.0))));
        }
        return d2;
    }

    static {
        Environment.LoadWrapJ();
    }
}

