/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.TransformationMode;
import com.supermap.data.TransformationNative;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Transformation
extends InternalHandleDisposable {
    private Point2Ds a;
    private Point2Ds b = null;
    private TransformationMode a = TransformationMode.RECT;

    public Transformation() {
        long l = TransformationNative.jni_New();
        this.setHandle(l, true);
        this.a = new Point2Ds();
        this.b = new Point2Ds();
    }

    public Transformation(Transformation transformation) {
        if (transformation == null) {
            String string = InternalResource.loadString("transformation", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (transformation.getHandle() == 0L) {
            String string = InternalResource.loadString("transformation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = TransformationNative.jni_New();
        this.setHandle(l, true);
        this.a = new Point2Ds();
        this.b = new Point2Ds();
    }

    public Transformation(Point2Ds point2Ds, Point2Ds point2Ds2, TransformationMode transformationMode) {
        if (point2Ds == null) {
            String string = InternalResource.loadString("originalControlPoints", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2Ds2 == null) {
            String string = InternalResource.loadString("targetControlPoints", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (transformationMode == null) {
            String string = InternalResource.loadString("transformationMode", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = TransformationNative.jni_New();
        this.setHandle(l, true);
        this.a = new Point2Ds();
        this.b = new Point2Ds();
        this.setOriginalControlPoints(point2Ds);
        this.setTargetControlPoints(point2Ds2);
        this.a = transformationMode;
    }

    public Point2Ds getOriginalControlPoints() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOriginalControlPoints()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a;
    }

    public boolean transform(Point2Ds point2Ds) {
        int n;
        if (point2Ds == null) {
            String string = InternalResource.loadString("transformPoint2Ds", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.a();
        int n2 = point2Ds.getCount();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = point2Ds.getItem(n).getX();
            dArray2[n] = point2Ds.getItem(n).getY();
        }
        n = TransformationNative.jni_TransformPoint2Ds(this.getHandle(), dArray, dArray2, this.a.value()) ? 1 : 0;
        if (n != 0) {
            point2Ds.clear();
            for (int i = 0; i < n2; ++i) {
                Point2D point2D = new Point2D(dArray[i], dArray2[i]);
                point2Ds.add(point2D);
            }
        }
        return n != 0;
    }

    public boolean setOriginalControlPoints(Point2Ds point2Ds) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOriginalControlPoints(Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (point2Ds == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = point2Ds.getCount();
        if (n2 < 1) {
            String string = InternalResource.loadString("Point2Ds", "Transformation_ControlPointsShouldNotSmallerThanOne", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = point2Ds.getItem(n).getX();
            dArray2[n] = point2Ds.getItem(n).getY();
        }
        n = TransformationNative.jni_SetOriginalControlPoints(this.getHandle(), dArray, dArray2) ? 1 : 0;
        if (n == 1) {
            this.a.clear();
            this.a.addRange(point2Ds.toArray());
        }
        return n != 0;
    }

    public Point2Ds getTargetControlPoints() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetControlPoints()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.b;
    }

    public boolean setTargetControlPoints(Point2Ds point2Ds) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetControlPoints(Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (point2Ds == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = point2Ds.getCount();
        if (n2 < 1) {
            String string = InternalResource.loadString("Point2Ds", "Transformation_ControlPointsShouldNotSmallerThanOne", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = point2Ds.getItem(n).getX();
            dArray2[n] = point2Ds.getItem(n).getY();
        }
        n = TransformationNative.jni_SetTargetControlPoints(this.getHandle(), dArray, dArray2) ? 1 : 0;
        if (n == 1) {
            this.b.clear();
            this.b.addRange(point2Ds.toArray());
        }
        return n != 0;
    }

    public TransformationMode getTransformMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTransformMode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a;
    }

    public void setTransformMode(TransformationMode transformationMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTransformMode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (transformationMode == null) {
            String string = InternalResource.loadString("transformMode", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.a = transformationMode;
    }

    @Override
    protected void clearHandle() {
        this.setHandle(0L);
        if (this.a != null) {
            this.a.clear();
            this.a = null;
        }
        if (this.b != null) {
            this.b.clear();
            this.b = null;
        }
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            TransformationNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    private void a() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Transformmation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == null || this.b == null) {
            String string = InternalResource.loadString("ControlPoints", "Transformation_ControlPointsNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.a.getCount();
        int n2 = this.b.getCount();
        if (n == 0 || n2 == 0) {
            String string = InternalResource.loadString("Transformmation", "Transformation_ControlPointsShouldNotBeZero", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n != n2) {
            String string = InternalResource.loadString("Transformmation", "Transformation_OriginalAndTargetControlPointsCountMustEqual", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == TransformationMode.RECT && n < 2) {
            String string = InternalResource.loadString("Transformmation", "Transformation_RectModeNeedLeastTwoControlPoints", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == TransformationMode.LINEAR && n < 4) {
            String string = InternalResource.loadString("Transformmation", "Transformation_LinearModeNeedLeastFourControlPoints", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == TransformationMode.SQUARE && n < 7) {
            String string = InternalResource.loadString("Transformmation", "Transformation_SquareModeNeedLeastSevenControlPoints", "data_resources");
            throw new IllegalStateException(string);
        }
    }
}

