/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.examples;

import java.io.IOException;
import org.jsoup.Jsoup;
import org.jsoup.helper.StringUtil;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

public class HtmlToPlainText {
    public static void main(String ... stringArray) throws IOException {
        Validate.isTrue(stringArray.length == 1 || stringArray.length == 2, "usage: java -cp jsoup.jar org.jsoup.examples.HtmlToPlainText url [selector]");
        String string = stringArray[0];
        String string2 = stringArray.length == 2 ? stringArray[1] : null;
        Document document = Jsoup.connect(string).userAgent("Mozilla/5.0 (jsoup)").timeout(5000).get();
        HtmlToPlainText htmlToPlainText = new HtmlToPlainText();
        if (string2 != null) {
            Elements elements = document.select(string2);
            for (Element element : elements) {
                String string3 = htmlToPlainText.getPlainText(element);
                System.out.println(string3);
            }
        } else {
            String string4 = htmlToPlainText.getPlainText(document);
            System.out.println(string4);
        }
    }

    public String getPlainText(Element element) {
        a a2 = new a();
        NodeTraversor nodeTraversor = new NodeTraversor(a2);
        nodeTraversor.traverse(element);
        return a2.toString();
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    class a
    implements NodeVisitor {
        private int a;
        private StringBuilder a = new StringBuilder();

        private a() {
        }

        public void head(Node node, int n) {
            String string = node.nodeName();
            if (node instanceof TextNode) {
                this.a(((TextNode)node).text());
            } else if (string.equals("li")) {
                this.a("\n * ");
            } else if (string.equals("dt")) {
                this.a("  ");
            } else if (StringUtil.in(string, "p", "h1", "h2", "h3", "h4", "h5", "tr")) {
                this.a("\n");
            }
        }

        public void tail(Node node, int n) {
            String string = node.nodeName();
            if (StringUtil.in(string, "br", "dd", "dt", "p", "h1", "h2", "h3", "h4", "h5")) {
                this.a("\n");
            } else if (string.equals("a")) {
                this.a(String.format(" <%s>", node.absUrl("href")));
            }
        }

        private void a(String string) {
            if (string.startsWith("\n")) {
                this.a = 0;
            }
            if (string.equals(" ") && (this.a.length() == 0 || StringUtil.in(this.a.substring(this.a.length() - 1), " ", "\n"))) {
                return;
            }
            if (string.length() + this.a > 80) {
                String[] stringArray = string.split("\\s+");
                for (int i = 0; i < stringArray.length; ++i) {
                    boolean bl;
                    String string2 = stringArray[i];
                    boolean bl2 = bl = i == stringArray.length - 1;
                    if (!bl) {
                        string2 = string2 + " ";
                    }
                    if (string2.length() + this.a > 80) {
                        this.a.append("\n").append(string2);
                        this.a = string2.length();
                        continue;
                    }
                    this.a.append(string2);
                    this.a += string2.length();
                }
            } else {
                this.a.append(string);
                this.a += string.length();
            }
        }

        public String toString() {
            return this.a.toString();
        }
    }
}

