/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jsoup.Connection;
import org.jsoup.HttpStatusException;
import org.jsoup.UnsupportedMimeTypeException;
import org.jsoup.helper.DataUtil;
import org.jsoup.helper.StringUtil;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;
import org.jsoup.parser.TokenQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class HttpConnection
implements Connection {
    public static final String CONTENT_ENCODING = "Content-Encoding";
    private Connection.Request a;
    private Connection.Response a = new Response();

    public static Connection connect(String string) {
        HttpConnection httpConnection = new HttpConnection();
        httpConnection.url(string);
        return httpConnection;
    }

    public static Connection connect(URL uRL) {
        HttpConnection httpConnection = new HttpConnection();
        httpConnection.url(uRL);
        return httpConnection;
    }

    private static String encodeUrl(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll(" ", "%20");
    }

    private static String encodeMimeName(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("\"", "%22");
    }

    private HttpConnection() {
    }

    @Override
    public Connection url(URL uRL) {
        this.a.url(uRL);
        return this;
    }

    @Override
    public Connection url(String string) {
        Validate.notEmpty(string, "Must supply a valid URL");
        try {
            this.a.url(new URL(HttpConnection.encodeUrl(string)));
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Malformed URL: " + string, malformedURLException);
        }
        return this;
    }

    @Override
    public Connection proxy(Proxy proxy) {
        this.a.proxy(proxy);
        return this;
    }

    @Override
    public Connection proxy(String string, int n) {
        this.a.proxy(string, n);
        return this;
    }

    @Override
    public Connection userAgent(String string) {
        Validate.notNull(string, "User agent must not be null");
        this.a.header("User-Agent", string);
        return this;
    }

    @Override
    public Connection timeout(int n) {
        this.a.timeout(n);
        return this;
    }

    @Override
    public Connection maxBodySize(int n) {
        this.a.maxBodySize(n);
        return this;
    }

    @Override
    public Connection followRedirects(boolean bl) {
        this.a.followRedirects(bl);
        return this;
    }

    @Override
    public Connection referrer(String string) {
        Validate.notNull(string, "Referrer must not be null");
        this.a.header("Referer", string);
        return this;
    }

    @Override
    public Connection method(Connection.Method method) {
        this.a.method(method);
        return this;
    }

    @Override
    public Connection ignoreHttpErrors(boolean bl) {
        this.a.ignoreHttpErrors(bl);
        return this;
    }

    @Override
    public Connection ignoreContentType(boolean bl) {
        this.a.ignoreContentType(bl);
        return this;
    }

    @Override
    public Connection validateTLSCertificates(boolean bl) {
        this.a.validateTLSCertificates(bl);
        return this;
    }

    @Override
    public Connection data(String string, String string2) {
        this.a.data(KeyVal.create(string, string2));
        return this;
    }

    @Override
    public Connection data(String string, String string2, InputStream inputStream) {
        this.a.data(KeyVal.create(string, string2, inputStream));
        return this;
    }

    @Override
    public Connection data(Map<String, String> map) {
        Validate.notNull(map, "Data map must not be null");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.a.data(KeyVal.create(entry.getKey(), entry.getValue()));
        }
        return this;
    }

    @Override
    public Connection data(String ... stringArray) {
        Validate.notNull(stringArray, "Data key value pairs must not be null");
        Validate.isTrue(stringArray.length % 2 == 0, "Must supply an even number of key value pairs");
        for (int i = 0; i < stringArray.length; i += 2) {
            String string = stringArray[i];
            String string2 = stringArray[i + 1];
            Validate.notEmpty(string, "Data key must not be empty");
            Validate.notNull(string2, "Data value must not be null");
            this.a.data(KeyVal.create(string, string2));
        }
        return this;
    }

    @Override
    public Connection data(Collection<Connection.KeyVal> collection) {
        Validate.notNull(collection, "Data collection must not be null");
        for (Connection.KeyVal keyVal : collection) {
            this.a.data(keyVal);
        }
        return this;
    }

    @Override
    public Connection.KeyVal data(String string) {
        Validate.notEmpty(string, "Data key must not be empty");
        for (Connection.KeyVal keyVal : this.request().data()) {
            if (!keyVal.key().equals(string)) continue;
            return keyVal;
        }
        return null;
    }

    @Override
    public Connection requestBody(String string) {
        this.a.requestBody(string);
        return this;
    }

    @Override
    public Connection header(String string, String string2) {
        this.a.header(string, string2);
        return this;
    }

    @Override
    public Connection headers(Map<String, String> map) {
        Validate.notNull(map, "Header map must not be null");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.a.header(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public Connection cookie(String string, String string2) {
        this.a.cookie(string, string2);
        return this;
    }

    @Override
    public Connection cookies(Map<String, String> map) {
        Validate.notNull(map, "Cookie map must not be null");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.a.cookie(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public Connection parser(Parser parser) {
        this.a.parser(parser);
        return this;
    }

    @Override
    public Document get() throws IOException {
        this.a.method(Connection.Method.GET);
        this.execute();
        return this.a.parse();
    }

    @Override
    public Document post() throws IOException {
        this.a.method(Connection.Method.POST);
        this.execute();
        return this.a.parse();
    }

    @Override
    public Connection.Response execute() throws IOException {
        this.a = Response.execute(this.a);
        return this.a;
    }

    @Override
    public Connection.Request request() {
        return this.a;
    }

    @Override
    public Connection request(Connection.Request request) {
        this.a = request;
        return this;
    }

    @Override
    public Connection.Response response() {
        return this.a;
    }

    @Override
    public Connection response(Connection.Response response) {
        this.a = response;
        return this;
    }

    @Override
    public Connection postDataCharset(String string) {
        this.a.postDataCharset(string);
        return this;
    }

    private static boolean needsMultipart(Connection.Request request) {
        boolean bl = false;
        for (Connection.KeyVal keyVal : request.data()) {
            if (!keyVal.hasInputStream()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static class KeyVal
    implements Connection.KeyVal {
        private String a;
        private String b;
        private InputStream a;

        public static KeyVal create(String string, String string2) {
            return new KeyVal().key(string).value(string2);
        }

        public static KeyVal create(String string, String string2, InputStream inputStream) {
            return new KeyVal().key(string).value(string2).inputStream(inputStream);
        }

        private KeyVal() {
        }

        public KeyVal key(String string) {
            Validate.notEmpty(string, "Data key must not be empty");
            this.a = string;
            return this;
        }

        public String key() {
            return this.a;
        }

        public KeyVal value(String string) {
            Validate.notNull(string, "Data value must not be null");
            this.b = string;
            return this;
        }

        public String value() {
            return this.b;
        }

        public KeyVal inputStream(InputStream inputStream) {
            Validate.notNull(this.b, "Data input stream must not be null");
            this.a = inputStream;
            return this;
        }

        public InputStream inputStream() {
            return this.a;
        }

        public boolean hasInputStream() {
            return this.a != null;
        }

        public String toString() {
            return this.a + "=" + this.b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static class Response
    extends a<Connection.Response>
    implements Connection.Response {
        private static SSLSocketFactory a;
        private int a;
        private String a;
        private ByteBuffer a;
        private String b;
        private String c;
        private boolean a;
        private int b = 0;
        private Connection.Request a = false;
        private static final Pattern a;

        Response() {
        }

        private Response(Response response) throws IOException {
            if (response != null) {
                this.b = response.b + 1;
                if (this.b >= 20) {
                    throw new IOException(String.format("Too many redirects occurred trying to load URL %s", response.url()));
                }
            }
        }

        static Response execute(Connection.Request request) throws IOException {
            return Response.execute(request, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Response execute(Connection.Request request, Response response) throws IOException {
            Response response2;
            block23: {
                boolean bl;
                Validate.notNull(request, "Request must not be null");
                String string = request.url().getProtocol();
                if (!string.equals("http") && !string.equals("https")) {
                    throw new MalformedURLException("Only http & https protocols supported");
                }
                boolean bl2 = request.method().hasBody();
                boolean bl3 = bl = request.requestBody() != null;
                if (!bl2) {
                    Validate.isFalse(bl, "Cannot set a request body for HTTP method " + (Object)((Object)request.method()));
                }
                String string2 = null;
                if (request.data().size() > 0 && (!bl2 || bl)) {
                    Response.serialiseRequestUrl(request);
                } else if (bl2) {
                    string2 = Response.setOutputContentType(request);
                }
                HttpURLConnection httpURLConnection = Response.createConnection(request);
                try {
                    httpURLConnection.connect();
                    if (httpURLConnection.getDoOutput()) {
                        Response.writePost(request, httpURLConnection.getOutputStream(), string2);
                    }
                    int n = httpURLConnection.getResponseCode();
                    response2 = new Response(response);
                    response2.a(httpURLConnection, response);
                    response2.a = request;
                    if (response2.hasHeader("Location") && request.followRedirects()) {
                        String string3;
                        if (n != 307) {
                            request.method(Connection.Method.GET);
                            request.data().clear();
                        }
                        if ((string3 = response2.header("Location")) != null && string3.startsWith("http:/") && string3.charAt(6) != '/') {
                            string3 = string3.substring(6);
                        }
                        request.url(StringUtil.resolve(request.url(), HttpConnection.encodeUrl(string3)));
                        for (Map.Entry entry : response2.b.entrySet()) {
                            request.cookie((String)entry.getKey(), (String)entry.getValue());
                        }
                        Response response3 = Response.execute(request, response2);
                        return response3;
                    }
                    if (!(n >= 200 && n < 400 || request.ignoreHttpErrors())) {
                        throw new HttpStatusException("HTTP error fetching URL", n, request.url().toString());
                    }
                    String string4 = response2.contentType();
                    if (!(string4 == null || request.ignoreContentType() || string4.startsWith("text/") || a.matcher(string4).matches())) {
                        throw new UnsupportedMimeTypeException("Unhandled content type. Must be text/*, application/xml, or application/xhtml+xml", string4, request.url().toString());
                    }
                    if (string4 != null && a.matcher(string4).matches() && request instanceof Request && !((Request)request).d) {
                        request.parser(Parser.xmlParser());
                    }
                    response2.b = DataUtil.getCharsetFromContentType(response2.c);
                    if (httpURLConnection.getContentLength() != 0 && request.method() != Connection.Method.HEAD) {
                        InputStream inputStream = null;
                        try {
                            InputStream inputStream2 = inputStream = httpURLConnection.getErrorStream() != null ? httpURLConnection.getErrorStream() : httpURLConnection.getInputStream();
                            if (response2.hasHeaderWithValue(HttpConnection.CONTENT_ENCODING, "gzip")) {
                                inputStream = new GZIPInputStream(inputStream);
                            }
                            response2.a = DataUtil.readToByteBuffer(inputStream, request.maxBodySize());
                            break block23;
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                    }
                    response2.a = DataUtil.emptyByteBuffer();
                }
                finally {
                    httpURLConnection.disconnect();
                }
            }
            response2.a = true;
            return response2;
        }

        @Override
        public int statusCode() {
            return this.a;
        }

        @Override
        public String statusMessage() {
            return this.a;
        }

        @Override
        public String charset() {
            return this.b;
        }

        @Override
        public Response charset(String string) {
            this.b = string;
            return this;
        }

        @Override
        public String contentType() {
            return this.c;
        }

        @Override
        public Document parse() throws IOException {
            Validate.isTrue(this.a, "Request must be executed (with .execute(), .get(), or .post() before parsing response");
            Document document = DataUtil.parseByteData(this.a, this.b, ((URL)((Object)this.a)).toExternalForm(), this.a.parser());
            this.a.rewind();
            this.b = document.outputSettings().charset().name();
            return document;
        }

        @Override
        public String body() {
            Validate.isTrue(this.a, "Request must be executed (with .execute(), .get(), or .post() before getting response body");
            String string = this.b == null ? Charset.forName("UTF-8").decode(this.a).toString() : Charset.forName(this.b).decode(this.a).toString();
            this.a.rewind();
            return string;
        }

        @Override
        public byte[] bodyAsBytes() {
            Validate.isTrue(this.a, "Request must be executed (with .execute(), .get(), or .post() before getting response body");
            return this.a.array();
        }

        private static HttpURLConnection createConnection(Connection.Request request) throws IOException {
            HttpURLConnection httpURLConnection = (HttpURLConnection)(request.proxy() == null ? request.url().openConnection() : request.url().openConnection(request.proxy()));
            httpURLConnection.setRequestMethod(request.method().name());
            httpURLConnection.setInstanceFollowRedirects(false);
            httpURLConnection.setConnectTimeout(request.timeout());
            httpURLConnection.setReadTimeout(request.timeout());
            if (httpURLConnection instanceof HttpsURLConnection && !request.validateTLSCertificates()) {
                Response.initUnSecureTSL();
                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(a);
                ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(Response.getInsecureVerifier());
            }
            if (request.method().hasBody()) {
                httpURLConnection.setDoOutput(true);
            }
            if (request.cookies().size() > 0) {
                httpURLConnection.addRequestProperty("Cookie", Response.getRequestCookieString(request));
            }
            for (Map.Entry<String, String> entry : request.headers().entrySet()) {
                httpURLConnection.addRequestProperty(entry.getKey(), entry.getValue());
            }
            return httpURLConnection;
        }

        private static HostnameVerifier getInsecureVerifier() {
            return new HostnameVerifier(){

                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            };
        }

        private static synchronized void initUnSecureTSL() throws IOException {
            if (a == null) {
                TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                    }

                    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                    }

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                }};
                try {
                    SSLContext sSLContext = SSLContext.getInstance("SSL");
                    sSLContext.init(null, trustManagerArray, new SecureRandom());
                    a = sSLContext.getSocketFactory();
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new IOException("Can't create unsecure trust manager");
                }
                catch (KeyManagementException keyManagementException) {
                    throw new IOException("Can't create unsecure trust manager");
                }
            }
        }

        private void a(HttpURLConnection httpURLConnection, Connection.Response response) throws IOException {
            this.a = Connection.Method.valueOf(httpURLConnection.getRequestMethod());
            this.a = httpURLConnection.getURL();
            this.a = httpURLConnection.getResponseCode();
            this.a = httpURLConnection.getResponseMessage();
            this.c = httpURLConnection.getContentType();
            LinkedHashMap<String, List<String>> linkedHashMap = Response.createHeaderMap(httpURLConnection);
            this.a(linkedHashMap);
            if (response != null) {
                for (Map.Entry<String, String> entry : response.cookies().entrySet()) {
                    if (this.hasCookie(entry.getKey())) continue;
                    this.cookie(entry.getKey(), entry.getValue());
                }
            }
        }

        private static LinkedHashMap<String, List<String>> createHeaderMap(HttpURLConnection httpURLConnection) {
            LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
            int n = 0;
            while (true) {
                String string = httpURLConnection.getHeaderFieldKey(n);
                String string2 = httpURLConnection.getHeaderField(n);
                if (string == null && string2 == null) break;
                ++n;
                if (string == null || string2 == null) continue;
                if (linkedHashMap.containsKey(string)) {
                    linkedHashMap.get(string).add(string2);
                    continue;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string2);
                linkedHashMap.put(string, arrayList);
            }
            return linkedHashMap;
        }

        void a(Map<String, List<String>> map) {
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                Object object;
                String string = entry.getKey();
                if (string == null) continue;
                List<String> list = entry.getValue();
                if (string.equalsIgnoreCase("Set-Cookie")) {
                    for (String string2 : list) {
                        if (string2 == null) continue;
                        object = new TokenQueue(string2);
                        String string3 = ((TokenQueue)object).chompTo("=").trim();
                        String string4 = ((TokenQueue)object).consumeTo(";").trim();
                        if (string3.length() <= 0) continue;
                        this.cookie(string3, string4);
                    }
                    continue;
                }
                if (list.size() == 1) {
                    this.header(string, list.get(0));
                    continue;
                }
                if (list.size() <= 1) continue;
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < list.size(); ++i) {
                    object = list.get(i);
                    if (i != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append((String)object);
                }
                this.header(string, stringBuilder.toString());
            }
        }

        private static String setOutputContentType(Connection.Request request) {
            String string = null;
            if (!request.hasHeader("Content-Type")) {
                if (HttpConnection.needsMultipart(request)) {
                    string = DataUtil.mimeBoundary();
                    request.header("Content-Type", "multipart/form-data; boundary=" + string);
                } else {
                    request.header("Content-Type", "application/x-www-form-urlencoded; charset=" + request.postDataCharset());
                }
            }
            return string;
        }

        private static void writePost(Connection.Request request, OutputStream outputStream, String string) throws IOException {
            Collection<Connection.KeyVal> collection = request.data();
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, request.postDataCharset()));
            if (string != null) {
                for (Connection.KeyVal keyVal : collection) {
                    bufferedWriter.write("--");
                    bufferedWriter.write(string);
                    bufferedWriter.write("\r\n");
                    bufferedWriter.write("Content-Disposition: form-data; name=\"");
                    bufferedWriter.write(HttpConnection.encodeMimeName(keyVal.key()));
                    bufferedWriter.write("\"");
                    if (keyVal.hasInputStream()) {
                        bufferedWriter.write("; filename=\"");
                        bufferedWriter.write(HttpConnection.encodeMimeName(keyVal.value()));
                        bufferedWriter.write("\"\r\nContent-Type: application/octet-stream\r\n\r\n");
                        bufferedWriter.flush();
                        DataUtil.crossStreams(keyVal.inputStream(), outputStream);
                        outputStream.flush();
                    } else {
                        bufferedWriter.write("\r\n\r\n");
                        bufferedWriter.write(keyVal.value());
                    }
                    bufferedWriter.write("\r\n");
                }
                bufferedWriter.write("--");
                bufferedWriter.write(string);
                bufferedWriter.write("--");
            } else if (request.requestBody() != null) {
                bufferedWriter.write(request.requestBody());
            } else {
                boolean bl = true;
                for (Connection.KeyVal keyVal : collection) {
                    if (!bl) {
                        bufferedWriter.append('&');
                    } else {
                        bl = false;
                    }
                    bufferedWriter.write(URLEncoder.encode(keyVal.key(), request.postDataCharset()));
                    bufferedWriter.write(61);
                    bufferedWriter.write(URLEncoder.encode(keyVal.value(), request.postDataCharset()));
                }
            }
            bufferedWriter.close();
        }

        private static String getRequestCookieString(Connection.Request request) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (Map.Entry<String, String> entry : request.cookies().entrySet()) {
                if (!bl) {
                    stringBuilder.append("; ");
                } else {
                    bl = false;
                }
                stringBuilder.append(entry.getKey()).append('=').append(entry.getValue());
            }
            return stringBuilder.toString();
        }

        private static void serialiseRequestUrl(Connection.Request request) throws IOException {
            URL uRL = request.url();
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            stringBuilder.append(uRL.getProtocol()).append("://").append(uRL.getAuthority()).append(uRL.getPath()).append("?");
            if (uRL.getQuery() != null) {
                stringBuilder.append(uRL.getQuery());
                bl = false;
            }
            for (Connection.KeyVal keyVal : request.data()) {
                Validate.isFalse(keyVal.hasInputStream(), "InputStream data not supported in URL query string.");
                if (!bl) {
                    stringBuilder.append('&');
                } else {
                    bl = false;
                }
                stringBuilder.append(URLEncoder.encode(keyVal.key(), "UTF-8")).append('=').append(URLEncoder.encode(keyVal.value(), "UTF-8"));
            }
            request.url(new URL(stringBuilder.toString()));
            request.data().clear();
        }

        static {
            a = Pattern.compile("(application|text)/\\w*\\+?xml.*");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static class Request
    extends a<Connection.Request>
    implements Connection.Request {
        private Proxy a;
        private int a;
        private int b;
        private boolean a;
        private Collection<Connection.KeyVal> a;
        private String a;
        private boolean b;
        private boolean c = false;
        private Parser a = Connection.Method.GET;
        private boolean d = false;
        private boolean e = true;
        private String b = 0x100000;

        private Request() {
            this.a.put("Accept-Encoding", "gzip");
            this.a = Parser.htmlParser();
        }

        @Override
        public Proxy proxy() {
            return this.a;
        }

        @Override
        public Request proxy(Proxy proxy) {
            this.a = proxy;
            return this;
        }

        @Override
        public Request proxy(String string, int n) {
            this.a = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(string, n));
            return this;
        }

        @Override
        public int timeout() {
            return this.a;
        }

        @Override
        public Request timeout(int n) {
            Validate.isTrue(n >= 0, "Timeout milliseconds must be 0 (infinite) or greater");
            this.a = n;
            return this;
        }

        @Override
        public int maxBodySize() {
            return this.b;
        }

        @Override
        public Connection.Request maxBodySize(int n) {
            Validate.isTrue(n >= 0, "maxSize must be 0 (unlimited) or larger");
            this.b = n;
            return this;
        }

        @Override
        public boolean followRedirects() {
            return this.a;
        }

        @Override
        public Connection.Request followRedirects(boolean bl) {
            this.a = bl;
            return this;
        }

        @Override
        public boolean ignoreHttpErrors() {
            return this.b;
        }

        @Override
        public boolean validateTLSCertificates() {
            return this.e;
        }

        @Override
        public void validateTLSCertificates(boolean bl) {
            this.e = bl;
        }

        @Override
        public Connection.Request ignoreHttpErrors(boolean bl) {
            this.b = bl;
            return this;
        }

        @Override
        public boolean ignoreContentType() {
            return this.c;
        }

        @Override
        public Connection.Request ignoreContentType(boolean bl) {
            this.c = bl;
            return this;
        }

        @Override
        public Request data(Connection.KeyVal keyVal) {
            Validate.notNull(keyVal, "Key val must not be null");
            this.a.add(keyVal);
            return this;
        }

        @Override
        public Collection<Connection.KeyVal> data() {
            return this.a;
        }

        @Override
        public Connection.Request requestBody(String string) {
            this.a = string;
            return this;
        }

        @Override
        public String requestBody() {
            return this.a;
        }

        @Override
        public Request parser(Parser parser) {
            this.a = parser;
            this.d = true;
            return this;
        }

        @Override
        public Parser parser() {
            return this.a;
        }

        @Override
        public Connection.Request postDataCharset(String string) {
            Validate.notNull(string, "Charset must not be null");
            if (!Charset.isSupported(string)) {
                throw new IllegalCharsetNameException(string);
            }
            this.b = string;
            return this;
        }

        @Override
        public String postDataCharset() {
            return this.b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    static abstract class a<T extends Connection.Base>
    implements Connection.Base<T> {
        URL a;
        Connection.Method a;
        Map<String, String> a = new LinkedHashMap();
        Map<String, String> b = new LinkedHashMap<String, String>();

        private a() {
        }

        @Override
        public URL url() {
            return this.a;
        }

        @Override
        public T url(URL uRL) {
            Validate.notNull(uRL, "URL must not be null");
            this.a = uRL;
            return (T)this;
        }

        @Override
        public Connection.Method method() {
            return this.a;
        }

        @Override
        public T method(Connection.Method method) {
            Validate.notNull((Object)method, "Method must not be null");
            this.a = method;
            return (T)this;
        }

        @Override
        public String header(String string) {
            Validate.notNull(string, "Header name must not be null");
            return this.a(string);
        }

        @Override
        public T header(String string, String string2) {
            Validate.notEmpty(string, "Header name must not be empty");
            Validate.notNull(string2, "Header value must not be null");
            this.removeHeader(string);
            this.a.put(string, string2);
            return (T)this;
        }

        @Override
        public boolean hasHeader(String string) {
            Validate.notEmpty(string, "Header name must not be empty");
            return this.a(string) != null;
        }

        @Override
        public boolean hasHeaderWithValue(String string, String string2) {
            return this.hasHeader(string) && this.header(string).equalsIgnoreCase(string2);
        }

        @Override
        public T removeHeader(String string) {
            Validate.notEmpty(string, "Header name must not be empty");
            Map.Entry<String, String> entry = this.a(string);
            if (entry != null) {
                this.a.remove(entry.getKey());
            }
            return (T)this;
        }

        @Override
        public Map<String, String> headers() {
            return this.a;
        }

        private String a(String string) {
            Map.Entry<String, String> entry;
            Validate.notNull(string, "Header name must not be null");
            String string2 = (String)this.a.get(string);
            if (string2 == null) {
                string2 = (String)this.a.get(string.toLowerCase());
            }
            if (string2 == null && (entry = this.a(string)) != null) {
                string2 = entry.getValue();
            }
            return string2;
        }

        private Map.Entry<String, String> a(String string) {
            String string2 = string.toLowerCase();
            for (Map.Entry<String, String> entry : this.a.entrySet()) {
                if (!((String)entry.getKey()).toLowerCase().equals(string2)) continue;
                return entry;
            }
            return null;
        }

        @Override
        public String cookie(String string) {
            Validate.notEmpty(string, "Cookie name must not be empty");
            return this.b.get(string);
        }

        @Override
        public T cookie(String string, String string2) {
            Validate.notEmpty(string, "Cookie name must not be empty");
            Validate.notNull(string2, "Cookie value must not be null");
            this.b.put(string, string2);
            return (T)this;
        }

        @Override
        public boolean hasCookie(String string) {
            Validate.notEmpty(string, "Cookie name must not be empty");
            return this.b.containsKey(string);
        }

        @Override
        public T removeCookie(String string) {
            Validate.notEmpty(string, "Cookie name must not be empty");
            this.b.remove(string);
            return (T)this;
        }

        @Override
        public Map<String, String> cookies() {
            return this.b;
        }
    }
}

