/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jsoup.SerializationException;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.BooleanAttribute;
import org.jsoup.nodes.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attributes
implements Cloneable,
Iterable<Attribute> {
    protected static final String dataPrefix = "data-";
    private LinkedHashMap<String, Attribute> a = null;

    public String get(String string) {
        Validate.notEmpty(string);
        if (this.a == null) {
            return "";
        }
        Attribute attribute = this.a.get(string);
        return attribute != null ? attribute.getValue() : "";
    }

    public String getIgnoreCase(String string) {
        Validate.notEmpty(string);
        if (this.a == null) {
            return "";
        }
        for (String string2 : this.a.keySet()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return this.a.get(string2).getValue();
        }
        return "";
    }

    public void put(String string, String string2) {
        Attribute attribute = new Attribute(string, string2);
        this.put(attribute);
    }

    public void put(String string, boolean bl) {
        if (bl) {
            this.put(new BooleanAttribute(string));
        } else {
            this.remove(string);
        }
    }

    public void put(Attribute attribute) {
        Validate.notNull(attribute);
        if (this.a == null) {
            this.a = new LinkedHashMap(2);
        }
        this.a.put(attribute.getKey(), attribute);
    }

    public void remove(String string) {
        Validate.notEmpty(string);
        if (this.a == null) {
            return;
        }
        this.a.remove(string);
    }

    public void removeIgnoreCase(String string) {
        Validate.notEmpty(string);
        if (this.a == null) {
            return;
        }
        for (String string2 : this.a.keySet()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            this.a.remove(string2);
        }
    }

    public boolean hasKey(String string) {
        return this.a != null && this.a.containsKey(string);
    }

    public boolean hasKeyIgnoreCase(String string) {
        if (this.a == null) {
            return false;
        }
        for (String string2 : this.a.keySet()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        if (this.a == null) {
            return 0;
        }
        return this.a.size();
    }

    public void addAll(Attributes attributes) {
        if (attributes.size() == 0) {
            return;
        }
        if (this.a == null) {
            this.a = new LinkedHashMap(attributes.size());
        }
        this.a.putAll(attributes.a);
    }

    @Override
    public Iterator<Attribute> iterator() {
        if (this.a == null || this.a.isEmpty()) {
            return Collections.emptyList().iterator();
        }
        return this.a.values().iterator();
    }

    public List<Attribute> asList() {
        if (this.a == null) {
            return Collections.emptyList();
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(this.a.size());
        for (Map.Entry<String, Attribute> entry : this.a.entrySet()) {
            arrayList.add(entry.getValue());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Map<String, String> dataset() {
        return new a();
    }

    public String html() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            this.a(stringBuilder, new Document("").outputSettings());
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
        return stringBuilder.toString();
    }

    void a(Appendable appendable, Document.OutputSettings outputSettings) throws IOException {
        if (this.a == null) {
            return;
        }
        for (Map.Entry<String, Attribute> entry : this.a.entrySet()) {
            Attribute attribute = entry.getValue();
            appendable.append(" ");
            attribute.html(appendable, outputSettings);
        }
    }

    public String toString() {
        return this.html();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Attributes)) {
            return false;
        }
        Attributes attributes = (Attributes)object;
        return !(this.a == null ? attributes.a != null : !this.a.equals(attributes.a));
    }

    public int hashCode() {
        return this.a != null ? this.a.hashCode() : 0;
    }

    public Attributes clone() {
        Attributes attributes;
        if (this.a == null) {
            return new Attributes();
        }
        try {
            attributes = (Attributes)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
        attributes.a = new LinkedHashMap(this.a.size());
        for (Attribute attribute : this) {
            attributes.a.put(attribute.getKey(), attribute.clone());
        }
        return attributes;
    }

    private static String dataKey(String string) {
        return dataPrefix + string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class org.jsoup.nodes.Attributes$a
    extends AbstractMap<String, String> {
        private org.jsoup.nodes.Attributes$a() {
            if (Attributes.this.a == null) {
                Attributes.this.a = new LinkedHashMap(2);
            }
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return new b();
        }

        public String a(String string, String string2) {
            String string3 = Attributes.dataKey(string);
            String string4 = Attributes.this.hasKey(string3) ? ((Attribute)Attributes.this.a.get(string3)).getValue() : null;
            Attribute attribute = new Attribute(string3, string2);
            Attributes.this.a.put(string3, attribute);
            return string4;
        }

        @Override
        public /* synthetic */ Object put(Object object, Object object2) {
            return this.a((String)object, (String)object2);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         * Duplicate member names - consider using --renamedupmembers true
         */
        class a
        implements Iterator<Map.Entry<String, String>> {
            private Iterator<Attribute> a;
            private Attribute a;

            private a() {
                this.a = Attributes.this.a.values().iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.a.hasNext()) {
                    this.a = this.a.next();
                    if (!this.a.isDataAttribute()) continue;
                    return true;
                }
                return false;
            }

            public Map.Entry<String, String> a() {
                return new Attribute(this.a.getKey().substring(Attributes.dataPrefix.length()), this.a.getValue());
            }

            @Override
            public void remove() {
                Attributes.this.a.remove(this.a.getKey());
            }

            @Override
            public /* synthetic */ Object next() {
                return this.a();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class b
        extends AbstractSet<Map.Entry<String, String>> {
            private b() {
            }

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                return new a();
            }

            @Override
            public int size() {
                int n = 0;
                a a2 = new a();
                while (a2.hasNext()) {
                    ++n;
                }
                return n;
            }
        }
    }
}

