/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import org.jsoup.helper.StringUtil;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.nodes.XmlDeclaration;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Document
extends Element {
    private OutputSettings a;
    private QuirksMode a;
    private String b;
    private boolean a = false;

    public Document(String string) {
        super(Tag.valueOf("#root", ParseSettings.htmlDefault), string);
        this.b = string;
    }

    public static Document createShell(String string) {
        Validate.notNull(string);
        Document document = new Document(string);
        Element element = document.appendElement("html");
        element.appendElement("head");
        element.appendElement("body");
        return document;
    }

    public String location() {
        return this.b;
    }

    public Element head() {
        return this.a("head", (Node)this);
    }

    public Element body() {
        return this.a("body", (Node)this);
    }

    public String title() {
        Element element = this.getElementsByTag("title").first();
        return element != null ? StringUtil.normaliseWhitespace(element.text()).trim() : "";
    }

    public void title(String string) {
        Validate.notNull(string);
        Element element = this.getElementsByTag("title").first();
        if (element == null) {
            this.head().appendElement("title").text(string);
        } else {
            element.text(string);
        }
    }

    public Element createElement(String string) {
        return new Element(Tag.valueOf(string, ParseSettings.preserveCase), this.baseUri());
    }

    public Document normalise() {
        Element element = this.a("html", (Node)this);
        if (element == null) {
            element = this.appendElement("html");
        }
        if (this.head() == null) {
            element.prependElement("head");
        }
        if (this.body() == null) {
            element.appendElement("body");
        }
        this.a(this.head());
        this.a(element);
        this.a(this);
        this.a("head", element);
        this.a("body", element);
        this.a();
        return this;
    }

    private void a(Element element) {
        Node node;
        ArrayList<TextNode> arrayList = new ArrayList<TextNode>();
        Iterator iterator = element.a.iterator();
        while (iterator.hasNext()) {
            TextNode textNode;
            node = (Node)iterator.next();
            if (!(node instanceof TextNode) || (textNode = (TextNode)node).isBlank()) continue;
            arrayList.add(textNode);
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            node = (Node)arrayList.get(i);
            element.removeChild(node);
            this.body().prependChild(new TextNode(" ", ""));
            this.body().prependChild(node);
        }
    }

    private void a(String string, Element element) {
        Elements elements = this.getElementsByTag(string);
        Element element2 = elements.first();
        if (elements.size() > 1) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (int i = 1; i < elements.size(); ++i) {
                Node node = (Node)elements.get(i);
                Iterator iterator = node.a.iterator();
                while (iterator.hasNext()) {
                    Node node2 = (Node)iterator.next();
                    arrayList.add(node2);
                }
                node.remove();
            }
            for (Node node : arrayList) {
                element2.appendChild(node);
            }
        }
        if (!element2.parent().equals(element)) {
            element.appendChild(element2);
        }
    }

    private Element a(String string, Node node) {
        if (node.nodeName().equals(string)) {
            return (Element)node;
        }
        Iterator iterator = node.a.iterator();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            Element element = this.a(string, node2);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    public String outerHtml() {
        return super.html();
    }

    public Element text(String string) {
        this.body().text(string);
        return this;
    }

    public String nodeName() {
        return "#document";
    }

    public void charset(Charset charset) {
        this.updateMetaCharsetElement(true);
        this.a.charset(charset);
        this.a();
    }

    public Charset charset() {
        return this.a.charset();
    }

    public void updateMetaCharsetElement(boolean bl) {
        this.a = bl;
    }

    public boolean updateMetaCharsetElement() {
        return this.a;
    }

    public Document clone() {
        Document document = (Document)super.clone();
        document.a = this.a.clone();
        return document;
    }

    private void a() {
        if (this.a) {
            OutputSettings.Syntax syntax = this.outputSettings().syntax();
            if (syntax == OutputSettings.Syntax.html) {
                Element element = this.select("meta[charset]").first();
                if (element != null) {
                    element.attr("charset", this.charset().displayName());
                } else {
                    Element element2 = this.head();
                    if (element2 != null) {
                        element2.appendElement("meta").attr("charset", this.charset().displayName());
                    }
                }
                this.select("meta[name=charset]").remove();
            } else if (syntax == OutputSettings.Syntax.xml) {
                Node node = this.childNodes().get(0);
                if (node instanceof XmlDeclaration) {
                    XmlDeclaration xmlDeclaration = (XmlDeclaration)node;
                    if (xmlDeclaration.name().equals("xml")) {
                        xmlDeclaration.attr("encoding", this.charset().displayName());
                        String string = xmlDeclaration.attr("version");
                        if (string != null) {
                            xmlDeclaration.attr("version", "1.0");
                        }
                    } else {
                        xmlDeclaration = new XmlDeclaration("xml", (String)((Object)this.a), false);
                        xmlDeclaration.attr("version", "1.0");
                        xmlDeclaration.attr("encoding", this.charset().displayName());
                        this.prependChild(xmlDeclaration);
                    }
                } else {
                    XmlDeclaration xmlDeclaration = new XmlDeclaration("xml", (String)((Object)this.a), false);
                    xmlDeclaration.attr("version", "1.0");
                    xmlDeclaration.attr("encoding", this.charset().displayName());
                    this.prependChild(xmlDeclaration);
                }
            }
        }
    }

    public OutputSettings outputSettings() {
        return this.a;
    }

    public Document outputSettings(OutputSettings outputSettings) {
        Validate.notNull(outputSettings);
        this.a = outputSettings;
        return this;
    }

    public QuirksMode quirksMode() {
        return this.a;
    }

    public Document quirksMode(QuirksMode quirksMode) {
        this.a = quirksMode;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QuirksMode {
        noQuirks,
        quirks,
        limitedQuirks;

    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static class OutputSettings
    implements Cloneable {
        private Entities.EscapeMode a;
        private Charset a;
        private boolean a;
        private boolean b = false;
        private int a;
        private Syntax a = Syntax.html;

        public Entities.EscapeMode escapeMode() {
            return this.a;
        }

        public OutputSettings escapeMode(Entities.EscapeMode escapeMode) {
            this.a = escapeMode;
            return this;
        }

        public Charset charset() {
            return this.a;
        }

        public OutputSettings charset(Charset charset) {
            this.a = charset;
            return this;
        }

        public OutputSettings charset(String string) {
            this.charset(Charset.forName(string));
            return this;
        }

        CharsetEncoder a() {
            return this.a.newEncoder();
        }

        public Syntax syntax() {
            return this.a;
        }

        public OutputSettings syntax(Syntax syntax) {
            this.a = syntax;
            return this;
        }

        public boolean prettyPrint() {
            return this.a;
        }

        public OutputSettings prettyPrint(boolean bl) {
            this.a = bl;
            return this;
        }

        public boolean outline() {
            return this.b;
        }

        public OutputSettings outline(boolean bl) {
            this.b = bl;
            return this;
        }

        public int indentAmount() {
            return this.a;
        }

        public OutputSettings indentAmount(int n) {
            Validate.isTrue(n >= 0);
            this.a = n;
            return this;
        }

        public OutputSettings clone() {
            OutputSettings outputSettings;
            try {
                outputSettings = (OutputSettings)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
            outputSettings.charset(this.a.name());
            outputSettings.a = Entities.EscapeMode.valueOf(this.a.name());
            return outputSettings;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Syntax {
            html,
            xml;

        }
    }
}

