/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jsoup.helper.StringUtil;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.select.Collector;
import org.jsoup.select.Elements;
import org.jsoup.select.Evaluator;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.jsoup.select.Selector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Element
extends Node {
    private Tag a;
    private static final Pattern a = Pattern.compile("\\s+");

    public Element(Tag tag, String string, Attributes attributes) {
        super(string, attributes);
        Validate.notNull(tag);
        this.a = tag;
    }

    public Element(Tag tag, String string) {
        this(tag, string, new Attributes());
    }

    @Override
    public String nodeName() {
        return this.a.getName();
    }

    public String tagName() {
        return this.a.getName();
    }

    public Element tagName(String string) {
        Validate.notEmpty(string, "Tag name must not be empty.");
        this.a = Tag.valueOf(string, ParseSettings.preserveCase);
        return this;
    }

    public Tag tag() {
        return this.a;
    }

    public boolean isBlock() {
        return this.a.isBlock();
    }

    public String id() {
        return ((Attributes)((Object)this.a)).getIgnoreCase("id");
    }

    @Override
    public Element attr(String string, String string2) {
        super.attr(string, string2);
        return this;
    }

    public Element attr(String string, boolean bl) {
        ((Attributes)((Object)this.a)).put(string, bl);
        return this;
    }

    public Map<String, String> dataset() {
        return ((Attributes)((Object)this.a)).dataset();
    }

    @Override
    public final Element parent() {
        return (Element)((Object)this.a);
    }

    public Elements parents() {
        Elements elements = new Elements();
        Element.accumulateParents(this, elements);
        return elements;
    }

    private static void accumulateParents(Element element, Elements elements) {
        Element element2 = element.parent();
        if (element2 != null && !element2.tagName().equals("#root")) {
            elements.add(element2);
            Element.accumulateParents(element2, elements);
        }
    }

    public Element child(int n) {
        return (Element)this.children().get(n);
    }

    public Elements children() {
        ArrayList<Element> arrayList = new ArrayList<Element>(this.a.size());
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!(node instanceof Element)) continue;
            arrayList.add((Element)node);
        }
        return new Elements((List<Element>)arrayList);
    }

    public List<TextNode> textNodes() {
        ArrayList<TextNode> arrayList = new ArrayList<TextNode>();
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!(node instanceof TextNode)) continue;
            arrayList.add((TextNode)node);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List<DataNode> dataNodes() {
        ArrayList<DataNode> arrayList = new ArrayList<DataNode>();
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!(node instanceof DataNode)) continue;
            arrayList.add((DataNode)node);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Elements select(String string) {
        return Selector.select(string, this);
    }

    public Element appendChild(Node node) {
        Validate.notNull(node);
        this.reparentChild(node);
        this.ensureChildNodes();
        this.a.add(node);
        node.setSiblingIndex(this.a.size() - 1);
        return this;
    }

    public Element prependChild(Node node) {
        Validate.notNull(node);
        this.addChildren(0, node);
        return this;
    }

    public Element insertChildren(int n, Collection<? extends Node> collection) {
        Validate.notNull(collection, "Children collection to be inserted must not be null.");
        int n2 = this.childNodeSize();
        if (n < 0) {
            n += n2 + 1;
        }
        Validate.isTrue(n >= 0 && n <= n2, "Insert position out of bounds.");
        ArrayList<? extends Node> arrayList = new ArrayList<Node>(collection);
        Node[] nodeArray = arrayList.toArray(new Node[arrayList.size()]);
        this.addChildren(n, nodeArray);
        return this;
    }

    public Element appendElement(String string) {
        Element element = new Element(Tag.valueOf(string), this.baseUri());
        this.appendChild(element);
        return element;
    }

    public Element prependElement(String string) {
        Element element = new Element(Tag.valueOf(string), this.baseUri());
        this.prependChild(element);
        return element;
    }

    public Element appendText(String string) {
        Validate.notNull(string);
        TextNode textNode = new TextNode(string, this.baseUri());
        this.appendChild(textNode);
        return this;
    }

    public Element prependText(String string) {
        Validate.notNull(string);
        TextNode textNode = new TextNode(string, this.baseUri());
        this.prependChild(textNode);
        return this;
    }

    public Element append(String string) {
        Validate.notNull(string);
        List<Node> list = Parser.parseFragment(string, this, this.baseUri());
        this.addChildren(list.toArray(new Node[list.size()]));
        return this;
    }

    public Element prepend(String string) {
        Validate.notNull(string);
        List<Node> list = Parser.parseFragment(string, this, this.baseUri());
        this.addChildren(0, list.toArray(new Node[list.size()]));
        return this;
    }

    @Override
    public Element before(String string) {
        return (Element)super.before(string);
    }

    @Override
    public Element before(Node node) {
        return (Element)super.before(node);
    }

    @Override
    public Element after(String string) {
        return (Element)super.after(string);
    }

    @Override
    public Element after(Node node) {
        return (Element)super.after(node);
    }

    public Element empty() {
        this.a.clear();
        return this;
    }

    @Override
    public Element wrap(String string) {
        return (Element)super.wrap(string);
    }

    public String cssSelector() {
        if (this.id().length() > 0) {
            return "#" + this.id();
        }
        String string = this.tagName().replace(':', '|');
        StringBuilder stringBuilder = new StringBuilder(string);
        String string2 = StringUtil.join(this.classNames(), ".");
        if (string2.length() > 0) {
            stringBuilder.append('.').append(string2);
        }
        if (this.parent() == null || this.parent() instanceof Document) {
            return stringBuilder.toString();
        }
        stringBuilder.insert(0, " > ");
        if (this.parent().select(stringBuilder.toString()).size() > 1) {
            stringBuilder.append(String.format(":nth-child(%d)", this.elementSiblingIndex() + 1));
        }
        return this.parent().cssSelector() + stringBuilder.toString();
    }

    public Elements siblingElements() {
        if (this.a == null) {
            return new Elements(0);
        }
        Elements elements = this.parent().children();
        Elements elements2 = new Elements(elements.size() - 1);
        for (Element element : elements) {
            if (element == this) continue;
            elements2.add(element);
        }
        return elements2;
    }

    public Element nextElementSibling() {
        if (this.a == null) {
            return null;
        }
        Elements elements = this.parent().children();
        Integer n = Element.indexInList(this, elements);
        Validate.notNull(n);
        if (elements.size() > n + 1) {
            return (Element)elements.get(n + 1);
        }
        return null;
    }

    public Element previousElementSibling() {
        if (this.a == null) {
            return null;
        }
        Elements elements = this.parent().children();
        Integer n = Element.indexInList(this, elements);
        Validate.notNull(n);
        if (n > 0) {
            return (Element)elements.get(n - 1);
        }
        return null;
    }

    public Element firstElementSibling() {
        Elements elements = this.parent().children();
        return elements.size() > 1 ? (Element)elements.get(0) : null;
    }

    public Integer elementSiblingIndex() {
        if (this.parent() == null) {
            return 0;
        }
        return Element.indexInList(this, this.parent().children());
    }

    public Element lastElementSibling() {
        Elements elements = this.parent().children();
        return elements.size() > 1 ? (Element)elements.get(elements.size() - 1) : null;
    }

    private static <E extends Element> Integer indexInList(Element element, List<E> list) {
        Validate.notNull(element);
        Validate.notNull(list);
        for (int i = 0; i < list.size(); ++i) {
            Element element2 = (Element)list.get(i);
            if (element2 != element) continue;
            return i;
        }
        return null;
    }

    public Elements getElementsByTag(String string) {
        Validate.notEmpty(string);
        string = string.toLowerCase().trim();
        return Collector.collect(new Evaluator.Tag(string), this);
    }

    public Element getElementById(String string) {
        Validate.notEmpty(string);
        Elements elements = Collector.collect(new Evaluator.Id(string), this);
        if (elements.size() > 0) {
            return (Element)elements.get(0);
        }
        return null;
    }

    public Elements getElementsByClass(String string) {
        Validate.notEmpty(string);
        return Collector.collect(new Evaluator.Class(string), this);
    }

    public Elements getElementsByAttribute(String string) {
        Validate.notEmpty(string);
        string = string.trim();
        return Collector.collect(new Evaluator.Attribute(string), this);
    }

    public Elements getElementsByAttributeStarting(String string) {
        Validate.notEmpty(string);
        string = string.trim();
        return Collector.collect(new Evaluator.AttributeStarting(string), this);
    }

    public Elements getElementsByAttributeValue(String string, String string2) {
        return Collector.collect(new Evaluator.AttributeWithValue(string, string2), this);
    }

    public Elements getElementsByAttributeValueNot(String string, String string2) {
        return Collector.collect(new Evaluator.AttributeWithValueNot(string, string2), this);
    }

    public Elements getElementsByAttributeValueStarting(String string, String string2) {
        return Collector.collect(new Evaluator.AttributeWithValueStarting(string, string2), this);
    }

    public Elements getElementsByAttributeValueEnding(String string, String string2) {
        return Collector.collect(new Evaluator.AttributeWithValueEnding(string, string2), this);
    }

    public Elements getElementsByAttributeValueContaining(String string, String string2) {
        return Collector.collect(new Evaluator.AttributeWithValueContaining(string, string2), this);
    }

    public Elements getElementsByAttributeValueMatching(String string, Pattern pattern) {
        return Collector.collect(new Evaluator.AttributeWithValueMatching(string, pattern), this);
    }

    public Elements getElementsByAttributeValueMatching(String string, String string2) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(string2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Pattern syntax error: " + string2, patternSyntaxException);
        }
        return this.getElementsByAttributeValueMatching(string, pattern);
    }

    public Elements getElementsByIndexLessThan(int n) {
        return Collector.collect(new Evaluator.IndexLessThan(n), this);
    }

    public Elements getElementsByIndexGreaterThan(int n) {
        return Collector.collect(new Evaluator.IndexGreaterThan(n), this);
    }

    public Elements getElementsByIndexEquals(int n) {
        return Collector.collect(new Evaluator.IndexEquals(n), this);
    }

    public Elements getElementsContainingText(String string) {
        return Collector.collect(new Evaluator.ContainsText(string), this);
    }

    public Elements getElementsContainingOwnText(String string) {
        return Collector.collect(new Evaluator.ContainsOwnText(string), this);
    }

    public Elements getElementsMatchingText(Pattern pattern) {
        return Collector.collect(new Evaluator.Matches(pattern), this);
    }

    public Elements getElementsMatchingText(String string) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Pattern syntax error: " + string, patternSyntaxException);
        }
        return this.getElementsMatchingText(pattern);
    }

    public Elements getElementsMatchingOwnText(Pattern pattern) {
        return Collector.collect(new Evaluator.MatchesOwn(pattern), this);
    }

    public Elements getElementsMatchingOwnText(String string) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Pattern syntax error: " + string, patternSyntaxException);
        }
        return this.getElementsMatchingOwnText(pattern);
    }

    public Elements getAllElements() {
        return Collector.collect(new Evaluator.AllElements(), this);
    }

    public String text() {
        final StringBuilder stringBuilder = new StringBuilder();
        new NodeTraversor(new NodeVisitor(){

            public void head(Node node, int n) {
                if (node instanceof TextNode) {
                    TextNode textNode = (TextNode)node;
                    Element.appendNormalisedText(stringBuilder, textNode);
                } else if (node instanceof Element) {
                    Element element = (Element)node;
                    if (stringBuilder.length() > 0 && (element.isBlock() || element.a.getName().equals("br")) && !TextNode.lastCharIsWhitespace(stringBuilder)) {
                        stringBuilder.append(" ");
                    }
                }
            }

            public void tail(Node node, int n) {
            }
        }).traverse(this);
        return stringBuilder.toString().trim();
    }

    public String ownText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.a(stringBuilder);
        return stringBuilder.toString().trim();
    }

    private void a(StringBuilder stringBuilder) {
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node instanceof TextNode) {
                TextNode textNode = (TextNode)node;
                Element.appendNormalisedText(stringBuilder, textNode);
                continue;
            }
            if (!(node instanceof Element)) continue;
            Element.appendWhitespaceIfBr((Element)node, stringBuilder);
        }
    }

    private static void appendNormalisedText(StringBuilder stringBuilder, TextNode textNode) {
        String string = textNode.getWholeText();
        if (Element.preserveWhitespace(textNode.a)) {
            stringBuilder.append(string);
        } else {
            StringUtil.appendNormalisedWhitespace(stringBuilder, string, TextNode.lastCharIsWhitespace(stringBuilder));
        }
    }

    private static void appendWhitespaceIfBr(Element element, StringBuilder stringBuilder) {
        if (element.a.getName().equals("br") && !TextNode.lastCharIsWhitespace(stringBuilder)) {
            stringBuilder.append(" ");
        }
    }

    static boolean preserveWhitespace(Node node) {
        if (node != null && node instanceof Element) {
            Element element = (Element)node;
            return element.a.preserveWhitespace() || element.parent() != null && element.parent().a.preserveWhitespace();
        }
        return false;
    }

    public Element text(String string) {
        Validate.notNull(string);
        this.empty();
        TextNode textNode = new TextNode(string, (String)((Object)this.a));
        this.appendChild(textNode);
        return this;
    }

    public boolean hasText() {
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            Node node;
            Node node2 = (Node)iterator.next();
            if (!(node2 instanceof TextNode ? !((TextNode)(node = (TextNode)node2)).isBlank() : node2 instanceof Element && ((Element)(node = (Element)node2)).hasText())) continue;
            return true;
        }
        return false;
    }

    public String data() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            Node node;
            Node node2 = (Node)iterator.next();
            if (node2 instanceof DataNode) {
                node = (DataNode)node2;
                stringBuilder.append(((DataNode)node).getWholeData());
                continue;
            }
            if (!(node2 instanceof Element)) continue;
            node = (Element)node2;
            String string = ((Element)node).data();
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String className() {
        return this.attr("class").trim();
    }

    public Set<String> classNames() {
        String[] stringArray = a.split(this.className());
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(stringArray));
        linkedHashSet.remove("");
        return linkedHashSet;
    }

    public Element classNames(Set<String> set) {
        Validate.notNull(set);
        ((Attributes)((Object)this.a)).put("class", StringUtil.join(set, " "));
        return this;
    }

    public boolean hasClass(String string) {
        String string2 = ((Attributes)((Object)this.a)).get("class");
        int n = string2.length();
        int n2 = string.length();
        if (n == 0 || n < n2) {
            return false;
        }
        if (n == n2) {
            return string.equalsIgnoreCase(string2);
        }
        boolean bl = false;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string2.charAt(i))) {
                if (!bl) continue;
                if (i - n3 == n2 && string2.regionMatches(true, n3, string, 0, n2)) {
                    return true;
                }
                bl = false;
                continue;
            }
            if (bl) continue;
            bl = true;
            n3 = i;
        }
        if (bl && n - n3 == n2) {
            return string2.regionMatches(true, n3, string, 0, n2);
        }
        return false;
    }

    public Element addClass(String string) {
        Validate.notNull(string);
        Set<String> set = this.classNames();
        set.add(string);
        this.classNames(set);
        return this;
    }

    public Element removeClass(String string) {
        Validate.notNull(string);
        Set<String> set = this.classNames();
        set.remove(string);
        this.classNames(set);
        return this;
    }

    public Element toggleClass(String string) {
        Validate.notNull(string);
        Set<String> set = this.classNames();
        if (set.contains(string)) {
            set.remove(string);
        } else {
            set.add(string);
        }
        this.classNames(set);
        return this;
    }

    public String val() {
        if (this.tagName().equals("textarea")) {
            return this.text();
        }
        return this.attr("value");
    }

    public Element val(String string) {
        if (this.tagName().equals("textarea")) {
            this.text(string);
        } else {
            this.attr("value", string);
        }
        return this;
    }

    @Override
    void a(Appendable appendable, int n, Document.OutputSettings outputSettings) throws IOException {
        if (outputSettings.prettyPrint() && (this.a.formatAsBlock() || this.parent() != null && this.parent().tag().formatAsBlock() || outputSettings.outline())) {
            if (appendable instanceof StringBuilder) {
                if (((StringBuilder)appendable).length() > 0) {
                    this.indent(appendable, n, outputSettings);
                }
            } else {
                this.indent(appendable, n, outputSettings);
            }
        }
        appendable.append("<").append(this.tagName());
        ((Attributes)((Object)this.a)).a(appendable, outputSettings);
        if (this.a.isEmpty() && this.a.isSelfClosing()) {
            if (outputSettings.syntax() == Document.OutputSettings.Syntax.html && this.a.isEmpty()) {
                appendable.append('>');
            } else {
                appendable.append(" />");
            }
        } else {
            appendable.append(">");
        }
    }

    @Override
    void b(Appendable appendable, int n, Document.OutputSettings outputSettings) throws IOException {
        if (!this.a.isEmpty() || !this.a.isSelfClosing()) {
            if (outputSettings.prettyPrint() && !this.a.isEmpty() && (this.a.formatAsBlock() || outputSettings.outline() && (this.a.size() > 1 || this.a.size() == 1 && !(this.a.get(0) instanceof TextNode)))) {
                this.indent(appendable, n, outputSettings);
            }
            appendable.append("</").append(this.tagName()).append(">");
        }
    }

    public String html() {
        StringBuilder stringBuilder = new StringBuilder();
        this.b(stringBuilder);
        return this.a().prettyPrint() ? stringBuilder.toString().trim() : stringBuilder.toString();
    }

    private void b(StringBuilder stringBuilder) {
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            node.outerHtml(stringBuilder);
        }
    }

    @Override
    public <T extends Appendable> T html(T t) {
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            node.outerHtml(t);
        }
        return t;
    }

    public Element html(String string) {
        this.empty();
        this.append(string);
        return this;
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    @Override
    public Element clone() {
        return (Element)super.clone();
    }
}

