/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.SerializationException;
import org.jsoup.helper.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Entities {
    private static Pattern a = Pattern.compile("^(\\w+)=(\\w+)(?:,(\\w+))?;(\\w+)$");
    private static final HashMap<String, String> a;

    private Entities() {
    }

    public static boolean isNamedEntity(String string) {
        return EscapeMode.extended.a(string) != -1;
    }

    public static boolean isBaseNamedEntity(String string) {
        return EscapeMode.base.a(string) != -1;
    }

    public static Character getCharacterByName(String string) {
        return Character.valueOf((char)EscapeMode.extended.a(string));
    }

    public static String getByName(String string) {
        String string2 = (String)((HashMap)((Object)a)).get(string);
        if (string2 != null) {
            return string2;
        }
        int n = EscapeMode.extended.a(string);
        if (n != -1) {
            return new String(new int[]{n}, 0, 1);
        }
        return "";
    }

    public static int codepointsForName(String string, int[] nArray) {
        String string2 = (String)((HashMap)((Object)a)).get(string);
        if (string2 != null) {
            nArray[0] = string2.codePointAt(0);
            nArray[1] = string2.codePointAt(1);
            return 2;
        }
        int n = EscapeMode.extended.a(string);
        if (n != -1) {
            nArray[0] = n;
            return 1;
        }
        return 0;
    }

    static String escape(String string, Document.OutputSettings outputSettings) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        try {
            Entities.escape(stringBuilder, string, outputSettings, false, false, false);
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
        return stringBuilder.toString();
    }

    static void escape(Appendable appendable, String string, Document.OutputSettings outputSettings, boolean bl, boolean bl2, boolean bl3) throws IOException {
        int n;
        boolean bl4 = false;
        boolean bl5 = false;
        EscapeMode escapeMode = outputSettings.escapeMode();
        CharsetEncoder charsetEncoder = outputSettings.a();
        a a2 = org.jsoup.nodes.Entities$a.b(charsetEncoder.charset().name());
        int n2 = string.length();
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (bl2) {
                if (StringUtil.isWhitespace(n)) {
                    if (bl3 && !bl5 || bl4) continue;
                    appendable.append(' ');
                    bl4 = true;
                    continue;
                }
                bl4 = false;
                bl5 = true;
            }
            if (n < 65536) {
                char c2 = (char)n;
                switch (c2) {
                    case '&': {
                        appendable.append("&amp;");
                        break;
                    }
                    case '\u00a0': {
                        if (escapeMode != EscapeMode.xhtml) {
                            appendable.append("&nbsp;");
                            break;
                        }
                        appendable.append("&#xa0;");
                        break;
                    }
                    case '<': {
                        if (!bl || escapeMode == EscapeMode.xhtml) {
                            appendable.append("&lt;");
                            break;
                        }
                        appendable.append(c2);
                        break;
                    }
                    case '>': {
                        if (!bl) {
                            appendable.append("&gt;");
                            break;
                        }
                        appendable.append(c2);
                        break;
                    }
                    case '\"': {
                        if (bl) {
                            appendable.append("&quot;");
                            break;
                        }
                        appendable.append(c2);
                        break;
                    }
                    default: {
                        if (Entities.canEncode(a2, c2, charsetEncoder)) {
                            appendable.append(c2);
                            break;
                        }
                        Entities.appendEncoded(appendable, escapeMode, n);
                        break;
                    }
                }
                continue;
            }
            String string2 = new String(Character.toChars(n));
            if (charsetEncoder.canEncode(string2)) {
                appendable.append(string2);
                continue;
            }
            Entities.appendEncoded(appendable, escapeMode, n);
        }
    }

    private static void appendEncoded(Appendable appendable, EscapeMode escapeMode, int n) throws IOException {
        String string = escapeMode.a(n);
        if (string != "") {
            appendable.append('&').append(string).append(';');
        } else {
            appendable.append("&#x").append(Integer.toHexString(n)).append(';');
        }
    }

    static String unescape(String string) {
        return Entities.unescape(string, false);
    }

    static String unescape(String string, boolean bl) {
        return Parser.unescapeEntities(string, bl);
    }

    private static boolean canEncode(a a2, char c2, CharsetEncoder charsetEncoder) {
        switch (1.a[a2.ordinal()]) {
            case 1: {
                return c2 < '\u0080';
            }
            case 2: {
                return true;
            }
        }
        return charsetEncoder.canEncode(c2);
    }

    private static void load(EscapeMode escapeMode, String string, int n) {
        EscapeMode.access$202(escapeMode, new String[n]);
        EscapeMode.access$302(escapeMode, new int[n]);
        EscapeMode.access$402(escapeMode, new int[n]);
        EscapeMode.access$502(escapeMode, new String[n]);
        InputStream inputStream = Entities.class.getResourceAsStream(string);
        if (inputStream == null) {
            throw new IllegalStateException("Could not read resource " + string + ". Make sure you copy resources for " + Entities.class.getCanonicalName());
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        int n2 = 0;
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                Matcher matcher = a.matcher(string2);
                if (!matcher.find()) continue;
                String string3 = matcher.group(1);
                int n3 = Integer.parseInt(matcher.group(2), 36);
                int n4 = matcher.group(3) != null ? Integer.parseInt(matcher.group(3), 36) : -1;
                int n5 = Integer.parseInt(matcher.group(4), 36);
                ((EscapeMode)escapeMode).a[n2] = string3;
                ((EscapeMode)escapeMode).a[n2] = n3;
                ((EscapeMode)escapeMode).b[n5] = n3;
                ((EscapeMode)escapeMode).b[n5] = string3;
                if (n4 != -1) {
                    ((HashMap)((Object)a)).put(string3, new String(new int[]{n3, n4}, 0, 2));
                }
                ++n2;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Error reading resource " + string);
        }
    }

    static {
        a = new HashMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a();
        public static final /* enum */ a b = new a();
        public static final /* enum */ a c = new a();
        private static final /* synthetic */ a[] a;

        public static a[] a() {
            return (a[])a.clone();
        }

        private static a b(String string) {
            if (string.equals("US-ASCII")) {
                return a;
            }
            if (string.startsWith("UTF-")) {
                return b;
            }
            return c;
        }

        static {
            a = new a[]{a, b, c};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static enum EscapeMode {
        xhtml("entities-xhtml.properties", 4),
        base("entities-base.properties", 106),
        extended("entities-full.properties", 2125);

        private String[] a;
        private int[] a;
        private int[] b;
        private String[] b;

        private EscapeMode(String string2, int n2) {
            Entities.load(this, string2, n2);
        }

        int a(String string) {
            int n = Arrays.binarySearch(this.a, string);
            return n >= 0 ? this.a[n] : -1;
        }

        String a(int n) {
            int n2 = Arrays.binarySearch(this.b, n);
            if (n2 >= 0) {
                return n2 < this.b.length - 1 && this.b[n2 + 1] == n ? this.b[n2 + 1] : this.b[n2];
            }
            return "";
        }

        static /* synthetic */ String[] access$202(EscapeMode escapeMode, String[] stringArray) {
            escapeMode.a = stringArray;
            return stringArray;
        }

        static /* synthetic */ int[] access$302(EscapeMode escapeMode, int[] nArray) {
            escapeMode.a = nArray;
            return nArray;
        }

        static /* synthetic */ int[] access$402(EscapeMode escapeMode, int[] nArray) {
            escapeMode.b = nArray;
            return nArray;
        }

        static /* synthetic */ String[] access$502(EscapeMode escapeMode, String[] stringArray) {
            escapeMode.b = stringArray;
            return stringArray;
        }
    }
}

