/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.util.ArrayList;
import java.util.List;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.helper.HttpConnection;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormElement
extends Element {
    private final Elements a = new Elements();

    public FormElement(Tag tag, String string, Attributes attributes) {
        super(tag, string, attributes);
    }

    public Elements elements() {
        return this.a;
    }

    public FormElement addElement(Element element) {
        this.a.add(element);
        return this;
    }

    public Connection submit() {
        String string = this.hasAttr("action") ? this.absUrl("action") : this.baseUri();
        Validate.notEmpty(string, "Could not determine a form action URL for submit. Ensure you set a base URI when parsing.");
        Connection.Method method = this.attr("method").toUpperCase().equals("POST") ? Connection.Method.POST : Connection.Method.GET;
        return Jsoup.connect(string).data(this.formData()).method(method);
    }

    public List<Connection.KeyVal> formData() {
        ArrayList<Connection.KeyVal> arrayList = new ArrayList<Connection.KeyVal>();
        for (Element element : this.a) {
            Object object;
            String string;
            if (!element.tag().isFormSubmittable() || element.hasAttr("disabled") || (string = element.attr("name")).length() == 0) continue;
            String string2 = element.attr("type");
            if ("select".equals(element.tagName())) {
                object = element.select("option[selected]");
                boolean bl = false;
                Object object2 = ((ArrayList)object).iterator();
                while (object2.hasNext()) {
                    Element element2 = (Element)object2.next();
                    arrayList.add(HttpConnection.KeyVal.create(string, element2.val()));
                    bl = true;
                }
                if (bl || (object2 = element.select("option").first()) == null) continue;
                arrayList.add(HttpConnection.KeyVal.create(string, ((Element)object2).val()));
                continue;
            }
            if ("checkbox".equalsIgnoreCase(string2) || "radio".equalsIgnoreCase(string2)) {
                if (!element.hasAttr("checked")) continue;
                object = element.val().length() > 0 ? element.val() : "on";
                arrayList.add(HttpConnection.KeyVal.create(string, (String)object));
                continue;
            }
            arrayList.add(HttpConnection.KeyVal.create(string, element.val()));
        }
        return arrayList;
    }
}

