/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jsoup.SerializationException;
import org.jsoup.helper.StringUtil;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class Node
implements Cloneable {
    private static final List<Node> b = Collections.emptyList();
    Node a;
    List<Node> a;
    Attributes a;
    String a;
    int a;

    protected Node(String string, Attributes attributes) {
        Validate.notNull(string);
        Validate.notNull(attributes);
        this.a = b;
        this.a = string.trim();
        this.a = attributes;
    }

    protected Node(String string) {
        this(string, new Attributes());
    }

    protected Node() {
        this.a = b;
        this.a = null;
    }

    public abstract String nodeName();

    public String attr(String string) {
        Validate.notNull(string);
        String string2 = this.a.getIgnoreCase(string);
        if (string2.length() > 0) {
            return string2;
        }
        if (string.toLowerCase().startsWith("abs:")) {
            return this.absUrl(string.substring("abs:".length()));
        }
        return "";
    }

    public Attributes attributes() {
        return this.a;
    }

    public Node attr(String string, String string2) {
        this.a.put(string, string2);
        return this;
    }

    public boolean hasAttr(String string) {
        String string2;
        Validate.notNull(string);
        if (string.startsWith("abs:") && this.a.hasKeyIgnoreCase(string2 = string.substring("abs:".length())) && !this.absUrl(string2).equals("")) {
            return true;
        }
        return this.a.hasKeyIgnoreCase(string);
    }

    public Node removeAttr(String string) {
        Validate.notNull(string);
        this.a.removeIgnoreCase(string);
        return this;
    }

    public String baseUri() {
        return this.a;
    }

    public void setBaseUri(final String string) {
        Validate.notNull(string);
        this.traverse(new NodeVisitor(){

            public void head(Node node, int n) {
                node.a = string;
            }

            public void tail(Node node, int n) {
            }
        });
    }

    public String absUrl(String string) {
        Validate.notEmpty(string);
        if (!this.hasAttr(string)) {
            return "";
        }
        return StringUtil.resolve(this.a, this.attr(string));
    }

    public Node childNode(int n) {
        return (Node)this.a.get(n);
    }

    public List<Node> childNodes() {
        return Collections.unmodifiableList(this.a);
    }

    public List<Node> childNodesCopy() {
        ArrayList<Node> arrayList = new ArrayList<Node>(this.a.size());
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            arrayList.add(node.clone());
        }
        return arrayList;
    }

    public final int childNodeSize() {
        return this.a.size();
    }

    protected Node[] childNodesAsArray() {
        return this.a.toArray(new Node[this.childNodeSize()]);
    }

    public Node parent() {
        return this.a;
    }

    public final Node parentNode() {
        return this.a;
    }

    public Document ownerDocument() {
        if (this instanceof Document) {
            return (Document)this;
        }
        if (this.a == null) {
            return null;
        }
        return this.a.ownerDocument();
    }

    public void remove() {
        Validate.notNull(this.a);
        this.a.removeChild(this);
    }

    public Node before(String string) {
        this.a(this.a, string);
        return this;
    }

    public Node before(Node node) {
        Validate.notNull(node);
        Validate.notNull(this.a);
        this.a.addChildren(this.a, node);
        return this;
    }

    public Node after(String string) {
        this.a(this.a + 1, string);
        return this;
    }

    public Node after(Node node) {
        Validate.notNull(node);
        Validate.notNull(this.a);
        this.a.addChildren(this.a + 1, node);
        return this;
    }

    private void a(int n, String string) {
        Validate.notNull(string);
        Validate.notNull(this.a);
        Element element = this.parent() instanceof Element ? (Element)this.parent() : null;
        List<Node> list = Parser.parseFragment(string, element, this.baseUri());
        this.a.addChildren(n, list.toArray(new Node[list.size()]));
    }

    public Node wrap(String string) {
        Validate.notEmpty(string);
        Element element = this.parent() instanceof Element ? (Element)this.parent() : null;
        List<Node> list = Parser.parseFragment(string, element, this.baseUri());
        Node node = list.get(0);
        if (node == null || !(node instanceof Element)) {
            return null;
        }
        Element element2 = (Element)node;
        Element element3 = this.a(element2);
        this.a.replaceChild(this, element2);
        element3.addChildren(this);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Node node2 = list.get(i);
                node2.a.removeChild(node2);
                element2.appendChild(node2);
            }
        }
        return this;
    }

    public Node unwrap() {
        Validate.notNull(this.a);
        Node node = this.a.size() > 0 ? (Node)this.a.get(0) : null;
        this.a.addChildren(this.a, this.childNodesAsArray());
        this.remove();
        return node;
    }

    private Element a(Element element) {
        Elements elements = element.children();
        if (elements.size() > 0) {
            return this.a((Element)elements.get(0));
        }
        return element;
    }

    public void replaceWith(Node node) {
        Validate.notNull(node);
        Validate.notNull(this.a);
        this.a.replaceChild(this, node);
    }

    protected void setParentNode(Node node) {
        if (this.a != null) {
            this.a.removeChild(this);
        }
        this.a = node;
    }

    protected void replaceChild(Node node, Node node2) {
        Validate.isTrue(node.a == this);
        Validate.notNull(node2);
        if (node2.a != null) {
            node2.a.removeChild(node2);
        }
        int n = node.a;
        this.a.set(n, node2);
        node2.a = this;
        node2.setSiblingIndex(n);
        node.a = null;
    }

    protected void removeChild(Node node) {
        Validate.isTrue(node.a == this);
        int n = node.a;
        this.a.remove(n);
        this.a(n);
        node.a = null;
    }

    protected void addChildren(Node ... nodeArray) {
        for (Node node : nodeArray) {
            this.reparentChild(node);
            this.ensureChildNodes();
            this.a.add(node);
            node.setSiblingIndex(this.a.size() - 1);
        }
    }

    protected void addChildren(int n, Node ... nodeArray) {
        Validate.noNullElements(nodeArray);
        this.ensureChildNodes();
        for (int i = nodeArray.length - 1; i >= 0; --i) {
            Node node = nodeArray[i];
            this.reparentChild(node);
            this.a.add(n, node);
            this.a(n);
        }
    }

    protected void ensureChildNodes() {
        if (this.a == b) {
            this.a = new ArrayList(4);
        }
    }

    protected void reparentChild(Node node) {
        if (node.a != null) {
            node.a.removeChild(node);
        }
        node.setParentNode(this);
    }

    private void a(int n) {
        for (int i = n; i < this.a.size(); ++i) {
            ((Node)this.a.get(i)).setSiblingIndex(i);
        }
    }

    public List<Node> siblingNodes() {
        if (this.a == null) {
            return Collections.emptyList();
        }
        Node node = this.a.a;
        ArrayList<Node> arrayList = new ArrayList<Node>(node.size() - 1);
        Iterator iterator = node.iterator();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            if (node2 == this) continue;
            arrayList.add(node2);
        }
        return arrayList;
    }

    public Node nextSibling() {
        if (this.a == null) {
            return null;
        }
        Node node = this.a.a;
        int n = this.a + 1;
        if (node.size() > n) {
            return (Node)node.get(n);
        }
        return null;
    }

    public Node previousSibling() {
        if (this.a == null) {
            return null;
        }
        if (this.a > 0) {
            return (Node)this.a.a.get(this.a - 1);
        }
        return null;
    }

    public int siblingIndex() {
        return this.a;
    }

    protected void setSiblingIndex(int n) {
        this.a = n;
    }

    public Node traverse(NodeVisitor nodeVisitor) {
        Validate.notNull(nodeVisitor);
        NodeTraversor nodeTraversor = new NodeTraversor(nodeVisitor);
        nodeTraversor.traverse(this);
        return this;
    }

    public String outerHtml() {
        StringBuilder stringBuilder = new StringBuilder(128);
        this.outerHtml(stringBuilder);
        return stringBuilder.toString();
    }

    protected void outerHtml(Appendable appendable) {
        new NodeTraversor(new a(appendable, this.a())).traverse(this);
    }

    Document.OutputSettings a() {
        return this.ownerDocument() != null ? this.ownerDocument().outputSettings() : new Document("").outputSettings();
    }

    abstract void a(Appendable var1, int var2, Document.OutputSettings var3) throws IOException;

    abstract void b(Appendable var1, int var2, Document.OutputSettings var3) throws IOException;

    public <T extends Appendable> T html(T t) {
        this.outerHtml(t);
        return t;
    }

    public String toString() {
        return this.outerHtml();
    }

    protected void indent(Appendable appendable, int n, Document.OutputSettings outputSettings) throws IOException {
        appendable.append("\n").append(StringUtil.padding(n * outputSettings.indentAmount()));
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public boolean hasSameValue(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.outerHtml().equals(((Node)object).outerHtml());
    }

    public Node clone() {
        Node node = this.doClone(null);
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.add(node);
        while (!linkedList.isEmpty()) {
            Node node2 = (Node)linkedList.remove();
            for (int i = 0; i < node2.a.size(); ++i) {
                Node node3 = ((Node)node2.a.get(i)).doClone(node2);
                node2.a.set(i, node3);
                linkedList.add(node3);
            }
        }
        return node;
    }

    protected Node doClone(Node node) {
        Node node2;
        try {
            node2 = (Node)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
        node2.a = node;
        node2.a = node == null ? 0 : this.a;
        node2.a = this.a != null ? this.a.clone() : null;
        node2.a = this.a;
        node2.a = new ArrayList(this.a.size());
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            Node node3 = (Node)iterator.next();
            node2.a.add(node3);
        }
        return node2;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    static class a
    implements NodeVisitor {
        private Appendable a;
        private Document.OutputSettings a;

        a(Appendable appendable, Document.OutputSettings outputSettings) {
            this.a = appendable;
            this.a = outputSettings;
        }

        public void head(Node node, int n) {
            try {
                node.a(this.a, n, this.a);
            }
            catch (IOException iOException) {
                throw new SerializationException(iOException);
            }
        }

        public void tail(Node node, int n) {
            if (!node.nodeName().equals("#text")) {
                try {
                    node.b(this.a, n, this.a);
                }
                catch (IOException iOException) {
                    throw new SerializationException(iOException);
                }
            }
        }
    }
}

