/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import org.jsoup.helper.StringUtil;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.Node;

public class TextNode
extends Node {
    String b;

    public TextNode(String string, String string2) {
        this.a = string2;
        this.b = string;
    }

    public String nodeName() {
        return "#text";
    }

    public String text() {
        return TextNode.normaliseWhitespace(this.getWholeText());
    }

    public TextNode text(String string) {
        this.b = string;
        if (this.a != null) {
            this.a.put("text", string);
        }
        return this;
    }

    public String getWholeText() {
        return this.a == null ? this.b : this.a.get("text");
    }

    public boolean isBlank() {
        return StringUtil.isBlank(this.getWholeText());
    }

    public TextNode splitText(int n) {
        Validate.isTrue(n >= 0, "Split offset must be not be negative");
        Validate.isTrue(n < this.b.length(), "Split offset must not be greater than current text length");
        String string = this.getWholeText().substring(0, n);
        String string2 = this.getWholeText().substring(n);
        this.text(string);
        TextNode textNode = new TextNode(string2, this.baseUri());
        if (this.parent() != null) {
            this.parent().addChildren(this.siblingIndex() + 1, textNode);
        }
        return textNode;
    }

    void a(Appendable appendable, int n, Document.OutputSettings outputSettings) throws IOException {
        if (outputSettings.prettyPrint() && (this.siblingIndex() == 0 && this.a instanceof Element && ((Element)this.a).tag().formatAsBlock() && !this.isBlank() || outputSettings.outline() && this.siblingNodes().size() > 0 && !this.isBlank())) {
            this.indent(appendable, n, outputSettings);
        }
        boolean bl = outputSettings.prettyPrint() && this.parent() instanceof Element && !Element.preserveWhitespace(this.parent());
        Entities.escape(appendable, this.getWholeText(), outputSettings, false, bl, false);
    }

    void b(Appendable appendable, int n, Document.OutputSettings outputSettings) {
    }

    public String toString() {
        return this.outerHtml();
    }

    public static TextNode createFromEncoded(String string, String string2) {
        String string3 = Entities.unescape(string);
        return new TextNode(string3, string2);
    }

    static String normaliseWhitespace(String string) {
        string = StringUtil.normaliseWhitespace(string);
        return string;
    }

    static String stripLeadingWhitespace(String string) {
        return string.replaceFirst("^\\s+", "");
    }

    static boolean lastCharIsWhitespace(StringBuilder stringBuilder) {
        return stringBuilder.length() != 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ' ';
    }

    private void a() {
        if (this.a == null) {
            this.a = new Attributes();
            this.a.put("text", this.b);
        }
    }

    public String attr(String string) {
        this.a();
        return super.attr(string);
    }

    public Attributes attributes() {
        this.a();
        return super.attributes();
    }

    public Node attr(String string, String string2) {
        this.a();
        return super.attr(string, string2);
    }

    public boolean hasAttr(String string) {
        this.a();
        return super.hasAttr(string);
    }

    public Node removeAttr(String string) {
        this.a();
        return super.removeAttr(string);
    }

    public String absUrl(String string) {
        this.a();
        return super.absUrl(string);
    }
}

