/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import org.jsoup.helper.StringUtil;
import org.jsoup.helper.Validate;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TokenQueue {
    private String a;
    private int a = 0;

    public TokenQueue(String string) {
        Validate.notNull(string);
        this.a = string;
    }

    public boolean isEmpty() {
        return this.a() == 0;
    }

    private int a() {
        return this.a.length() - this.a;
    }

    public char peek() {
        return this.isEmpty() ? (char)'\u0000' : this.a.charAt(this.a);
    }

    public void addFirst(Character c2) {
        this.addFirst(c2.toString());
    }

    public void addFirst(String string) {
        this.a = string + this.a.substring(this.a);
        this.a = 0;
    }

    public boolean matches(String string) {
        return this.a.regionMatches(true, this.a, string, 0, string.length());
    }

    public boolean matchesCS(String string) {
        return this.a.startsWith(string, this.a);
    }

    public boolean matchesAny(String ... stringArray) {
        for (String string : stringArray) {
            if (!this.matches(string)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesAny(char ... cArray) {
        if (this.isEmpty()) {
            return false;
        }
        for (char c2 : cArray) {
            if (this.a.charAt(this.a) != c2) continue;
            return true;
        }
        return false;
    }

    public boolean matchesStartTag() {
        return this.a() >= 2 && this.a.charAt(this.a) == '<' && Character.isLetter(this.a.charAt(this.a + 1));
    }

    public boolean matchChomp(String string) {
        if (this.matches(string)) {
            this.a += string.length();
            return true;
        }
        return false;
    }

    public boolean matchesWhitespace() {
        return !this.isEmpty() && StringUtil.isWhitespace(this.a.charAt(this.a));
    }

    public boolean matchesWord() {
        return !this.isEmpty() && Character.isLetterOrDigit(this.a.charAt(this.a));
    }

    public void advance() {
        if (!this.isEmpty()) {
            ++this.a;
        }
    }

    public char consume() {
        return this.a.charAt(this.a++);
    }

    public void consume(String string) {
        if (!this.matches(string)) {
            throw new IllegalStateException("Queue did not match expected sequence");
        }
        int n = string.length();
        if (n > this.a()) {
            throw new IllegalStateException("Queue not long enough to consume sequence");
        }
        this.a += n;
    }

    public String consumeTo(String string) {
        int n = this.a.indexOf(string, this.a);
        if (n != -1) {
            String string2 = this.a.substring(this.a, n);
            this.a += string2.length();
            return string2;
        }
        return this.remainder();
    }

    public String consumeToIgnoreCase(String string) {
        int n = this.a;
        String string2 = string.substring(0, 1);
        boolean bl = string2.toLowerCase().equals(string2.toUpperCase());
        while (!this.isEmpty() && !this.matches(string)) {
            if (bl) {
                int n2 = this.a.indexOf(string2, this.a) - this.a;
                if (n2 == 0) {
                    ++this.a;
                    continue;
                }
                if (n2 < 0) {
                    this.a = this.a.length();
                    continue;
                }
                this.a += n2;
                continue;
            }
            ++this.a;
        }
        return this.a.substring(n, this.a);
    }

    public String consumeToAny(String ... stringArray) {
        int n = this.a;
        while (!this.isEmpty() && !this.matchesAny(stringArray)) {
            ++this.a;
        }
        return this.a.substring(n, this.a);
    }

    public String chompTo(String string) {
        String string2 = this.consumeTo(string);
        this.matchChomp(string);
        return string2;
    }

    public String chompToIgnoreCase(String string) {
        String string2 = this.consumeToIgnoreCase(string);
        this.matchChomp(string);
        return string2;
    }

    public String chompBalanced(char c2, char c3) {
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        while (!this.isEmpty()) {
            block11: {
                Character c4;
                block10: {
                    c4 = Character.valueOf(this.consume());
                    if (n4 != 0 && n4 == 92) break block10;
                    if ((c4.equals(Character.valueOf('\'')) || c4.equals(Character.valueOf('\"'))) && c4.charValue() != c2) {
                        boolean bl2 = bl = !bl;
                    }
                    if (bl) break block11;
                    if (c4.equals(Character.valueOf(c2))) {
                        ++n3;
                        if (n == -1) {
                            n = this.a;
                        }
                    } else if (c4.equals(Character.valueOf(c3))) {
                        --n3;
                    }
                }
                if (n3 > 0 && n4 != 0) {
                    n2 = this.a;
                }
                n4 = c4.charValue();
            }
            if (n3 > 0) continue;
        }
        return n2 >= 0 ? this.a.substring(n, n2) : "";
    }

    public static String unescape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        char c2 = '\u0000';
        for (char c3 : string.toCharArray()) {
            if (c3 == '\\') {
                if (c2 != '\u0000' && c2 == '\\') {
                    stringBuilder.append(c3);
                }
            } else {
                stringBuilder.append(c3);
            }
            c2 = c3;
        }
        return stringBuilder.toString();
    }

    public boolean consumeWhitespace() {
        boolean bl = false;
        while (this.matchesWhitespace()) {
            ++this.a;
            bl = true;
        }
        return bl;
    }

    public String consumeWord() {
        int n = this.a;
        while (this.matchesWord()) {
            ++this.a;
        }
        return this.a.substring(n, this.a);
    }

    public String consumeTagName() {
        int n = this.a;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAny(':', '_', '-'))) {
            ++this.a;
        }
        return this.a.substring(n, this.a);
    }

    public String consumeElementSelector() {
        int n = this.a;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAny("*|", "|", "_", "-"))) {
            ++this.a;
        }
        return this.a.substring(n, this.a);
    }

    public String consumeCssIdentifier() {
        int n = this.a;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAny('-', '_'))) {
            ++this.a;
        }
        return this.a.substring(n, this.a);
    }

    public String consumeAttributeKey() {
        int n = this.a;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAny('-', '_', ':'))) {
            ++this.a;
        }
        return this.a.substring(n, this.a);
    }

    public String remainder() {
        String string = this.a.substring(this.a, this.a.length());
        this.a = this.a.length();
        return string;
    }

    public String toString() {
        return this.a.substring(this.a);
    }
}

