/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.safety;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Whitelist {
    private Set<d> a;
    private Map<d, Set<a>> a;
    private Map<d, Map<a, b>> b;
    private Map<d, Map<a, Set<c>>> c;
    private boolean a = false;

    public static Whitelist none() {
        return new Whitelist();
    }

    public static Whitelist simpleText() {
        return new Whitelist().addTags("b", "em", "i", "strong", "u");
    }

    public static Whitelist basic() {
        return new Whitelist().addTags("a", "b", "blockquote", "br", "cite", "code", "dd", "dl", "dt", "em", "i", "li", "ol", "p", "pre", "q", "small", "span", "strike", "strong", "sub", "sup", "u", "ul").addAttributes("a", "href").addAttributes("blockquote", "cite").addAttributes("q", "cite").addProtocols("a", "href", "ftp", "http", "https", "mailto").addProtocols("blockquote", "cite", "http", "https").addProtocols("cite", "cite", "http", "https").addEnforcedAttribute("a", "rel", "nofollow");
    }

    public static Whitelist basicWithImages() {
        return Whitelist.basic().addTags("img").addAttributes("img", "align", "alt", "height", "src", "title", "width").addProtocols("img", "src", "http", "https");
    }

    public static Whitelist relaxed() {
        return new Whitelist().addTags("a", "b", "blockquote", "br", "caption", "cite", "code", "col", "colgroup", "dd", "div", "dl", "dt", "em", "h1", "h2", "h3", "h4", "h5", "h6", "i", "img", "li", "ol", "p", "pre", "q", "small", "span", "strike", "strong", "sub", "sup", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "u", "ul").addAttributes("a", "href", "title").addAttributes("blockquote", "cite").addAttributes("col", "span", "width").addAttributes("colgroup", "span", "width").addAttributes("img", "align", "alt", "height", "src", "title", "width").addAttributes("ol", "start", "type").addAttributes("q", "cite").addAttributes("table", "summary", "width").addAttributes("td", "abbr", "axis", "colspan", "rowspan", "width").addAttributes("th", "abbr", "axis", "colspan", "rowspan", "scope", "width").addAttributes("ul", "type").addProtocols("a", "href", "ftp", "http", "https", "mailto").addProtocols("blockquote", "cite", "http", "https").addProtocols("cite", "cite", "http", "https").addProtocols("img", "src", "http", "https").addProtocols("q", "cite", "http", "https");
    }

    public Whitelist() {
        this.b = new HashMap<d, Map<a, b>>();
        this.c = new HashMap<d, Map<a, Set<c>>>();
    }

    public Whitelist addTags(String ... stringArray) {
        Validate.notNull(stringArray);
        for (String string : stringArray) {
            Validate.notEmpty(string);
            this.a.add(d.a(string));
        }
        return this;
    }

    public Whitelist removeTags(String ... stringArray) {
        Validate.notNull(stringArray);
        for (String string : stringArray) {
            Validate.notEmpty(string);
            d d2 = d.a(string);
            if (!this.a.remove(d2)) continue;
            this.a.remove(d2);
            this.b.remove(d2);
            this.c.remove(d2);
        }
        return this;
    }

    public Whitelist addAttributes(String string, String ... stringArray) {
        Validate.notEmpty(string);
        Validate.notNull(stringArray);
        Validate.isTrue(stringArray.length > 0, "No attributes supplied.");
        d d2 = d.a(string);
        if (!this.a.contains(d2)) {
            this.a.add(d2);
        }
        HashSet<a> hashSet = new HashSet<a>();
        for (String string2 : stringArray) {
            Validate.notEmpty(string2);
            hashSet.add(org.jsoup.safety.Whitelist$a.a(string2));
        }
        if (this.a.containsKey(d2)) {
            Set set = (Set)this.a.get(d2);
            set.addAll(hashSet);
        } else {
            this.a.put(d2, hashSet);
        }
        return this;
    }

    public Whitelist removeAttributes(String string, String ... stringArray) {
        Validate.notEmpty(string);
        Validate.notNull(stringArray);
        Validate.isTrue(stringArray.length > 0, "No attributes supplied.");
        d d2 = d.a(string);
        HashSet<a> hashSet = new HashSet<a>();
        for (String string2 : stringArray) {
            Validate.notEmpty(string2);
            hashSet.add(org.jsoup.safety.Whitelist$a.a(string2));
        }
        if (this.a.contains(d2) && this.a.containsKey(d2)) {
            Set set = (Set)this.a.get(d2);
            set.removeAll(hashSet);
            if (set.isEmpty()) {
                this.a.remove(d2);
            }
        }
        if (string.equals(":all")) {
            for (d d3 : this.a.keySet()) {
                Set set = (Set)this.a.get(d3);
                set.removeAll(hashSet);
                if (!set.isEmpty()) continue;
                this.a.remove(d3);
            }
        }
        return this;
    }

    public Whitelist addEnforcedAttribute(String string, String string2, String string3) {
        Validate.notEmpty(string);
        Validate.notEmpty(string2);
        Validate.notEmpty(string3);
        d d2 = d.a(string);
        if (!this.a.contains(d2)) {
            this.a.add(d2);
        }
        a a2 = org.jsoup.safety.Whitelist$a.a(string2);
        b b2 = org.jsoup.safety.Whitelist$b.a(string3);
        if (this.b.containsKey(d2)) {
            this.b.get(d2).put(a2, b2);
        } else {
            HashMap<a, b> hashMap = new HashMap<a, b>();
            hashMap.put(a2, b2);
            this.b.put(d2, hashMap);
        }
        return this;
    }

    public Whitelist removeEnforcedAttribute(String string, String string2) {
        Validate.notEmpty(string);
        Validate.notEmpty(string2);
        d d2 = d.a(string);
        if (this.a.contains(d2) && this.b.containsKey(d2)) {
            a a2 = org.jsoup.safety.Whitelist$a.a(string2);
            Map<a, b> map = this.b.get(d2);
            map.remove(a2);
            if (map.isEmpty()) {
                this.b.remove(d2);
            }
        }
        return this;
    }

    public Whitelist preserveRelativeLinks(boolean bl) {
        this.a = bl;
        return this;
    }

    public Whitelist addProtocols(String string, String string2, String ... stringArray) {
        Set<c> set;
        Map<Object, Object> map;
        Validate.notEmpty(string);
        Validate.notEmpty(string2);
        Validate.notNull(stringArray);
        d d2 = d.a(string);
        a a2 = org.jsoup.safety.Whitelist$a.a(string2);
        if (this.c.containsKey(d2)) {
            map = this.c.get(d2);
        } else {
            map = new HashMap();
            this.c.put(d2, map);
        }
        if (map.containsKey(a2)) {
            set = (Set)map.get(a2);
        } else {
            set = new HashSet();
            map.put(a2, set);
        }
        for (String string3 : stringArray) {
            Validate.notEmpty(string3);
            c c2 = org.jsoup.safety.Whitelist$c.a(string3);
            set.add(c2);
        }
        return this;
    }

    public Whitelist removeProtocols(String string, String string2, String ... stringArray) {
        Map<a, Set<c>> map;
        Validate.notEmpty(string);
        Validate.notEmpty(string2);
        Validate.notNull(stringArray);
        d d2 = d.a(string);
        a a2 = org.jsoup.safety.Whitelist$a.a(string2);
        if (this.c.containsKey(d2) && (map = this.c.get(d2)).containsKey(a2)) {
            Set<c> set = map.get(a2);
            for (String string3 : stringArray) {
                Validate.notEmpty(string3);
                c c2 = org.jsoup.safety.Whitelist$c.a(string3);
                set.remove(c2);
            }
            if (set.isEmpty()) {
                map.remove(a2);
                if (map.isEmpty()) {
                    this.c.remove(d2);
                }
            }
        }
        return this;
    }

    protected boolean isSafeTag(String string) {
        return this.a.contains(d.a(string));
    }

    protected boolean isSafeAttribute(String string, Element element, Attribute attribute) {
        d d2 = d.a(string);
        a a2 = org.jsoup.safety.Whitelist$a.a(attribute.getKey());
        if (this.a.containsKey(d2) && ((Set)this.a.get(d2)).contains(a2)) {
            if (this.c.containsKey(d2)) {
                Map<a, Set<c>> map = this.c.get(d2);
                return !map.containsKey(a2) || this.a(element, attribute, map.get(a2));
            }
            return true;
        }
        return !string.equals(":all") && this.isSafeAttribute(":all", element, attribute);
    }

    private boolean a(Element element, Attribute attribute, Set<c> set) {
        String string = element.absUrl(attribute.getKey());
        if (string.length() == 0) {
            string = attribute.getValue();
        }
        if (!this.a) {
            attribute.setValue(string);
        }
        for (c c2 : set) {
            String string2 = c2.toString();
            if (string2.equals("#")) {
                if (!this.a(string)) continue;
                return true;
            }
            string2 = string2 + ":";
            if (!string.toLowerCase().startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean a(String string) {
        return string.startsWith("#") && !string.matches(".*\\s.*");
    }

    Attributes a(String string) {
        Attributes attributes = new Attributes();
        d d2 = d.a(string);
        if (this.b.containsKey(d2)) {
            Map<a, b> map = this.b.get(d2);
            for (Map.Entry<a, b> entry : map.entrySet()) {
                attributes.put(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        return attributes;
    }

    static abstract class e {
        private String a;

        e(String string) {
            Validate.notNull(string);
            this.a = string;
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + (this.a == null ? 0 : this.a.hashCode());
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            e e2 = (e)object;
            return !(this.a == null ? e2.a != null : !this.a.equals(e2.a));
        }

        public String toString() {
            return this.a;
        }
    }

    static class c
    extends e {
        c(String string) {
            super(string);
        }

        static c a(String string) {
            return new c(string);
        }
    }

    static class b
    extends e {
        b(String string) {
            super(string);
        }

        static b a(String string) {
            return new b(string);
        }
    }

    static class a
    extends e {
        a(String string) {
            super(string);
        }

        static a a(String string) {
            return new a(string);
        }
    }

    static class d
    extends e {
        d(String string) {
            super(string);
        }

        static d a(String string) {
            return new d(string);
        }
    }
}

