/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.FormElement;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.jsoup.select.Selector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Elements
extends ArrayList<Element> {
    public Elements() {
    }

    public Elements(int n) {
        super(n);
    }

    public Elements(Collection<Element> collection) {
        super(collection);
    }

    public Elements(List<Element> list) {
        super(list);
    }

    public Elements(Element ... elementArray) {
        super(Arrays.asList(elementArray));
    }

    @Override
    public Elements clone() {
        Elements elements = new Elements(this.size());
        for (Element element : this) {
            elements.add(element.clone());
        }
        return elements;
    }

    public String attr(String string) {
        for (Element element : this) {
            if (!element.hasAttr(string)) continue;
            return element.attr(string);
        }
        return "";
    }

    public boolean hasAttr(String string) {
        for (Element element : this) {
            if (!element.hasAttr(string)) continue;
            return true;
        }
        return false;
    }

    public Elements attr(String string, String string2) {
        for (Element element : this) {
            element.attr(string, string2);
        }
        return this;
    }

    public Elements removeAttr(String string) {
        for (Element element : this) {
            element.removeAttr(string);
        }
        return this;
    }

    public Elements addClass(String string) {
        for (Element element : this) {
            element.addClass(string);
        }
        return this;
    }

    public Elements removeClass(String string) {
        for (Element element : this) {
            element.removeClass(string);
        }
        return this;
    }

    public Elements toggleClass(String string) {
        for (Element element : this) {
            element.toggleClass(string);
        }
        return this;
    }

    public boolean hasClass(String string) {
        for (Element element : this) {
            if (!element.hasClass(string)) continue;
            return true;
        }
        return false;
    }

    public String val() {
        if (this.size() > 0) {
            return this.first().val();
        }
        return "";
    }

    public Elements val(String string) {
        for (Element element : this) {
            element.val(string);
        }
        return this;
    }

    public String text() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Element element : this) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(element.text());
        }
        return stringBuilder.toString();
    }

    public boolean hasText() {
        for (Element element : this) {
            if (!element.hasText()) continue;
            return true;
        }
        return false;
    }

    public String html() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Element element : this) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(element.html());
        }
        return stringBuilder.toString();
    }

    public String outerHtml() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Element element : this) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(element.outerHtml());
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    public Elements tagName(String string) {
        for (Element element : this) {
            element.tagName(string);
        }
        return this;
    }

    public Elements html(String string) {
        for (Element element : this) {
            element.html(string);
        }
        return this;
    }

    public Elements prepend(String string) {
        for (Element element : this) {
            element.prepend(string);
        }
        return this;
    }

    public Elements append(String string) {
        for (Element element : this) {
            element.append(string);
        }
        return this;
    }

    public Elements before(String string) {
        for (Element element : this) {
            element.before(string);
        }
        return this;
    }

    public Elements after(String string) {
        for (Element element : this) {
            element.after(string);
        }
        return this;
    }

    public Elements wrap(String string) {
        Validate.notEmpty(string);
        for (Element element : this) {
            element.wrap(string);
        }
        return this;
    }

    public Elements unwrap() {
        for (Element element : this) {
            element.unwrap();
        }
        return this;
    }

    public Elements empty() {
        for (Element element : this) {
            element.empty();
        }
        return this;
    }

    public Elements remove() {
        for (Element element : this) {
            element.remove();
        }
        return this;
    }

    public Elements select(String string) {
        return Selector.select(string, this);
    }

    public Elements not(String string) {
        Elements elements = Selector.select(string, this);
        return Selector.filterOut(this, elements);
    }

    public Elements eq(int n) {
        return this.size() > n ? new Elements((Element)this.get(n)) : new Elements();
    }

    public boolean is(String string) {
        Elements elements = this.select(string);
        return !elements.isEmpty();
    }

    public Elements parents() {
        LinkedHashSet<Element> linkedHashSet = new LinkedHashSet<Element>();
        for (Element element : this) {
            linkedHashSet.addAll(element.parents());
        }
        return new Elements((Collection<Element>)linkedHashSet);
    }

    public Element first() {
        return this.isEmpty() ? null : (Element)this.get(0);
    }

    public Element last() {
        return this.isEmpty() ? null : (Element)this.get(this.size() - 1);
    }

    public Elements traverse(NodeVisitor nodeVisitor) {
        Validate.notNull(nodeVisitor);
        NodeTraversor nodeTraversor = new NodeTraversor(nodeVisitor);
        for (Element element : this) {
            nodeTraversor.traverse(element);
        }
        return this;
    }

    public List<FormElement> forms() {
        ArrayList<FormElement> arrayList = new ArrayList<FormElement>();
        for (Element element : this) {
            if (!(element instanceof FormElement)) continue;
            arrayList.add((FormElement)element);
        }
        return arrayList;
    }
}

