/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.XmlDeclaration;
import org.jsoup.select.Elements;

public abstract class Evaluator {
    protected Evaluator() {
    }

    public abstract boolean matches(Element var1, Element var2);

    public static final class MatchesOwn
    extends Evaluator {
        private Pattern a;

        public MatchesOwn(Pattern pattern) {
            this.a = pattern;
        }

        public boolean matches(Element element, Element element2) {
            Matcher matcher = this.a.matcher(element2.ownText());
            return matcher.find();
        }

        public String toString() {
            return String.format(":matchesOwn(%s", this.a);
        }
    }

    public static final class Matches
    extends Evaluator {
        private Pattern a;

        public Matches(Pattern pattern) {
            this.a = pattern;
        }

        public boolean matches(Element element, Element element2) {
            Matcher matcher = this.a.matcher(element2.text());
            return matcher.find();
        }

        public String toString() {
            return String.format(":matches(%s", this.a);
        }
    }

    public static final class ContainsOwnText
    extends Evaluator {
        private String a;

        public ContainsOwnText(String string) {
            this.a = string.toLowerCase();
        }

        public boolean matches(Element element, Element element2) {
            return element2.ownText().toLowerCase().contains(this.a);
        }

        public String toString() {
            return String.format(":containsOwn(%s", this.a);
        }
    }

    public static final class ContainsText
    extends Evaluator {
        private String a;

        public ContainsText(String string) {
            this.a = string.toLowerCase();
        }

        public boolean matches(Element element, Element element2) {
            return element2.text().toLowerCase().contains(this.a);
        }

        public String toString() {
            return String.format(":contains(%s", this.a);
        }
    }

    public static abstract class IndexEvaluator
    extends Evaluator {
        int a;

        public IndexEvaluator(int n) {
            this.a = n;
        }
    }

    public static final class IsEmpty
    extends Evaluator {
        public boolean matches(Element element, Element element2) {
            List<Node> list = element2.childNodes();
            for (Node node : list) {
                if (node instanceof Comment || node instanceof XmlDeclaration || node instanceof DocumentType) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return ":empty";
        }
    }

    public static final class IsOnlyOfType
    extends Evaluator {
        public boolean matches(Element element, Element element2) {
            Element element3 = element2.parent();
            if (element3 == null || element3 instanceof Document) {
                return false;
            }
            int n = 0;
            Elements elements = element3.children();
            for (Element element4 : elements) {
                if (!element4.tag().equals(element2.tag())) continue;
                ++n;
            }
            return n == 1;
        }

        public String toString() {
            return ":only-of-type";
        }
    }

    public static final class IsOnlyChild
    extends Evaluator {
        public boolean matches(Element element, Element element2) {
            Element element3 = element2.parent();
            return element3 != null && !(element3 instanceof Document) && element2.siblingElements().size() == 0;
        }

        public String toString() {
            return ":only-child";
        }
    }

    public static final class IsRoot
    extends Evaluator {
        public boolean matches(Element element, Element element2) {
            Element element3 = element instanceof Document ? element.child(0) : element;
            return element2 == element3;
        }

        public String toString() {
            return ":root";
        }
    }

    public static final class IsFirstChild
    extends Evaluator {
        public boolean matches(Element element, Element element2) {
            Element element3 = element2.parent();
            return element3 != null && !(element3 instanceof Document) && element2.elementSiblingIndex() == 0;
        }

        public String toString() {
            return ":first-child";
        }
    }

    public static class IsNthLastOfType
    extends CssNthEvaluator {
        public IsNthLastOfType(int n, int n2) {
            super(n, n2);
        }

        protected int calculatePosition(Element element, Element element2) {
            int n = 0;
            Elements elements = element2.parent().children();
            for (int i = element2.elementSiblingIndex().intValue(); i < elements.size(); ++i) {
                if (!((Element)elements.get(i)).tag().equals(element2.tag())) continue;
                ++n;
            }
            return n;
        }

        protected String getPseudoClass() {
            return "nth-last-of-type";
        }
    }

    public static class IsNthOfType
    extends CssNthEvaluator {
        public IsNthOfType(int n, int n2) {
            super(n, n2);
        }

        protected int calculatePosition(Element element, Element element2) {
            int n = 0;
            Elements elements = element2.parent().children();
            for (Element element3 : elements) {
                if (element3.tag().equals(element2.tag())) {
                    ++n;
                }
                if (element3 != element2) continue;
                break;
            }
            return n;
        }

        protected String getPseudoClass() {
            return "nth-of-type";
        }
    }

    public static final class IsNthLastChild
    extends CssNthEvaluator {
        public IsNthLastChild(int n, int n2) {
            super(n, n2);
        }

        protected int calculatePosition(Element element, Element element2) {
            return element2.parent().children().size() - element2.elementSiblingIndex();
        }

        protected String getPseudoClass() {
            return "nth-last-child";
        }
    }

    public static final class IsNthChild
    extends CssNthEvaluator {
        public IsNthChild(int n, int n2) {
            super(n, n2);
        }

        protected int calculatePosition(Element element, Element element2) {
            return element2.elementSiblingIndex() + 1;
        }

        protected String getPseudoClass() {
            return "nth-child";
        }
    }

    public static abstract class CssNthEvaluator
    extends Evaluator {
        protected final int a;
        protected final int b;

        public CssNthEvaluator(int n, int n2) {
            this.a = n;
            this.b = n2;
        }

        public CssNthEvaluator(int n) {
            this(0, n);
        }

        public boolean matches(Element element, Element element2) {
            Element element3 = element2.parent();
            if (element3 == null || element3 instanceof Document) {
                return false;
            }
            int n = this.calculatePosition(element, element2);
            if (this.a == 0) {
                return n == this.b;
            }
            return (n - this.b) * this.a >= 0 && (n - this.b) % this.a == 0;
        }

        public String toString() {
            if (this.a == 0) {
                return String.format(":%s(%d)", this.getPseudoClass(), this.b);
            }
            if (this.b == 0) {
                return String.format(":%s(%dn)", this.getPseudoClass(), this.a);
            }
            return String.format(":%s(%dn%+d)", this.getPseudoClass(), this.a, this.b);
        }

        protected abstract String getPseudoClass();

        protected abstract int calculatePosition(Element var1, Element var2);
    }

    public static final class IsLastOfType
    extends IsNthLastOfType {
        public IsLastOfType() {
            super(0, 1);
        }

        public String toString() {
            return ":last-of-type";
        }
    }

    public static final class IsFirstOfType
    extends IsNthOfType {
        public IsFirstOfType() {
            super(0, 1);
        }

        public String toString() {
            return ":first-of-type";
        }
    }

    public static final class IsLastChild
    extends Evaluator {
        public boolean matches(Element element, Element element2) {
            Element element3 = element2.parent();
            return element3 != null && !(element3 instanceof Document) && element2.elementSiblingIndex() == element3.children().size() - 1;
        }

        public String toString() {
            return ":last-child";
        }
    }

    public static final class IndexEquals
    extends IndexEvaluator {
        public IndexEquals(int n) {
            super(n);
        }

        public boolean matches(Element element, Element element2) {
            return element2.elementSiblingIndex() == this.a;
        }

        public String toString() {
            return String.format(":eq(%d)", this.a);
        }
    }

    public static final class IndexGreaterThan
    extends IndexEvaluator {
        public IndexGreaterThan(int n) {
            super(n);
        }

        public boolean matches(Element element, Element element2) {
            return element2.elementSiblingIndex() > this.a;
        }

        public String toString() {
            return String.format(":gt(%d)", this.a);
        }
    }

    public static final class IndexLessThan
    extends IndexEvaluator {
        public IndexLessThan(int n) {
            super(n);
        }

        public boolean matches(Element element, Element element2) {
            return element2.elementSiblingIndex() < this.a;
        }

        public String toString() {
            return String.format(":lt(%d)", this.a);
        }
    }

    public static final class AllElements
    extends Evaluator {
        public boolean matches(Element element, Element element2) {
            return true;
        }

        public String toString() {
            return "*";
        }
    }

    public static abstract class AttributeKeyPair
    extends Evaluator {
        String a;
        String b;

        public AttributeKeyPair(String string, String string2) {
            Validate.notEmpty(string);
            Validate.notEmpty(string2);
            this.a = string.trim().toLowerCase();
            if (string2.startsWith("\"") && string2.endsWith("\"") || string2.startsWith("'") && string2.endsWith("'")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            this.b = string2.trim().toLowerCase();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class AttributeWithValueMatching
    extends Evaluator {
        String a;
        Pattern a;

        public AttributeWithValueMatching(String string, Pattern pattern) {
            this.a = string.trim().toLowerCase();
            this.a = pattern;
        }

        public boolean matches(Element element, Element element2) {
            return element2.hasAttr(this.a) && this.a.matcher(element2.attr(this.a)).find();
        }

        public String toString() {
            return String.format("[%s~=%s]", this.a, this.a.toString());
        }
    }

    public static final class AttributeWithValueContaining
    extends AttributeKeyPair {
        public AttributeWithValueContaining(String string, String string2) {
            super(string, string2);
        }

        public boolean matches(Element element, Element element2) {
            return element2.hasAttr(this.a) && element2.attr(this.a).toLowerCase().contains(this.b);
        }

        public String toString() {
            return String.format("[%s*=%s]", this.a, this.b);
        }
    }

    public static final class AttributeWithValueEnding
    extends AttributeKeyPair {
        public AttributeWithValueEnding(String string, String string2) {
            super(string, string2);
        }

        public boolean matches(Element element, Element element2) {
            return element2.hasAttr(this.a) && element2.attr(this.a).toLowerCase().endsWith(this.b);
        }

        public String toString() {
            return String.format("[%s$=%s]", this.a, this.b);
        }
    }

    public static final class AttributeWithValueStarting
    extends AttributeKeyPair {
        public AttributeWithValueStarting(String string, String string2) {
            super(string, string2);
        }

        public boolean matches(Element element, Element element2) {
            return element2.hasAttr(this.a) && element2.attr(this.a).toLowerCase().startsWith(this.b);
        }

        public String toString() {
            return String.format("[%s^=%s]", this.a, this.b);
        }
    }

    public static final class AttributeWithValueNot
    extends AttributeKeyPair {
        public AttributeWithValueNot(String string, String string2) {
            super(string, string2);
        }

        public boolean matches(Element element, Element element2) {
            return !this.b.equalsIgnoreCase(element2.attr(this.a));
        }

        public String toString() {
            return String.format("[%s!=%s]", this.a, this.b);
        }
    }

    public static final class AttributeWithValue
    extends AttributeKeyPair {
        public AttributeWithValue(String string, String string2) {
            super(string, string2);
        }

        public boolean matches(Element element, Element element2) {
            return element2.hasAttr(this.a) && this.b.equalsIgnoreCase(element2.attr(this.a).trim());
        }

        public String toString() {
            return String.format("[%s=%s]", this.a, this.b);
        }
    }

    public static final class AttributeStarting
    extends Evaluator {
        private String a;

        public AttributeStarting(String string) {
            Validate.notEmpty(string);
            this.a = string.toLowerCase();
        }

        public boolean matches(Element element, Element element2) {
            List<org.jsoup.nodes.Attribute> list = element2.attributes().asList();
            for (org.jsoup.nodes.Attribute attribute : list) {
                if (!attribute.getKey().toLowerCase().startsWith(this.a)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return String.format("[^%s]", this.a);
        }
    }

    public static final class Attribute
    extends Evaluator {
        private String a;

        public Attribute(String string) {
            this.a = string;
        }

        public boolean matches(Element element, Element element2) {
            return element2.hasAttr(this.a);
        }

        public String toString() {
            return String.format("[%s]", this.a);
        }
    }

    public static final class Class
    extends Evaluator {
        private String a;

        public Class(String string) {
            this.a = string;
        }

        public boolean matches(Element element, Element element2) {
            return element2.hasClass(this.a);
        }

        public String toString() {
            return String.format(".%s", this.a);
        }
    }

    public static final class Id
    extends Evaluator {
        private String a;

        public Id(String string) {
            this.a = string;
        }

        public boolean matches(Element element, Element element2) {
            return this.a.equals(element2.id());
        }

        public String toString() {
            return String.format("#%s", this.a);
        }
    }

    public static final class TagEndsWith
    extends Evaluator {
        private String a;

        public TagEndsWith(String string) {
            this.a = string;
        }

        public boolean matches(Element element, Element element2) {
            return element2.tagName().endsWith(this.a);
        }

        public String toString() {
            return String.format("%s", this.a);
        }
    }

    public static final class Tag
    extends Evaluator {
        private String a;

        public Tag(String string) {
            this.a = string;
        }

        public boolean matches(Element element, Element element2) {
            return element2.tagName().equalsIgnoreCase(this.a);
        }

        public String toString() {
            return String.format("%s", this.a);
        }
    }
}

