/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import android.graphics.Color;
import com.supermap.mapping.Gradient;
import com.supermap.mapping.WeightedPoint;
import java.util.Collection;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
class HeatMapLayer {
    private static final Gradient a = new Gradient(new int[]{0, Color.argb((int)70, (int)0, (int)0, (int)255), Color.argb((int)180, (int)0, (int)255, (int)0), Color.argb((int)200, (int)255, (int)255, (int)0), Color.rgb((int)255, (int)200, (int)0), -65536}, new float[]{0.0f, 0.25f, 0.55f, 0.7f, 0.85f, 1.0f});
    private Collection<WeightedPoint> a;
    private int a;
    private Gradient b;
    private int[] a;
    private double[] a;
    private double a;
    private int b;
    private int c;

    private HeatMapLayer(Builder builder) {
        this.a = builder.a;
        this.a = builder.a;
        this.b = builder.a;
        this.a = builder.a;
        this.b = builder.b;
        this.c = builder.c;
        this.a = HeatMapLayer.a(this.a, (double)this.a / 3.0);
        this.a(this.b);
    }

    static double[] a(int n2, double d2) {
        double[] dArray = new double[n2 * 2 + 1];
        for (int i2 = -n2; i2 <= n2; ++i2) {
            dArray[i2 + n2] = Math.exp((double)(-i2 * i2) / (2.0 * d2 * d2));
        }
        return dArray;
    }

    public void a(Gradient gradient) {
        this.b = gradient;
        this.a = gradient.a(this.a);
    }

    static /* synthetic */ Gradient a() {
        return a;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static class Builder {
        private Collection<WeightedPoint> a;
        private int a;
        private Gradient a;
        private double a = 0.6;
        private int b = 0;
        private int c = 0;

        public Builder weightedData(Collection<WeightedPoint> collection) {
            this.a = collection;
            if (this.a.isEmpty()) {
                throw new IllegalArgumentException("No input points.");
            }
            return this;
        }

        public Builder radius(int n2) {
            this.a = n2;
            if (this.a < 10 || this.a > 50) {
                throw new IllegalArgumentException("Radius not within bounds.");
            }
            return this;
        }

        public Builder gradient(Gradient gradient) {
            this.a = gradient;
            return this;
        }

        public Builder opacity(double d2) {
            this.a = d2;
            if (this.a < 0.0 || this.a > 1.0) {
                throw new IllegalArgumentException("Opacity must be in range [0, 1]");
            }
            return this;
        }

        public Builder width(int n2) {
            this.b = n2;
            if (this.b <= 0) {
                throw new IllegalArgumentException("Width must be above 0");
            }
            return this;
        }

        public Builder height(int n2) {
            this.c = n2;
            if (this.c <= 0) {
                throw new IllegalArgumentException("Height must be above 0");
            }
            return this;
        }

        public HeatMapLayer build() {
            return new HeatMapLayer(this);
        }
    }
}

