/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetVector;
import com.supermap.data.GeoRegion;
import com.supermap.data.InternalHandle;
import com.supermap.data.Point;
import com.supermap.data.Point2D;
import com.supermap.data.QueryParameter;
import com.supermap.data.Workspace;
import com.supermap.mapping.LayerGroup;
import com.supermap.mapping.LayerNative;
import com.supermap.mapping.LayerSetting;
import com.supermap.mapping.LayerSettingGrid;
import com.supermap.mapping.LayerSettingImage;
import com.supermap.mapping.LayerSettingType;
import com.supermap.mapping.LayerSettingVector;
import com.supermap.mapping.Layers;
import com.supermap.mapping.LayersStateListener;
import com.supermap.mapping.Map;
import com.supermap.mapping.Selection;
import com.supermap.mapping.Theme;
import com.supermap.mapping.b;
import com.supermap.mapping.i;
import com.supermap.mapping.l;
import com.supermap.mapping.m;
import com.supermap.mapping.s;
import com.supermap.mapping.u;
import com.supermap.mapping.x;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Layer
extends InternalHandle {
    protected Layers m_layers = null;
    protected Map m_map = null;
    private Selection a;
    private Dataset a;
    private LayerSetting a;
    private Theme a;
    private GeoRegion a;
    private long a;
    private QueryParameter a;
    LayerGroup a;
    private boolean a;
    private int a = -1;

    Layer(long l2, long l3, Layers layers, Map map) {
        this.setHandle(l2);
        this.m_map = map;
        this.m_layers = layers;
    }

    void a(Map map) {
        this.m_map = map;
    }

    void a() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setAddtionalSetting(LayerSetting layerSetting)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        LayerNative.jni_StopRenderMap(this.getHandle());
    }

    public void setAdditionalSetting(LayerSetting layerSetting) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setAddtionalSetting(LayerSetting layerSetting)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (this.getAdditionalSetting() == null) {
            String string3 = u.a("setAddtionalSetting(LayerSetting layerSetting)", "Layer_UnsupportedOperationOfSetAdditionalSetting", "mapping_resources");
            throw new UnsupportedOperationException(string3);
        }
        if (layerSetting == null) {
            String string4 = u.a("layerSetting", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        LayerSettingType layerSettingType = this.getAdditionalSetting().getType();
        if (layerSettingType.equals((Object)layerSetting.getType())) {
            if (layerSettingType.equals((Object)LayerSettingType.VECTOR)) {
                LayerSettingVector layerSettingVector = (LayerSettingVector)layerSetting;
                ((LayerSettingVector)this.a).setStyle(layerSettingVector.getStyle());
            } else if (layerSettingType.equals((Object)LayerSettingType.GRID)) {
                LayerSettingGrid layerSettingGrid = (LayerSettingGrid)layerSetting;
                ((LayerSettingGrid)this.a).setSpecialValueColor(layerSettingGrid.getSpecialValueColor());
                if (!((LayerSettingGrid)layerSetting).b && !((LayerSettingGrid)layerSetting).a) {
                    ((LayerSettingGrid)this.a).setSpecialValue(((DatasetGrid)this.getDataset()).getNoValue());
                } else {
                    ((LayerSettingGrid)this.a).setSpecialValue(layerSettingGrid.getSpecialValue());
                }
                ((LayerSettingGrid)this.a).setSpecialValueTransparent(layerSettingGrid.isSpecialValueTransparent());
            } else if (layerSettingType.equals((Object)LayerSettingType.IMAGE)) {
                LayerSettingImage layerSettingImage = (LayerSettingImage)layerSetting;
                ((LayerSettingImage)this.a).setTransparent(layerSettingImage.isTransparent());
                ((LayerSettingImage)this.a).setTransparentColor(layerSettingImage.getTransparentColor());
                ((LayerSettingImage)this.a).setTransparentColorTolerance(layerSettingImage.getTransparentColorTolerance());
            }
        } else {
            String string5 = u.a("layerSetting", "Layer_TheArgumentOfLayerSettingIsInvalidLayerSettingType", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        this.a = true;
    }

    public LayerSetting getAdditionalSetting() {
        Dataset dataset;
        if (this.getHandle() == 0L) {
            String string2 = u.a("getAddtionalSetting()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        long l2 = LayerNative.jni_GetTheme(this.getHandle());
        if (l2 == 0L && this.a == null && (dataset = this.getDataset()) != null && l.getHandle((InternalHandle)dataset) != 0L) {
            Class<?> clazz = dataset.getClass();
            if (clazz.equals(DatasetVector.class)) {
                this.a = new LayerSettingVector(this, this.m_layers);
            }
            if (clazz.equals(DatasetGrid.class)) {
                this.a = new LayerSettingGrid(this, this.m_layers);
            }
            if (clazz.equals(DatasetImage.class)) {
                this.a = new LayerSettingImage(this, this.m_layers);
            }
        }
        return this.a;
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return LayerNative.jni_GetName(this.getHandle());
    }

    public String getCaption() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getCaption()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return LayerNative.jni_GetCaption(this.getHandle());
    }

    public void setCaption(String string2) {
        if (this.getHandle() == 0L) {
            String string3 = u.a("setCaption(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string4 = u.a("value", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string2.indexOf("/") != -1 || string2.indexOf("\\") != -1 || string2.indexOf("<") != -1 || string2.indexOf(">") != -1 || string2.indexOf(":") != -1 || string2.indexOf("|") != -1 || string2.indexOf("\"") != -1 || string2.indexOf("?") != -1 || string2.indexOf("*") != -1) {
            String string5 = u.a("value", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        String string6 = this.getCaption();
        if (this.m_layers.e != null) {
            for (LayersStateListener layersStateListener : this.m_layers.e) {
                layersStateListener.layerCaptionChanged(this, string6, string2);
            }
        }
        this.a = true;
        LayerNative.jni_SetCaption(this.getHandle(), string2);
    }

    public Selection getSelection() {
        long l2;
        if (this.getHandle() == 0L) {
            String string2 = u.a("getSelection()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        Dataset dataset = this.getDataset();
        if (b.a(dataset) && this.a == null && (l2 = LayerNative.jni_GetSelection(this.getHandle())) != 0L) {
            this.a = new Selection(l2, this);
        }
        return this.a;
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getDescription()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return LayerNative.jni_GetDescription(this.getHandle());
    }

    public void setDescription(String string2) {
        if (this.getHandle() == 0L) {
            String string3 = u.a("setDescription(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        if (string2 == null) {
            string2 = "";
        }
        this.a = true;
        LayerNative.jni_SetDescription(this.getHandle(), string2);
    }

    public Dataset getDataset() {
        long l2;
        if (this.getHandle() == 0L) {
            String string2 = u.a("getDataset()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (this.a == null && (l2 = LayerNative.jni_GetDataset(this.getHandle())) != 0L) {
            Workspace workspace = this.m_map.getWorkspace();
            this.a = x.a(workspace, l2);
        }
        return this.a;
    }

    public QueryParameter getDisplayFilter() {
        long l2;
        if (this.getHandle() == 0L) {
            String string2 = u.a("getDisplayFilter()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (this.a == null && (l2 = LayerNative.jni_GetDisplayFilter(this.getHandle())) != 0L) {
            this.a = s.a(l2);
        }
        return this.a;
    }

    public void setDisplayFilter(QueryParameter queryParameter) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setDisplayFilter(QueryParameter value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (queryParameter == null) {
            String string3 = u.a("queryParameter", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        long l2 = l.getHandle((InternalHandle)queryParameter);
        if (l2 == 0L) {
            String string4 = u.a("queryParameter", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        QueryParameter queryParameter2 = new QueryParameter(queryParameter);
        long l3 = l.getHandle((InternalHandle)queryParameter2);
        this.a = true;
        LayerNative.jni_SetDisplayFilter(this.getHandle(), l3);
    }

    public boolean isSelectable() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getIsSelectable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return LayerNative.jni_GetSelectable(this.getHandle());
    }

    public void setSelectable(boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setIsSelectable(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        this.a = true;
        LayerNative.jni_SetSelectable(this.getHandle(), bl);
    }

    public boolean isSnapable() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getIsSnapable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        int n2 = this.m_layers.a().indexOf((Object)this);
        if (n2 == -1) {
            String string3 = u.a("getIsSnapable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        return LayerNative.jni_GetIsSnapable(this.getHandle());
    }

    public void setSnapable(boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setIsSnapable(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        int n2 = this.m_layers.a().indexOf((Object)this);
        if (n2 == -1) {
            String string3 = u.a("setIsSnapable(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        LayerNative.jni_SetIsSnapable(this.getHandle(), bl);
    }

    public boolean isSymbolScalable() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getIsSymbolScalable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return LayerNative.jni_GetIsSymbolScalable(this.getHandle());
    }

    public void setSymbolScalable(boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setIsSymbolScalable(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        this.a = true;
        LayerNative.jni_SetIsSymbolScalable(this.getHandle(), bl);
    }

    public boolean isVisible() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getIsVisible()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return LayerNative.jni_GetIsVisible(this.getHandle());
    }

    public void setVisible(boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setIsVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        LayerNative.jni_SetIsVisible(this.getHandle(), bl);
        if (this.m_layers.e != null) {
            for (LayersStateListener layersStateListener : this.m_layers.e) {
                layersStateListener.layerVisiableChanged(this, bl);
            }
        }
        this.a = true;
    }

    public double getMaxVisibleScale() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getMaxVisibleScale()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return LayerNative.jni_GetMaxVisibleScale(this.getHandle());
    }

    public void setMaxVisibleScale(double d2) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setMaxVisibleScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (d2 < 0.0) {
            String string3 = u.a("value", "Layer_MaxVisibleScaleShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        this.a = true;
        LayerNative.jni_SetMaxVisibleScale(this.getHandle(), d2);
    }

    public double getMinVisibleScale() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getMinVisibleScale()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return LayerNative.jni_GetMinVisibleScale(this.getHandle());
    }

    public void setMinVisibleScale(double d2) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setMinVisibleScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (d2 < 0.0) {
            String string3 = u.a("value", "Layer_MinVisibleScaleShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        this.a = true;
        LayerNative.jni_SetMinVisibleScale(this.getHandle(), d2);
    }

    public Selection hitTest(Point2D point2D, double d2) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("hitTest(Point2D point, double tolerance)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        Dataset dataset = this.getDataset();
        Selection selection = null;
        if (b.a(dataset)) {
            if (d2 < 0.0) {
                String string3 = u.a("tolerance", "Layer_InvalidTolerance", "mapping_resources");
                throw new IllegalArgumentException(string3);
            }
            long l2 = InternalHandle.getHandle((InternalHandle)this.m_map);
            long l3 = LayerNative.jni_HitTest(this.getHandle(), point2D.getX(), point2D.getY(), d2, l2);
            if (l3 != 0L) {
                selection = new Selection(l3, this);
                m.setIsDisposable(selection, true);
            }
        }
        return selection;
    }

    public Selection hitTestEx(Point point, int n2) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("hitTest(Point2D point, double tolerance)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        Dataset dataset = this.getDataset();
        Selection selection = null;
        if (b.a(dataset)) {
            if (n2 < 0) {
                String string3 = u.a("tolerance", "Layer_InvalidTolerance", "mapping_resources");
                throw new IllegalArgumentException(string3);
            }
            Point2D point2D = this.m_map.pixelToMap(point);
            Point2D point2D2 = this.m_map.pixelToMap(new Point(0, 0));
            Point2D point2D3 = this.m_map.pixelToMap(new Point(0, n2));
            double d2 = Math.abs(point2D3.getY() - point2D2.getY());
            selection = this.hitTest(point2D, d2);
        }
        return selection;
    }

    public boolean isVisibleScale(double d2) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("isVisibleScale(double dScale)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return LayerNative.jni_IsVisibleScale(this.getHandle(), d2);
    }

    public boolean isDisposed() {
        boolean bl = false;
        if (this.getHandle() == 0L) {
            bl = true;
        }
        return bl;
    }

    void b() {
        LayerNative.jni_Reset(this.getHandle());
    }

    protected void clearHandle() {
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        if (this.a != null) {
            this.a = null;
        }
        if (this.a != null) {
            this.a.clearHandle();
        }
        this.m_layers = null;
        this.m_map = null;
        if (this.a != 0L) {
            LayerNative.jni_DeleteSelfEventHandle(this.a);
            this.a = 0L;
        }
        if (this.a != null) {
            i.a(this.a);
            this.a = null;
        }
        this.setHandle(0L);
    }

    public boolean isEditable() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("isEditable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return LayerNative.jni_GetIsEditable(this.getHandle());
    }

    public void setEditable(boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setEditable(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        LayerNative.jni_SetIsEditable(this.getHandle(), 0, bl);
        if (this.m_layers.e != null) {
            for (LayersStateListener layersStateListener : this.m_layers.e) {
                layersStateListener.layerEditableChanged(this, bl);
            }
        }
        if (this.m_map != null) {
            if (bl) {
                this.m_map.a = this;
                this.m_map.b = true;
            } else if (this.m_map.a != null && ((Object)((Object)this.m_map.a)).equals((Object)this)) {
                this.m_map.b = false;
                this.m_map.a = null;
            }
        }
        this.a = true;
    }

    @Deprecated
    public Theme GetTheme() {
        long l2;
        if (this.getHandle() == 0L) {
            String string2 = u.a("GetTheme()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (this.a == null && (l2 = LayerNative.jni_GetTheme(this.getHandle())) != 0L) {
            this.a = Theme.createInstance(l2, this);
        }
        return this.a;
    }

    public Theme getTheme() {
        long l2;
        if (this.getHandle() == 0L) {
            String string2 = u.a("getTheme()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (this.a == null && (l2 = LayerNative.jni_GetTheme(this.getHandle())) != 0L) {
            this.a = Theme.createInstance(l2, this);
        }
        return this.a;
    }

    public void setOpaqueRate(int n2) {
        LayerNative.jni_SetOpaqueRate(this.getHandle(), n2);
    }

    public LayerGroup getParentGroup() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getExternalInfo()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return this.a;
    }

    void a(LayerGroup layerGroup) {
        this.a = layerGroup;
    }

    boolean a() {
        boolean bl = false;
        if (this.a) {
            bl = true;
        } else if (this.a != null && this.a.a()) {
            bl = true;
        }
        return bl;
    }

    void c() {
        this.a = false;
        if (this.a != null) {
            this.a.a(false);
        }
    }

    public void setDataset(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string2 = u.a(" setDataset(Dataset dataset)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        if (dataset == null) {
            String string3 = u.a("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new NullPointerException(string3);
        }
        long l2 = l.getHandle((InternalHandle)dataset);
        if (l2 == 0L) {
            String string4 = u.a("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        boolean bl2 = bl = dataset.getDatasource().getWorkspace() == this.m_map.getWorkspace();
        if (!bl) {
            String string5 = u.a("setDataset(Dataset dataset)", "Layer_WorkspaceNoContainTheDataset(-100~100)", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this.a != null && this.a.getType() != dataset.getType()) {
            String string6 = "The dataset type is different, the type must be '" + this.a.getType() + "'.";
            throw new IllegalArgumentException(string6);
        }
        this.m_map.stopRenderMap(true);
        LayerNative.jni_SetDataset(this.getHandle(), l2);
        this.m_map.refresh();
    }

    public void removeCache() {
        this.m_map.stopRenderMap(true);
        LayerNative.jni_RemoveCache(this.getHandle());
        this.m_map.refresh();
    }

    public void setSelectedGeoID(int n2) {
        if (this.a == null) {
            this.getSelection();
        }
        try {
            if (this.a != -1) {
                this.a.clear();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (n2 != this.a && n2 != -1) {
            this.a = n2;
            this.a.add(n2);
        } else {
            this.a = -1;
        }
        this.m_map.refresh();
    }

    public double getMinVisibleGeometrySize() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getMinVisibleGeometrySize()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return LayerNative.jni_GetMinVisibleGeometrySize(this.getHandle());
    }

    public void setMinVisibleGeometrySize(double d2) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setMinVisibleGeometrySize(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (d2 < 0.0) {
            String string3 = u.a("value", "Layer_MinVisibleGeometrySizeShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        LayerNative.jni_SetMinVisibleGeometrySize(this.getHandle(), d2);
    }
}

