/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.CoordSysTransMethod;
import com.supermap.data.CoordSysTransParameter;
import com.supermap.data.DatasetType;
import com.supermap.data.Environment;
import com.supermap.data.GeoStyle;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.MapSaveListener;
import com.supermap.data.Maps;
import com.supermap.data.Point;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Point3D;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Workspace;
import com.supermap.mapping.AbstractMapControl;
import com.supermap.mapping.Layer;
import com.supermap.mapping.Layers;
import com.supermap.mapping.LayersStateListener;
import com.supermap.mapping.Legend;
import com.supermap.mapping.MapColorMode;
import com.supermap.mapping.MapLoadedListener;
import com.supermap.mapping.MapNative;
import com.supermap.mapping.MapOperateListener;
import com.supermap.mapping.MapParameterChangedListener;
import com.supermap.mapping.MapSurfaceView;
import com.supermap.mapping.MapView;
import com.supermap.mapping.PrjCoordSysTranslatorListener;
import com.supermap.mapping.ScreenLayer;
import com.supermap.mapping.TrackingLayer;
import com.supermap.mapping.e;
import com.supermap.mapping.j;
import com.supermap.mapping.l;
import com.supermap.mapping.r;
import com.supermap.mapping.u;
import java.util.ArrayList;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Map
extends InternalHandleDisposable {
    private int a;
    private int b;
    private Workspace a;
    private Layers a;
    private TrackingLayer a;
    private ScreenLayer a;
    private GeoStyle a;
    private PrjCoordSys a;
    private CoordSysTransParameter a;
    Layer a;
    boolean a;
    private Vector<LayersStateListener> b;
    private MapLoadedListener a;
    boolean b = false;
    private AbstractMapControl a;
    private long a;
    private Vector<MapOperateListener> c;
    Vector<MapParameterChangedListener> a;
    private Legend a;
    private Rectangle2D a;
    boolean c = false;
    private MapView a;
    static transient PrjCoordSysTranslatorListener a;
    private MapSaveListener a = null;
    private boolean g = false;
    public Vector<MapStatusOperation> mMapStatusOperation = new Vector();
    boolean d = false;
    boolean e = false;
    boolean f = false;

    public Map() {
        long l2 = MapNative.jni_New();
        this.setHandle(l2, true);
        this.a = MapNative.jni_RegisteAllEvents(l2, (Object)this);
        this.c();
        MapNative.jni_SetName(this.getHandle(), "UntitledMap");
        MapNative.jni_SetModified(this.getHandle(), false);
    }

    void a(LayersStateListener layersStateListener) {
        if (layersStateListener != null && !this.b.contains(layersStateListener)) {
            this.b.add(layersStateListener);
        }
    }

    boolean a(LayersStateListener layersStateListener) {
        if (layersStateListener != null) {
            int n2 = this.b.indexOf(layersStateListener);
            if (n2 != -1) {
                this.b.remove(n2);
                return true;
            }
            return false;
        }
        return false;
    }

    protected void stopRenderMap(boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setAddtionalSetting(LayerSetting layerSetting)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        MapNative.jni_StopRenderMap(this.getHandle(), bl);
    }

    public Map(Workspace workspace) {
        if (workspace == null) {
            String string2 = u.a("workspace", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string2);
        }
        long l2 = InternalHandle.getHandle((InternalHandle)workspace);
        if (l2 == 0L) {
            String string3 = u.a("workspace", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        long l3 = MapNative.jni_New();
        this.setHandle(l3, true);
        this.a = MapNative.jni_RegisteAllEvents(l3, (Object)this);
        this.c();
        this.setWorkspace(workspace);
        this.a = workspace;
        MapNative.jni_SetName(this.getHandle(), "UntitledMap");
        MapNative.jni_SetModified(this.getHandle(), false);
    }

    private Map(long l2, AbstractMapControl abstractMapControl) {
        this.setHandle(l2, false);
        this.a = abstractMapControl;
        MapNative.jni_RegisteAllEvents(l2, (Object)this);
        MapNative.jni_SetName(this.getHandle(), "UntitledMap");
        MapNative.jni_SetModified(this.getHandle(), false);
    }

    private Map(long l2, MapSurfaceView mapSurfaceView) {
        this.setHandle(l2, true);
        MapNative.jni_RegisteAllEvents(l2, (Object)this);
        MapNative.jni_SetName(this.getHandle(), "UntitledMap");
        MapNative.jni_SetModified(this.getHandle(), false);
    }

    public void setMapOperateListener(MapOperateListener mapOperateListener) {
        if (mapOperateListener != null && !this.c.contains(mapOperateListener)) {
            this.c.add(mapOperateListener);
        }
    }

    public boolean removeMapOperateListener(MapOperateListener mapOperateListener) {
        if (mapOperateListener != null) {
            int n2 = this.c.indexOf(mapOperateListener);
            if (n2 != -1) {
                this.c.remove(n2);
                return true;
            }
            return false;
        }
        return false;
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return MapNative.jni_GetName(this.getHandle());
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getDescription()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return MapNative.jni_GetDescription(this.getHandle());
    }

    public void setDescription(String string2) {
        if (this.getHandle() == 0L) {
            String string3 = u.a("setDescription(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        if (string2 == null) {
            string2 = "";
        }
        this.g = true;
        MapNative.jni_SetDescription(this.getHandle(), string2);
    }

    public double getAngle() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getAngle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return MapNative.jni_GetAngle(this.getHandle());
    }

    public void setAngle(double d2) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setAngle(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        MapNative.jni_SetAngle(this.getHandle(), d2);
    }

    public GeoStyle getBackgroundStyle() {
        long l2;
        if (this.getHandle() == 0L) {
            String string2 = u.a("getBackgroundStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (this.a == null && (l2 = MapNative.jni_GetBackGroundStyle(this.getHandle())) != 0L) {
            this.a = j.a(l2);
        }
        return this.a;
    }

    public boolean isDynamicProjection() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getIsDynamicProjection()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return MapNative.jni_GetIsDynamicProjection(this.getHandle());
    }

    public void setDynamicProjection(boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setIsDynamicProjection(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        this.g = true;
        MapNative.jni_SetIsDynamicProjection(this.getHandle(), bl);
    }

    public void setBackgroundStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setBackgroundStyle(GeoStyle value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (geoStyle == null) {
            String string3 = u.a("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        long l2 = InternalHandle.getHandle((InternalHandle)geoStyle);
        if (l2 == 0L) {
            String string4 = u.a("style", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        this.g = true;
        long l3 = InternalHandle.getHandle((InternalHandle)geoStyle.clone());
        this.stopRenderMap(true);
        MapNative.jni_SetBackgroundStyle(this.getHandle(), l3);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getBounds()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        double[] dArray = new double[4];
        MapNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public Rectangle2D getViewBounds() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getViewBounds()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        double[] dArray = new double[4];
        MapNative.jni_GetViewBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    Rectangle2D a() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getViewBounds()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (this.a == null) {
            double[] dArray = new double[4];
            MapNative.jni_GetViewBounds(this.getHandle(), dArray);
            Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
            return rectangle2D;
        }
        return new Rectangle2D(this.a);
    }

    void a(Rectangle2D rectangle2D) {
        if (this.a == null) {
            this.a = new Rectangle2D(rectangle2D);
        } else {
            this.a.setLeft(rectangle2D.getLeft());
            this.a.setBottom(rectangle2D.getBottom());
            this.a.setRight(rectangle2D.getRight());
            this.a.setTop(rectangle2D.getTop());
        }
    }

    void a(MapView mapView) {
        if (mapView != null) {
            this.a = mapView;
        }
    }

    public MapView getMapView() {
        return this.a;
    }

    public boolean isViewBoundsLocked() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return MapNative.jni_GetIsViewBoundsLocked(this.getHandle());
    }

    public void setViewBoundsLocked(boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        MapNative.jni_SetIsViewBoundsLocked(this.getHandle(), bl);
    }

    public void setViewBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setViewBounds(Rectangle2D value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (rectangle2D == null) {
            String string3 = u.a("rect", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (rectangle2D.getHeight() < 0.0) {
            String string4 = u.a("rect", "Map_ViewBoundsHeightShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (rectangle2D.getWidth() < 0.0) {
            String string5 = u.a("rect", "Map_ViewBoundsWidthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        for (MapParameterChangedListener mapParameterChangedListener : this.a) {
            mapParameterChangedListener.boundsChanged(rectangle2D.getCenter());
        }
        MapNative.jni_SetViewBounds(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        if (this.a != null && !this.a.b) {
            MapStatusOperation mapStatusOperation = new MapStatusOperation();
            mapStatusOperation.mViewBounds = rectangle2D;
            mapStatusOperation.mOperation = Operation.SETVIEWBOUNDS;
            this.mMapStatusOperation.add(mapStatusOperation);
        }
    }

    public Rectangle2D getLockedViewBounds() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getViewBounds()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        double[] dArray = new double[4];
        MapNative.jni_GetLockedViewBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setLockedViewBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setViewBounds(Rectangle2D value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (rectangle2D == null) {
            String string3 = u.a("rect", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (rectangle2D.getHeight() <= 0.0) {
            String string4 = u.a("rect", "Map_ViewBoundsHeightShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (rectangle2D.getWidth() <= 0.0) {
            String string5 = u.a("rect", "Map_ViewBoundsWidthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        MapNative.jni_SetLockedViewBounds(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
    }

    public Point2D getCenter() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getCenter()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        double[] dArray = new double[2];
        MapNative.jni_GetCenter(this.getHandle(), dArray);
        Point2D point2D = new Point2D(dArray[0], dArray[1]);
        return point2D;
    }

    public void setCenter(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setCenter(Point2D point)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (point2D == null) {
            String string3 = u.a("point", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        for (MapParameterChangedListener mapParameterChangedListener : this.a) {
            mapParameterChangedListener.boundsChanged(point2D);
        }
        this.g = true;
        MapNative.jni_SetCenter(this.getHandle(), point2D.getX(), point2D.getY());
        if (this.a != null && !this.a.b) {
            MapStatusOperation mapStatusOperation = new MapStatusOperation();
            mapStatusOperation.mCenter = point2D;
            mapStatusOperation.mOperation = Operation.SETCENTER;
            this.mMapStatusOperation.add(mapStatusOperation);
        }
    }

    public boolean isAntialias() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getIsAntialias()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return MapNative.jni_GetIsSmoothingMode(this.getHandle());
    }

    public void setAntialias(boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setIsAntialias(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        this.g = true;
        MapNative.jni_SetIsSmoothingMode(this.getHandle(), bl);
    }

    public boolean isModified() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getIsModified()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return MapNative.jni_GetIsModified(this.getHandle());
    }

    public void setModified(boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setModified(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        MapNative.jni_SetIsModified(this.getHandle(), bl);
    }

    public boolean isPaintBackground() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getIsPaintBackground()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return MapNative.jni_GetIsPaintBackground(this.getHandle());
    }

    public void setPaintBackground(boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setIsPaintBackground(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        MapNative.jni_SetIsPaintBackground(this.getHandle(), bl);
    }

    public TrackingLayer getTrackingLayer() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getTrackingLayer()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (this.a == null) {
            long l2 = MapNative.jni_GetTrackingLayer(this.getHandle());
            if (l2 == 0L) {
                return null;
            }
            this.a = TrackingLayer.createInstance(l2, this);
        }
        return this.a;
    }

    public ScreenLayer getScreenLayer() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getScreenLayer()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (this.a == null) {
            long l2 = MapNative.jni_GetScreenLayer(this.getHandle());
            if (l2 == 0L) {
                return null;
            }
            this.a = ScreenLayer.createInstance(l2, this);
        }
        return this.a;
    }

    public PrjCoordSys getPrjCoordSys() {
        long l2;
        if (this.getHandle() == 0L) {
            String string2 = u.a("getPrjCoordSys()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (this.a == null && (l2 = MapNative.jni_GetPrjCoordSys(this.getHandle())) != 0L) {
            this.a = r.a(l2, false);
        }
        return this.a;
    }

    public void setPrjCoordSys(PrjCoordSys prjCoordSys) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (prjCoordSys == null || l.getHandle((InternalHandle)prjCoordSys) == 0L) {
            String string3 = u.a("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        this.g = true;
        long l2 = l.getHandle((InternalHandle)prjCoordSys);
        this.stopRenderMap(false);
        MapNative.jni_SetPrjCoordSys(this.getHandle(), l2);
    }

    public Layers getLayers() {
        long l2;
        if (this.getHandle() == 0L) {
            String string2 = u.a("getLayers()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (this.a == null && (l2 = MapNative.jni_GetLayersHandle(this.getHandle())) != 0L) {
            this.a = Layers.createInstance(l2, this);
        }
        return this.a;
    }

    public Workspace getWorkspace() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getWorkspace()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return this.a;
    }

    public void setWorkspace(Workspace workspace) {
        long l2;
        if (this.getHandle() == 0L) {
            String string2 = u.a("setWorkspace(Workspace workspace)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (this.getWorkspace() != null && this.getWorkspace().equals(workspace)) {
            return;
        }
        String string3 = "";
        if (this.a != null && (l2 = InternalHandle.getHandle((InternalHandle)this.a)) == 0L) {
            String string4 = u.a("setWorkspace()", "Map_DontDisposeOldWorkspace", "mapping_resources");
            throw new IllegalStateException(string4);
        }
        this.close();
        this.c = false;
        if (workspace == null) {
            if (this.a != null) {
                this.a.removeMapSaveListener(this.a);
            }
            this.a = null;
        } else {
            l2 = InternalHandle.getHandle((InternalHandle)workspace);
            if (l2 == 0L) {
                String string5 = u.a("workspace", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string5);
            }
            MapNative.jni_SetWorkspace(this.getHandle(), l2);
            if (this.a != null) {
                this.a.removeMapSaveListener(this.a);
            }
            this.a = workspace;
            if (this.a == null) {
                this.a = new MapSaveListener(){

                    public String saveMap() {
                        String string2 = null;
                        string2 = Map.this.a();
                        return string2;
                    }
                };
            }
            this.a.addMapSaveListener(this.a);
            this.a = true;
        }
    }

    public int getImageSizeWidth() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getIsModified()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        int n2 = 256;
        if (this.a != null) {
            n2 = this.a;
        } else if (this.a != null) {
            // empty if block
        }
        return n2;
    }

    public int getImageSizeHeight() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getIsModified()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        int n2 = 256;
        if (this.a != null) {
            n2 = this.b;
        } else if (this.a != null) {
            // empty if block
        }
        return n2;
    }

    void a(int n2, int n3) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getIsModified()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (n2 <= 0) {
            String string3 = u.a("size", "Map_ImageWidthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (n3 <= 0) {
            String string4 = u.a("size", "Map_ImageWidthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        this.a = n2;
        this.b = n3;
        MapNative.jni_SetImageSize(this.getHandle(), n2, n3);
    }

    public Point2D pixelToMap(Point point) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("pixelToMap(Point point)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (point == null) {
            String string3 = u.a("point", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        double d2 = 0.0;
        if (this.a != null) {
            d2 = this.a.a();
        }
        boolean bl = Environment.isOpenGLMode();
        double[] dArray = new double[2];
        MapNative.jni_PixelToMap(this.getHandle(), point.getX(), point.getY(), d2, bl, dArray);
        double d3 = dArray[0];
        double d4 = dArray[1];
        return new Point2D(d3, d4);
    }

    public Point mapToPixel(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("mapToPixel(Point2D point)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (point2D == null) {
            String string3 = u.a("point", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        double d2 = 0.0;
        if (this.a != null) {
            d2 = this.a.a();
        }
        boolean bl = Environment.isOpenGLMode();
        int[] nArray = new int[2];
        MapNative.jni_MapToPixel(this.getHandle(), point2D.getX(), point2D.getY(), d2, bl, nArray);
        int n2 = nArray[0];
        int n3 = nArray[1];
        return new Point(n2, n3);
    }

    private boolean a(String string2) {
        if (this.getHandle() == 0L) {
            String string3 = u.a("open(String name)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        if (this.a == null || InternalHandle.getHandle((InternalHandle)this.a) == 0L) {
            String string4 = u.a("open(String name)", "Map_SetTheWorkspaceFirst", "mapping_resources");
            throw new IllegalStateException(string4);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string5 = u.a("name", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        Maps maps = this.a.getMaps();
        int n2 = maps.indexOf(string2);
        if (n2 == -1) {
            String string6 = u.a("name", "Global_SpecifiedNameNotExist", "mapping_resources");
            throw new IllegalArgumentException(string6);
        }
        int n3 = this.getImageSizeWidth();
        int n4 = this.getImageSizeHeight();
        boolean bl = MapNative.jni_Open(this.getHandle(), maps.get(n2));
        this.a(n3, n4);
        if (bl) {
            this.b();
            this.getLayers();
            if (this.a != null) {
                for (LayersStateListener object : this.b) {
                    this.a.setLayersStateListener(object);
                }
            }
        }
        this.b = false;
        if (this.c != null) {
            for (MapOperateListener mapOperateListener : this.c) {
                mapOperateListener.mapOpened();
            }
        }
        this.a = true;
        return bl;
    }

    private void a() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("close()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        this.stopRenderMap(true);
        if (this.a != null) {
            long l2 = InternalHandle.getHandle((InternalHandle)this.a);
            if (l2 == 0L) {
                String string3 = u.a("close()", "Map_CloseMapBeforeDisposeWksp", "mapping_resources");
                throw new IllegalStateException(string3);
            }
            int n2 = this.getImageSizeWidth();
            int n3 = this.getImageSizeHeight();
            this.b();
            MapNative.jni_Close(this.getHandle());
            this.a(n2, n3);
            if (this.a != null) {
                this.a.a();
                this.a.postInvalidate();
            }
            if (this.c != null) {
                for (MapOperateListener mapOperateListener : this.c) {
                    mapOperateListener.mapClosed();
                }
            }
            if (this.a != null) {
                this.a.removeMapSaveListener(this.a);
            }
            this.b = false;
        }
        this.a = false;
        this.g = false;
    }

    public boolean open(String string2) {
        this.c = false;
        if (!Environment.isOpenGLMode()) {
            return this.a(string2);
        }
        final String string3 = string2;
        this.e = true;
        new Thread(){

            @Override
            public void run() {
                super.run();
                Map.this.d = Map.this.a(string3);
                Map.this.e = false;
            }
        }.start();
        while (this.e) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        return this.d;
    }

    private void b() {
        if (this.a != null) {
            ArrayList arrayList = this.a.a();
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Layer layer = (Layer)((Object)arrayList.get(i2));
                layer.clearHandle();
            }
            arrayList.clear();
            this.a = null;
        }
    }

    public void close() {
        this.c = true;
        if (!Environment.isOpenGLMode()) {
            this.a();
        } else {
            this.f = true;
            new Thread(){

                @Override
                public void run() {
                    super.run();
                    Map.this.a();
                    Map.this.f = false;
                }
            }.start();
            while (this.f) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {}
            }
        }
    }

    boolean a() {
        return this.a;
    }

    public void zoom(double d2) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("zoom(double ratio)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (d2 <= 0.0) {
            String string3 = u.a("ratio", "Map_ZoomRatioShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        MapNative.jni_Zoom(this.getHandle(), d2);
        for (MapParameterChangedListener mapParameterChangedListener : this.a) {
            mapParameterChangedListener.scaleChanged(this.getScale());
        }
    }

    public void pan(double d2, double d3) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("pan(double offsetX, double offsetY)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        MapNative.jni_Pan(this.getHandle(), d2, d3);
    }

    public double getScale() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getScale()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return MapNative.jni_GetScale(this.getHandle());
    }

    public void setScale(double d2) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (d2 < 0.0) {
            String string3 = u.a("value", "MapSacleShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        for (MapParameterChangedListener mapParameterChangedListener : this.a) {
            mapParameterChangedListener.scaleChanged(d2);
        }
        this.g = true;
        this.stopRenderMap(true);
        MapNative.jni_SetScale(this.getHandle(), d2);
        if (this.a != null && !this.a.b) {
            MapStatusOperation mapStatusOperation = new MapStatusOperation();
            mapStatusOperation.mScale = d2;
            mapStatusOperation.mOperation = Operation.SETSCALE;
            this.mMapStatusOperation.add(mapStatusOperation);
        }
    }

    public double getMaxScale() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return MapNative.jni_GetMaxScale(this.getHandle());
    }

    public double getMinScale() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return MapNative.jni_GetMinScale(this.getHandle());
    }

    public void viewEntire() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("viewEntire()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        int n2 = this.getImageSizeWidth();
        int n3 = this.getImageSizeHeight();
        MapNative.jni_ViewEntire(this.getHandle(), n2, n3);
        for (MapParameterChangedListener mapParameterChangedListener : this.a) {
            mapParameterChangedListener.scaleChanged(this.getScale());
            mapParameterChangedListener.boundsChanged(this.getCenter());
        }
        if (this.a != null) {
            // empty if block
        }
        this.refresh();
        if (this.a != null && !this.a.b) {
            MapStatusOperation mapStatusOperation = new MapStatusOperation();
            mapStatusOperation.mOperation = Operation.VIEWENTIRE;
            this.mMapStatusOperation.add(mapStatusOperation);
        }
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            return;
        }
        if (this.a != null && InternalHandle.getHandle((InternalHandle)this.a) == 0L) {
            String string2 = u.a("dispose()", "Map_DontDisposeWkspBeforeMap", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        this.close();
        this.c = false;
        MapNative.jni_Delete(this.getHandle());
        this.clearHandle();
        if (this.a != null) {
            this.a.removeMapSaveListener(this.a);
            this.a = null;
        }
    }

    protected static void clearHandle(Map map) {
        map.clearHandle();
    }

    private void c() {
        MapNative.jni_Reset(this.getHandle());
        this.a(this.a, this.b);
    }

    AbstractMapControl a() {
        return this.a;
    }

    public void refresh() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("refresh()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (this.a != null) {
            this.a.b();
        } else if (this.a != null) {
            this.a.refresh();
        }
    }

    protected static Map createInstance(long l2, AbstractMapControl abstractMapControl) {
        return new Map(l2, abstractMapControl);
    }

    protected static Map createInstance(long l2, MapSurfaceView mapSurfaceView) {
        return new Map(l2, mapSurfaceView);
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("toXML()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (!this.b()) {
            String string3 = u.a("toXML()", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        return MapNative.jni_ToXML(this.getHandle());
    }

    private boolean b() {
        if (this.a == null) {
            return false;
        }
        long l2 = InternalHandle.getHandle((InternalHandle)this.a);
        return l2 != 0L;
    }

    protected static void angleChangeCallback(Map map, double d2) {
        if (map != null && map.a != null) {
            for (MapParameterChangedListener mapParameterChangedListener : map.a) {
                mapParameterChangedListener.angleChanged(d2);
            }
        }
    }

    protected static void refreshCallBack(Map map) {
        if (map != null && map.a != null) {
            map.a.refreshCallback();
        } else if (map == null || map.a != null) {
            // empty if block
        }
    }

    protected static void mapLoadedCallback(Map map) {
        if (map != null && map.a != null) {
            map.a.onMapLoaded();
        }
    }

    protected static void onTimerStart(Map map, int n2) {
        if (map != null && map.a != null) {
            map.a.onTimerStart(n2);
        } else if (map == null || map.a != null) {
            // empty if block
        }
    }

    protected static void onTimerEnd(Map map, int n2) {
        if (map != null && map.a != null) {
            map.a.onTimerEnd(n2);
        } else if (map == null || map.a != null) {
            // empty if block
        }
    }

    public void setMapDPI(double d2) {
        MapNative.jni_SetMapDPI(this.getHandle(), d2);
    }

    public double getMapDPI() {
        return MapNative.jni_GetMapDPI(this.getHandle());
    }

    public void setUseSystemDPI(boolean bl) {
        Layers layers = this.getLayers();
        for (int i2 = layers.getCount() - 1; i2 >= 0; --i2) {
            if (!layers.get(i2).getDataset().getType().equals((Object)DatasetType.IMAGE)) continue;
            return;
        }
        MapNative.jni_SetUseSystemDPI(this.getHandle(), bl);
    }

    public boolean isUseSystemDPI() {
        return MapNative.jni_IsUseSystemDPI(this.getHandle());
    }

    public void setFullScreenDrawModel(boolean bl) {
        MapNative.jni_SetFullScreenDrawModel(this.getHandle(), bl);
        if (!bl) {
            MapNative.jni_SetAngle(this.getHandle(), 0.0);
        }
    }

    public boolean isFullScreenDrawModel() {
        return MapNative.jni_IsFullScreenDrawModel(this.getHandle());
    }

    public ArrayList<Point> convertToPiexl(Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("toXML()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (point2Ds == null) {
            String string3 = u.a("convertToPiexl()", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        int n2 = point2Ds.getCount();
        ArrayList<Point> arrayList = new ArrayList<Point>();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = point2Ds.getItem(i2).getX();
            dArray2[i2] = point2Ds.getItem(i2).getY();
        }
        double d2 = 0.0;
        if (this.a != null) {
            d2 = this.a.a();
        }
        MapNative.jni_ConvertToPiexl(this.getHandle(), dArray, dArray2, nArray, nArray2, n2, d2);
        for (int i3 = 0; i3 < n2; ++i3) {
            Point point = new Point(nArray[i3], nArray2[i3]);
            arrayList.add(point);
        }
        return arrayList;
    }

    public void setMapLoadedListener(MapLoadedListener mapLoadedListener) {
        this.a = mapLoadedListener;
    }

    public MapLoadedListener getMapLoadedListener() {
        return this.a;
    }

    double a(double d2) {
        Point point = new Point(0, 0);
        Point point2 = new Point(0, (int)d2);
        Point2D point2D = this.pixelToMap(point);
        Point2D point2D2 = this.pixelToMap(point2);
        double d3 = point2D.getX() - point2D2.getX();
        double d4 = point2D.getY() - point2D2.getY();
        return Math.sqrt(d3 * d3 + d4 * d4);
    }

    public static boolean isMapOpen(Map map) {
        return map.a();
    }

    public static long getNetArithmetic(Map map) {
        return map.a();
    }

    long a() {
        return MapNative.jni_GetNetArithmetic(this.getHandle());
    }

    public Legend getLegend() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getLegend()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        this.a = new Legend(this);
        return this.a;
    }

    public boolean save() throws Exception {
        boolean bl = false;
        String string2 = null;
        if (!this.a) {
            string2 = "This map was closed.";
            throw new Exception(string2);
        }
        if (this.getHandle() == 0L) {
            string2 = "This map was disposed.";
            throw new Exception(string2);
        }
        if (this.a == null) {
            string2 = "No associated workspace, please call setWorkspace() first.";
            throw new Exception(string2);
        }
        long l2 = InternalHandle.getHandle((InternalHandle)this.a);
        if (l2 == 0L) {
            string2 = "The associated workspace was disposed.";
            throw new Exception(string2);
        }
        String string3 = this.getName();
        int n2 = this.getLayers().getCount();
        if (string3.isEmpty() || string3.equals("UntitledMap")) {
            if (n2 > 0) {
                string3 = this.getLayers().get(n2 - 1).getName();
            }
            if (string3.equals("UntitledMap")) {
                string3 = string3 + "_1";
            }
            string3 = this.a(string3);
            MapNative.jni_SetName(this.getHandle(), string3);
        }
        bl = MapNative.jni_SaveAs(this.getHandle(), string3, true);
        return bl;
    }

    public boolean save(String string2) throws Exception {
        boolean bl = false;
        String string3 = null;
        if (!this.a) {
            string3 = "This map was closed.";
            throw new Exception(string3);
        }
        if (this.getHandle() == 0L) {
            string3 = "This map was disposed.";
            throw new Exception(string3);
        }
        if (string2 == null) {
            string3 = "The parameter is null";
            throw new Exception(string3);
        }
        if (string2.equals("")) {
            string3 = "The parameter is empty.";
            throw new Exception(string3);
        }
        if (this.a == null) {
            string3 = "No associated workspace, please call setWorkspace() first.";
            throw new Exception(string3);
        }
        long l2 = InternalHandle.getHandle((InternalHandle)this.a);
        if (l2 == 0L) {
            string3 = "The associated workspace was disposed.";
            throw new Exception(string3);
        }
        String string4 = this.getName();
        int n2 = this.a.getMaps().indexOf(string2);
        if (n2 >= 0 && !string2.equals(string4)) {
            string3 = "The map , " + string2 + ", is duplicated.";
            throw new Exception(string3);
        }
        if (n2 == -1) {
            MapNative.jni_SetName(this.getHandle(), string2);
        }
        bl = MapNative.jni_SaveAs(this.getHandle(), string2, true);
        return bl;
    }

    public boolean saveAs(String string2) throws Exception {
        boolean bl = false;
        String string3 = null;
        if (!this.a) {
            string3 = "This map was closed.";
            throw new Exception(string3);
        }
        if (this.getHandle() == 0L) {
            string3 = "This map was disposed.";
            throw new Exception(string3);
        }
        if (string2 == null) {
            string3 = "The parameter is null";
            throw new Exception(string3);
        }
        if (string2.equals("")) {
            string3 = "The parameter is empty.";
            throw new Exception(string3);
        }
        if (this.a == null) {
            string3 = "No associated workspace, please call setWorkspace() first.";
            throw new Exception(string3);
        }
        long l2 = InternalHandle.getHandle((InternalHandle)this.a);
        if (l2 == 0L) {
            string3 = "The associated workspace was disposed.";
            throw new Exception(string3);
        }
        int n2 = this.a.getMaps().indexOf(string2);
        if (n2 >= 0) {
            string3 = "The map , " + string2 + ", is duplicated.";
            throw new Exception(string3);
        }
        bl = MapNative.jni_SaveAs(this.getHandle(), string2, false);
        return bl;
    }

    private String a() {
        boolean bl = false;
        String string2 = null;
        boolean bl2 = this.c();
        if (!bl2) {
            return null;
        }
        try {
            bl = this.save();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl) {
            string2 = this.getName();
            this.d();
        }
        return string2;
    }

    private String a(String string2) {
        String string3 = string2;
        string3 = MapNative.jni_GetUnoccupiedMapName(this.getHandle(), string2);
        return string3;
    }

    private boolean c() {
        boolean bl = false;
        if (this.g) {
            bl = true;
        } else if (this.getLayers().a()) {
            bl = true;
        }
        return bl;
    }

    private void d() {
        this.g = false;
        this.a.b();
    }

    protected static Rectangle2D getCacheBounds(Map map) {
        return map.a();
    }

    public static void setCacheBounds(Map map, Rectangle2D rectangle2D) {
        map.a(rectangle2D);
    }

    public void setUserEditBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setUserEditBounds(Rectangle2D rect)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (rectangle2D == null) {
            String string3 = u.a("rect", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (rectangle2D.getHeight() < 0.0) {
            String string4 = u.a("rect", "Map_ViewBoundsHeightShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (rectangle2D.getWidth() < 0.0) {
            String string5 = u.a("rect", "Map_ViewBoundsWidthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        MapNative.jni_SetUserEditBounds(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
    }

    public Rectangle2D getUserEditBounds() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getUserEditBounds()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        double[] dArray = new double[4];
        MapNative.jni_GetUserEditBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setMinScale(double d2) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (d2 < 0.0) {
            String string3 = u.a("value", "Global_ArgumentShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        MapNative.jni_SetMinScale(this.getHandle(), d2);
        this.refresh();
    }

    public void setMaxScale(double d2) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (d2 < 0.0) {
            String string3 = u.a("value", "Global_ArgumentShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        MapNative.jni_SetMaxScale(this.getHandle(), d2);
        this.refresh();
    }

    public boolean isVisibleScalesEnabled() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("isVisibleScalesEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return MapNative.jni_IsVisibleScalesEnabled(this.getHandle());
    }

    public void setVisibleScalesEnabled(boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setVisibleScalesEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        MapNative.jni_SetVisibleScalesEnabled(this.getHandle(), bl);
    }

    public double[] getVisibleScales() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getVisibleScales()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return MapNative.jni_GetVisibleScales(this.getHandle());
    }

    public void setVisibleScales(double[] dArray) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setVisibleScales()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (dArray == null) {
            String string3 = u.a("setVisibleScales()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        MapNative.jni_SetVisibleScales(this.getHandle(), dArray);
    }

    public MapColorMode getColorMode() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("getColorMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        int n2 = MapNative.jni_GetColorMode(this.getHandle());
        return (MapColorMode)com.supermap.mapping.e.a(MapColorMode.class, n2);
    }

    public void setColorMode(MapColorMode mapColorMode) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setColorMode(MapColorMode value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (mapColorMode == null) {
            String string3 = u.a("mapColorMode", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        int n2 = com.supermap.mapping.e.a(mapColorMode);
        MapNative.jni_SetColorMode(this.getHandle(), n2);
    }

    static boolean prjTranslateCallBack(boolean bl, long l2, int n2, long l3, int n3) {
        int n4;
        boolean bl2 = true;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        Point2D[] point2DArray = new Point2D[n2];
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[n3];
        double[] dArray5 = new double[n3];
        Point3D[] point3DArray = new Point3D[n3];
        MapNative.jni_GetPoints(l2, dArray, dArray2, l2, dArray3, dArray4, dArray5);
        for (n4 = 0; n4 < point2DArray.length; ++n4) {
            point2DArray[n4] = new Point2D(dArray[n4], dArray2[n4]);
        }
        for (n4 = 0; n4 < point3DArray.length; ++n4) {
            point3DArray[n4] = new Point3D(dArray3[n4], dArray4[n4], dArray5[n4]);
        }
        bl2 = Map.firePrjCoordSysTranslator(bl, point2DArray, point3DArray);
        for (n4 = 0; n4 < point2DArray.length; ++n4) {
            dArray[n4] = point2DArray[n4].getX();
            dArray2[n4] = point2DArray[n4].getY();
        }
        for (n4 = 0; n4 < point3DArray.length; ++n4) {
            dArray3[n4] = point3DArray[n4].getX();
            dArray4[n4] = point3DArray[n4].getY();
            dArray5[n4] = point3DArray[n4].getZ();
        }
        MapNative.jni_SetPoints(l2, dArray, dArray2, l3, dArray3, dArray4, dArray5);
        return bl2;
    }

    public synchronized void setPrjCoordSysTransListener(PrjCoordSysTranslatorListener prjCoordSysTranslatorListener, PrjCoordSys prjCoordSys, PrjCoordSys prjCoordSys2) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setPrjCoordSysTransListener(PrjCoordSysTranslatorListener l, PrjCoordSys srcPrjCoordSys, PrjCoordSys desPrjCoordSys)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string3 = u.a("srcPrjCoordSys", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (prjCoordSys2 == null || prjCoordSys2.getHandle() == 0L) {
            String string4 = u.a("desPrjCoordSys", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        MapNative.jni_SetGeoCoordSysTransListener(this, prjCoordSys.getHandle(), prjCoordSys2.getHandle());
        a = prjCoordSysTranslatorListener;
    }

    public synchronized void removePrjCoordSysTransListener(PrjCoordSysTranslatorListener prjCoordSysTranslatorListener) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("removePrjCoordSysTransListener(PrjCoordSysTranslatorListener l)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        MapNative.jni_RemoveGeoCoordSysTransListener(this);
        a = null;
    }

    protected static boolean firePrjCoordSysTranslator(boolean bl, Point2D[] point2DArray, Point3D[] point3DArray) {
        if (a != null) {
            return a.translateCoordSys(bl, point2DArray, point3DArray);
        }
        return false;
    }

    public void setDynamicProjection(boolean bl, PrjCoordSys prjCoordSys) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (prjCoordSys == null || l.getHandle((InternalHandle)prjCoordSys) == 0L) {
            String string3 = u.a("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        this.g = true;
        long l2 = l.getHandle((InternalHandle)prjCoordSys);
        MapNative.jni_SetDynamicProjection(this.getHandle(), bl, l2);
    }

    public CoordSysTransMethod getDynamicPrjTransMethond() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        int n2 = MapNative.jni_GetTransMethod(this.getHandle());
        return (CoordSysTransMethod)com.supermap.mapping.e.a(CoordSysTransMethod.class, n2);
    }

    public void setDynamicPrjTransMethond(CoordSysTransMethod coordSysTransMethod) {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        MapNative.jni_SetTransMethod(this.getHandle(), coordSysTransMethod.value());
    }

    public CoordSysTransParameter getDynamicPrjTransParameter() {
        if (this.getHandle() == 0L) {
            String string2 = u.a("setPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (this.a == null) {
            long l2 = MapNative.jni_GetTransParameter(this.getHandle());
            this.a = new CoordSysTransParameter(l2, false);
        }
        return this.a;
    }

    public void setDynamicPrjTransParameter(CoordSysTransParameter coordSysTransParameter) {
        long l2;
        if (this.getHandle() == 0L) {
            String string2 = u.a("setPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        long l3 = l2 = coordSysTransParameter == null ? 0L : l.getHandle((InternalHandle)coordSysTransParameter);
        if (l2 == 0L) {
            String string3 = u.a("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        MapNative.jni_SetTransParameter(this.getHandle(), l2);
    }

    public class MapStatusOperation {
        public Point2D mCenter;
        public double mScale = 0.0;
        public Operation mOperation = Operation.NONE;
        public Rectangle2D mViewBounds;

        MapStatusOperation() {
            this.mCenter = new Point2D(0.0, 0.0);
            this.mViewBounds = new Rectangle2D(0.0, 0.0, 0.0, 0.0);
        }
    }

    public static enum Operation {
        VIEWENTIRE,
        SETCENTER,
        SETSCALE,
        SETVIEWBOUNDS,
        NONE;

    }
}

