/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import com.supermap.data.CoordSysTranslator;
import com.supermap.data.GeoLine;
import com.supermap.data.InternalHandle;
import com.supermap.data.Point;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.PrjCoordSysType;
import com.supermap.mapping.Map;
import com.supermap.mapping.MapControlNative;
import com.supermap.mapping.MapParameterChangedListener;
import com.supermap.mapping.MapView;
import com.supermap.mapping.ScaleType;
import com.supermap.mapping.l;
import com.supermap.mapping.u;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ScaleView
extends View {
    private Context a;
    private Paint a;
    private Map a;
    private boolean a;
    private ScaleType a;
    private Bitmap a;
    private float a;
    private float b;
    private float c;
    private float d;
    private NinePatch a;
    private int a;
    private int b;
    private int c = 4;
    private DecimalFormat a;
    private String a = null;
    private static final int[] a = new int[]{10, 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000, 20000, 25000, 50000, 100000, 200000, 500000, 1000000, 2000000};
    private static final String[] a = new String[]{"10\u7c73", "20\u7c73", "50\u7c73", "100\u7c73", "200\u7c73", "500\u7c73", "1\u516c\u91cc", "2\u516c\u91cc", "5\u516c\u91cc", "10\u516c\u91cc", "20\u516c\u91cc", "25\u516c\u91cc", "50\u516c\u91cc", "100\u516c\u91cc", "200\u516c\u91cc", "500\u516c\u91cc", "1000\u516c\u91cc", "2000\u516c\u91cc"};
    private static final String[] b = new String[]{"10m", "20m", "50m", "100m", "200m", "500m", "1km", "2km", "5km", "10km", "20km", "25km", "50km", "100km", "200km", "500km", "1000km", "2000km"};
    private int d = 0;
    private String b = null;
    private int e;
    private float e = 0.0f;

    public ScaleView(Context context) {
        this(context, null);
    }

    public ScaleView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ScaleView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.a = context;
        this.a = new Paint();
        this.a = context.getResources().getDisplayMetrics().density;
        this.c = (float)((double)(this.a * 160.0f) / 2.54);
        this.d = 1.0f / this.c;
        this.a = (int)((float)this.a * this.a);
        this.b = (int)((float)this.b * this.a);
        this.c = (int)((float)this.c * this.a);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.a == null) {
            return;
        }
        if (this.a) {
            this.a(canvas);
        } else {
            this.b(canvas);
        }
    }

    private void a(Canvas canvas, Rect rect) {
        if (this.a != null && this.a != null) {
            this.a.draw(canvas, rect);
        }
    }

    private Point2D a() {
        Point2D point2D = null;
        point2D = this.a.getViewBounds().getLeft() >= this.a.getBounds().getLeft() && this.a.getViewBounds().getBottom() >= this.a.getBounds().getBottom() && this.a.getViewBounds().getTop() <= this.a.getBounds().getTop() && this.a.getViewBounds().getRight() <= this.a.getBounds().getRight() ? this.a.getViewBounds().getCenter() : this.a.getBounds().getCenter();
        return point2D;
    }

    private double a() {
        double d2 = 0.0;
        PrjCoordSys prjCoordSys = this.a.getPrjCoordSys();
        if (prjCoordSys.getType() == PrjCoordSysType.PCS_NON_EARTH) {
            d2 = this.a.getScale();
            return d2 *= 100.0;
        }
        Point2D point2D = this.a();
        Point point = this.a.mapToPixel(point2D);
        Point point2 = new Point(point.getX() + 10, point.getY());
        Point2D point2D2 = this.a.pixelToMap(point2);
        Point2Ds point2Ds = new Point2Ds();
        point2Ds.add(point2D2);
        point2Ds.add(point2D);
        GeoLine geoLine = new GeoLine(point2Ds);
        long l2 = l.getHandle((InternalHandle)geoLine);
        if (l2 == 0L) {
            String string2 = u.a("geometry", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string2);
        }
        double d3 = prjCoordSys.getGeoCoordSys().getGeoDatum().getGeoSpheroid().getAxis();
        if (prjCoordSys.getType() == PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE) {
            double d4 = MapControlNative.jni_GetRadianDistance(l2, d3);
            d2 = (double)(10.0f * this.d) / d4;
            if (Math.abs(point2D2.getX() - point2D.getX()) > 100.0) {
                d2 = Math.pow(10.0, -8.0);
            }
        } else {
            boolean bl = CoordSysTranslator.inverse((Point2Ds)point2Ds, (PrjCoordSys)prjCoordSys);
            if (bl) {
                Point2Ds point2Ds2 = new Point2Ds(point2Ds);
                GeoLine geoLine2 = new GeoLine(point2Ds2);
                long l3 = l.getHandle((InternalHandle)geoLine2);
                if (l3 == 0L) {
                    String string3 = u.a("geometry", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                    throw new IllegalArgumentException(string3);
                }
                double d5 = MapControlNative.jni_GetRadianDistance(l3, d3);
                d2 = (double)(10.0f * this.d) / d5;
                if (Math.abs(point2Ds2.getItem(1).getX() - point2Ds2.getItem(0).getX()) > 100.0) {
                    d2 = Math.pow(10.0, -8.0);
                }
            }
        }
        geoLine.dispose();
        return d2;
    }

    private int a() {
        int n2 = (int)(1.0 / this.a());
        int n3 = 0;
        for (int i2 = 0; i2 < a.length; ++i2) {
            if (n2 >= a[i2] && n2 < a[i2 + 1]) {
                n3 = i2;
                break;
            }
            if (n2 < a[0]) {
                n3 = -1;
                break;
            }
            if (n2 <= a[a.length - 1]) continue;
            n3 = 255;
            break;
        }
        return n3;
    }

    private int a(int n2) {
        int n3 = 0;
        if (n2 >= 0 && n2 < a.length) {
            n3 = a[n2];
        } else if (n2 == -1) {
            n3 = 10;
        } else if (n2 == 255) {
            n3 = 2000000;
        }
        return n3;
    }

    private String a(int n2) {
        String string2 = null;
        if (this.a == ScaleType.Chinese) {
            if (n2 >= 0 && n2 < a.length) {
                string2 = a[n2];
            } else if (n2 == -1) {
                string2 = "< 10\u7c73";
            } else if (n2 == 255) {
                string2 = "> 2000\u516c\u91cc";
            }
        } else if (this.a == ScaleType.Global) {
            if (n2 >= 0 && n2 < b.length) {
                string2 = b[n2];
            } else if (n2 == -1) {
                string2 = "< 10m";
            } else if (n2 == 255) {
                string2 = "> 2000km";
            }
        }
        return string2;
    }

    private float a(int n2) {
        float f2 = 0.0f;
        float f3 = (float)(1.0 / this.a());
        float f4 = f3 / (float)this.e;
        f2 = f3 > 2000000.0f || f3 < 10.0f ? this.c : this.c / f4;
        return f2;
    }

    private void a(Canvas canvas) {
        this.d = this.a();
        this.b = this.a(this.d);
        this.e = this.a(this.d);
        this.e = this.a(this.d);
        this.a.setColor(-16777216);
        this.a.setAntiAlias(true);
        this.a.setTextSize((float)this.b);
        this.a.setTypeface(Typeface.DEFAULT_BOLD);
        this.a = this.b;
        float f2 = this.a.measureText(this.a);
        float f3 = (this.e - f2) / 2.0f;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        float f4 = 1.0f;
        this.a.setColor(-1);
        canvas.drawText(this.a, f3 - f4, (float)this.b, this.a);
        canvas.drawText(this.a, f3 - f4, (float)this.b - f4, this.a);
        canvas.drawText(this.a, f3 - f4, (float)this.b + f4, this.a);
        canvas.drawText(this.a, f3, (float)this.b - f4, this.a);
        canvas.drawText(this.a, f3, (float)this.b + f4, this.a);
        canvas.drawText(this.a, f3 + f4, (float)this.b - f4, this.a);
        canvas.drawText(this.a, f3 + f4, (float)this.b, this.a);
        canvas.drawText(this.a, f3 + f4, (float)this.b + f4, this.a);
        this.a.setColor(-16777216);
        canvas.drawText(this.a, f3, (float)this.b, this.a);
        Rect rect = new Rect(0, this.b + this.a, (int)this.e, this.b + this.a + this.c);
        this.a(canvas, rect);
    }

    private void b(Canvas canvas) {
        this.a.setColor(-16777216);
        this.a.setAntiAlias(true);
        this.a.setTextSize((float)this.b);
        this.a.setTypeface(Typeface.DEFAULT_BOLD);
        double d2 = 1.0 / this.a.getScale();
        int n2 = (int)(d2 + 0.5);
        if (this.a == ScaleType.Chinese) {
            if (d2 >= 10000.0) {
                String string2 = "";
                string2 = string2 + String.valueOf(n2 / 10000);
                this.a = "1 : " + string2 + "\u4e07";
            } else {
                this.a = n2 == 0 ? "1 : " + this.a.format(d2) : "1 : " + String.valueOf(n2);
            }
        } else if (this.a == ScaleType.Global) {
            this.a = n2 == 0 ? "1 : " + this.a.format(d2) : "1 : " + String.valueOf(n2);
        }
        float f2 = this.a.measureText(this.a);
        float f3 = (this.c - f2) / 2.0f;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        float f4 = 1.0f;
        this.a.setColor(-1);
        canvas.drawText(this.a, f3 - f4, (float)this.b, this.a);
        canvas.drawText(this.a, f3 - f4, (float)this.b - f4, this.a);
        canvas.drawText(this.a, f3 - f4, (float)this.b + f4, this.a);
        canvas.drawText(this.a, f3, (float)this.b - f4, this.a);
        canvas.drawText(this.a, f3, (float)this.b + f4, this.a);
        canvas.drawText(this.a, f3 + f4, (float)this.b - f4, this.a);
        canvas.drawText(this.a, f3 + f4, (float)this.b, this.a);
        canvas.drawText(this.a, f3 + f4, (float)this.b + f4, this.a);
        this.a.setColor(-16777216);
        canvas.drawText(this.a, f3, (float)this.b, this.a);
        Rect rect = new Rect(0, this.b + this.a, (int)this.c, this.b + this.a + this.c);
        this.a(canvas, rect);
    }

    public void setMapView(MapView mapView) {
        if (mapView != null) {
            mapView.getMapControl().setMapParamChangedListener(new MapParameterChangedListener(){

                @Override
                public void scaleChanged(double d2) {
                    ScaleView.this.postInvalidate();
                }

                @Override
                public void boundsChanged(Point2D point2D) {
                    ScaleView.this.postInvalidate();
                }

                @Override
                public void angleChanged(double d2) {
                }

                @Override
                public void sizeChanged(int n2, int n3) {
                }
            });
            this.a = (double)this.a >= 0.5 && (double)this.a < 1.5 ? this.a("res/icon_scale.9.png") : ((double)this.a >= 1.5 && (double)this.a <= 2.5 ? this.a("res/icon_scale3.9.png") : ((double)this.a >= 2.5 && (double)this.a < 3.5 ? this.a("res/icon_scale3.9.png") : this.a("res/icon_scale3.9.png")));
            if (this.a != null && this.a.getNinePatchChunk() != null) {
                this.a = new NinePatch(this.a, this.a.getNinePatchChunk(), null);
            }
            this.a = mapView.getMapControl().getMap();
        }
    }

    public void setLevelEnable(boolean bl) {
        this.a = bl;
        this.invalidate();
    }

    public boolean getLevelEnable() {
        return this.a;
    }

    public void setScaleType(ScaleType scaleType) {
        this.a = scaleType;
        this.invalidate();
    }

    public ScaleType getScaleType() {
        return this.a;
    }

    private Bitmap a(String string2) {
        AssetManager assetManager = this.a.getAssets();
        Bitmap bitmap = null;
        try {
            InputStream inputStream = assetManager.open(string2);
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bitmap;
    }
}

